/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.biz.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.SystemTypeEnum;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.service.dto.resp.NetSchoolAppResp;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomerCriteria;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.system.mapper.PackageMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScrmBizServiceImpl
implements ScrmBizService {
    private static final Logger log = LoggerFactory.getLogger(ScrmBizServiceImpl.class);
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private PackageMapper packageMapper;
    @Autowired
    private AppBindingsMapper appBindingsMapper;
    @Autowired
    private SettingService settingService;
    @Value(value="${main.biz.id}")
    private Long mainBizId;
    @Value(value="${exclude.biz.ids}")
    private List<Long> excludeBizIds;
    @Value(value="${exclude.biz.corpIds}")
    private List<String> excludeBizCorpIds;

    public String getBizNumByCorpId(String corpId) {
        log.info("getBizNumByCorpId, corpId:{}", (Object)corpId);
        return this.businessCustomerMapper.getNumByCorpId(corpId);
    }

    public String getCorpIdByNum(String num) {
        log.info("getCorpIdByNum,num:{}", (Object)num);
        return this.businessCustomerMapper.getCorpIdByNum(num);
    }

    public List<String> getAllCorpIds() {
        return this.businessCustomerMapper.getAllCorpIds();
    }

    public List<BizSimpleDto> getAll() {
        BusinessCustomerCriteria criteria = new BusinessCustomerCriteria();
        criteria.createCriteria().andIsDeletedEqualTo(Byte.valueOf((byte)0));
        List list = this.businessCustomerMapper.selectByExample((Object)criteria);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        ArrayList<BizSimpleDto> result = new ArrayList<BizSimpleDto>();
        for (BusinessCustomer it : list) {
            result.add(this.newBizSimpleDto(it));
        }
        return result;
    }

    public BizSimpleDto getById(Long id) {
        log.info("get by id={}", (Object)id);
        if (id == null) {
            return null;
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)id);
        return this.newBizSimpleDto(businessCustomer);
    }

    public BizSimpleDto getByCorpId(String corpId) {
        log.info("get by corpId={}", (Object)corpId);
        if (StringUtils.isBlank((CharSequence)corpId)) {
            return null;
        }
        BusinessCustomer businessCustomer = this.businessCustomerMapper.selectByCorpId(corpId);
        return this.newBizSimpleDto(businessCustomer);
    }

    public Boolean isOpenCrm(Long bizId) {
        if (bizId == null || bizId <= 0L) {
            return false;
        }
        String pkgIdsStr = this.businessCustomerMapper.getPkgIdsById(bizId);
        if (StringUtils.isBlank((CharSequence)pkgIdsStr)) {
            return false;
        }
        ArrayList pkgIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)pkgIdsStr)) {
            for (String s : StringUtils.split((String)pkgIdsStr, (String)",")) {
                try {
                    Long parseLong = Long.parseLong(s);
                    pkgIds.add(parseLong);
                }
                catch (NumberFormatException e) {
                    log.error("unknown package, bizId={}, packageId:{}", (Object)bizId, (Object)s);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)pkgIds)) {
            List systemIds = this.packageMapper.querySystemIds((List)pkgIds);
            for (Long id : systemIds) {
                if (id.intValue() != SystemTypeEnum.CRM.getValue()) continue;
                return true;
            }
        }
        return false;
    }

    public NetSchoolAppResp getNetSchoolAppResp(Long bizId) {
        NetSchoolAppResp netSchoolAppResp = new NetSchoolAppResp();
        netSchoolAppResp.setIsCanInvokeNetSchoolInterface(Boolean.valueOf(false));
        AppBindings appBindings = this.appBindingsMapper.selectByBizIdAndAppCode(this.mainBizId, "baijiayunwangxiao");
        if (appBindings == null) {
            netSchoolAppResp.setIsOpen(NumberUtils.INTEGER_ZERO);
            return netSchoolAppResp;
        }
        netSchoolAppResp.setIsOpen(appBindings.getIsOpen());
        if (NumberUtils.INTEGER_ZERO.equals(appBindings.getIsOpen()) || StringUtils.isBlank((CharSequence)appBindings.getConfigJson())) {
            return netSchoolAppResp;
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = null;
        try {
            jsonNode = mapper.readTree(appBindings.getConfigJson());
        }
        catch (Exception e) {
            log.error("getNetSchoolAppResp bizId:{}\u89e3\u6790\u914d\u7f6e\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)this.mainBizId, (Object)e);
        }
        if (Objects.isNull(jsonNode)) {
            return netSchoolAppResp;
        }
        if (Objects.nonNull(jsonNode.get("netSchoolDomain"))) {
            String domain = jsonNode.get("netSchoolDomain").asText();
            if (!domain.startsWith("http://") && !domain.startsWith("https://")) {
                domain = "https://" + domain;
            }
            netSchoolAppResp.setNetSchoolDomain(domain);
        }
        if (Objects.nonNull(jsonNode.get("netSchoolPartnerId"))) {
            netSchoolAppResp.setNetSchoolPartnerId(jsonNode.get("netSchoolPartnerId").asText());
        }
        if (NumberUtils.INTEGER_ONE.equals(netSchoolAppResp.getIsOpen()) && StringUtils.isNotBlank((CharSequence)netSchoolAppResp.getNetSchoolPartnerId()) && StringUtils.isNotBlank((CharSequence)netSchoolAppResp.getNetSchoolDomain())) {
            netSchoolAppResp.setIsCanInvokeNetSchoolInterface(Boolean.valueOf(true));
        }
        return netSchoolAppResp;
    }

    public BizSimpleDto getByNum(String num) {
        log.info("get by num={}", (Object)num);
        if (StringUtils.isBlank((CharSequence)num)) {
            return null;
        }
        BusinessCustomer businessCustomer = this.businessCustomerMapper.selectByNum(num);
        return this.newBizSimpleDto(businessCustomer);
    }

    private BizSimpleDto newBizSimpleDto(BusinessCustomer it) {
        if (it == null) {
            return null;
        }
        BizSimpleDto dto = new BizSimpleDto();
        dto.setId(it.getId());
        dto.setNum(it.getNum());
        dto.setCorpId(it.getCorpId());
        dto.setName(it.getName());
        String pkgIdsStr = it.getPkgIds();
        if (StringUtils.isBlank((CharSequence)pkgIdsStr)) {
            return dto;
        }
        ArrayList pkgIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)pkgIdsStr)) {
            for (String s : StringUtils.split((String)pkgIdsStr, (String)",")) {
                try {
                    Long parseLong = Long.parseLong(s);
                    pkgIds.add(parseLong);
                }
                catch (NumberFormatException e) {
                    log.error("unknown package, bizId={}, packageId:{}", (Object)it.getId(), (Object)s);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)pkgIds)) {
            List systemIds = this.packageMapper.querySystemIds((List)pkgIds);
            for (Long id : systemIds) {
                if (id.intValue() == SystemTypeEnum.TRADE.getValue()) {
                    dto.setIsOpenTrade(Integer.valueOf(1));
                    continue;
                }
                if (id.intValue() != SystemTypeEnum.CRM.getValue()) continue;
                dto.setIsOpenCrm(Integer.valueOf(1));
            }
        }
        return dto;
    }

    public Boolean isOpenSyncTag(Long bizId) {
        String settingValue = this.settingService.getSettingDetail(bizId, SettingEnum.TAG_SYNC.getName());
        if (StringUtils.isEmpty((CharSequence)settingValue) || settingValue.equals("0")) {
            log.info("contactTagToKafka \u4f01\u4e1a\u4e3a\u5f00\u901a\u6807\u7b7e\u540c\u6b65\uff0c bizId: {}", (Object)bizId);
            return false;
        }
        return true;
    }

    public Map<Long, String> getCorpIdsByIds(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Maps.newHashMap();
        }
        return this.businessCustomerMapper.queryCorpIdsByIds(ids);
    }

    public Boolean isMainBiz(Long bizId) {
        return Objects.equals(bizId, this.mainBizId);
    }

    public List<Long> excludeBizIds() {
        return this.excludeBizIds;
    }

    public List<Long> queryAllBizIds() {
        return this.businessCustomerMapper.queryAllBizIds();
    }

    public List<String> excludeCorpIds() {
        return this.excludeBizCorpIds;
    }

    public Long getMainBizId() {
        return this.mainBizId;
    }
}

