/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.biz.dto.request;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class BizEditReqDto {
    private Long id;
    private String name;
    private Date expireDate;
    private Integer type;
    private Integer isOpenConversation;
    private Long versionId;
    private Integer openNetSchool;
    private Integer numCount;
    private BigDecimal money;
    private Integer convCount;
    private String follower;
    private Integer smsPrice;
    private List<String> signature;
    private List<Long> pkgIds;
    private String remark;
    private String avatar;

    public void validate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.id), (Object)"\u5546\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.name), (Object)"\u5546\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.expireDate), (Object)"\u5546\u6237\u8fc7\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.type), (Object)"\u5546\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.isOpenConversation), (Object)"\u5546\u6237\u662f\u5426\u5f00\u542f\u4f1a\u8bdd\u5b58\u6863\u529f\u80fd\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.openNetSchool == null || this.openNetSchool != 0 && this.openNetSchool != 1) {
            this.openNetSchool = 0;
        }
        if (NumberUtils.INTEGER_TWO.equals(this.type)) {
            Preconditions.checkArgument((!Objects.isNull(this.numCount) && this.numCount > 0 ? 1 : 0) != 0, (Object)"\u5f00\u901a\u6b63\u5f0f\u8d26\u6237\u6570\u91cf\u4e0d\u6b63\u786e");
            Preconditions.checkArgument((!Objects.isNull(this.money) && this.money.compareTo(BigDecimal.valueOf(0L)) >= 1 ? 1 : 0) != 0, (Object)"\u5f00\u901a\u6b63\u5f0f\u8d26\u53f7\u91d1\u989d\u6570\u4e0d\u6b63\u786e");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.follower), (Object)"\u5f00\u901a\u6b63\u5f0f\u8d26\u53f7\u8ddf\u8fdb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.follower.length() < 100 ? 1 : 0) != 0, (Object)"\u5f00\u901a\u6b63\u5f0f\u8d26\u53f7\u8ddf\u8fdb\u4eba\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26");
        }
        if (NumberUtils.INTEGER_ONE.equals(this.isOpenConversation)) {
            Preconditions.checkArgument((!Objects.isNull(this.convCount) && this.convCount > 0 ? 1 : 0) != 0, (Object)"\u5f00\u901a\u4f1a\u8bdd\u5b58\u6863\u6570\u91cf\u4e0d\u6b63\u786e");
        }
        Preconditions.checkArgument((this.pkgIds != null && this.pkgIds.size() > 0 ? 1 : 0) != 0, (Object)"\u529f\u80fd\u96c6ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.pkgIds = this.pkgIds.stream().distinct().collect(Collectors.toList());
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getIsOpenConversation() {
        return this.isOpenConversation;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public Integer getOpenNetSchool() {
        return this.openNetSchool;
    }

    public Integer getNumCount() {
        return this.numCount;
    }

    public BigDecimal getMoney() {
        return this.money;
    }

    public Integer getConvCount() {
        return this.convCount;
    }

    public String getFollower() {
        return this.follower;
    }

    public Integer getSmsPrice() {
        return this.smsPrice;
    }

    public List<String> getSignature() {
        return this.signature;
    }

    public List<Long> getPkgIds() {
        return this.pkgIds;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setIsOpenConversation(Integer isOpenConversation) {
        this.isOpenConversation = isOpenConversation;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public void setOpenNetSchool(Integer openNetSchool) {
        this.openNetSchool = openNetSchool;
    }

    public void setNumCount(Integer numCount) {
        this.numCount = numCount;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public void setConvCount(Integer convCount) {
        this.convCount = convCount;
    }

    public void setFollower(String follower) {
        this.follower = follower;
    }

    public void setSmsPrice(Integer smsPrice) {
        this.smsPrice = smsPrice;
    }

    public void setSignature(List<String> signature) {
        this.signature = signature;
    }

    public void setPkgIds(List<Long> pkgIds) {
        this.pkgIds = pkgIds;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BizEditReqDto)) {
            return false;
        }
        BizEditReqDto other = (BizEditReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$isOpenConversation = this.getIsOpenConversation();
        Integer other$isOpenConversation = other.getIsOpenConversation();
        if (this$isOpenConversation == null ? other$isOpenConversation != null : !((Object)this$isOpenConversation).equals(other$isOpenConversation)) {
            return false;
        }
        Long this$versionId = this.getVersionId();
        Long other$versionId = other.getVersionId();
        if (this$versionId == null ? other$versionId != null : !((Object)this$versionId).equals(other$versionId)) {
            return false;
        }
        Integer this$openNetSchool = this.getOpenNetSchool();
        Integer other$openNetSchool = other.getOpenNetSchool();
        if (this$openNetSchool == null ? other$openNetSchool != null : !((Object)this$openNetSchool).equals(other$openNetSchool)) {
            return false;
        }
        Integer this$numCount = this.getNumCount();
        Integer other$numCount = other.getNumCount();
        if (this$numCount == null ? other$numCount != null : !((Object)this$numCount).equals(other$numCount)) {
            return false;
        }
        Integer this$convCount = this.getConvCount();
        Integer other$convCount = other.getConvCount();
        if (this$convCount == null ? other$convCount != null : !((Object)this$convCount).equals(other$convCount)) {
            return false;
        }
        Integer this$smsPrice = this.getSmsPrice();
        Integer other$smsPrice = other.getSmsPrice();
        if (this$smsPrice == null ? other$smsPrice != null : !((Object)this$smsPrice).equals(other$smsPrice)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$expireDate = this.getExpireDate();
        Date other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        BigDecimal this$money = this.getMoney();
        BigDecimal other$money = other.getMoney();
        if (this$money == null ? other$money != null : !((Object)this$money).equals(other$money)) {
            return false;
        }
        String this$follower = this.getFollower();
        String other$follower = other.getFollower();
        if (this$follower == null ? other$follower != null : !this$follower.equals(other$follower)) {
            return false;
        }
        List<String> this$signature = this.getSignature();
        List<String> other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature)) {
            return false;
        }
        List<Long> this$pkgIds = this.getPkgIds();
        List<Long> other$pkgIds = other.getPkgIds();
        if (this$pkgIds == null ? other$pkgIds != null : !((Object)this$pkgIds).equals(other$pkgIds)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$avatar = this.getAvatar();
        String other$avatar = other.getAvatar();
        return !(this$avatar == null ? other$avatar != null : !this$avatar.equals(other$avatar));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BizEditReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $isOpenConversation = this.getIsOpenConversation();
        result = result * 59 + ($isOpenConversation == null ? 43 : ((Object)$isOpenConversation).hashCode());
        Long $versionId = this.getVersionId();
        result = result * 59 + ($versionId == null ? 43 : ((Object)$versionId).hashCode());
        Integer $openNetSchool = this.getOpenNetSchool();
        result = result * 59 + ($openNetSchool == null ? 43 : ((Object)$openNetSchool).hashCode());
        Integer $numCount = this.getNumCount();
        result = result * 59 + ($numCount == null ? 43 : ((Object)$numCount).hashCode());
        Integer $convCount = this.getConvCount();
        result = result * 59 + ($convCount == null ? 43 : ((Object)$convCount).hashCode());
        Integer $smsPrice = this.getSmsPrice();
        result = result * 59 + ($smsPrice == null ? 43 : ((Object)$smsPrice).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        BigDecimal $money = this.getMoney();
        result = result * 59 + ($money == null ? 43 : ((Object)$money).hashCode());
        String $follower = this.getFollower();
        result = result * 59 + ($follower == null ? 43 : $follower.hashCode());
        List<String> $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        List<Long> $pkgIds = this.getPkgIds();
        result = result * 59 + ($pkgIds == null ? 43 : ((Object)$pkgIds).hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $avatar = this.getAvatar();
        result = result * 59 + ($avatar == null ? 43 : $avatar.hashCode());
        return result;
    }

    public String toString() {
        return "BizEditReqDto(id=" + this.getId() + ", name=" + this.getName() + ", expireDate=" + this.getExpireDate() + ", type=" + this.getType() + ", isOpenConversation=" + this.getIsOpenConversation() + ", versionId=" + this.getVersionId() + ", openNetSchool=" + this.getOpenNetSchool() + ", numCount=" + this.getNumCount() + ", money=" + this.getMoney() + ", convCount=" + this.getConvCount() + ", follower=" + this.getFollower() + ", smsPrice=" + this.getSmsPrice() + ", signature=" + this.getSignature() + ", pkgIds=" + this.getPkgIds() + ", remark=" + this.getRemark() + ", avatar=" + this.getAvatar() + ")";
    }
}

