/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.approval.serivce.impl;

import cn.kinyun.wework.sdk.entity.AccessToken;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.approval.dto.GetCorpTokenCfg;
import com.kuaike.scrm.approval.dto.SetCorpSecretReq;
import com.kuaike.scrm.approval.serivce.SettingApproveService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.approval.entity.CorpApproveToken;
import com.kuaike.scrm.dal.approval.mapper.CorpApproveTokenMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.token.service.ApproveTokenService;
import com.kuaike.scrm.token.utils.TokenGen;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SettingApproveServiceImpl
implements SettingApproveService {
    private static final Logger log = LoggerFactory.getLogger(SettingApproveServiceImpl.class);
    @Value(value="${scrm.callback.protocol}${scrm.domain.scrm-callback}/callback/")
    private String callbackUrl;
    @Autowired
    private CorpApproveTokenMapper corpApproveTokenMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private ApproveTokenService approveTokenService;

    @Override
    public boolean set(SetCorpSecretReq params) {
        CorpApproveToken record;
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        log.info("set secret, params:{}, operatorId:{}", (Object)params, (Object)user.getId());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getSecret()), (Object)"secret\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String secret = params.getSecret();
        Date now = new Date();
        String corpId = user.getCorpId();
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        if (weworkCorp.getIsNewDkf() != null && weworkCorp.getIsNewDkf() == 1) {
            corpId = params.getCorpId();
        }
        if (Objects.isNull(record = this.corpApproveTokenMapper.getAccessToken(bizId))) {
            AccessToken accessToken = this.approveTokenService.getAccessToken(corpId, secret);
            record = new CorpApproveToken();
            record.setBizId(bizId);
            record.setCorpId(corpId);
            record.setSecret(secret);
            record.setAccessToken(accessToken.getAccessToken());
            record.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            record.setCreateTime(now);
            record.setUpdateTime(now);
            log.info("insert secret:{}", (Object)record);
            this.corpApproveTokenMapper.insertSelective((Object)record);
        } else {
            if (secret.equals(record.getSecret())) {
                log.info("secret not changed");
                return false;
            }
            AccessToken accessToken = this.approveTokenService.getAccessToken(corpId, secret);
            record.setSecret(secret);
            if (!accessToken.getAccessToken().equals(record.getAccessToken())) {
                log.info("update access_token");
                record.setAccessToken(accessToken.getAccessToken());
                record.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            }
            record.setUpdateTime(now);
            record.setErrBizMsg("");
            record.setErrCode(null);
            record.setErrTime(null);
            record.setErrMsg("");
            log.info("update secret:{}", (Object)record);
            this.corpApproveTokenMapper.updateByPrimaryKey((Object)record);
        }
        return true;
    }

    @Override
    public GetCorpTokenCfg detail() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        log.info("detail, operatorId:{}", (Object)user.getId());
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        CorpApproveToken record = this.corpApproveTokenMapper.getCryptToken(bizId);
        if (record == null) {
            record = new CorpApproveToken();
            record.setBizId(bizId);
            record.setCorpId(corpId);
            record.setToken(TokenGen.getRandomToken());
            record.setAesKey(TokenGen.getRandomAESKey());
            record.setCreateTime(new Date());
            record.setUpdateTime(new Date());
            log.info("insert secret:{}", (Object)record);
            this.corpApproveTokenMapper.insertSelective((Object)record);
        }
        GetCorpTokenCfg result = new GetCorpTokenCfg();
        result.setSecret(record.getSecret());
        String bizNum = this.businessCustomerMapper.getNumByCorpId(corpId);
        result.setCallbackUrl(this.callbackUrl + bizNum + "/flowStatus.json");
        result.setAeskey(record.getAesKey());
        result.setToken(record.getToken());
        return result;
    }

    @Override
    public String rndAESKey() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        log.info("rndAESKey, operatorId:{}", (Object)user.getId());
        Long bizId = user.getBizId();
        CorpApproveToken record = this.corpApproveTokenMapper.getCryptToken(bizId);
        if (record != null) {
            record.setAesKey(TokenGen.getRandomAESKey());
            record.setUpdateTime(new Date());
            log.info("update aeskey:{}", (Object)record);
            this.corpApproveTokenMapper.updateByPrimaryKeySelective((Object)record);
        }
        return record.getAesKey();
    }

    @Override
    public String rndToken() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        log.info("rndToken, operatorId:{}", (Object)user.getId());
        Long bizId = user.getBizId();
        CorpApproveToken record = this.corpApproveTokenMapper.getCryptToken(bizId);
        if (record != null) {
            record.setToken(TokenGen.getRandomToken());
            record.setUpdateTime(new Date());
            log.info("update token:{}", (Object)record);
            this.corpApproveTokenMapper.updateByPrimaryKeySelective((Object)record);
        }
        return record.getToken();
    }

    @Override
    public void freshApproveAccessToken(String corpId, AccessToken accessToken) {
        if (accessToken == null) {
            return;
        }
        CorpApproveToken contactToken = this.corpApproveTokenMapper.getAccessTokenFromCorpId(corpId);
        String token = accessToken.getAccessToken();
        Date now = new Date();
        Long expires = accessToken.getExpires();
        Date expireTime = new Date(now.getTime() + expires * 1000L);
        this.corpApproveTokenMapper.updateAccessToken(contactToken.getId(), token, expireTime, now, null, Integer.valueOf(0), null, null);
    }
}

