/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.approval.serivce.impl;

import cn.kinyun.wework.sdk.api.req.Content;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.entity.oa.Value;
import com.alibaba.dubbo.config.annotation.Service;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.approval.dto.StartApprovalReqWrapper;
import com.kuaike.scrm.approval.serivce.ApproveService;
import com.kuaike.scrm.approval.serivce.SettingApproveService;
import com.kuaike.scrm.common.service.ScrmApproveService;
import com.kuaike.scrm.common.service.dto.req.ScrmApprovalReq;
import com.kuaike.scrm.common.service.dto.req.ScrmApprovalTokenReq;
import com.kuaike.scrm.common.service.dto.req.ScrmRefreshTokenReq;
import com.kuaike.scrm.common.service.dto.resp.ScrmApprovalTokenResp;
import com.kuaike.scrm.dal.approval.entity.CorpApproveToken;
import com.kuaike.scrm.dal.approval.mapper.CorpApproveTokenMapper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Service
@Component
public class ScrmApproveServiceImpl
implements ScrmApproveService {
    private static final Logger log = LoggerFactory.getLogger(ScrmApproveServiceImpl.class);
    @Autowired
    private ApproveService approveService;
    @Autowired
    private SettingApproveService settingApproveService;
    @Resource
    private CorpApproveTokenMapper corpApproveTokenMapper;

    public String startApproval(ScrmApprovalReq req) {
        StartApprovalReqWrapper reqWrapper = this.buildReqWrapper(req);
        return this.approveService.startApproval(reqWrapper);
    }

    private StartApprovalReqWrapper buildReqWrapper(ScrmApprovalReq req) {
        StartApprovalReqWrapper reqWrapper = new StartApprovalReqWrapper();
        BeanUtils.copyProperties((Object)req, (Object)reqWrapper);
        List contents = req.getContents();
        if (CollectionUtils.isEmpty((Collection)contents)) {
            return reqWrapper;
        }
        List<Content> contentList = contents.stream().map(item -> {
            Content content = new Content();
            com.kuaike.scrm.common.service.dto.oa.Value value = item.getValue();
            Value paramValue = new Value();
            BeanUtils.copyProperties((Object)value, (Object)paramValue);
            content.setValue(paramValue);
            content.setName(item.getName());
            return content;
        }).collect(Collectors.toList());
        reqWrapper.setContents(contentList);
        return reqWrapper;
    }

    public ScrmApprovalTokenResp getApprovalToken(ScrmApprovalTokenReq req) {
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getCorpId()), (Object)"corpId \u4e0d\u80fd\u4e3a\u7a7a");
        CorpApproveToken accessToken = this.corpApproveTokenMapper.getAccessTokenFromCorpId(req.getCorpId());
        if (Objects.isNull(accessToken)) {
            return null;
        }
        ScrmApprovalTokenResp resp = new ScrmApprovalTokenResp();
        BeanUtils.copyProperties((Object)accessToken, (Object)resp);
        return resp;
    }

    public void freshApproveAccessToken(ScrmRefreshTokenReq req) {
        if (Objects.isNull(req)) {
            return;
        }
        req.validateForFresh();
        AccessToken accessToken = new AccessToken();
        BeanUtils.copyProperties((Object)req, (Object)accessToken);
        this.settingApproveService.freshApproveAccessToken(req.getCorpId(), accessToken);
    }
}

