/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.approval.serivce.impl;

import cn.kinyun.wework.sdk.api.OaApi;
import cn.kinyun.wework.sdk.api.req.OaTemplateDetailReq;
import cn.kinyun.wework.sdk.entity.oa.TemplateDetailResp;
import com.alibaba.fastjson.JSON;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.approval.dto.FlowTemplateType;
import com.kuaike.scrm.approval.dto.TemplateConfigRespDto;
import com.kuaike.scrm.approval.dto.TemplateDetailReq;
import com.kuaike.scrm.approval.serivce.FlowTemplateDetailService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.approval.entity.FlowTemplateDetail;
import com.kuaike.scrm.dal.approval.mapper.FlowTemplateDetailMapper;
import com.kuaike.scrm.token.service.ApproveTokenService;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FlowTemplateDetailServiceImpl
implements FlowTemplateDetailService {
    private static final Logger log = LoggerFactory.getLogger(FlowTemplateDetailServiceImpl.class);
    @Resource
    private FlowTemplateDetailMapper flowTemplateDetailMapper;
    @Resource
    private ApproveTokenService approveTokenService;
    @Resource
    private OaApi oaApi;

    @Override
    public TemplateConfigRespDto getTemplate(Long bizId, String templateId) {
        FlowTemplateDetail entity = this.flowTemplateDetailMapper.selectByTmeplateId(bizId, templateId);
        return TemplateConfigRespDto.fromEntity(entity);
    }

    @Override
    public TemplateConfigRespDto setTemplate(TemplateDetailReq templateDetailReq) {
        log.info("setTemplate: param:{}", (Object)JSON.toJSONString((Object)templateDetailReq));
        templateDetailReq.validateForSet();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String templateId = templateDetailReq.getTemplateId();
        TemplateConfigRespDto template = this.getTemplate(bizId, templateDetailReq.getTemplateId());
        if (Objects.nonNull((Object)template) && !YnEnum.YES.getValue().equals(templateDetailReq.getUpdateTemplateInfo())) {
            log.warn(" flow setTemplate fail template exist:bizId:{};template:{}; result:{} ", new Object[]{bizId, template, JSON.toJSON((Object)((Object)template))});
            return template;
        }
        String token = this.approveTokenService.getAccessToken(bizId);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u5148\u914d\u7f6e\u5ba1\u6279\u6d41\u7a0bsecret");
        }
        OaTemplateDetailReq oaTemplateDetailReq = new OaTemplateDetailReq();
        oaTemplateDetailReq.setTemplateId(templateId);
        try {
            TemplateDetailResp templateDetailResp = this.oaApi.templateDetail(token, oaTemplateDetailReq);
            String templateInfo = JacksonUtil.obj2Str((Object)templateDetailResp);
            if (Objects.nonNull((Object)template) && YnEnum.YES.getValue().equals(templateDetailReq.getUpdateTemplateInfo())) {
                this.updateFlowTemplateDetail(userInfo, templateInfo, template);
                return TemplateConfigRespDto.fromEntity(template);
            }
            FlowTemplateDetail flowTemplateDetail = this.buildFlowTemplateDetail(userInfo, templateId, templateInfo, FlowTemplateType.getByValue(templateDetailReq.getTemplateType()));
            this.flowTemplateDetailMapper.insert((Object)flowTemplateDetail);
            return TemplateConfigRespDto.fromEntity(flowTemplateDetail);
        }
        catch (Exception ex) {
            log.error("\u62c9\u53d6bizId:{}, \u5bf9\u5e94\u7684\u6a21\u677ftemplateId:{}\u5931\u8d25", new Object[]{bizId, templateId, ex});
            return null;
        }
    }

    public void updateFlowTemplateDetail(CurrentUserInfo userInfo, String templateInfo, FlowTemplateDetail entity) {
        if (Objects.isNull(entity)) {
            return;
        }
        entity.setUpdateTime(new Date());
        entity.setUpdateBy(userInfo.getId());
        entity.setTemplateInfo(templateInfo);
        this.flowTemplateDetailMapper.updateByPrimaryKeySelective((Object)entity);
    }

    private FlowTemplateDetail buildFlowTemplateDetail(CurrentUserInfo userInfo, String templateId, String templateInfo, FlowTemplateType templateType) {
        FlowTemplateDetail flowTemplateDetail = new FlowTemplateDetail();
        flowTemplateDetail.setBizId(userInfo.getBizId());
        flowTemplateDetail.setCorpId(userInfo.getCorpId());
        flowTemplateDetail.setTemplateType(Objects.isNull((Object)templateType) ? null : templateType.getValue());
        flowTemplateDetail.setTemplateId(templateId);
        flowTemplateDetail.setTemplateInfo(templateInfo);
        flowTemplateDetail.setCreateBy(userInfo.getId());
        flowTemplateDetail.setCreateTime(new Date());
        flowTemplateDetail.setUpdateBy(userInfo.getId());
        flowTemplateDetail.setUpdateTime(new Date());
        return flowTemplateDetail;
    }
}

