/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.approval.serivce.impl;

import cn.kinyun.wework.sdk.entity.AccessToken;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.approval.dto.GetCorpTokenCfg;
import com.kuaike.scrm.approval.dto.SetCorpSecretReq;
import com.kuaike.scrm.approval.serivce.SettingApproveService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.approval.entity.CorpApproveToken;
import com.kuaike.scrm.dal.approval.mapper.CorpApproveTokenMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.token.service.ApproveTokenService;
import com.kuaike.scrm.token.utils.TokenGen;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SettingApproveServiceImpl
implements SettingApproveService {
    private static final Logger log = LoggerFactory.getLogger(SettingApproveServiceImpl.class);
    @Value(value="${scrm.callback.protocol}${scrm.domain.scrm-callback}/callback/")
    private String callbackUrl;
    @Autowired
    private CorpApproveTokenMapper corpApproveTokenMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private ApproveTokenService approveTokenService;

    @Override
    public boolean set(SetCorpSecretReq params) {
        CorpApproveToken corpApproveToken;
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        log.info("set secret, params:{}, operatorId:{}", (Object)params, (Object)user.getId());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getSecret()), (Object)"secret\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String secret = params.getSecret();
        Date now = new Date();
        String corpId = user.getCorpId();
        if (StringUtils.isNotEmpty((CharSequence)params.getCorpId())) {
            corpId = params.getCorpId();
        }
        if (Objects.isNull(corpApproveToken = this.corpApproveTokenMapper.getAccessToken(bizId))) {
            AccessToken accessToken = this.approveTokenService.getAccessToken(corpId, secret);
            corpApproveToken = new CorpApproveToken();
            corpApproveToken.setBizId(bizId);
            corpApproveToken.setCorpId(corpId);
            corpApproveToken.setSecret(secret);
            corpApproveToken.setAccessToken(accessToken.getAccessToken());
            corpApproveToken.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            corpApproveToken.setCreateTime(now);
            corpApproveToken.setUpdateTime(now);
            log.info("insert secret:{}", (Object)corpApproveToken);
            this.corpApproveTokenMapper.insertSelective((Object)corpApproveToken);
        } else {
            if (secret.equals(corpApproveToken.getSecret()) && corpId.equals(corpApproveToken.getCorpId())) {
                log.info("secret not changed");
                return false;
            }
            corpApproveToken.setCorpId(corpId);
            AccessToken accessToken = this.approveTokenService.getAccessToken(corpId, secret);
            corpApproveToken.setSecret(secret);
            if (!accessToken.getAccessToken().equals(corpApproveToken.getAccessToken())) {
                log.info("update access_token");
                corpApproveToken.setAccessToken(accessToken.getAccessToken());
                corpApproveToken.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            }
            corpApproveToken.setUpdateTime(now);
            corpApproveToken.setErrBizMsg("");
            corpApproveToken.setErrCode(null);
            corpApproveToken.setErrTime(null);
            corpApproveToken.setErrMsg("");
            log.info("update secret:{}", (Object)corpApproveToken);
            this.corpApproveTokenMapper.updateByPrimaryKey((Object)corpApproveToken);
        }
        return true;
    }

    @Override
    public GetCorpTokenCfg detail() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        log.info("detail, operatorId:{}", (Object)user.getId());
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        GetCorpTokenCfg result = new GetCorpTokenCfg();
        CorpApproveToken corpApproveToken = this.corpApproveTokenMapper.getCryptToken(bizId);
        if (corpApproveToken == null) {
            corpApproveToken = new CorpApproveToken();
            corpApproveToken.setBizId(bizId);
            corpApproveToken.setCorpId(corpId);
            corpApproveToken.setToken(TokenGen.getRandomToken());
            corpApproveToken.setAesKey(TokenGen.getRandomAESKey());
            corpApproveToken.setCreateTime(new Date());
            corpApproveToken.setUpdateTime(new Date());
            log.info("insert secret:{}", (Object)corpApproveToken);
            this.corpApproveTokenMapper.insertSelective((Object)corpApproveToken);
        } else {
            result.setCorpId(corpApproveToken.getCorpId());
        }
        result.setSecret(corpApproveToken.getSecret());
        String bizNum = this.businessCustomerMapper.getNumByCorpId(corpId);
        result.setCallbackUrl(this.callbackUrl + bizNum + "/flowStatus.json");
        result.setAeskey(corpApproveToken.getAesKey());
        result.setToken(corpApproveToken.getToken());
        return result;
    }

    @Override
    public String rndAESKey() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        log.info("rndAESKey, operatorId:{}", (Object)user.getId());
        Long bizId = user.getBizId();
        CorpApproveToken corpApproveToken = this.corpApproveTokenMapper.getCryptToken(bizId);
        String randomAESKey = TokenGen.getRandomAESKey();
        if (corpApproveToken != null) {
            corpApproveToken.setAesKey(randomAESKey);
            corpApproveToken.setUpdateTime(new Date());
            log.info("update aeskey:{}", (Object)corpApproveToken);
            this.corpApproveTokenMapper.updateByPrimaryKeySelective((Object)corpApproveToken);
        }
        return randomAESKey;
    }

    @Override
    public String rndToken() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        log.info("rndToken, operatorId:{}", (Object)user.getId());
        Long bizId = user.getBizId();
        CorpApproveToken corpApproveToken = this.corpApproveTokenMapper.getCryptToken(bizId);
        String randomToken = TokenGen.getRandomToken();
        if (corpApproveToken != null) {
            corpApproveToken.setToken(randomToken);
            corpApproveToken.setUpdateTime(new Date());
            log.info("update token:{}", (Object)corpApproveToken);
            this.corpApproveTokenMapper.updateByPrimaryKeySelective((Object)corpApproveToken);
        }
        return randomToken;
    }

    @Override
    public void freshApproveAccessToken(String corpId, AccessToken accessToken, Long updateUserId) {
        if (accessToken == null) {
            return;
        }
        CorpApproveToken contactToken = this.corpApproveTokenMapper.getAccessTokenFromCorpId(corpId);
        String token = accessToken.getAccessToken();
        Date now = new Date();
        Long expires = accessToken.getExpires();
        Date expireTime = new Date(now.getTime() + expires * 1000L);
        CorpApproveToken updated = new CorpApproveToken();
        updated.setId(contactToken.getId());
        updated.setAccessToken(token);
        updated.setExpireTime(expireTime);
        updated.setUpdateTime(now);
        updated.setUpdateBy(Long.valueOf(Objects.isNull(updateUserId) ? -1L : updateUserId));
        this.corpApproveTokenMapper.updateByPrimaryKeySelective((Object)updated);
    }
}

