/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.material.service.impl;

import cn.kinyun.ad.common.dto.IdAndNameDto;
import cn.kinyun.ad.common.enums.AllocBusinessType;
import cn.kinyun.ad.common.resp.alloc.GetQrcodeResp;
import cn.kinyun.ad.common.service.WeworkAllocService;
import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.CrmLeadsTagService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsTagReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.req.QueryConfigReq;
import com.kuaike.scrm.applet.dto.req.marketingmaterial.GetAllocQrcodeReq;
import com.kuaike.scrm.applet.dto.req.setting.ViewSettingReq;
import com.kuaike.scrm.applet.dto.resp.AppletCountResp;
import com.kuaike.scrm.applet.dto.resp.ConfigResp;
import com.kuaike.scrm.applet.dto.resp.marketingmaterial.GetAllocQrcodeResp;
import com.kuaike.scrm.applet.service.AppletSettingService;
import com.kuaike.scrm.applet.service.AppletStaticService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.AddWeworkStatusEnum;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.AreaService;
import com.kuaike.scrm.common.service.QrCodeService;
import com.kuaike.scrm.common.service.ScrmContactService;
import com.kuaike.scrm.common.service.ScrmLockCustomerService;
import com.kuaike.scrm.common.service.dto.AddFriendRemarkConfigDto;
import com.kuaike.scrm.common.service.dto.FriendWelcomeDto;
import com.kuaike.scrm.common.service.dto.TagConfigDto;
import com.kuaike.scrm.common.service.dto.WelcomeConfigDto;
import com.kuaike.scrm.common.service.dto.req.ModMobileSyncReq;
import com.kuaike.scrm.common.service.dto.resp.WeworkUserResp;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.applet.dto.AppletMaterialQuery;
import com.kuaike.scrm.dal.applet.entity.AppletConfig;
import com.kuaike.scrm.dal.applet.entity.AppletContactInfo;
import com.kuaike.scrm.dal.applet.entity.AppletLevelConfig;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingAddFriendConfig;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterial;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterialFile;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterialGroup;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterialTag;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterialUserInfo;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterialWeworkUser;
import com.kuaike.scrm.dal.applet.entity.AppletSpreadChannel;
import com.kuaike.scrm.dal.applet.entity.AppletSpreadChannelStaff;
import com.kuaike.scrm.dal.applet.mapper.AppletConfigMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletContactInfoMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletLevelConfigMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingAddFriendConfigMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialFileMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialGroupMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialTagMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialUserInfoMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialWeworkUserMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletSpreadChannelMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletSpreadChannelStaffMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.qyqrcodetask.mapper.QyQrcodeSubTaskMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.enums.AppletConfigTypeEnum;
import com.kuaike.scrm.enums.GroupConfigEnum;
import com.kuaike.scrm.enums.IntoGroupStatusEnum;
import com.kuaike.scrm.enums.MarketingMaterialGlobalQrcodeConfigEnum;
import com.kuaike.scrm.enums.QrcodeConfigEnum;
import com.kuaike.scrm.enums.ShelvesStatusEnum;
import com.kuaike.scrm.enums.StaffTypeEnum;
import com.kuaike.scrm.material.dto.TagDto;
import com.kuaike.scrm.material.dto.req.AppletMaterialAddReq;
import com.kuaike.scrm.material.dto.req.AppletMaterialDetailReq;
import com.kuaike.scrm.material.dto.req.AppletMaterialListReq;
import com.kuaike.scrm.material.dto.req.AppletMaterialModReq;
import com.kuaike.scrm.material.dto.req.AppletMaterialModStatusReq;
import com.kuaike.scrm.material.dto.req.GroupFileDto;
import com.kuaike.scrm.material.dto.req.MaterialGroupDto;
import com.kuaike.scrm.material.dto.resp.AppletMaterialDetailResp;
import com.kuaike.scrm.material.dto.resp.AppletMaterialListResp;
import com.kuaike.scrm.material.service.MarketingMaterialService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.lucene.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketingMaterialServiceImpl
implements MarketingMaterialService {
    private static final Logger log = LoggerFactory.getLogger(MarketingMaterialServiceImpl.class);
    @Resource
    private UserRoleCommonService userRoleCommonService;
    @Resource
    private AreaService areaService;
    @Resource
    private IdGen idGen;
    @Resource
    private QrCodeService qrCodeService;
    @Resource
    private AppletMarketingMaterialMapper materialMapper;
    @Resource
    private AppletMarketingMaterialTagMapper materialTagMapper;
    @Resource
    private AppletMarketingMaterialWeworkUserMapper materialWeworkUserMapper;
    @Resource
    private AppletMarketingMaterialGroupMapper materialGroupMapper;
    @Resource
    private AppletMarketingMaterialFileMapper materialFileMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private AppletLevelConfigMapper appletLevelConfigMapper;
    @Resource
    private AppletConfigMapper appletConfigMapper;
    @Resource
    private WeworkTagMapper weworkTagMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private AppletMarketingMaterialMapper appletMarketingMaterialMapper;
    @Resource
    private AppletMarketingMaterialUserInfoMapper appletMarketingMaterialUserInfoMapper;
    @Resource
    private WeworkAllocService weworkAllocService;
    @Resource
    private AppletSpreadChannelStaffMapper appletSpreadChannelStaffMapper;
    @Resource
    private AppletSpreadChannelMapper appletSpreadChannelMapper;
    @Resource
    private AppletSettingService appletSettingService;
    @Resource
    private AppletMarketingMaterialWeworkUserMapper appletMarketingMaterialWeworkUserMapper;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private ScrmLockCustomerService scrmLockCustomerService;
    @Resource
    private AppletContactInfoMapper appletContactInfoMapper;
    @Resource
    private CrmLeadsService crmLeadsService;
    @Resource
    private QyQrcodeSubTaskMapper qyQrcodeSubTaskMapper;
    @Resource
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private CcCustomerInfoService ccCustomerInfoService;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private AppletMarketingAddFriendConfigMapper appletMarketingAddFriendConfigMapper;
    @Resource
    private ScrmContactService scrmContactService;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService appletMarketingMaterialService = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("appletMarketingMaterialService"), new ThreadPoolExecutor.CallerRunsPolicy());
    private final ExecutorService syncAddFriendConfigService = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("syncAddFriendConfigService"), new ThreadPoolExecutor.CallerRunsPolicy());
    @Value(value="${scrm.applet.viewSetting.default}")
    private String viewSettingDefault;
    @Resource
    private CrmLeadsTagService crmLeadsTagService;
    @Resource
    private AppletStaticService appletStaticService;

    @Override
    public List<AppletMaterialListResp> list(AppletMaterialListReq req) {
        List appletLevelConfigs;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("applet material list, req:{}, operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        AppletMaterialQuery appletMaterialQuery = req.buildQuery(userInfo.getBizId(), manageUserIds);
        List marketingMaterials = this.materialMapper.selectListByQuery(appletMaterialQuery);
        if (CollectionUtils.isEmpty((Collection)marketingMaterials)) {
            log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6appletMaterialQuery:{}\u672a\u67e5\u8be2\u5230\u8425\u9500\u8d44\u6599", (Object)appletMaterialQuery);
            return Collections.emptyList();
        }
        Integer count = this.materialMapper.selectCountByQuery(appletMaterialQuery);
        req.getPageDto().setCount(count);
        HashSet userIds = Sets.newHashSet();
        HashSet areaCodes = Sets.newHashSet();
        HashSet categoryIds = Sets.newHashSet();
        for (AppletMarketingMaterial marketingMaterial : marketingMaterials) {
            userIds.add(marketingMaterial.getCreateBy());
            userIds.add(marketingMaterial.getUpdateBy());
            if (StringUtils.isNotBlank((CharSequence)marketingMaterial.getAreaCode())) {
                areaCodes.add(marketingMaterial.getAreaCode());
            }
            if (StringUtils.isNotBlank((CharSequence)marketingMaterial.getFirstCategoryId())) {
                categoryIds.add(marketingMaterial.getFirstCategoryId());
            }
            if (!StringUtils.isNotBlank((CharSequence)marketingMaterial.getSecondCategoryId())) continue;
            categoryIds.add(marketingMaterial.getSecondCategoryId());
        }
        Map userId2NameMap = this.userMapper.selectUserIdAndNameByIds(userInfo.getBizId(), userInfo.getCorpId(), (Collection)userIds);
        Map areaCode2FullNameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)areaCodes)) {
            areaCode2FullNameMap = this.areaService.getFullNames((Collection)areaCodes);
        }
        Map<Object, Object> categoryId2NameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)categoryIds) && CollectionUtils.isNotEmpty((Collection)(appletLevelConfigs = this.appletLevelConfigMapper.selectByNums((Collection)categoryIds)))) {
            categoryId2NameMap = appletLevelConfigs.stream().collect(Collectors.toMap(AppletLevelConfig::getNum, AppletLevelConfig::getName));
        }
        return this.buildMaterialList(marketingMaterials, userId2NameMap, areaCode2FullNameMap, categoryId2NameMap);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(AppletMaterialAddReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("applet material add,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        ViewSettingReq viewSettingReq = this.getViewSetting(userInfo.getBizId());
        req.validateParams(viewSettingReq);
        Date currDate = new Date();
        AppletMarketingMaterial appletMarketingMaterial = this.buildMarketingMaterial(req, userInfo, currDate);
        this.materialMapper.insertSelective((Object)appletMarketingMaterial);
        Long materialId = appletMarketingMaterial.getId();
        if (CollectionUtils.isNotEmpty(req.getTagIds())) {
            List<AppletMarketingMaterialTag> materialTags = this.buildMaterialTagList(req.getTagIds(), materialId, userInfo, currDate);
            this.materialTagMapper.batchInsert(materialTags);
        }
        if (CollectionUtils.isNotEmpty(req.getWeworkUserNums())) {
            List<AppletMarketingMaterialWeworkUser> materialWeworkUsers = this.buildMaterialWeworkUserList(req.getWeworkUserNums(), materialId, userInfo, currDate);
            this.materialWeworkUserMapper.batchInsert(materialWeworkUsers);
        }
        this.addSaveGroupAndFile(req.getGroupDtos(), req.getGroupConfig(), materialId, userInfo, currDate);
    }

    @Override
    public AppletMaterialDetailResp detail(AppletMaterialDetailReq req) {
        List materialGroups;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("applet material detail, req:{}, operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        AppletMarketingMaterial marketingMaterial = this.materialMapper.selectByNum(req.getId());
        if (marketingMaterial == null) {
            log.info("\u6839\u636enum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long materialId = marketingMaterial.getId();
        Set tagIds = this.materialTagMapper.selectTagIdsByBizIdAndMaterialId(bizId, materialId);
        Map tagId2NameMap = null;
        if (CollectionUtils.isNotEmpty((Collection)tagIds)) {
            tagId2NameMap = this.weworkTagMapper.queryTagIdAndName(corpId, (Collection)tagIds);
        }
        Set weworkUserNums = this.materialWeworkUserMapper.selectWeworkUserIdByBizIdAndMaterialId(bizId, materialId);
        Map weworkUserId2NameMap = null;
        if (CollectionUtils.isNotEmpty((Collection)weworkUserNums)) {
            weworkUserId2NameMap = this.weworkUserMapper.queryWeworkUserNameMapByNums(corpId, (Collection)weworkUserNums);
        }
        Map<Object, Object> groupId2GroupMap = Maps.newHashMap();
        if (GroupConfigEnum.GROUP.getValue() == marketingMaterial.getGroupConfig().intValue() && CollectionUtils.isNotEmpty((Collection)(materialGroups = this.materialGroupMapper.selectByBizIdAndMaterialId(bizId, materialId)))) {
            groupId2GroupMap = materialGroups.stream().collect(Collectors.toMap(AppletMarketingMaterialGroup::getId, Functions.identity()));
        }
        Map<Object, Object> groupId2FilesMap = Maps.newHashMap();
        List materialFiles = this.materialFileMapper.selectByBizIdAndMaterialId(bizId, materialId);
        if (CollectionUtils.isNotEmpty((Collection)materialFiles)) {
            groupId2FilesMap = materialFiles.stream().collect(Collectors.groupingBy(AppletMarketingMaterialFile::getGroupId));
        }
        return this.buildMaterialDetailInfo(marketingMaterial, tagId2NameMap, weworkUserId2NameMap, groupId2GroupMap, groupId2FilesMap);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mod(AppletMaterialModReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("applet material mod:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        ViewSettingReq viewSettingReq = this.getViewSetting(userInfo.getBizId());
        req.validateParams(viewSettingReq);
        AppletMarketingMaterial marketingMaterial = this.materialMapper.selectByNum(req.getId());
        if (marketingMaterial == null) {
            log.info("mod,\u6839\u636enum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d44\u6599id\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        Long materialId = marketingMaterial.getId();
        Date currDate = new Date();
        this.handleTag(materialId, req.getTagIds(), userInfo, currDate);
        this.handleWeworkUser(materialId, req.getWeworkUserNums(), userInfo, currDate);
        this.handleGroupAndFile(materialId, req.getGroupConfig(), marketingMaterial.getGroupConfig(), req.getGroupDtos(), userInfo, currDate);
        this.handleQrcodeConfig(materialId, req.getQrcodeConfig(), marketingMaterial.getQrcodeConfig(), userInfo, currDate);
        marketingMaterial.setAreaCode(req.getAreaCode());
        marketingMaterial.setFirstCategoryId(req.getFirstCategoryId());
        marketingMaterial.setSecondCategoryId(req.getSecondCategoryId());
        marketingMaterial.setTitle(req.getTitle());
        marketingMaterial.setPicUrl(req.getPicUrl());
        marketingMaterial.setInitNumber(req.getInitNumber());
        marketingMaterial.setAuthConfig(req.getAuthConfig());
        marketingMaterial.setQrcodeConfig(req.getQrcodeConfig());
        marketingMaterial.setGroupConfig(req.getGroupConfig());
        marketingMaterial.setUpdateBy(userInfo.getId());
        marketingMaterial.setUpdateTime(currDate);
        this.materialMapper.updateByPrimaryKey((Object)marketingMaterial);
    }

    @Override
    public void modStatus(AppletMaterialModStatusReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("applet material modStatus,req:{}, operatorId:{}", (Object)req, (Object)userInfo.getId());
        this.materialMapper.updateStatus(req.getStatus(), userInfo.getId(), req.getId());
    }

    private List<AppletMaterialListResp> buildMaterialList(List<AppletMarketingMaterial> marketingMaterials, Map<Long, String> userId2NameMap, Map<String, String> areaCode2FullNameMap, Map<String, String> categoryId2NameMap) {
        ArrayList resps = Lists.newArrayList();
        Set<String> materialNums = marketingMaterials.stream().map(AppletMarketingMaterial::getNum).collect(Collectors.toSet());
        Map<String, AppletCountResp> materialId2AppletCountMap = this.appletStaticService.spreadStatisticByMaterialIds(materialNums);
        for (AppletMarketingMaterial marketingMaterial : marketingMaterials) {
            AppletMaterialListResp resp = new AppletMaterialListResp();
            resps.add(resp);
            resp.setId(marketingMaterial.getNum());
            resp.setTitle(marketingMaterial.getTitle());
            if (materialId2AppletCountMap.get(marketingMaterial.getNum()) != null) {
                resp.setStaticsCounts(materialId2AppletCountMap.get(marketingMaterial.getNum()));
            }
            if (StringUtils.isNotBlank((CharSequence)marketingMaterial.getAreaCode())) {
                if ("1".equals(marketingMaterial.getAreaCode())) {
                    resp.setAreaName("\u5168\u56fd");
                } else if (MapUtils.isNotEmpty(areaCode2FullNameMap) && areaCode2FullNameMap.containsKey(marketingMaterial.getAreaCode())) {
                    resp.setAreaName(areaCode2FullNameMap.get(marketingMaterial.getAreaCode()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)marketingMaterial.getFirstCategoryId()) && MapUtils.isNotEmpty(categoryId2NameMap) && categoryId2NameMap.containsKey(marketingMaterial.getFirstCategoryId())) {
                resp.setFirstCategoryName(categoryId2NameMap.get(marketingMaterial.getFirstCategoryId()));
            }
            if (StringUtils.isNotBlank((CharSequence)marketingMaterial.getSecondCategoryId()) && MapUtils.isNotEmpty(categoryId2NameMap) && categoryId2NameMap.containsKey(marketingMaterial.getSecondCategoryId())) {
                resp.setSecondCategoryName(categoryId2NameMap.get(marketingMaterial.getSecondCategoryId()));
            }
            resp.setStatus(marketingMaterial.getStatus());
            resp.setStatusDesc(ShelvesStatusEnum.CACHE.get(marketingMaterial.getStatus()).getDesc());
            resp.setCreateTime(marketingMaterial.getCreateTime());
            resp.setUpdateTime(marketingMaterial.getUpdateTime());
            if (MapUtils.isNotEmpty(userId2NameMap) && userId2NameMap.containsKey(marketingMaterial.getCreateBy())) {
                resp.setCreatorName(userId2NameMap.get(marketingMaterial.getCreateBy()));
            }
            if (MapUtils.isNotEmpty(userId2NameMap) && userId2NameMap.containsKey(marketingMaterial.getUpdateBy())) {
                resp.setUpdatorName(userId2NameMap.get(marketingMaterial.getUpdateBy()));
            }
            resp.setQrcodeConfig(marketingMaterial.getQrcodeConfig());
        }
        return resps;
    }

    private AppletMarketingMaterial buildMarketingMaterial(AppletMaterialAddReq req, CurrentUserInfo userInfo, Date currDate) {
        AppletMarketingMaterial appletMarketingMaterial = new AppletMarketingMaterial();
        appletMarketingMaterial.setBizId(userInfo.getBizId());
        appletMarketingMaterial.setNum(this.idGen.getNum());
        appletMarketingMaterial.setAreaCode(req.getAreaCode());
        appletMarketingMaterial.setFirstCategoryId(req.getFirstCategoryId());
        appletMarketingMaterial.setSecondCategoryId(req.getSecondCategoryId());
        appletMarketingMaterial.setTitle(req.getTitle());
        appletMarketingMaterial.setPicUrl(req.getPicUrl());
        appletMarketingMaterial.setInitNumber(req.getInitNumber());
        appletMarketingMaterial.setAuthConfig(req.getAuthConfig());
        appletMarketingMaterial.setQrcodeConfig(req.getQrcodeConfig());
        appletMarketingMaterial.setGroupConfig(req.getGroupConfig());
        appletMarketingMaterial.setStatus(Integer.valueOf(ShelvesStatusEnum.NOT_ON.getStatus()));
        appletMarketingMaterial.setStatusChangeTime(currDate);
        appletMarketingMaterial.setCreateTime(currDate);
        appletMarketingMaterial.setCreateBy(userInfo.getId());
        appletMarketingMaterial.setUpdateTime(currDate);
        appletMarketingMaterial.setUpdateBy(userInfo.getId());
        return appletMarketingMaterial;
    }

    private List<AppletMarketingMaterialTag> buildMaterialTagList(Collection<String> tagIds, Long materialId, CurrentUserInfo userInfo, Date currDate) {
        ArrayList materialTags = Lists.newArrayList();
        for (String tagId : tagIds) {
            AppletMarketingMaterialTag materialTag = new AppletMarketingMaterialTag();
            materialTags.add(materialTag);
            materialTag.setBizId(userInfo.getBizId());
            materialTag.setMaterialId(materialId);
            materialTag.setTagId(tagId);
            materialTag.setIsDeleted(NumberUtils.INTEGER_ZERO);
            materialTag.setCreateTime(currDate);
            materialTag.setCreateBy(userInfo.getId());
            materialTag.setUpdateTime(currDate);
            materialTag.setUpdateBy(userInfo.getId());
        }
        return materialTags;
    }

    private List<AppletMarketingMaterialWeworkUser> buildMaterialWeworkUserList(Collection<String> weworkUserNums, Long materialId, CurrentUserInfo userInfo, Date currDate) {
        ArrayList materialWeworkUsers = Lists.newArrayList();
        for (String weworkUserNum : weworkUserNums) {
            AppletMarketingMaterialWeworkUser materialWeworkUser = new AppletMarketingMaterialWeworkUser();
            materialWeworkUsers.add(materialWeworkUser);
            materialWeworkUser.setBizId(userInfo.getBizId());
            materialWeworkUser.setMaterialId(materialId);
            materialWeworkUser.setWeworkUserNum(weworkUserNum);
            materialWeworkUser.setIsDeleted(NumberUtils.INTEGER_ZERO);
            materialWeworkUser.setCreateTime(currDate);
            materialWeworkUser.setCreateBy(userInfo.getId());
            materialWeworkUser.setUpdateTime(currDate);
            materialWeworkUser.setUpdateBy(userInfo.getId());
        }
        return materialWeworkUsers;
    }

    private void addSaveGroupAndFile(List<MaterialGroupDto> groupDtos, Integer groupConfig, Long materialId, CurrentUserInfo userInfo, Date currDate) {
        if (CollectionUtils.isEmpty(groupDtos)) {
            log.info("addSaveGroupAndFile,materialId:{}\u6ca1\u6709\u5bf9\u5e94\u7684\u5206\u7ec4\u548c\u6587\u4ef6", (Object)materialId);
            return;
        }
        ArrayList materialFiles = Lists.newArrayList();
        if (GroupConfigEnum.NONE_GROUP.getValue() == groupConfig.intValue()) {
            this.buildMaterialFiles(materialFiles, groupDtos.get(0).getGroupFiles(), NumberUtils.LONG_ZERO, materialId, userInfo, currDate);
        } else {
            for (MaterialGroupDto groupDto : groupDtos) {
                AppletMarketingMaterialGroup materialGroup = this.buildMaterialGroup(groupDto, materialId, userInfo, currDate);
                this.materialGroupMapper.insertSelective((Object)materialGroup);
                this.buildMaterialFiles(materialFiles, groupDto.getGroupFiles(), materialGroup.getId(), materialId, userInfo, currDate);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)materialFiles)) {
            this.materialFileMapper.batchInsert((List)materialFiles);
        }
    }

    private AppletMarketingMaterialGroup buildMaterialGroup(MaterialGroupDto groupDto, Long materialId, CurrentUserInfo userInfo, Date currDate) {
        AppletMarketingMaterialGroup materialGroup = new AppletMarketingMaterialGroup();
        materialGroup.setBizId(userInfo.getBizId());
        materialGroup.setMaterialId(materialId);
        materialGroup.setGroupName(groupDto.getGroupName());
        materialGroup.setSort(groupDto.getSort());
        materialGroup.setIsDeleted(NumberUtils.INTEGER_ZERO);
        materialGroup.setCreateTime(currDate);
        materialGroup.setCreateBy(userInfo.getId());
        materialGroup.setUpdateTime(currDate);
        materialGroup.setUpdateBy(userInfo.getId());
        return materialGroup;
    }

    private void buildMaterialFiles(List<AppletMarketingMaterialFile> materialFiles, List<GroupFileDto> groupFiles, Long groupId, Long materialId, CurrentUserInfo userInfo, Date currDate) {
        if (CollectionUtils.isEmpty(groupFiles)) {
            log.info("buildMaterialFiles, groupFiles is empty");
            return;
        }
        for (GroupFileDto fileDto : groupFiles) {
            AppletMarketingMaterialFile materialFile = new AppletMarketingMaterialFile();
            materialFiles.add(materialFile);
            materialFile.setBizId(userInfo.getBizId());
            materialFile.setNum(this.idGen.getNum());
            materialFile.setMaterialId(materialId);
            materialFile.setGroupId(groupId);
            materialFile.setFileName(fileDto.getFileName());
            materialFile.setFileUrl(fileDto.getFileUrl());
            materialFile.setSort(fileDto.getSort());
            materialFile.setIsDeleted(NumberUtils.INTEGER_ZERO);
            materialFile.setCreateTime(currDate);
            materialFile.setCreateBy(userInfo.getId());
            materialFile.setUpdateTime(currDate);
            materialFile.setUpdateBy(userInfo.getId());
        }
    }

    private AppletMaterialDetailResp buildMaterialDetailInfo(AppletMarketingMaterial marketingMaterial, Map<String, String> tagId2NameMap, Map<String, String> weworkUserId2NameMap, Map<Long, AppletMarketingMaterialGroup> groupId2GroupMap, Map<Long, List<AppletMarketingMaterialFile>> groupId2FilesMap) {
        List appletLevelConfigs;
        AppletMaterialDetailResp resp = new AppletMaterialDetailResp();
        resp.setId(marketingMaterial.getNum());
        if (StringUtils.isNotBlank((CharSequence)marketingMaterial.getAreaCode())) {
            resp.setAreaCode(marketingMaterial.getAreaCode());
            if ("1".equals(marketingMaterial.getAreaCode())) {
                resp.setAreaName("\u5168\u56fd");
            } else {
                resp.setAreaName(this.areaService.getFullName(marketingMaterial.getAreaCode()));
            }
        }
        HashSet categoryIds = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)marketingMaterial.getFirstCategoryId())) {
            categoryIds.add(marketingMaterial.getFirstCategoryId());
        }
        if (StringUtils.isNotBlank((CharSequence)marketingMaterial.getSecondCategoryId())) {
            categoryIds.add(marketingMaterial.getSecondCategoryId());
        }
        if (CollectionUtils.isNotEmpty((Collection)categoryIds) && CollectionUtils.isNotEmpty((Collection)(appletLevelConfigs = this.appletLevelConfigMapper.selectByNums((Collection)categoryIds)))) {
            Iterator<Map.Entry<String, String>> categoryId2NameMap = appletLevelConfigs.stream().collect(Collectors.toMap(AppletLevelConfig::getNum, AppletLevelConfig::getName));
            resp.setFirstCategoryId(marketingMaterial.getFirstCategoryId());
            resp.setFirstCategoryName(StringUtils.isNotBlank((CharSequence)marketingMaterial.getFirstCategoryId()) ? categoryId2NameMap.get(marketingMaterial.getFirstCategoryId()) : "");
            resp.setSecondCategoryId(marketingMaterial.getSecondCategoryId());
            resp.setSecondCategoryName(StringUtils.isNotBlank((CharSequence)marketingMaterial.getSecondCategoryId()) ? (String)categoryId2NameMap.get(marketingMaterial.getSecondCategoryId()) : "");
        }
        resp.setTitle(marketingMaterial.getTitle());
        resp.setPicUrl(marketingMaterial.getPicUrl());
        resp.setInitNumber(marketingMaterial.getInitNumber());
        resp.setAuthConfig(marketingMaterial.getAuthConfig());
        resp.setQrcodeConfig(marketingMaterial.getQrcodeConfig());
        resp.setGroupConfig(marketingMaterial.getGroupConfig());
        if (MapUtils.isNotEmpty(tagId2NameMap)) {
            ArrayList tagDtos = Lists.newArrayList();
            resp.setTagDtos(tagDtos);
            for (Map.Entry<String, String> entry : tagId2NameMap.entrySet()) {
                TagDto tagDto = new TagDto();
                tagDtos.add(tagDto);
                tagDto.setTagId(entry.getKey());
                tagDto.setTagName(entry.getValue());
            }
        }
        if (MapUtils.isNotEmpty(weworkUserId2NameMap)) {
            ArrayList weworkUserDtos = Lists.newArrayList();
            resp.setWeworkUserDtos(weworkUserDtos);
            for (Map.Entry<String, String> entry : weworkUserId2NameMap.entrySet()) {
                WeworkUserDto weworkUserDto = new WeworkUserDto();
                weworkUserDtos.add(weworkUserDto);
                weworkUserDto.setId(entry.getKey());
                weworkUserDto.setNickname(entry.getValue());
            }
        }
        ArrayList groupDtos = Lists.newArrayList();
        if (GroupConfigEnum.NONE_GROUP.getValue() == marketingMaterial.getGroupConfig().intValue()) {
            MaterialGroupDto groupDto = new MaterialGroupDto();
            groupDtos.add(groupDto);
            ArrayList groupFiles = Lists.newArrayList();
            groupDto.setGroupFiles(groupFiles);
            if (MapUtils.isNotEmpty(groupId2FilesMap)) {
                for (AppletMarketingMaterialFile materialFile : groupId2FilesMap.get(NumberUtils.LONG_ZERO)) {
                    GroupFileDto fileDto = new GroupFileDto();
                    groupFiles.add(fileDto);
                    fileDto.setId(materialFile.getId());
                    fileDto.setFileName(materialFile.getFileName());
                    fileDto.setFileUrl(materialFile.getFileUrl());
                    fileDto.setSort(materialFile.getSort());
                }
            }
        } else {
            for (Map.Entry<Long, AppletMarketingMaterialGroup> groupEntry : groupId2GroupMap.entrySet()) {
                MaterialGroupDto groupDto = new MaterialGroupDto();
                groupDtos.add(groupDto);
                Long groupId = groupEntry.getKey();
                AppletMarketingMaterialGroup materialGroup = groupEntry.getValue();
                groupDto.setId(groupId);
                groupDto.setGroupName(materialGroup.getGroupName());
                groupDto.setSort(materialGroup.getSort());
                List<AppletMarketingMaterialFile> materialFiles = groupId2FilesMap.get(groupId);
                if (!CollectionUtils.isNotEmpty(materialFiles)) continue;
                ArrayList groupFiles = Lists.newArrayList();
                groupDto.setGroupFiles(groupFiles);
                for (AppletMarketingMaterialFile materialFile : materialFiles) {
                    GroupFileDto fileDto = new GroupFileDto();
                    groupFiles.add(fileDto);
                    fileDto.setId(materialFile.getId());
                    fileDto.setFileName(materialFile.getFileName());
                    fileDto.setFileUrl(materialFile.getFileUrl());
                    fileDto.setSort(materialFile.getSort());
                }
            }
        }
        resp.setGroupDtos(groupDtos);
        return resp;
    }

    private void handleTag(Long materialId, Set<String> newTagIds, CurrentUserInfo userInfo, Date currDate) {
        Set oldTagIds = this.materialTagMapper.selectTagIdsByBizIdAndMaterialId(userInfo.getBizId(), materialId);
        log.info("handleTag,\u7f16\u8f91\u8d44\u6599\uff0c\u8001\u7684\u6807\u7b7e\u96c6\u5408:{},\u65b0\u7684\u6807\u7b7e\u96c6\u5408:{}", (Object)oldTagIds, newTagIds);
        if (CollectionUtils.isEmpty(newTagIds)) {
            newTagIds = Sets.newHashSet();
        }
        if (CollectionUtils.isEmpty((Collection)oldTagIds)) {
            oldTagIds = Sets.newHashSet();
        }
        Collection needAddTagIds = CollectionUtils.removeAll((Collection)newTagIds, (Collection)oldTagIds);
        Collection needDelTagIds = CollectionUtils.removeAll((Collection)oldTagIds, (Collection)newTagIds);
        if (CollectionUtils.isNotEmpty((Collection)needAddTagIds)) {
            List<AppletMarketingMaterialTag> materialTags = this.buildMaterialTagList(needAddTagIds, materialId, userInfo, currDate);
            this.materialTagMapper.batchInsert(materialTags);
            log.info("handleTag,needAddTagIds:{}", (Object)needAddTagIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)needDelTagIds)) {
            this.materialTagMapper.logicDelByMaterialIdAndTags(userInfo.getBizId(), materialId, needDelTagIds, userInfo.getId());
            log.info("handleTag,needDelTagIds:{}", (Object)needDelTagIds);
        }
    }

    private void handleWeworkUser(Long materialId, Set<String> newWeworkUserNums, CurrentUserInfo userInfo, Date currDate) {
        Set oldWeworkUserNums = this.materialWeworkUserMapper.selectWeworkUserIdByBizIdAndMaterialId(userInfo.getBizId(), materialId);
        log.info("handleWeworkUser,\u7f16\u8f91\u524d\u7684\u5907\u7528\u6210\u5458:{},\u7f16\u8f91\u4e4b\u540e\u7684\u5907\u7528\u6210\u5458:{}", (Object)oldWeworkUserNums, newWeworkUserNums);
        if (CollectionUtils.isEmpty(newWeworkUserNums)) {
            newWeworkUserNums = Sets.newHashSet();
        }
        if (CollectionUtils.isEmpty((Collection)oldWeworkUserNums)) {
            oldWeworkUserNums = Sets.newHashSet();
        }
        Collection needAddWeworkUsers = CollectionUtils.removeAll((Collection)newWeworkUserNums, (Collection)oldWeworkUserNums);
        Collection needDelWeworkUsers = CollectionUtils.removeAll((Collection)oldWeworkUserNums, (Collection)newWeworkUserNums);
        if (CollectionUtils.isNotEmpty((Collection)needAddWeworkUsers)) {
            List<AppletMarketingMaterialWeworkUser> materialWeworkUsers = this.buildMaterialWeworkUserList(needAddWeworkUsers, materialId, userInfo, currDate);
            this.materialWeworkUserMapper.batchInsert(materialWeworkUsers);
            log.info("handleWeworkUser,needAddWeworkUsers:{}", (Object)needAddWeworkUsers);
        }
        if (CollectionUtils.isNotEmpty((Collection)needDelWeworkUsers)) {
            this.materialWeworkUserMapper.logicDelByMaterialIdAndWeworkUser(userInfo.getBizId(), materialId, needDelWeworkUsers, userInfo.getId());
            log.info("handleWeworkUser,needDelWeworkUsers:{}", (Object)needDelWeworkUsers);
        }
    }

    private void handleGroupAndFile(Long materialId, Integer newGroupConfig, Integer oldGroupConfig, List<MaterialGroupDto> groupDtos, CurrentUserInfo userInfo, Date currDate) {
        log.info("handleGroupAndFile,oldGroupConfig:{},newGroupConfig:{},groupDtos:{}", new Object[]{oldGroupConfig, newGroupConfig, groupDtos});
        if (GroupConfigEnum.NONE_GROUP.getValue() == oldGroupConfig.intValue()) {
            this.materialFileMapper.logicDelFilesByMaterialId(userInfo.getBizId(), materialId, userInfo.getId(), currDate);
            this.addSaveGroupAndFile(groupDtos, newGroupConfig, materialId, userInfo, currDate);
        } else {
            this.materialGroupMapper.logicDelByMaterialId(userInfo.getBizId(), materialId, userInfo.getId(), currDate);
            this.materialFileMapper.logicDelFilesByMaterialId(userInfo.getBizId(), materialId, userInfo.getId(), currDate);
            this.addSaveGroupAndFile(groupDtos, newGroupConfig, materialId, userInfo, currDate);
        }
    }

    private void handleQrcodeConfig(Long materialId, Integer newQrcodeConfig, Integer oldQrcodeConfig, CurrentUserInfo userInfo, Date currDate) {
        log.info("handleQrcodeConfig,materialId:{},newQrcodeConfig:{},oldQrcodeConfig:{}", new Object[]{materialId, newQrcodeConfig, oldQrcodeConfig});
        if (newQrcodeConfig.equals(oldQrcodeConfig)) {
            log.info("\u7f16\u8f91\u524d\u540e\u7684\u4e8c\u7ef4\u7801\u8bbe\u7f6e\u76f8\u540c");
            return;
        }
        List spreadChannels = this.appletSpreadChannelMapper.selectNotDistinctRecordByBizIdAndMaterialId(userInfo.getBizId(), materialId);
        if (CollectionUtils.isEmpty((Collection)spreadChannels)) {
            log.info("\u8d44\u6599materialId:{}\u8fd8\u672a\u8bbe\u7f6e\u6e20\u9053\u63a8\u5e7f\u7801", (Object)materialId);
            return;
        }
        ArrayList spreadChannelIds = Lists.newArrayList();
        ArrayList allocRuleCacheIds = Lists.newArrayList();
        for (AppletSpreadChannel spreadChannel : spreadChannels) {
            spreadChannelIds.add(spreadChannel.getId());
            allocRuleCacheIds.add(spreadChannel.getAllocRuleCacheId());
        }
        if (QrcodeConfigEnum.ALLOC_RULE.getValue() == oldQrcodeConfig.intValue()) {
            if (CollectionUtils.isNotEmpty((Collection)spreadChannelIds)) {
                this.appletSpreadChannelMapper.clearAllocRuleByIds(userInfo.getId(), currDate, (Collection)spreadChannelIds);
                log.info("\u6e05\u7a7a\u8d44\u6599materialId:{}\u5bf9\u5e94\u7684\u6e20\u9053\u7801\u8bb0\u5f55spreadChannelIds:{}\u7684\u540d\u7247\u5206\u914d\u89c4\u5219", (Object)materialId, (Object)spreadChannelIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)allocRuleCacheIds)) {
                new Thread(() -> {
                    for (String allocRuleCache : allocRuleCacheIds) {
                        this.weworkAllocService.releaseByCacheNum(allocRuleCache);
                    }
                }).start();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GetAllocQrcodeResp getAllocQrcode(GetAllocQrcodeReq req) {
        log.info("getAllocQrcode req:{}", (Object)req);
        req.validate();
        GetAllocQrcodeResp resp = null;
        try {
            boolean allocatedQrcode;
            AppletSpreadChannel appletSpreadChannel;
            GetQrcodeResp getQrcodeResp;
            BusinessCustomer businessCustomer;
            AppletMarketingMaterialUserInfo materialUserInfo;
            Long bizId;
            AppletMarketingMaterial marketingMaterial;
            block22: {
                block26: {
                    Integer qrcodeConfig;
                    block25: {
                        block24: {
                            String backUpWeworkUserNum;
                            block23: {
                                AppletMarketingMaterial select = new AppletMarketingMaterial();
                                select.setNum(req.getMaterialId());
                                select.setStatus(Integer.valueOf(1));
                                marketingMaterial = (AppletMarketingMaterial)this.appletMarketingMaterialMapper.selectOne((Object)select);
                                Preconditions.checkArgument((marketingMaterial != null ? 1 : 0) != 0, (Object)"\u8d44\u6599\u4e0d\u5b58\u5728");
                                resp = new GetAllocQrcodeResp();
                                bizId = marketingMaterial.getBizId();
                                backUpWeworkUserNum = null;
                                if (StringUtils.isBlank((CharSequence)req.getSpreadChannelId()) && StringUtils.isBlank((CharSequence)req.getSpreadChannelStaffId())) {
                                    boolean isShowSpreadStaffQrcode;
                                    boolean bl = isShowSpreadStaffQrcode = QrcodeConfigEnum.SPREAD_STAFF_CODE.getValue() == marketingMaterial.getQrcodeConfig().intValue();
                                    if (!isShowSpreadStaffQrcode) {
                                        log.info("getAllocQrcode materialId:{} openId:{}, \u81ea\u7136\u6d41\u91cf\u4e14\u8d44\u6599\u6ca1\u6709\u8bbe\u7f6e\u5907\u7528\u6210\u5458\uff0c\u4e0d\u5c55\u793a\u5458\u5de5\u4e8c\u7ef4\u7801", (Object)req.getMaterialId(), (Object)req.getOpenId());
                                        return resp;
                                    }
                                    Set weworkUserNums = this.appletMarketingMaterialWeworkUserMapper.selectWeworkUserIdByBizIdAndMaterialId(marketingMaterial.getBizId(), marketingMaterial.getId());
                                    if (CollectionUtils.isEmpty((Collection)weworkUserNums)) {
                                        log.info("getAllocQrcode materialId:{} openId:{}, \u81ea\u7136\u6d41\u91cf\u4e14\u8d44\u6599\u6ca1\u6709\u8bbe\u7f6e\u5907\u7528\u6210\u5458\uff0c\u4e0d\u5c55\u793a\u5458\u5de5\u4e8c\u7ef4\u7801", (Object)req.getMaterialId(), (Object)req.getOpenId());
                                        return resp;
                                    }
                                    backUpWeworkUserNum = (String)weworkUserNums.iterator().next();
                                }
                                Preconditions.checkArgument(((materialUserInfo = this.appletMarketingMaterialUserInfoMapper.selectByMaterialNumAndOpenId(bizId, marketingMaterial.getNum(), req.getOpenId())) != null ? 1 : 0) != 0, (Object)"\u975e\u6cd5\u8bbf\u95ee");
                                qrcodeConfig = marketingMaterial.getQrcodeConfig();
                                if (qrcodeConfig.intValue() == QrcodeConfigEnum.NOT_DISPLAY.getValue()) {
                                    log.info("getAllocQrcode materialId:{} openId:{}, \u5f53\u524d\u8d44\u6599\u4e0d\u8fd4\u56de\u4e8c\u7ef4\u7801", (Object)req.getMaterialId(), (Object)req.getOpenId());
                                    return resp;
                                }
                                businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
                                if (businessCustomer == null) {
                                    log.info("getAllocQrcode materialId:{} openId:{}, \u67e5\u8be2\u4e0d\u5230\u4f01\u4e1a\u4fe1\u606f", (Object)req.getMaterialId(), (Object)req.getOpenId());
                                    return resp;
                                }
                                getQrcodeResp = null;
                                appletSpreadChannel = null;
                                String contactId = this.appletContactInfoMapper.getContactIdByOpenId(bizId, req.getOpenId());
                                if (StringUtils.isNotBlank((CharSequence)contactId)) {
                                    WeworkUserResp weworkUserResp = this.scrmLockCustomerService.queryWeworkUserCodeByContactId(contactId, businessCustomer.getCorpId());
                                    log.info("getAllocQrcode materialId:{} openId:{}, \u5f53\u524dopenId\u5206\u914d\u8fc7\u4e8c\u7ef4\u7801\u4e14\u52a0\u4e86\u597d\u53cb contactId is:{} ,queryWeworkUserCodeByContactId res:{}", new Object[]{req.getMaterialId(), req.getOpenId(), contactId, weworkUserResp});
                                    if (weworkUserResp != null) {
                                        this.buildGetAllocQrcodeRespByLock(resp, weworkUserResp, businessCustomer.getName());
                                        this.updateMarketingMaterialUserInfo(resp.getUrl(), weworkUserResp.getWeworkUserId(), weworkUserResp.getName(), "", materialUserInfo, true);
                                        log.info("getAllocQrcode materialId:{} openId:{}, \u901a\u8fc7\u9501\u5ba2\u8fd4\u56de\u4e8c\u7ef4\u7801, contactId:{}, weworkUserResp:{}", new Object[]{req.getMaterialId(), req.getOpenId(), contactId, weworkUserResp});
                                        WeworkContactRelation contactRelation = this.weworkContactRelationMapper.get(businessCustomer.getCorpId(), weworkUserResp.getWeworkUserId(), contactId);
                                        if (contactRelation != null) {
                                            if (!NumberUtils.INTEGER_ONE.equals(contactRelation.getIsDeleted())) return resp;
                                        }
                                        log.info("\u6839\u636e\u9501\u5ba2\u89c4\u5219\u83b7\u53d6\u7684\u4f01\u5fae\u6210\u5458:{}\u4e0e\u5ba2\u6237:{}\u4e0d\u662f\u597d\u53cb\u5173\u7cfb,\u9700\u8981\u8bbe\u7f6e\u52a0\u597d\u53cb\u914d\u7f6e", (Object)weworkUserResp.getWeworkUserId(), (Object)contactId);
                                        appletSpreadChannel = this.getAppletSpreadChannel(req.getSpreadChannelId(), req.getSpreadChannelStaffId(), bizId);
                                        if (appletSpreadChannel == null) return resp;
                                        getQrcodeResp = this.weworkAllocService.getQrcodeByWeworkUserNum(bizId, weworkUserResp.getWeworkUserId(), false, AllocBusinessType.APPLET_MARKETING_MATERIAL.getType(), appletSpreadChannel.getChannelId());
                                        if (getQrcodeResp != null && StringUtils.isNotBlank((CharSequence)getQrcodeResp.getState())) {
                                            GetQrcodeResp qrcodeResp = getQrcodeResp;
                                            this.syncAddFriendConfigService.submit(() -> this.syncAddFriendConfig(bizId, businessCustomer.getCorpId(), req, qrcodeResp.getState(), marketingMaterial.getId()));
                                        }
                                        this.buildGetAllocQrcodeResp(resp, getQrcodeResp, bizId, businessCustomer.getName());
                                        return resp;
                                    }
                                }
                                allocatedQrcode = false;
                                AppletMarketingMaterialUserInfo earliestAllocMaterialUserInfo = this.appletMarketingMaterialUserInfoMapper.selectAllocByMaterialNumAndOpenId(bizId, marketingMaterial.getNum(), req.getOpenId());
                                if (earliestAllocMaterialUserInfo == null) break block23;
                                allocatedQrcode = true;
                                String channelId = earliestAllocMaterialUserInfo.getChannelId();
                                getQrcodeResp = this.weworkAllocService.getQrcodeByWeworkUserNum(bizId, earliestAllocMaterialUserInfo.getWeworkUserId(), false, AllocBusinessType.APPLET_MARKETING_MATERIAL.getType(), StringUtils.isNotBlank((CharSequence)channelId) ? channelId : SysChannelEnum.APPLET_SHOP.getCode());
                                log.info("getAllocQrcode materialId:{} openId:{}, \u5f53\u524d\u7528\u6237&\u8d44\u6599\u6b64\u524d\u5206\u914d\u8fc7\u4e8c\u7ef4\u7801, materialUserInfoWeworkUserId:{}, \u83b7\u53d6\u6b64\u524d\u5206\u914d\u6210\u5458\u6700\u65b0\u7684\u4e00\u5f20\u4e8c\u7ef4\u7801, getQrcodeResp:{}", new Object[]{req.getMaterialId(), req.getOpenId(), earliestAllocMaterialUserInfo.getWeworkUserId(), getQrcodeResp});
                                break block22;
                            }
                            if (!StringUtils.isNotBlank((CharSequence)backUpWeworkUserNum)) break block24;
                            getQrcodeResp = this.weworkAllocService.getQrcodeByWeworkUserNum(bizId, backUpWeworkUserNum, false, AllocBusinessType.APPLET_MARKETING_MATERIAL.getType(), SysChannelEnum.APPLET_SHOP.getCode());
                            log.info("getAllocQrcode materialId:{} openId:{}, \u81ea\u7136\u6d41\u91cf\uff0c\u4e14\u8d44\u6599\u8bbe\u7f6e\u4e86\u5907\u7528\u6210\u5458, \u4e8c\u7ef4\u7801\u5219\u663e\u793a\u5907\u7528\u6210\u5458\u7684, getQrcodeResp:{}", new Object[]{req.getMaterialId(), req.getOpenId(), getQrcodeResp});
                            break block22;
                        }
                        appletSpreadChannel = this.getAppletSpreadChannel(req.getSpreadChannelId(), req.getSpreadChannelStaffId(), bizId);
                        if (appletSpreadChannel == null) {
                            log.info("getAllocQrcode materialId:{} openId:{}, \u67e5\u8be2\u4e0d\u5230\u63a8\u5e7f\u6e20\u9053", (Object)req.getMaterialId(), (Object)req.getOpenId());
                            return resp;
                        }
                        String weworkUserNum = this.allocRuleMemberContainsSpreadUser(req, appletSpreadChannel.getAllocRuleId(), bizId);
                        if (!StringUtils.isNotBlank((CharSequence)weworkUserNum)) break block25;
                        MarketingMaterialGlobalQrcodeConfigEnum globalQrcodeConfig = this.getGlobalQrcodeConfig(req.getAppId());
                        if (MarketingMaterialGlobalQrcodeConfigEnum.ALLOC_RULE.equals((Object)globalQrcodeConfig)) {
                            getQrcodeResp = this.weworkAllocService.getQrcodeByCacheNum(appletSpreadChannel.getAllocRuleCacheId(), false, appletSpreadChannel.getChannelId());
                            log.info("getAllocQrcode materialId:{} openId:{}, \u8d44\u6599\u7684\u83b7\u5ba2\u4eba\u5458\u5305\u542b\u5f53\u524d\u63a8\u5e7f\u4eba\u5458, \u4e8c\u7ef4\u7801\u663e\u793a\u8bbe\u7f6e\u4e3a\u6309\u7167\u5206\u914d\u89c4\u5219, getQrcodeResp:{}", new Object[]{req.getMaterialId(), req.getOpenId(), getQrcodeResp});
                            break block22;
                        } else {
                            try {
                                getQrcodeResp = this.weworkAllocService.getQrcodeByWeworkUserNum(bizId, weworkUserNum, false, AllocBusinessType.APPLET_MARKETING_MATERIAL.getType(), appletSpreadChannel.getChannelId());
                                log.info("getAllocQrcode materialId:{} openId:{}, \u8d44\u6599\u7684\u83b7\u5ba2\u4eba\u5458\u5305\u542b\u5f53\u524d\u63a8\u5e7f\u4eba\u5458, \u4e8c\u7ef4\u7801\u663e\u793a\u8bbe\u7f6e\u4e3a\u663e\u793a\u63a8\u5e7f\u4eba, getQrcodeResp:{}", new Object[]{req.getMaterialId(), req.getOpenId(), getQrcodeResp});
                            }
                            catch (Exception e) {
                                log.error("getAllocQrcode materialId:{} openId:{}, \u8d44\u6599\u7684\u83b7\u5ba2\u4eba\u5458\u5305\u542b\u5f53\u524d\u63a8\u5e7f\u4eba\u5458, \u4e8c\u7ef4\u7801\u663e\u793a\u8bbe\u7f6e\u4e3a\u663e\u793a\u63a8\u5e7f\u4eba, \u4f46\u83b7\u53d6\u63a8\u5e7f\u4eba\u4e8c\u7ef4\u7801\u5f02\u5e38, \u5c1d\u8bd5\u83b7\u53d6\u5907\u7528\u6210\u5458\u4e8c\u7ef4\u7801", (Object)req.getMaterialId(), (Object)req.getOpenId());
                                Set weworkUserNums = this.appletMarketingMaterialWeworkUserMapper.selectWeworkUserIdByBizIdAndMaterialId(marketingMaterial.getBizId(), marketingMaterial.getId());
                                if (CollectionUtils.isNotEmpty((Collection)weworkUserNums)) {
                                    getQrcodeResp = this.weworkAllocService.getQrcodeByWeworkUserNum(bizId, (String)weworkUserNums.iterator().next(), false, AllocBusinessType.APPLET_MARKETING_MATERIAL.getType(), appletSpreadChannel.getChannelId());
                                    log.info("getAllocQrcode materialId:{} openId:{}, \u8d44\u6599\u7684\u83b7\u5ba2\u4eba\u5458\u5305\u542b\u5f53\u524d\u63a8\u5e7f\u4eba\u5458, \u4e8c\u7ef4\u7801\u663e\u793a\u8bbe\u7f6e\u4e3a\u663e\u793a\u63a8\u5e7f\u4eba, \u4f46\u83b7\u53d6\u63a8\u5e7f\u4eba\u4e8c\u7ef4\u7801\u5f02\u5e38, \u83b7\u53d6\u5907\u7528\u6210\u5458\u4e8c\u7ef4\u7801, getQrcodeResp:{}", new Object[]{req.getMaterialId(), req.getOpenId(), getQrcodeResp});
                                }
                                break block22;
                            }
                        }
                    }
                    if (qrcodeConfig.intValue() != QrcodeConfigEnum.SPREAD_STAFF_CODE.getValue()) break block26;
                    String appletSpreadChannelStaffWeworkUserNum = this.getAppletSpreadChannelStaffWeworkUserNum(req, bizId);
                    if (StringUtils.isBlank((CharSequence)appletSpreadChannelStaffWeworkUserNum)) {
                        String materialBackupAllocMemberWeworkUserNum = this.getMaterialBackupAllocMemberWeworkUserNum(marketingMaterial.getId());
                        getQrcodeResp = this.weworkAllocService.getQrcodeByWeworkUserNum(bizId, materialBackupAllocMemberWeworkUserNum, false, AllocBusinessType.APPLET_MARKETING_MATERIAL.getType(), appletSpreadChannel.getChannelId());
                        log.info("getAllocQrcode materialId:{} openId:{}, \u8d44\u6599\u7684\u83b7\u5ba2\u4eba\u5458\u4e0d\u5305\u542b\u5f53\u524d\u63a8\u5e7f\u4eba\u5458, \u663e\u793a\u63a8\u5e7f\u5458\u5de5\u4e8c\u7ef4\u7801, \u4e14\u63a8\u5e7f\u5458\u5de5\u6ca1\u6709\u4e8c\u7ef4\u7801, \u5907\u7528\u6210\u5458 {}, getQrcodeResp:{}", new Object[]{req.getMaterialId(), req.getOpenId(), materialBackupAllocMemberWeworkUserNum, getQrcodeResp});
                        break block22;
                    } else {
                        try {
                            getQrcodeResp = this.weworkAllocService.getQrcodeByWeworkUserNum(bizId, appletSpreadChannelStaffWeworkUserNum, false, AllocBusinessType.APPLET_MARKETING_MATERIAL.getType(), appletSpreadChannel.getChannelId());
                            log.info("getAllocQrcode materialId:{} openId:{}, \u8d44\u6599\u7684\u83b7\u5ba2\u4eba\u5458\u4e0d\u5305\u542b\u5f53\u524d\u63a8\u5e7f\u4eba\u5458, \u663e\u793a\u63a8\u5e7f\u5458\u5de5\u4e8c\u7ef4\u7801, \u663e\u793a\u63a8\u5e7f\u4eba\u7684\u4e8c\u7ef4\u7801 {}, getQrcodeResp:{}", new Object[]{req.getMaterialId(), req.getOpenId(), appletSpreadChannelStaffWeworkUserNum, getQrcodeResp});
                        }
                        catch (Exception e) {
                            log.info("getAllocQrcode materialId:{} openId:{}, \u8d44\u6599\u7684\u83b7\u5ba2\u4eba\u5458\u4e0d\u5305\u542b\u5f53\u524d\u63a8\u5e7f\u4eba\u5458, \u663e\u793a\u63a8\u5e7f\u5458\u5de5\u4e8c\u7ef4\u7801, \u663e\u793a\u63a8\u5e7f\u4eba\u7684\u4e8c\u7ef4\u7801 {}, \u4f46\u83b7\u53d6\u63a8\u5e7f\u4eba\u4e8c\u7ef4\u7801\u5f02\u5e38, \u5c1d\u8bd5\u83b7\u53d6\u5907\u7528\u6210\u5458\u4e8c\u7ef4\u7801", new Object[]{req.getMaterialId(), req.getOpenId(), appletSpreadChannelStaffWeworkUserNum});
                            Set weworkUserNums = this.appletMarketingMaterialWeworkUserMapper.selectWeworkUserIdByBizIdAndMaterialId(marketingMaterial.getBizId(), marketingMaterial.getId());
                            if (CollectionUtils.isNotEmpty((Collection)weworkUserNums)) {
                                getQrcodeResp = this.weworkAllocService.getQrcodeByWeworkUserNum(bizId, (String)weworkUserNums.iterator().next(), false, AllocBusinessType.APPLET_MARKETING_MATERIAL.getType(), appletSpreadChannel.getChannelId());
                                log.info("getAllocQrcode materialId:{} openId:{}, \u8d44\u6599\u7684\u83b7\u5ba2\u4eba\u5458\u4e0d\u5305\u542b\u5f53\u524d\u63a8\u5e7f\u4eba\u5458, \u663e\u793a\u63a8\u5e7f\u5458\u5de5\u4e8c\u7ef4\u7801, \u663e\u793a\u63a8\u5e7f\u4eba\u7684\u4e8c\u7ef4\u7801 {}, \u4f46\u83b7\u53d6\u63a8\u5e7f\u4eba\u4e8c\u7ef4\u7801\u5f02\u5e38, \u5c1d\u8bd5\u83b7\u53d6\u5907\u7528\u6210\u5458\u4e8c\u7ef4\u7801, getQrcodeResp:{}", new Object[]{req.getMaterialId(), req.getOpenId(), appletSpreadChannelStaffWeworkUserNum, getQrcodeResp});
                            }
                            break block22;
                        }
                    }
                }
                getQrcodeResp = this.weworkAllocService.getQrcodeByCacheNum(appletSpreadChannel.getAllocRuleCacheId(), false, appletSpreadChannel.getChannelId());
                log.info("getAllocQrcode materialId:{} openId:{}, \u8d44\u6599\u7684\u83b7\u5ba2\u4eba\u5458\u4e0d\u5305\u542b\u5f53\u524d\u63a8\u5e7f\u4eba\u5458, \u663e\u793a\u5206\u914d\u89c4\u5219\u5bf9\u5e94\u5206\u914d\u7684\u4e8c\u7ef4\u7801 {}, getQrcodeResp:{}", new Object[]{req.getMaterialId(), req.getOpenId(), appletSpreadChannel.getAllocRuleCacheId(), getQrcodeResp});
            }
            this.buildGetAllocQrcodeResp(resp, getQrcodeResp, bizId, businessCustomer.getName());
            boolean finalAllocatedQrcode = allocatedQrcode;
            AppletSpreadChannel finalAppletSpreadChannel = appletSpreadChannel;
            GetQrcodeResp finalGetQrcodeResp = getQrcodeResp;
            this.appletMarketingMaterialService.submit(() -> {
                if (finalGetQrcodeResp == null) {
                    return;
                }
                if (!finalAllocatedQrcode) {
                    this.addLeadsToCrm(businessCustomer.getId(), businessCustomer.getCorpId(), materialUserInfo.getOpenId(), materialUserInfo.getUnionId(), finalGetQrcodeResp.getState(), materialUserInfo.getMaterialNum(), finalAppletSpreadChannel, finalGetQrcodeResp.getWeworkUserId());
                }
                this.updateMarketingMaterialUserInfo(finalGetQrcodeResp.getCardUrl(), finalGetQrcodeResp.getWeworkUserId(), finalGetQrcodeResp.getWeworkUserName(), finalGetQrcodeResp.getState(), materialUserInfo, false);
                try {
                    this.judgeAddFriendByAllocQrcode(bizId, finalGetQrcodeResp.getWeworkUserId(), materialUserInfo.getUnionId(), businessCustomer.getCorpId());
                }
                catch (Exception e) {
                    log.error("judgeAddFriendByAllocQrcode error", (Throwable)e);
                }
            });
            if (getQrcodeResp == null) return resp;
            if (!StringUtils.isNotBlank((CharSequence)getQrcodeResp.getState())) return resp;
            this.syncAddFriendConfigService.submit(() -> this.syncAddFriendConfig(bizId, businessCustomer.getCorpId(), req, finalGetQrcodeResp.getState(), marketingMaterial.getId()));
            return resp;
        }
        catch (Exception e) {
            log.error("getAllocQrcode error", (Throwable)e);
        }
        return resp;
    }

    private void syncAddFriendConfig(Long bizId, String corpId, GetAllocQrcodeReq req, String state, Long materialId) {
        FriendWelcomeDto friendWelcomeDto;
        List idAndNameDtos;
        log.info("syncAddFriendConfig,bizId:{},req:{},state:{}", new Object[]{bizId, req, state});
        String channelId = "";
        if (StringUtils.isNotBlank((CharSequence)req.getSpreadChannelId())) {
            channelId = this.appletSpreadChannelMapper.queryChannelIdByNum(req.getSpreadChannelId());
        } else if (StringUtils.isNotBlank((CharSequence)req.getSpreadChannelStaffId())) {
            channelId = this.appletSpreadChannelStaffMapper.queryChannelNumByNum(req.getSpreadChannelStaffId());
        }
        if (StringUtils.isBlank((CharSequence)channelId)) {
            log.info("syncAddFriendConfig, channelId is null");
            return;
        }
        AppletMarketingAddFriendConfig addFriendConfig = this.appletMarketingAddFriendConfigMapper.selectByMaterialIdAndChannelId(bizId, materialId, channelId);
        if (addFriendConfig == null) {
            log.info("syncAddFriendConfig,\u6839\u636ematerialId:{},channelId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)materialId, (Object)channelId);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)addFriendConfig.getTagIds()) && CollectionUtils.isNotEmpty((Collection)(idAndNameDtos = JSONArray.parseArray((String)addFriendConfig.getTagIds(), IdAndNameDto.class)))) {
            List tagIds = idAndNameDtos.stream().map(IdAndNameDto::getId).collect(Collectors.toList());
            ArrayList tagConfigDtos = Lists.newArrayList();
            TagConfigDto tagConfigDto = new TagConfigDto();
            tagConfigDtos.add(tagConfigDto);
            tagConfigDto.setState(state);
            tagConfigDto.setTagIds(tagIds);
            this.qrCodeService.setTagConfig(corpId, (List)tagConfigDtos);
        }
        if (StringUtils.isNotBlank((CharSequence)addFriendConfig.getWelcomeContent()) && (CollectionUtils.isNotEmpty((Collection)(friendWelcomeDto = (FriendWelcomeDto)JSONObject.parseObject((String)addFriendConfig.getWelcomeContent(), FriendWelcomeDto.class)).getAttachments()) || StringUtils.isNotBlank((CharSequence)friendWelcomeDto.getText()))) {
            ArrayList configDtos = Lists.newArrayList();
            WelcomeConfigDto welcomeConfigDto = new WelcomeConfigDto();
            configDtos.add(welcomeConfigDto);
            welcomeConfigDto.setState(state);
            welcomeConfigDto.setFriendWelcome(friendWelcomeDto);
            this.qrCodeService.setWelcomeConfig(corpId, (List)configDtos);
        }
        if (StringUtils.isNotBlank((CharSequence)addFriendConfig.getAddFriendRemark())) {
            AddFriendRemarkConfigDto addFriendRemarkConfigDto = new AddFriendRemarkConfigDto();
            addFriendRemarkConfigDto.setRemark(addFriendConfig.getAddFriendRemark());
            addFriendRemarkConfigDto.setState(state);
            this.qrCodeService.setAddFriendRemarkConfig(corpId, addFriendRemarkConfigDto);
        }
    }

    private void judgeAddFriendByAllocQrcode(Long bizId, String weworkUserNum, String unionId, String corpId) {
        if (StringUtils.isBlank((CharSequence)unionId)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            return;
        }
        log.info("judgeAddFriendByAllocQrcode, bizId:{}, weworkUserNum:{}, unionId:{}", new Object[]{bizId, weworkUserNum, unionId});
        WeworkUser select = new WeworkUser();
        select.setBizId(bizId);
        select.setNum(weworkUserNum);
        select.setIsDeleted(Integer.valueOf(0));
        WeworkUser weworkUser = (WeworkUser)this.weworkUserMapper.selectOne((Object)select);
        if (weworkUser == null) {
            log.info("judgeAddFriendByAllocQrcode, weworkUserNum:{}, unionId:{}, weworkUser is null", (Object)weworkUserNum, (Object)unionId);
            return;
        }
        WeworkContact weworkContact = this.weworkContactMapper.selectByCorpIdAndUnionId(corpId, unionId);
        if (weworkContact == null || StringUtils.isBlank((CharSequence)weworkContact.getContactId())) {
            return;
        }
        WeworkContactRelation weworkContactRelation = this.weworkContactRelationMapper.queryWeworkContactDetail(corpId, weworkUser.getWeworkUserId(), weworkContact.getContactId(), YnEnum.NO.getValue());
        if (weworkContactRelation == null) {
            return;
        }
        if (weworkContactRelation.getIsDeleted() == 1) {
            log.info("judgeAddFriendByAllocQrcode, weworkUserNum:{}, unionId:{}, weworkContactRelation deleted, {}", new Object[]{weworkUserNum, unionId, weworkContactRelation.getId()});
            return;
        }
        if (weworkContactRelation.getIsZombieFans() == 1) {
            log.info("judgeAddFriendByAllocQrcode, weworkUserNum:{}, unionId:{}, weworkContactRelation isZombieFans, {}", new Object[]{weworkUserNum, unionId, weworkContactRelation.getId()});
            return;
        }
        log.info("judgeAddFriendByAllocQrcode, weworkUserNum:{}, unionId:{}, is add friend, {}", new Object[]{weworkUserNum, unionId, weworkContactRelation.getId()});
        this.appletMarketingMaterialUserInfoMapper.updateToAddFriendByUnionId(unionId);
    }

    @Override
    public void addLeadsToCrm(Long bizId, String corpId, String openId, String unionId, String state, String materialNum, AppletSpreadChannel appletSpreadChannel, String weworkUserNum) {
        User allocUser;
        Long id;
        AppletContactInfo appletContactInfo;
        log.info("addLeadsToCrm bizId:{}, openId:{}, unionId:{}, state:{}, materialNum:{}, appletSpreadChannel:{}, weworkUserNum:{}", new Object[]{bizId, openId, unionId, state, materialNum, appletSpreadChannel, weworkUserNum});
        AppletContactInfo select = new AppletContactInfo();
        select.setIsDeleted(Integer.valueOf(0));
        select.setBizId(bizId);
        select.setOpenId(openId);
        if (StringUtils.isNotBlank((CharSequence)unionId)) {
            select.setUnionId(unionId);
        }
        if ((appletContactInfo = (AppletContactInfo)this.appletContactInfoMapper.selectOne((Object)select)) == null) {
            log.info("addLeadsToCrm bizId:{}, openId:{}, unionId:{}, appletContactInfo is null", new Object[]{bizId, openId, unionId});
            return;
        }
        if (StringUtils.isBlank((CharSequence)appletContactInfo.getPhone())) {
            log.info("addLeadsToCrm bizId:{}, openId:{}, unionId:{}, appletContactMobile is null", new Object[]{bizId, openId, unionId});
            return;
        }
        CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
        crmLeadsReq.setCorpId(corpId);
        crmLeadsReq.setMobile(appletContactInfo.getPhone());
        crmLeadsReq.setName(StringUtils.isBlank((CharSequence)appletContactInfo.getNickName()) ? "-" : appletContactInfo.getNickName());
        crmLeadsReq.setCreatorId(Long.valueOf(-1L));
        crmLeadsReq.setSourceType(Integer.valueOf(SourceType.APPLET_SHOP.getValue()));
        if (StringUtils.isNotBlank((CharSequence)materialNum)) {
            crmLeadsReq.setTagIds(this.selectTagIds(bizId, materialNum));
        }
        if (appletSpreadChannel != null && StringUtils.isNotBlank((CharSequence)appletSpreadChannel.getChannelId())) {
            id = this.channelMapper.getIdByNum(bizId, appletSpreadChannel.getChannelId());
            if (id != null) {
                crmLeadsReq.setChannelId(id);
            }
        } else {
            id = this.channelMapper.getIdByNum(bizId, SysChannelEnum.APPLET_SHOP.getCode());
            if (id != null) {
                crmLeadsReq.setChannelId(id);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum) && (allocUser = this.userMapper.getUserInfoByWeworkUserNum(bizId, weworkUserNum)) != null) {
            crmLeadsReq.setAllocUserId(allocUser.getId());
        }
        log.info("addLeadsToCrm bizId:{}, openId:{}, unionId:{}, addLeads req: {}", new Object[]{bizId, openId, unionId, crmLeadsReq});
        try {
            this.crmLeadsService.addLeads(crmLeadsReq);
        }
        catch (Exception e) {
            log.error("addLeadsToCrm error, bizId:{}, openId:{}, unionId:{}", new Object[]{bizId, openId, unionId, e});
        }
    }

    private List<String> selectTagIds(Long bizId, String materialNum) {
        List materialTagIds = this.appletMarketingMaterialMapper.selectTagByNums(bizId, Collections.singletonList(materialNum));
        return new ArrayList<String>(materialTagIds);
    }

    private void updateMarketingMaterialUserInfo(String url, String weworkUserNum, String weworkUserName, String state, AppletMarketingMaterialUserInfo materialUserInfo, boolean isLock) {
        Date now = new Date();
        materialUserInfo.setWeworkQrcode(url);
        materialUserInfo.setWeworkUserId(weworkUserNum);
        materialUserInfo.setQrcodeState(state);
        materialUserInfo.setWeworkUserName(weworkUserName);
        materialUserInfo.setUpdateTime(now);
        if (isLock) {
            materialUserInfo.setIsAddFriend(AddWeworkStatusEnum.ADD.getValue());
            materialUserInfo.setAddFriendTime(now);
        }
        this.appletMarketingMaterialUserInfoMapper.updateByPrimaryKey((Object)materialUserInfo);
    }

    private void buildGetAllocQrcodeRespByLock(GetAllocQrcodeResp resp, WeworkUserResp weworkUserResp, String businessName) {
        resp.setUrl(weworkUserResp.getQrCode());
        resp.setName(weworkUserResp.getName());
        resp.setBusinessName(businessName);
        resp.setMobile(weworkUserResp.getMobile());
    }

    private void buildGetAllocQrcodeResp(GetAllocQrcodeResp resp, GetQrcodeResp getQrcodeResp, Long bizId, String businessName) {
        if (getQrcodeResp == null) {
            return;
        }
        resp.setUrl(getQrcodeResp.getCardUrl());
        resp.setName(getQrcodeResp.getWeworkUserName());
        resp.setBusinessName(businessName);
        WeworkUser select = new WeworkUser();
        select.setIsDeleted(Integer.valueOf(0));
        select.setNum(getQrcodeResp.getWeworkUserId());
        select.setBizId(bizId);
        WeworkUser weworkUser = (WeworkUser)this.weworkUserMapper.selectOne((Object)select);
        if (weworkUser != null) {
            resp.setMobile(weworkUser.getMobile());
        }
    }

    private String getMaterialBackupAllocMemberWeworkUserNum(Long materialId) {
        AppletMarketingMaterialWeworkUser select = new AppletMarketingMaterialWeworkUser();
        select.setMaterialId(materialId);
        select.setIsDeleted(Integer.valueOf(0));
        AppletMarketingMaterialWeworkUser appletMarketingMaterialWeworkUser = (AppletMarketingMaterialWeworkUser)this.appletMarketingMaterialWeworkUserMapper.selectOne((Object)select);
        return appletMarketingMaterialWeworkUser.getWeworkUserNum();
    }

    private String getAppletSpreadChannelStaffWeworkUserNum(GetAllocQrcodeReq req, Long bizId) {
        log.info("getAllocQrcode materialId:{} openId:{}, getAppletSpreadChannelStaffWeworkUserNum", (Object)req.getMaterialId(), (Object)req.getOpenId());
        String spreadChannelStaffId = req.getSpreadChannelStaffId();
        if (StringUtils.isBlank((CharSequence)spreadChannelStaffId)) {
            log.info("getAllocQrcode materialId:{} openId:{}, getAppletSpreadChannelStaffWeworkUserNum, spreadChannelStaffId is blank", (Object)req.getMaterialId(), (Object)req.getOpenId());
            return null;
        }
        AppletSpreadChannelStaff appletSpreadChannelStaff = this.selectSpreadChannelStaffByNum(bizId, spreadChannelStaffId);
        if (appletSpreadChannelStaff == null) {
            log.info("getAllocQrcode materialId:{} openId:{}, getAppletSpreadChannelStaffWeworkUserNum, AppletSpreadChannelStaff is null", (Object)req.getMaterialId(), (Object)req.getOpenId());
            return null;
        }
        if (appletSpreadChannelStaff.getStaffType().intValue() == StaffTypeEnum.PART_TIME.getStatus()) {
            log.info("getAllocQrcode materialId:{} openId:{}, getAppletSpreadChannelStaffWeworkUserNum, AppletSpreadChannelStaff is temp staff", (Object)req.getMaterialId(), (Object)req.getOpenId());
            return null;
        }
        User selectUser = new User();
        selectUser.setBizId(bizId);
        selectUser.setNum(appletSpreadChannelStaff.getUserId());
        User user = (User)this.userMapper.selectOne((Object)selectUser);
        if (user == null || StringUtils.isBlank((CharSequence)user.getWeworkUserId())) {
            log.info("getAllocQrcode materialId:{} openId:{}, getAppletSpreadChannelStaffWeworkUserNum, user is null or user weworkUserId is null", (Object)req.getMaterialId(), (Object)req.getOpenId());
            return null;
        }
        WeworkUser selectWeworkUser = new WeworkUser();
        selectWeworkUser.setBizId(bizId);
        selectWeworkUser.setCorpId(user.getCorpId());
        selectWeworkUser.setWeworkUserId(user.getWeworkUserId());
        selectWeworkUser.setIsDeleted(Integer.valueOf(0));
        WeworkUser weworkUser = (WeworkUser)this.weworkUserMapper.selectOne((Object)selectWeworkUser);
        if (weworkUser == null) {
            log.info("getAllocQrcode materialId:{} openId:{}, getAppletSpreadChannelStaffWeworkUserNum, weworkUser is null", (Object)req.getMaterialId(), (Object)req.getOpenId());
            return null;
        }
        return weworkUser.getNum();
    }

    private MarketingMaterialGlobalQrcodeConfigEnum getGlobalQrcodeConfig(String appId) {
        QueryConfigReq configReq = new QueryConfigReq();
        configReq.setType(AppletConfigTypeEnum.QRCODE_DISPLAY_RULE.getType());
        configReq.setAppId(appId);
        ConfigResp appletConfig = this.appletSettingService.getAppletConfig(configReq);
        if (appletConfig == null) {
            return MarketingMaterialGlobalQrcodeConfigEnum.SPREAD_USER;
        }
        try {
            String data = appletConfig.getData();
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            Integer globalQrcodeConfig = jsonObject.getInteger("globalQrcodeConfig");
            MarketingMaterialGlobalQrcodeConfigEnum configEnum = MarketingMaterialGlobalQrcodeConfigEnum.get(globalQrcodeConfig);
            return configEnum != null ? configEnum : MarketingMaterialGlobalQrcodeConfigEnum.SPREAD_USER;
        }
        catch (Exception e) {
            return MarketingMaterialGlobalQrcodeConfigEnum.SPREAD_USER;
        }
    }

    @Override
    public AppletSpreadChannel getAppletSpreadChannel(String spreadChannelId, String spreadChannelStaffId, Long bizId) {
        log.info("getAppletSpreadChannel, spreadChannelId:{}, spreadChannelStaffId:{}, bizId:{}", new Object[]{spreadChannelId, spreadChannelStaffId, bizId});
        if (StringUtils.isNotBlank((CharSequence)spreadChannelId)) {
            return this.selectSpreadChannelByNum(bizId, spreadChannelId);
        }
        if (StringUtils.isNotBlank((CharSequence)spreadChannelStaffId)) {
            AppletSpreadChannelStaff appletSpreadChannelStaff = this.selectSpreadChannelStaffByNum(bizId, spreadChannelStaffId);
            if (appletSpreadChannelStaff == null) {
                return null;
            }
            AppletSpreadChannel select = new AppletSpreadChannel();
            select.setId(appletSpreadChannelStaff.getSpreadChannelId());
            select.setIsDeleted(Integer.valueOf(0));
            return (AppletSpreadChannel)this.appletSpreadChannelMapper.selectByPrimaryKey((Object)select);
        }
        return null;
    }

    private AppletSpreadChannel selectSpreadChannelByNum(Long bizId, String num) {
        AppletSpreadChannel select = new AppletSpreadChannel();
        select.setNum(num);
        select.setBizId(bizId);
        select.setIsDeleted(Integer.valueOf(0));
        return (AppletSpreadChannel)this.appletSpreadChannelMapper.selectOne((Object)select);
    }

    private AppletSpreadChannelStaff selectSpreadChannelStaffByNum(Long bizId, String num) {
        AppletSpreadChannelStaff select = new AppletSpreadChannelStaff();
        select.setNum(num);
        select.setBizId(bizId);
        select.setIsDeleted(Integer.valueOf(0));
        return (AppletSpreadChannelStaff)this.appletSpreadChannelStaffMapper.selectOne((Object)select);
    }

    private String allocRuleMemberContainsSpreadUser(GetAllocQrcodeReq req, String allocRuleNum, Long bizId) {
        log.info("getAllocQrcode materialId:{} openId:{}, allocRuleMemberContainsSpreadUser, allocRuleNum:{}", new Object[]{req.getMaterialId(), req.getOpenId(), allocRuleNum});
        String spreadChannelStaffId = req.getSpreadChannelStaffId();
        if (StringUtils.isBlank((CharSequence)spreadChannelStaffId)) {
            log.info("getAllocQrcode materialId:{} openId:{}, allocRuleMemberContainsSpreadUser, spreadChannelStaffId isBlank", (Object)req.getMaterialId(), (Object)req.getOpenId());
            return null;
        }
        AppletSpreadChannelStaff select = new AppletSpreadChannelStaff();
        select.setNum(spreadChannelStaffId);
        select.setBizId(bizId);
        select.setIsDeleted(Integer.valueOf(0));
        AppletSpreadChannelStaff appletSpreadChannelStaff = (AppletSpreadChannelStaff)this.appletSpreadChannelStaffMapper.selectOne((Object)select);
        if (appletSpreadChannelStaff == null) {
            log.info("getAllocQrcode materialId:{} openId:{}, allocRuleMemberContainsSpreadUser, appletSpreadChannelStaff is null", (Object)req.getMaterialId(), (Object)req.getOpenId());
            return null;
        }
        if (appletSpreadChannelStaff.getStaffType().intValue() == StaffTypeEnum.PART_TIME.getStatus()) {
            log.info("getAllocQrcode materialId:{} openId:{}, allocRuleMemberContainsSpreadUser, appletSpreadChannelStaff is temp staff", (Object)req.getMaterialId(), (Object)req.getOpenId());
            return null;
        }
        User selectUser = new User();
        selectUser.setBizId(bizId);
        selectUser.setNum(appletSpreadChannelStaff.getUserId());
        User user = (User)this.userMapper.selectOne((Object)selectUser);
        if (StringUtils.isEmpty((CharSequence)user.getWeworkUserId())) {
            return null;
        }
        WeworkUser selectWeworkUser = new WeworkUser();
        selectWeworkUser.setBizId(bizId);
        selectWeworkUser.setCorpId(user.getCorpId());
        selectWeworkUser.setWeworkUserId(user.getWeworkUserId());
        selectWeworkUser.setIsDeleted(Integer.valueOf(0));
        WeworkUser weworkUser = (WeworkUser)this.weworkUserMapper.selectOne((Object)selectWeworkUser);
        if (weworkUser == null) {
            log.info("getAllocQrcode materialId:{} openId:{}, allocRuleMemberContainsSpreadUser, weworkUser is null", (Object)req.getMaterialId(), (Object)req.getOpenId());
            return null;
        }
        Set weworkUserNums = this.weworkAllocService.selectRuleWeworkUserNumsByRuleNum(bizId, allocRuleNum);
        log.info("getAllocQrcode materialId:{} openId:{}, allocRuleMemberContainsSpreadUser, SpreadChannelStaffWeworkUserNum is:{} , selectRuleWeworkUserNumsByRuleNum res:{}", new Object[]{req.getMaterialId(), req.getOpenId(), weworkUser.getNum(), weworkUserNums});
        if (CollectionUtils.isEmpty((Collection)weworkUserNums)) {
            return null;
        }
        if (weworkUserNums.contains(weworkUser.getNum())) {
            return weworkUser.getNum();
        }
        return null;
    }

    @Override
    public void updateIntoGroupStatus(Long bizId, String corpId, String contactId, IntoGroupStatusEnum intoGroupStatus, String chatRoomOwner) {
        List ownerList;
        log.info("updateIntoGroupStatus: bizId:{}, contactId:{}, intoGroupStatus:{}, chatRoomOwner:{}", new Object[]{bizId, contactId, intoGroupStatus, chatRoomOwner});
        AppletContactInfo select = new AppletContactInfo();
        select.setIsDeleted(Integer.valueOf(0));
        select.setBizId(bizId);
        select.setContactId(contactId);
        AppletContactInfo appletContactInfo = (AppletContactInfo)this.appletContactInfoMapper.selectOne((Object)select);
        if (appletContactInfo == null) {
            log.info("updateIntoGroupStatus: bizId:{}, contactId:{}, \u4e0d\u662f\u5c0f\u7a0b\u5e8f\u5e97\u94fa\u7528\u6237", (Object)bizId, (Object)contactId);
            return;
        }
        if (IntoGroupStatusEnum.JOIN_GROUP.equals((Object)intoGroupStatus)) {
            WeworkUser selectWeworkUser = new WeworkUser();
            selectWeworkUser.setCorpId(corpId);
            selectWeworkUser.setWeworkUserId(chatRoomOwner);
            selectWeworkUser.setIsDeleted(Integer.valueOf(0));
            int count = this.weworkUserMapper.selectCount((Object)selectWeworkUser);
            if (count == 0) {
                log.info("updateIntoGroupStatus: bizId:{}, chatRoomOwner:{}, \u7fa4\u4e3b\u4e0d\u662fWeworkUser", (Object)bizId, (Object)chatRoomOwner);
                return;
            }
        } else if (IntoGroupStatusEnum.QUIT_GROUP.equals((Object)intoGroupStatus) && CollectionUtils.isNotEmpty((Collection)(ownerList = this.weworkChatRoomRelationMapper.queryOwnerByContactId(corpId, contactId)))) {
            boolean isExist;
            Long id = this.weworkUserMapper.queryIdByWeworkUserIds(corpId, (Collection)ownerList);
            boolean bl = isExist = id != null && id > 0L;
            if (isExist) {
                log.info("updateIntoGroupStatus: corpId:{}, contactId:{}, \u7528\u6237\u8fd8\u5728\u5176\u4ed6\u6210\u5458\u4e3a\u7fa4\u4e3b\u7684\u7fa4, ownerList:{}", new Object[]{corpId, contactId, ownerList});
                return;
            }
        }
        log.info("updateIntoGroupStatus: \u66f4\u65b0\u7528\u6237\u5165\u7fa4\u9000\u7fa4\u4fe1\u606f\uff0c bizId:{}, corpId:{}, contactId:{}, intoGroupStatus:{}, chatRoomOwner:{}", new Object[]{bizId, corpId, contactId, intoGroupStatus, chatRoomOwner});
        appletContactInfo.setIntoGroupStatus(Integer.valueOf(intoGroupStatus.getValue()));
        appletContactInfo.setUpdateTime(new Date());
        this.appletContactInfoMapper.updateByPrimaryKeySelective((Object)appletContactInfo);
    }

    private ViewSettingReq getViewSetting(Long bizId) {
        AppletConfig appletConfig = this.appletConfigMapper.selectByBizIdAndType(bizId, Integer.valueOf(AppletConfigTypeEnum.VIEW_SETTING.getType()));
        String configJson = this.viewSettingDefault;
        if (appletConfig != null) {
            configJson = appletConfig.getContent();
        }
        return (ViewSettingReq)JSONObject.parseObject((String)configJson, ViewSettingReq.class);
    }

    @Override
    public void updateIntoGroupStatusByContactId(Long bizId, String corpId, String contactId) {
        log.info("updateIntoGroupStatusByContactId bizId:{}, contactId:{}", (Object)bizId, (Object)contactId);
        List ownerList = this.weworkChatRoomRelationMapper.queryOwnerByContactId(corpId, contactId);
        log.info("updateIntoGroupStatusByContactId bizId:{}, contactId:{}, ownerListSize:{}", new Object[]{bizId, contactId, ownerList.size()});
        Long id = this.weworkUserMapper.queryIdByWeworkUserIds(corpId, (Collection)ownerList);
        boolean isExist = id != null && id > 0L;
        log.info("updateIntoGroupStatusByContactId bizId:{}, contactId:{}, isExist:{}", new Object[]{bizId, contactId, isExist});
        if (isExist) {
            this.appletContactInfoMapper.updateIntoGroupStatusByContactId(bizId, contactId, Integer.valueOf(IntoGroupStatusEnum.JOIN_GROUP.getValue()));
        }
    }

    @Override
    public void bindMobileAndContactId(Long bizId, String mobile, String contactId, String customerNum) {
        log.info("bindMobileAndContactId bizId:{}, mobile:{}, contactId:{}, customerNum:{}", new Object[]{bizId, mobile, contactId, customerNum});
        boolean mobileBindCustomer = this.checkMobileBindCustomer(bizId, mobile);
        boolean contactBindMobiles = this.checkContactBindMobiles(bizId, customerNum);
        if (!mobileBindCustomer && contactBindMobiles) {
            this.ccCustomerNumService.bindWeworkContactAndMobile(bizId, contactId, mobile, ModuleType.APPLET_SHOP.getCode());
        }
        log.info("bindMobileAndContactId bizId:{}, mobile:{}, contactId:{}, customerNum:{}, mobileBindCustomer:{}, contactBindMobiles:{}", new Object[]{bizId, mobile, contactId, customerNum, mobileBindCustomer, contactBindMobiles});
        try {
            String corpId = this.businessCustomerMapper.getCorpIdById(bizId);
            ModMobileSyncReq syncReq = new ModMobileSyncReq();
            syncReq.setCorpId(corpId);
            syncReq.setContactId(contactId);
            ArrayList mobiles = Lists.newArrayList();
            mobiles.add(mobile);
            syncReq.setMobiles((List)mobiles);
            this.scrmContactService.modMobileByAllWeworkUserIds(syncReq);
        }
        catch (Exception e) {
            log.error("bindMobileAndContactId modMobileByAllWeworkUserIds error", (Throwable)e);
        }
    }

    private boolean checkMobileBindCustomer(Long bizId, String mobile) {
        boolean ret = false;
        String customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, mobile);
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            log.info("checkMobileBindCustomer customerNum isBlank");
            return false;
        }
        String contactId = this.ccCustomerNumService.getWeworkContactId(bizId, customerNum);
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            log.info("checkMobileBindCustomer contactId isNotBlank");
            ret = true;
        }
        return ret;
    }

    private boolean checkContactBindMobiles(Long bizId, String customerNum) {
        CustomerDetailResp detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNum);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{detailResp.getMobile1(), detailResp.getMobile2()})) {
            log.info("checkContactBindMobiles Mobile1 Mobile2 isNoneEmpty");
            return false;
        }
        return true;
    }

    @Override
    public void addTagWhenGetMaterialDetailByUserAuthorised(Long bizId, String materialNum, String mobile) {
        log.info("addTagWhenGetMaterialDetailByUserAuthorised, bizId:{}, materialNum:{}, mobile:{}", new Object[]{bizId, materialNum, mobile});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)materialNum), (Object)"materialNum\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)mobile), (Object)"mobile\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> tagIds = this.selectTagIds(bizId, materialNum);
        if (CollectionUtils.isEmpty(tagIds)) {
            log.info("addTagWhenGetMaterialDetailByUserAuthorised, bizId:{}, materialNum:{}, mobile:{}, tagIds is empty", new Object[]{bizId, materialNum, mobile});
            return;
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        CrmLeadsTagReq req = new CrmLeadsTagReq();
        req.setBizId(bizId);
        req.setMobile(mobile);
        req.setTags(tagIds);
        req.setCorpId(businessCustomer.getCorpId());
        try {
            log.info("addTagWhenGetMaterialDetailByUserAuthorised, bizId:{}, materialNum:{}, mobile:{}, req:{}", new Object[]{bizId, materialNum, mobile, req});
            this.crmLeadsTagService.add(req);
        }
        catch (Exception e) {
            log.error("addTagWhenGetMaterialDetailByUserAuthorised, crmLeadsTagService.add, error", (Throwable)e);
        }
    }
}

