/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.material.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.applet.dto.req.setting.ViewSettingReq;
import com.kuaike.scrm.enums.AuthConfigEnum;
import com.kuaike.scrm.enums.GroupConfigEnum;
import com.kuaike.scrm.enums.QrcodeConfigEnum;
import com.kuaike.scrm.material.dto.req.MaterialGroupDto;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class AppletMaterialAddReq {
    private String areaCode;
    private String firstCategoryId;
    private String secondCategoryId;
    private String title;
    private String picUrl;
    private Long initNumber = 0L;
    private Set<String> tagIds;
    private Integer authConfig;
    private Integer qrcodeConfig;
    private Set<String> weworkUserNums;
    private Integer groupConfig;
    private List<MaterialGroupDto> groupDtos;

    public void validateParams(ViewSettingReq viewSettingReq) {
        if (NumberUtils.INTEGER_ONE.equals(viewSettingReq.getMaterial().getShowArea())) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.areaCode), (Object)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            Preconditions.checkArgument((boolean)StringUtils.isBlank((CharSequence)this.areaCode), (Object)"\u672a\u5f00\u542f\u533a\u57df\u7ec4\u4ef6,\u4e0d\u9700\u8981\u8bbe\u7f6e\u533a\u57df\u7684\u503c");
        }
        if (this.firstCategoryId == null) {
            this.firstCategoryId = "";
        }
        if (this.secondCategoryId == null) {
            this.secondCategoryId = "";
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.title), (Object)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.picUrl), (Object)"\u56fe\u7247\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.authConfig != null ? 1 : 0) != 0, (Object)"\u6388\u6743\u914d\u7f6e\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((AuthConfigEnum.get(this.authConfig) != null ? 1 : 0) != 0, (Object)"\u6388\u6743\u914d\u7f6e\u503c\u4e0d\u5408\u6cd5");
        Preconditions.checkArgument((this.qrcodeConfig != null ? 1 : 0) != 0, (Object)"\u4e8c\u7ef4\u7801\u8bbe\u7f6e\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        QrcodeConfigEnum qrcodeConfigEnum = QrcodeConfigEnum.get(this.qrcodeConfig);
        Preconditions.checkArgument((qrcodeConfigEnum != null ? 1 : 0) != 0, (Object)"\u4e8c\u7ef4\u7801\u8bbe\u7f6e\u503c\u4e0d\u5408\u6cd5");
        if (qrcodeConfigEnum == QrcodeConfigEnum.SPREAD_STAFF_CODE) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.weworkUserNums), (Object)"\u5907\u7528\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            this.weworkUserNums = null;
        }
        if (this.initNumber == null) {
            this.initNumber = 0L;
        }
        Preconditions.checkArgument((this.groupConfig != null ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        GroupConfigEnum groupConfigEnum = GroupConfigEnum.get(this.groupConfig);
        Preconditions.checkArgument((groupConfigEnum != null ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u503c\u4e0d\u5408\u6cd5");
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public String getFirstCategoryId() {
        return this.firstCategoryId;
    }

    public String getSecondCategoryId() {
        return this.secondCategoryId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPicUrl() {
        return this.picUrl;
    }

    public Long getInitNumber() {
        return this.initNumber;
    }

    public Set<String> getTagIds() {
        return this.tagIds;
    }

    public Integer getAuthConfig() {
        return this.authConfig;
    }

    public Integer getQrcodeConfig() {
        return this.qrcodeConfig;
    }

    public Set<String> getWeworkUserNums() {
        return this.weworkUserNums;
    }

    public Integer getGroupConfig() {
        return this.groupConfig;
    }

    public List<MaterialGroupDto> getGroupDtos() {
        return this.groupDtos;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public void setFirstCategoryId(String firstCategoryId) {
        this.firstCategoryId = firstCategoryId;
    }

    public void setSecondCategoryId(String secondCategoryId) {
        this.secondCategoryId = secondCategoryId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public void setInitNumber(Long initNumber) {
        this.initNumber = initNumber;
    }

    public void setTagIds(Set<String> tagIds) {
        this.tagIds = tagIds;
    }

    public void setAuthConfig(Integer authConfig) {
        this.authConfig = authConfig;
    }

    public void setQrcodeConfig(Integer qrcodeConfig) {
        this.qrcodeConfig = qrcodeConfig;
    }

    public void setWeworkUserNums(Set<String> weworkUserNums) {
        this.weworkUserNums = weworkUserNums;
    }

    public void setGroupConfig(Integer groupConfig) {
        this.groupConfig = groupConfig;
    }

    public void setGroupDtos(List<MaterialGroupDto> groupDtos) {
        this.groupDtos = groupDtos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppletMaterialAddReq)) {
            return false;
        }
        AppletMaterialAddReq other = (AppletMaterialAddReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$initNumber = this.getInitNumber();
        Long other$initNumber = other.getInitNumber();
        if (this$initNumber == null ? other$initNumber != null : !((Object)this$initNumber).equals(other$initNumber)) {
            return false;
        }
        Integer this$authConfig = this.getAuthConfig();
        Integer other$authConfig = other.getAuthConfig();
        if (this$authConfig == null ? other$authConfig != null : !((Object)this$authConfig).equals(other$authConfig)) {
            return false;
        }
        Integer this$qrcodeConfig = this.getQrcodeConfig();
        Integer other$qrcodeConfig = other.getQrcodeConfig();
        if (this$qrcodeConfig == null ? other$qrcodeConfig != null : !((Object)this$qrcodeConfig).equals(other$qrcodeConfig)) {
            return false;
        }
        Integer this$groupConfig = this.getGroupConfig();
        Integer other$groupConfig = other.getGroupConfig();
        if (this$groupConfig == null ? other$groupConfig != null : !((Object)this$groupConfig).equals(other$groupConfig)) {
            return false;
        }
        String this$areaCode = this.getAreaCode();
        String other$areaCode = other.getAreaCode();
        if (this$areaCode == null ? other$areaCode != null : !this$areaCode.equals(other$areaCode)) {
            return false;
        }
        String this$firstCategoryId = this.getFirstCategoryId();
        String other$firstCategoryId = other.getFirstCategoryId();
        if (this$firstCategoryId == null ? other$firstCategoryId != null : !this$firstCategoryId.equals(other$firstCategoryId)) {
            return false;
        }
        String this$secondCategoryId = this.getSecondCategoryId();
        String other$secondCategoryId = other.getSecondCategoryId();
        if (this$secondCategoryId == null ? other$secondCategoryId != null : !this$secondCategoryId.equals(other$secondCategoryId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$picUrl = this.getPicUrl();
        String other$picUrl = other.getPicUrl();
        if (this$picUrl == null ? other$picUrl != null : !this$picUrl.equals(other$picUrl)) {
            return false;
        }
        Set<String> this$tagIds = this.getTagIds();
        Set<String> other$tagIds = other.getTagIds();
        if (this$tagIds == null ? other$tagIds != null : !((Object)this$tagIds).equals(other$tagIds)) {
            return false;
        }
        Set<String> this$weworkUserNums = this.getWeworkUserNums();
        Set<String> other$weworkUserNums = other.getWeworkUserNums();
        if (this$weworkUserNums == null ? other$weworkUserNums != null : !((Object)this$weworkUserNums).equals(other$weworkUserNums)) {
            return false;
        }
        List<MaterialGroupDto> this$groupDtos = this.getGroupDtos();
        List<MaterialGroupDto> other$groupDtos = other.getGroupDtos();
        return !(this$groupDtos == null ? other$groupDtos != null : !((Object)this$groupDtos).equals(other$groupDtos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppletMaterialAddReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $initNumber = this.getInitNumber();
        result = result * 59 + ($initNumber == null ? 43 : ((Object)$initNumber).hashCode());
        Integer $authConfig = this.getAuthConfig();
        result = result * 59 + ($authConfig == null ? 43 : ((Object)$authConfig).hashCode());
        Integer $qrcodeConfig = this.getQrcodeConfig();
        result = result * 59 + ($qrcodeConfig == null ? 43 : ((Object)$qrcodeConfig).hashCode());
        Integer $groupConfig = this.getGroupConfig();
        result = result * 59 + ($groupConfig == null ? 43 : ((Object)$groupConfig).hashCode());
        String $areaCode = this.getAreaCode();
        result = result * 59 + ($areaCode == null ? 43 : $areaCode.hashCode());
        String $firstCategoryId = this.getFirstCategoryId();
        result = result * 59 + ($firstCategoryId == null ? 43 : $firstCategoryId.hashCode());
        String $secondCategoryId = this.getSecondCategoryId();
        result = result * 59 + ($secondCategoryId == null ? 43 : $secondCategoryId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $picUrl = this.getPicUrl();
        result = result * 59 + ($picUrl == null ? 43 : $picUrl.hashCode());
        Set<String> $tagIds = this.getTagIds();
        result = result * 59 + ($tagIds == null ? 43 : ((Object)$tagIds).hashCode());
        Set<String> $weworkUserNums = this.getWeworkUserNums();
        result = result * 59 + ($weworkUserNums == null ? 43 : ((Object)$weworkUserNums).hashCode());
        List<MaterialGroupDto> $groupDtos = this.getGroupDtos();
        result = result * 59 + ($groupDtos == null ? 43 : ((Object)$groupDtos).hashCode());
        return result;
    }

    public String toString() {
        return "AppletMaterialAddReq(areaCode=" + this.getAreaCode() + ", firstCategoryId=" + this.getFirstCategoryId() + ", secondCategoryId=" + this.getSecondCategoryId() + ", title=" + this.getTitle() + ", picUrl=" + this.getPicUrl() + ", initNumber=" + this.getInitNumber() + ", tagIds=" + this.getTagIds() + ", authConfig=" + this.getAuthConfig() + ", qrcodeConfig=" + this.getQrcodeConfig() + ", weworkUserNums=" + this.getWeworkUserNums() + ", groupConfig=" + this.getGroupConfig() + ", groupDtos=" + this.getGroupDtos() + ")";
    }
}

