/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.component.ComponentAuthAPI;
import cn.kinyun.scrm.weixin.sdk.entity.component.AppletFastRegisteMsg;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizationInfo;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizeMsg;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfo;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfoResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.req.audit.AuditAndReleaseReq;
import com.kuaike.scrm.applet.dto.req.auth.CheckAuthStatusReq;
import com.kuaike.scrm.applet.dto.req.auth.GetAppletByBusinessTypeReq;
import com.kuaike.scrm.applet.dto.resp.AppletListResp;
import com.kuaike.scrm.applet.dto.resp.auth.CheckAuthStatusResp;
import com.kuaike.scrm.applet.service.AppletAuditService;
import com.kuaike.scrm.applet.service.AppletAuthService;
import com.kuaike.scrm.applet.service.AppletDraftTemplateService;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.applet.AppletAuthStatus;
import com.kuaike.scrm.common.enums.applet.ShopAvailableStatus;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.dal.applet.entity.AppletAuditReleaseCriteria;
import com.kuaike.scrm.dal.applet.entity.FastRegisterDraft;
import com.kuaike.scrm.dal.applet.mapper.AppletAuditReleaseMapper;
import com.kuaike.scrm.dal.applet.mapper.FastRegisterDraftMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.enums.AppletUseBusinessType;
import com.kuaike.scrm.enums.FastRegisterWeAppStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppletAuthServiceImpl
implements AppletAuthService {
    private static final Logger log = LoggerFactory.getLogger(AppletAuthServiceImpl.class);
    @Autowired
    private ComponentTokenService componentTokenService;
    @Autowired
    private ComponentAuthAPI componentAuthAPI;
    @Value(value="${wx.component.appid}")
    private String componentAppId;
    @Autowired
    private AppletInfoMapper appletInfoMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private FastRegisterDraftMapper fastRegisterDraftMapper;
    @Resource
    private AppletAuditReleaseMapper appletAuditReleaseMapper;
    @Resource
    private IdGen idGen;
    @Resource
    private AppletAuditService appletAuditService;
    @Resource
    private AppletDraftTemplateService draftTemplateService;
    @Resource
    private DistributedLock lock;
    private int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService appletAuthService = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(10), (ThreadFactory)new NamedThreadFactory("appletAuthService"), new ThreadPoolExecutor.CallerRunsPolicy());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean callback(Long bizId, String authCode, int expire, String appletId) {
        AuthorizerInfoResp appInfo;
        String appId;
        AuthInfoResp authInfo;
        log.info("shop auth callback with bizId={},authCode={}, expire={}, appletId={}", new Object[]{bizId, authCode, expire, appletId});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)authCode), (Object)"authCode is null!");
        try {
            String componentAccessToken = this.componentTokenService.getComponentAccessToken();
            authInfo = this.componentAuthAPI.apiQueryAuth(componentAccessToken, this.componentAppId, authCode);
            appId = authInfo.getAuthorizationInfo().getAuthorizerAppId();
            appInfo = this.componentAuthAPI.apiGetAuthorizerInfo(componentAccessToken, this.componentAppId, appId);
        }
        catch (WeixinException e) {
            log.error("\u5c0f\u7a0b\u5e8f\u6388\u6743\u5931\u8d25", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
        }
        if (StringUtils.isBlank((CharSequence)appletId)) {
            if (this.fillShopInfo(bizId, appId, authInfo, appInfo)) {
                return false;
            }
        } else {
            String key = "handleAuthCallbackByAppletId-" + appletId;
            try {
                this.lock.lock(key);
                boolean bl = this.handleAuthCallbackByAppletId(bizId, appId, authInfo, appInfo, appletId);
                return bl;
            }
            catch (Exception e) {
                log.error("handleAuthCallbackByAppletId error", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock(key);
            }
        }
        return false;
    }

    private boolean handleAuthCallbackByAppletId(Long bizId, String appId, AuthInfoResp authInfo, AuthorizerInfoResp appInfo, String appletId) {
        log.info("handleAuthCallbackByAppletId bizId:{}, appletId:{} authInfo:{} appInfo:{}", new Object[]{bizId, appletId, authInfo, appInfo});
        AuthorizerInfo authorizerInfo = appInfo.getAuthorizerInfo();
        if (Objects.isNull(authorizerInfo.getMiniProgramInfo())) {
            log.warn("\u975e\u5c0f\u7a0b\u5e8f\u7c7b\u578b, appId={},nickname={}", (Object)appId, (Object)authorizerInfo.getNickName());
            return false;
        }
        AppletInfo select = new AppletInfo();
        select.setBizId(bizId);
        select.setNum(appletId);
        select.setIsDeleted(Integer.valueOf(0));
        select.setBusinessType(AppletUseBusinessType.MARKETING_MATERIAL.getType());
        AppletInfo appletInfo = (AppletInfo)this.appletInfoMapper.selectOne((Object)select);
        if (appletInfo == null) {
            log.error("\u5c0f\u7a0b\u5e8f\u6388\u6743\u5904\u7406\u5f02\u5e38, \u901a\u8fc7appletId\u67e5\u4e0d\u5230AppletInfo, bizId:{}, appletId:{}", (Object)bizId, (Object)appletId);
            return false;
        }
        if (AppletAuthStatus.AUTHORIZED.getStatus().equals(appletInfo.getAuthStatus())) {
            log.info("handleAuthCallbackByAppletId,\u5f53\u524d\u5c0f\u7a0b\u5e8f\u5df2\u6388\u6743,\u672c\u6b21\u4e0d\u5904\u7406,appletId:{}", (Object)appletId);
            return true;
        }
        AppletInfo selectExist = new AppletInfo();
        selectExist.setBizId(bizId);
        selectExist.setIsDeleted(Integer.valueOf(0));
        selectExist.setAppId(appId);
        AppletInfo appletInfoExist = (AppletInfo)this.appletInfoMapper.selectOne((Object)selectExist);
        if (appletInfoExist != null && appletInfoExist.getId().equals(appletInfo.getId())) {
            appletInfoExist = null;
        }
        this.updateAppletInfo(authorizerInfo, appletInfo, authInfo.getAuthorizationInfo(), null, appId, appletInfoExist);
        this.setDomain(appletInfo);
        this.appletAuthService.submit(() -> {
            try {
                String templateId = this.draftTemplateService.getMarketingMaterialValidTemplateId();
                AuditAndReleaseReq req = new AuditAndReleaseReq();
                req.setAppId(appId);
                CurrentUserInfo userInfo = new CurrentUserInfo();
                userInfo.setBizId(appletInfo.getBizId());
                userInfo.setCorpId(appletInfo.getCorpId());
                userInfo.setId(Long.valueOf(-1L));
                req.setUserInfo(userInfo);
                req.setTemplateId(templateId);
                this.appletAuditService.auditAndRelease(req);
            }
            catch (Exception e) {
                log.error("\u5c0f\u7a0b\u5e8f\u4e0a\u4f20\u4ee3\u7801\uff0c\u63d0\u4ea4\u5ba1\u6838\uff0c\u53d1\u5e03\u4ee3\u7801\u5f02\u5e38", (Throwable)e);
            }
        });
        return true;
    }

    private void setDomain(AppletInfo appletInfo) {
        int retryTimes = 3;
        while (retryTimes > 0) {
            try {
                if (appletInfo.getDomainStatus().equals(1)) {
                    return;
                }
                this.appletAuditService.reqSetDomain(appletInfo.getAccessToken());
                appletInfo.setDomainStatus(Integer.valueOf(1));
                return;
            }
            catch (Exception e) {
                log.error("\u5c0f\u7a0b\u5e8f\u6388\u6743\u56de\u8c03\uff0c\u8bbe\u7f6e\u670d\u52a1\u5668\u57df\u540d\u5f02\u5e38\uff0cretryTimes:{}", (Object)retryTimes, (Object)e);
                if (--retryTimes != 0) continue;
                StringBuilder msg = new StringBuilder(StringUtils.abbreviate((String)e.getMessage(), (int)240));
                msg.append(",\u8bf7\u8054\u7cfb\u5ba2\u670d");
                appletInfo.setDomainReason(msg.toString());
                appletInfo.setDomainStatus(Integer.valueOf(0));
            }
        }
    }

    @Override
    public boolean fillShopInfo(Long bizId, String appId, AuthInfoResp authInfo, AuthorizerInfoResp appInfo) {
        AppletInfo appletInfo;
        AuthorizerInfo authorizerInfo = appInfo.getAuthorizerInfo();
        if (Objects.isNull(authorizerInfo.getMiniProgramInfo())) {
            log.warn("\u975e\u5c0f\u7a0b\u5e8f\u7c7b\u578b, appId={},nickname={}", (Object)appId, (Object)authorizerInfo.getNickName());
            return true;
        }
        WeworkCorp weworkCorp = null;
        if (Objects.nonNull(bizId)) {
            weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        }
        if (Objects.isNull(appletInfo = this.appletInfoMapper.getByAppId(appId))) {
            log.info("insert appletInfo={}", (Object)appletInfo);
            this.insertAppletInfo(appId, authorizerInfo, authInfo.getAuthorizationInfo(), weworkCorp);
        } else {
            log.info("update appletInfo={}", (Object)appletInfo);
            this.updateAppletInfo(authorizerInfo, appletInfo, authInfo.getAuthorizationInfo(), weworkCorp, appId, null);
        }
        return false;
    }

    private void updateAppletInfo(AuthorizerInfo authorizerInfo, AppletInfo appletInfo, AuthorizationInfo authorizationInfo, WeworkCorp weworkCorp, String appId, AppletInfo appletInfoExist) {
        Date now = new Date();
        if (appletInfoExist != null) {
            String secondNum = appletInfo.getNum();
            appletInfo.setNum(appletInfoExist.getNum());
            appletInfo.setSecondNum(secondNum);
            appletInfo.setBusinessType(appletInfoExist.getBusinessType());
            log.info("updateAppletInfo,deleteByPrimaryKey:{}", (Object)appletInfoExist);
            this.appletInfoMapper.deleteByPrimaryKey((Object)appletInfoExist.getId());
        }
        appletInfo.setIsDeleted(Integer.valueOf(0));
        appletInfo.setAuthTime(now);
        appletInfo.setAuthStatus(AppletAuthStatus.AUTHORIZED.getStatus());
        appletInfo.setDeauthTime(null);
        appletInfo.setAppId(appId);
        if (Objects.nonNull(weworkCorp)) {
            appletInfo.setBizId(weworkCorp.getBizId());
            appletInfo.setCorpId(weworkCorp.getCorpId());
        }
        appletInfo.setLogo(authorizerInfo.getHeadImg());
        appletInfo.setAuthTime(now);
        appletInfo.setPrincipalName(authorizerInfo.getPrincipalName());
        appletInfo.setQrcodeUrl(authorizerInfo.getQrcodeUrl());
        appletInfo.setStoreName(authorizerInfo.getNickName());
        appletInfo.setUserName(authorizerInfo.getUserName());
        appletInfo.setServiceType(Integer.valueOf(authorizerInfo.getServiceTypeInfo().getId().intValue()));
        appletInfo.setVerifyType(Integer.valueOf(authorizerInfo.getVerifyTypeInfo().getId().intValue()));
        appletInfo.setAccessToken(authorizationInfo.getAuthorizerAccessToken());
        appletInfo.setRefreshToken(authorizationInfo.getAuthorizerRefreshToken());
        appletInfo.setTokenExpireTime(DateUtils.addSeconds((Date)now, (int)((int)authorizationInfo.getExpires())));
        appletInfo.setUpdateTime(now);
        log.info("updateAppletInfo,appletInfo:{}", (Object)appletInfo);
        this.appletInfoMapper.updateByPrimaryKey((Object)appletInfo);
    }

    private void insertAppletInfo(String appId, AuthorizerInfo authorizerInfo, AuthorizationInfo authorizationInfo, WeworkCorp weworkCorp) {
        AppletInfo appletInfo = new AppletInfo();
        appletInfo.setNum(this.idGen.getNum());
        appletInfo.setAppId(appId);
        appletInfo.setAuthStatus(Integer.valueOf(1));
        if (Objects.nonNull(weworkCorp)) {
            appletInfo.setBizId(weworkCorp.getBizId());
            appletInfo.setCorpId(weworkCorp.getCorpId());
        } else {
            appletInfo.setBizId(Long.valueOf(0L));
        }
        appletInfo.setLogo(authorizerInfo.getHeadImg());
        appletInfo.setAuthTime(new Date());
        appletInfo.setPrincipalName(authorizerInfo.getPrincipalName());
        appletInfo.setQrcodeUrl(authorizerInfo.getQrcodeUrl());
        appletInfo.setStoreName(authorizerInfo.getNickName());
        appletInfo.setUserName(authorizerInfo.getUserName());
        appletInfo.setCreateBy(Long.valueOf(-1L));
        appletInfo.setCreateTime(new Date());
        appletInfo.setType(Integer.valueOf(0));
        appletInfo.setServiceType(Integer.valueOf(authorizerInfo.getServiceTypeInfo().getId().intValue()));
        appletInfo.setVerifyType(Integer.valueOf(authorizerInfo.getVerifyTypeInfo().getId().intValue()));
        appletInfo.setAccessToken(authorizationInfo.getAuthorizerAccessToken());
        appletInfo.setRefreshToken(authorizationInfo.getAuthorizerRefreshToken());
        appletInfo.setTokenExpireTime(new Date(authorizationInfo.getExpires() * 1000L));
        this.appletInfoMapper.insertSelective((Object)appletInfo);
    }

    @Override
    public void unauthorize(AuthorizeMsg msg) {
        log.info("shopAuthService unauthorize with msg={}", (Object)msg);
        String appId = msg.getAuthorizerAppid();
        log.info("app deauth callback, appId={}", (Object)appId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null!");
        AppletInfo appletInfo = this.appletInfoMapper.getByAppId(appId);
        if (appletInfo != null) {
            appletInfo.setAuthStatus(AppletAuthStatus.DE_AUTHORIZED.getStatus());
            appletInfo.setShopAvailable(ShopAvailableStatus.UNAVAILABLE.getStatus());
            appletInfo.setDeauthTime(new Date());
            this.appletInfoMapper.updateByPrimaryKeySelective((Object)appletInfo);
            AppletAuditReleaseCriteria criteria = new AppletAuditReleaseCriteria();
            criteria.createCriteria().andAppIdEqualTo(appletInfo.getAppId());
            this.appletAuditReleaseMapper.deleteByExample((Object)criteria);
        }
    }

    @Override
    public void updateAuthorize(AuthorizeMsg msg) {
        log.info("shopAuthService updateAuthorize with msg={}", (Object)msg);
        String appId = msg.getAuthorizerAppid();
        String authCode = msg.getAuthorizationCode();
        Date expiredTime = new Date(msg.getAuthorizationCodeExpiredTime() * 1000L);
        String preAuthCode = msg.getPreAuthCode();
        log.info("updateAuthorize, appId={},authCode={},expiredTime={},preAuthCode={}", new Object[]{appId, authCode, expiredTime, preAuthCode});
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        try {
            AuthInfoResp authInfo = this.componentAuthAPI.apiQueryAuth(componentAccessToken, this.componentAppId, authCode);
            AuthorizerInfoResp appInfo = this.componentAuthAPI.apiGetAuthorizerInfo(componentAccessToken, this.componentAppId, appId);
            this.fillShopInfo(null, appId, authInfo, appInfo);
        }
        catch (WeixinException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fastRegisteCallback(AppletFastRegisteMsg msg) {
        FastRegisterWeAppStatus status;
        log.info("fastRegisteCallback with msg={}", (Object)msg);
        String appId = msg.getCreateAppId();
        String authCode = msg.getAuthCode();
        String corpName = msg.getInfo().getName();
        String code = msg.getInfo().getCode();
        String personaWechatId = msg.getInfo().getLegalPersonaWechat();
        String personaName = msg.getInfo().getLegalPersonaName();
        FastRegisterDraft draft = this.fastRegisterDraftMapper.queryByLegalInfo(personaWechatId, personaName, corpName, code);
        Long bizId = null;
        if (Objects.nonNull(draft)) {
            bizId = draft.getBizId();
        }
        if (Objects.equals((Object)FastRegisterWeAppStatus.SUCCESS, (Object)(status = FastRegisterWeAppStatus.getByStatus(msg.getStatus())))) {
            String componentAccessToken = this.componentTokenService.getComponentAccessToken();
            try {
                AuthInfoResp authInfo = this.componentAuthAPI.apiQueryAuth(componentAccessToken, this.componentAppId, authCode);
                AuthorizerInfoResp appInfo = this.componentAuthAPI.apiGetAuthorizerInfo(componentAccessToken, this.componentAppId, appId);
                this.fillShopInfo(bizId, appId, authInfo, appInfo);
                if (!Objects.nonNull(draft)) return;
                draft.setRegisterStatus(Integer.valueOf(2));
                draft.setAppId(appId);
                this.fastRegisterDraftMapper.updateByPrimaryKeySelective((Object)draft);
                return;
            }
            catch (WeixinException e) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
            }
        } else {
            if (!Objects.nonNull((Object)status) || !Objects.nonNull(draft)) return;
            draft.setRegisterReason(status.getDesc());
            draft.setRegisterStatus(Integer.valueOf(3));
            this.fastRegisterDraftMapper.updateByPrimaryKeySelective((Object)draft);
        }
    }

    @Override
    public CheckAuthStatusResp checkAuthStatus(CheckAuthStatusReq req) {
        log.info("checkAuthStatus req:{}", (Object)req);
        req.validate();
        CheckAuthStatusResp resp = new CheckAuthStatusResp();
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        List appletInfos = this.appletInfoMapper.queryByNumOrSecondNum(currentUser.getBizId(), req.getAppletId());
        if (CollectionUtils.isEmpty((Collection)appletInfos)) {
            resp.setAuthStatus(null);
            return resp;
        }
        AppletInfo appletInfo = (AppletInfo)appletInfos.get(0);
        resp.setAuthStatus(appletInfo.getAuthStatus());
        resp.setAppletId(appletInfo.getNum());
        return resp;
    }

    @Override
    public List<AppletListResp> getAppletByBusinessType(GetAppletByBusinessTypeReq req) {
        log.info("getAppletByBusinessType req:{}", (Object)req);
        req.validate();
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        AppletInfo select = new AppletInfo();
        select.setBizId(currentUser.getBizId());
        select.setBusinessType(req.getBusinessType());
        select.setAuthStatus(AppletAuthStatus.AUTHORIZED.getStatus());
        List appletInfos = this.appletInfoMapper.select((Object)select);
        if (CollectionUtils.isEmpty((Collection)appletInfos)) {
            return Collections.emptyList();
        }
        ArrayList<AppletListResp> respList = new ArrayList<AppletListResp>();
        for (AppletInfo appletInfo : appletInfos) {
            AppletListResp resp = new AppletListResp();
            resp.setId(appletInfo.getNum());
            resp.setName(appletInfo.getStoreName());
            resp.setAppId(appletInfo.getAppId());
            respList.add(resp);
        }
        return respList;
    }
}

