/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.material.service.impl;

import cn.kinyun.ad.common.dto.IdAndNameDto;
import cn.kinyun.ad.common.enums.AllocBusinessType;
import cn.kinyun.ad.common.req.alloc.CreateAllocCacheReq;
import cn.kinyun.ad.common.resp.alloc.CreateAllocCacheResp;
import cn.kinyun.ad.common.service.WeworkAllocService;
import cn.kinyun.scrm.weixin.sdk.api.applet.AppletQrcodeAPI;
import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateUrlLinkReq;
import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateUrlLinkResp;
import cn.kinyun.scrm.weixin.sdk.entity.applet.QrcodeCreateReq;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.req.AddFriendConfigReq;
import com.kuaike.scrm.applet.dto.resp.AddFriendConfigResp;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.dto.FriendWelcomeDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.applet.dto.SpreadChannelStaffQuery;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingAddFriendConfig;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterial;
import com.kuaike.scrm.dal.applet.entity.AppletSpreadChannel;
import com.kuaike.scrm.dal.applet.entity.AppletSpreadChannelStaff;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingAddFriendConfigMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletSpreadChannelMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletSpreadChannelStaffMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.enums.AppletUseBusinessType;
import com.kuaike.scrm.enums.SpreadCodeTypeEnum;
import com.kuaike.scrm.enums.StaffTypeEnum;
import com.kuaike.scrm.material.dto.SpreadStaffDto;
import com.kuaike.scrm.material.dto.req.ChannelStaffDto;
import com.kuaike.scrm.material.dto.req.MaterialBaseReq;
import com.kuaike.scrm.material.dto.req.SpreadCodeAddReq;
import com.kuaike.scrm.material.dto.req.SpreadCodeDetailReq;
import com.kuaike.scrm.material.dto.req.SpreadCodeLinkReq;
import com.kuaike.scrm.material.dto.req.SpreadCodeListReq;
import com.kuaike.scrm.material.dto.req.SpreadCodeModReq;
import com.kuaike.scrm.material.dto.resp.ChannelSpreadCodeResp;
import com.kuaike.scrm.material.dto.resp.SpreadCodeDetailResp;
import com.kuaike.scrm.material.dto.resp.StaffSpreadCodeResp;
import com.kuaike.scrm.material.service.SpreadCodeService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.lucene.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SpreadCodeServiceImpl
implements SpreadCodeService {
    private static final Logger log = LoggerFactory.getLogger(SpreadCodeServiceImpl.class);
    @Autowired
    private AliyunOss aliyunOss;
    @Resource
    private WeworkAllocService weworkAllocService;
    @Resource
    private IdGen idGen;
    @Resource
    private AppletQrcodeAPI appletQrcodeAPI;
    @Resource
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private AppletMarketingMaterialMapper materialMapper;
    @Resource
    private AppletSpreadChannelMapper spreadChannelMapper;
    @Resource
    private AppletSpreadChannelStaffMapper channelStaffMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private AppletMarketingAddFriendConfigMapper appletMarketingAddFriendConfigMapper;
    @Value(value="${applet.marketing.index.page}")
    private String marketingIndexPage;
    @Value(value="${scrm.applet.envVersion}")
    private String envVersion;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService spreadCodeExecutorService = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(2000), (ThreadFactory)new NamedThreadFactory("spreadCodeExecutorService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public List<ChannelSpreadCodeResp> channelCodeList(MaterialBaseReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("channelCodeList:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        AppletMarketingMaterial marketingMaterial = this.materialMapper.selectByNum(req.getMaterialId());
        if (marketingMaterial == null) {
            log.info("channelCodeList,\u6839\u636enum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getMaterialId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        List spreadChannels = this.spreadChannelMapper.selectByBizIdAndMaterialId(userInfo.getBizId(), marketingMaterial.getId());
        if (CollectionUtils.isEmpty((Collection)spreadChannels)) {
            return Collections.emptyList();
        }
        Set channelNums = spreadChannels.stream().map(AppletSpreadChannel::getChannelId).collect(Collectors.toSet());
        Map channelNum2NameMap = this.channelMapper.selectNameByNums(userInfo.getBizId(), channelNums);
        ArrayList resps = Lists.newArrayList();
        for (AppletSpreadChannel spreadChannel : spreadChannels) {
            ChannelSpreadCodeResp resp = new ChannelSpreadCodeResp();
            resps.add(resp);
            resp.setId(spreadChannel.getNum());
            resp.setMaterialId(req.getMaterialId());
            resp.setChannelId(spreadChannel.getChannelId());
            resp.setChannelName(channelNum2NameMap != null ? (String)channelNum2NameMap.get(spreadChannel.getChannelId()) : "");
            resp.setQrcodeUrl(spreadChannel.getQrcodeUrl());
        }
        return resps;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SpreadCodeAddReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("add spread code req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        AppletMarketingMaterial marketingMaterial = this.materialMapper.selectByNum(req.getMaterialId());
        if (marketingMaterial == null) {
            log.info("\u6839\u636ematerialNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getMaterialId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8d44\u6599id\u503c\u4e0d\u5408\u6cd5");
        }
        Long materialId = marketingMaterial.getId();
        List<ChannelStaffDto> channelStaffDtos = req.getChannelStaffDtos();
        channelStaffDtos.forEach(channelStaffDto -> channelStaffDto.validateParams(marketingMaterial.getQrcodeConfig()));
        String appId = this.getAppletId(userInfo.getBizId());
        HashMap ruleId2CacheIdMap = Maps.newHashMap();
        Date currDate = new Date();
        HashSet channelSpreadCodeNums = Sets.newHashSet();
        HashSet staffSpreadCodeNums = Sets.newHashSet();
        for (ChannelStaffDto channelStaffDto2 : channelStaffDtos) {
            Set<String> userNums = channelStaffDto2.getUserIds();
            Set<String> partTimeJobPerson = channelStaffDto2.getPartTimeJobPerson();
            List users = this.userMapper.getUserInfoByNums(userNums);
            HashMap userId2NumMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)users)) {
                Map deptId2NumMap = this.organizationMapper.getNumByIds(userInfo.getBizId(), (Collection)users.stream().map(User::getNodeId).collect(Collectors.toSet()));
                for (User user : users) {
                    if (!Objects.nonNull(user.getNodeId()) || !deptId2NumMap.containsKey(user.getNodeId())) continue;
                    userId2NumMap.put(user.getNum(), deptId2NumMap.get(user.getNodeId()));
                }
            }
            for (String channelId : channelStaffDto2.getChannelIds()) {
                AppletSpreadChannelStaff channelStaff;
                String channelStaffNum;
                ArrayList spreadChannelStaffs = Lists.newArrayList();
                String allocRuleId = channelStaffDto2.getAllocRuleId();
                String allocCacheId = "";
                if (StringUtils.isNotBlank((CharSequence)allocRuleId) && !ruleId2CacheIdMap.containsKey(allocRuleId)) {
                    allocCacheId = this.getAllocCacheId(userInfo, allocRuleId);
                    ruleId2CacheIdMap.put(allocRuleId, allocCacheId);
                }
                String channelSpreadNum = this.idGen.getNum();
                channelSpreadCodeNums.add(channelSpreadNum);
                AppletSpreadChannel spreadChannel = this.buildSpreadChannel(materialId, channelSpreadNum, channelId, allocRuleId, allocCacheId, "", userInfo, currDate);
                this.spreadChannelMapper.insertSelective((Object)spreadChannel);
                Long spreadChannelId = spreadChannel.getId();
                if (CollectionUtils.isNotEmpty(userNums)) {
                    for (String userNum : userNums) {
                        channelStaffNum = this.idGen.getNum();
                        staffSpreadCodeNums.add(channelStaffNum);
                        channelStaff = this.buildSpreadChannelStaff(userInfo, materialId, spreadChannelId, userNum, StaffTypeEnum.EMPLOYEE.getStatus(), (String)userId2NumMap.get(userNum), "", channelStaffNum, currDate);
                        spreadChannelStaffs.add(channelStaff);
                    }
                }
                if (CollectionUtils.isNotEmpty(partTimeJobPerson)) {
                    for (String jobPerson : partTimeJobPerson) {
                        channelStaffNum = this.idGen.getNum();
                        staffSpreadCodeNums.add(channelStaffNum);
                        channelStaff = this.buildSpreadChannelStaff(userInfo, materialId, spreadChannelId, jobPerson, StaffTypeEnum.PART_TIME.getStatus(), channelStaffDto2.getDeptId(), "", channelStaffNum, currDate);
                        spreadChannelStaffs.add(channelStaff);
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)spreadChannelStaffs)) continue;
                this.channelStaffMapper.batchInsert((Collection)spreadChannelStaffs);
            }
        }
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        new Thread(() -> {
            for (String channelSpreadCodeNum : channelSpreadCodeNums) {
                this.spreadCodeExecutorService.submit(() -> {
                    try {
                        String qrcodeUrl = this.getQrcodeUrl(accessToken, userInfo.getCorpId(), SpreadCodeTypeEnum.CHANNEL_SPREAD_CODE.getValue(), channelSpreadCodeNum, req.getMaterialId());
                        this.spreadChannelMapper.updateQrcodeUrlByNum(qrcodeUrl, channelSpreadCodeNum);
                    }
                    catch (Exception ex) {
                        log.error("materialNum:{},channelSpreadCodeNum:{}\u751f\u6210\u63a8\u5e7f\u7801\u5931\u8d25:", new Object[]{req.getMaterialId(), channelSpreadCodeNum, ex});
                    }
                });
            }
        }).start();
        new Thread(() -> {
            for (String staffSpreadCodeNum : staffSpreadCodeNums) {
                this.spreadCodeExecutorService.submit(() -> {
                    try {
                        String qrcodeUrl = this.getQrcodeUrl(accessToken, userInfo.getCorpId(), SpreadCodeTypeEnum.STAFF_SPREAD_CODE.getValue(), staffSpreadCodeNum, req.getMaterialId());
                        this.channelStaffMapper.updateQrcodeUrlByNum(qrcodeUrl, staffSpreadCodeNum);
                    }
                    catch (Exception ex) {
                        log.error("materialNum:{},staffSpreadCodeNum:{}\u751f\u6210\u63a8\u5e7f\u7801\u5931\u8d25:", new Object[]{req.getMaterialId(), staffSpreadCodeNum, ex});
                    }
                });
            }
        }).start();
    }

    @Override
    public List<SpreadCodeDetailResp> channelCodeDetail(SpreadCodeDetailReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("channelCodeDetail req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        AppletMarketingMaterial marketingMaterial = this.materialMapper.selectByNum(req.getMaterialId());
        if (marketingMaterial == null) {
            log.info("\u6839\u636ematerialNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getMaterialId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d44\u6599id\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        List spreadChannels = this.spreadChannelMapper.queryByBizIdMaterialIdAndChannelId(userInfo.getBizId(), marketingMaterial.getId(), req.getChannelId());
        if (CollectionUtils.isEmpty((Collection)spreadChannels)) {
            log.info("\u6839\u636ematerialId:{},channelId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)marketingMaterial.getId(), (Object)req.getChannelId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        Map spreadChannelId2SpreadChannelMap = spreadChannels.stream().collect(Collectors.toMap(AppletSpreadChannel::getId, Functions.identity()));
        Set spreadChannelIds = spreadChannels.stream().map(AppletSpreadChannel::getId).collect(Collectors.toSet());
        List channelStaffs = this.channelStaffMapper.queryByMaterialIdAndSpreadChannelId(userInfo.getBizId(), marketingMaterial.getId(), spreadChannelIds);
        Map channelNum2NameMap = this.channelMapper.selectNameByNums(userInfo.getBizId(), Collections.singletonList(req.getChannelId()));
        ArrayList resps = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)channelStaffs)) {
            for (AppletSpreadChannel spreadChannel : spreadChannels) {
                SpreadCodeDetailResp resp = new SpreadCodeDetailResp();
                resps.add(resp);
                resp.setChannelSpreadCodeId(spreadChannel.getNum());
                resp.setMaterialId(marketingMaterial.getNum());
                resp.setChannelId(spreadChannel.getChannelId());
                resp.setChannelName(channelNum2NameMap != null ? (String)channelNum2NameMap.get(req.getChannelId()) : "");
                resp.setAllocRuleId(spreadChannel.getAllocRuleId());
            }
            return resps;
        }
        Map<Long, List<AppletSpreadChannelStaff>> spreadChannelId2StaffsMap = channelStaffs.stream().collect(Collectors.groupingBy(AppletSpreadChannelStaff::getSpreadChannelId));
        for (Map.Entry<Long, List<AppletSpreadChannelStaff>> entry : spreadChannelId2StaffsMap.entrySet()) {
            Set userNums;
            List users;
            List employees;
            List<AppletSpreadChannelStaff> channelStaffList = entry.getValue();
            AppletSpreadChannel spreadChannel = (AppletSpreadChannel)spreadChannelId2SpreadChannelMap.get(entry.getKey());
            SpreadCodeDetailResp resp = new SpreadCodeDetailResp();
            resps.add(resp);
            resp.setChannelSpreadCodeId(spreadChannel.getNum());
            resp.setMaterialId(marketingMaterial.getNum());
            resp.setChannelId(spreadChannel.getChannelId());
            resp.setChannelName(channelNum2NameMap != null ? (String)channelNum2NameMap.get(req.getChannelId()) : "");
            resp.setAllocRuleId(spreadChannel.getAllocRuleId());
            List partTimeJobList = channelStaffList.stream().filter(staff -> StaffTypeEnum.PART_TIME.getStatus() == staff.getStaffType().intValue()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(partTimeJobList)) {
                Set<String> partTimeJobPerson = partTimeJobList.stream().map(AppletSpreadChannelStaff::getUserId).collect(Collectors.toSet());
                String deptNum = ((AppletSpreadChannelStaff)partTimeJobList.get(0)).getBelongDeptId();
                Map deptNum2NameMap = this.organizationMapper.getOrgNameByIds(userInfo.getBizId(), Collections.singletonList(deptNum));
                resp.setPartTimeJobPerson(partTimeJobPerson);
                resp.setDeptId(deptNum);
                resp.setDeptName(deptNum2NameMap != null ? (String)deptNum2NameMap.get(deptNum) : "");
            }
            if (!CollectionUtils.isNotEmpty(employees = channelStaffList.stream().filter(staff -> StaffTypeEnum.EMPLOYEE.getStatus() == staff.getStaffType().intValue()).collect(Collectors.toList())) || !CollectionUtils.isNotEmpty((Collection)(users = this.userMapper.getUserInfoByNums(userNums = employees.stream().map(AppletSpreadChannelStaff::getUserId).collect(Collectors.toSet()))))) continue;
            ArrayList staffDtos = Lists.newArrayList();
            for (User user : users) {
                SpreadStaffDto spreadStaffDto = new SpreadStaffDto();
                staffDtos.add(spreadStaffDto);
                spreadStaffDto.setUserId(user.getNum());
                spreadStaffDto.setUserName(user.getName());
            }
            resp.setSpreadStaff(staffDtos);
        }
        return resps;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void channelCodeMod(List<SpreadCodeModReq> reqs) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("mod spread code reqs:{},operatorId:{}", reqs, (Object)userInfo.getId());
        AppletMarketingMaterial marketingMaterial = this.materialMapper.selectByNum(reqs.get(0).getMaterialId());
        if (marketingMaterial == null) {
            log.info("\u6839\u636ematerialNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqs.get(0).getMaterialId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d44\u6599id\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        reqs.forEach(req -> req.validate(marketingMaterial.getQrcodeConfig()));
        Date currDate = new Date();
        Set channelSpreadIds = reqs.stream().map(SpreadCodeModReq::getChannelSpreadCodeId).collect(Collectors.toSet());
        List spreadChannels = this.spreadChannelMapper.selectByParams(userInfo.getBizId(), marketingMaterial.getId(), channelSpreadIds);
        if (CollectionUtils.isEmpty(channelSpreadIds)) {
            log.info("\u6839\u636ematerialId:{},channelSpreadIds:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)marketingMaterial.getId(), (Object)spreadChannels);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        Set newSpreadChannelIds = spreadChannels.stream().map(AppletSpreadChannel::getId).collect(Collectors.toSet());
        Set oldSpreadChannelIds = this.spreadChannelMapper.selectIdsByMaterialIdAndChannelId(userInfo.getBizId(), marketingMaterial.getId(), reqs.get(0).getChannelId());
        Collection needDelSpreadChannelIds = CollectionUtils.removeAll((Collection)oldSpreadChannelIds, newSpreadChannelIds);
        if (CollectionUtils.isNotEmpty((Collection)needDelSpreadChannelIds)) {
            log.info("channelCodeMod,\u9700\u8981\u5220\u9664\u7684\u6e20\u9053\u63a8\u5e7f\u7801ids:{}", (Object)needDelSpreadChannelIds);
            this.spreadChannelMapper.logicDelByIds(userInfo.getId(), currDate, needDelSpreadChannelIds);
            this.channelStaffMapper.logicDelByMaterialIdAndSpreadChannelIds(userInfo.getId(), currDate, userInfo.getBizId(), marketingMaterial.getId(), needDelSpreadChannelIds);
        }
        Map spreadChannelNum2SpreadChannelMap = spreadChannels.stream().collect(Collectors.toMap(AppletSpreadChannel::getNum, Functions.identity()));
        String appId = this.getAppletId(userInfo.getBizId());
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        HashSet cacheRuleIds = Sets.newHashSet();
        for (SpreadCodeModReq req2 : reqs) {
            String staffQrcodeUrl;
            String channelStaffNum;
            Collection needDelUserIds;
            AppletSpreadChannel spreadChannel = (AppletSpreadChannel)spreadChannelNum2SpreadChannelMap.get(req2.getChannelSpreadCodeId());
            String oldAllocRuleId = spreadChannel.getAllocRuleId();
            String oldAllocCacheId = spreadChannel.getAllocRuleCacheId();
            String newAllocRuleId = req2.getAllocRuleId();
            log.info("\u7f16\u8f91\u524d\u540e\u7684\u5206\u914d\u89c4\u5219\uff0coldAllocRuleId:{},newAllocRuleId:{}", (Object)oldAllocRuleId, (Object)newAllocRuleId);
            boolean isNeedReleaseCacheRule = false;
            if (!oldAllocRuleId.equals(newAllocRuleId)) {
                if (StringUtils.isNotBlank((CharSequence)oldAllocRuleId)) {
                    isNeedReleaseCacheRule = true;
                }
                if (StringUtils.isNotBlank((CharSequence)newAllocRuleId)) {
                    String allocCacheId = this.getAllocCacheId(userInfo, newAllocRuleId);
                    spreadChannel.setAllocRuleId(newAllocRuleId);
                    spreadChannel.setAllocRuleCacheId(allocCacheId);
                    spreadChannel.setUpdateBy(userInfo.getId());
                    spreadChannel.setUpdateTime(currDate);
                    this.spreadChannelMapper.updateByPrimaryKey((Object)spreadChannel);
                }
            }
            Set<String> newEmployee = req2.getUserIds();
            Set<String> newPartTimeJobPerson = req2.getPartTimeJobPerson();
            List channelStaffs = this.channelStaffMapper.queryByMaterialIdAndSpreadChannelId(userInfo.getBizId(), marketingMaterial.getId(), Collections.singletonList(spreadChannel.getId()));
            List employeeList = null;
            List partTimeJobPersonList = null;
            if (CollectionUtils.isNotEmpty((Collection)channelStaffs)) {
                employeeList = channelStaffs.stream().filter(staff -> staff.getStaffType().intValue() == StaffTypeEnum.EMPLOYEE.getStatus()).collect(Collectors.toList());
                partTimeJobPersonList = channelStaffs.stream().filter(staff -> staff.getStaffType().intValue() == StaffTypeEnum.PART_TIME.getStatus()).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty(partTimeJobPersonList)) {
                String oldDeptId = ((AppletSpreadChannelStaff)partTimeJobPersonList.get(0)).getBelongDeptId();
                log.info("\u7f16\u8f91\u524d\u540e\u7684\u517c\u804c\u96b6\u5c5e\u90e8\u95e8,oldDeptId:{}, newDeptId:{}", (Object)oldDeptId, (Object)req2.getDeptId());
                if (StringUtils.isNotBlank((CharSequence)req2.getDeptId()) && !req2.getDeptId().equals(oldDeptId)) {
                    this.channelStaffMapper.updateDeptIdByIds(userInfo.getId(), currDate, req2.getDeptId(), (Collection)partTimeJobPersonList.stream().map(AppletSpreadChannelStaff::getId).collect(Collectors.toList()));
                }
            }
            Long materialId = marketingMaterial.getId();
            Long spreadChannelId = spreadChannel.getId();
            HashSet needAddUserIds = Sets.newHashSet();
            ArrayList needDelIds = Lists.newArrayList();
            ArrayList needAddRecords = Lists.newArrayList();
            if (CollectionUtils.isEmpty(newEmployee)) {
                if (CollectionUtils.isNotEmpty(employeeList)) {
                    needDelIds.addAll(employeeList.stream().map(AppletSpreadChannelStaff::getId).collect(Collectors.toList()));
                }
            } else {
                Object users;
                if (CollectionUtils.isEmpty(employeeList)) {
                    needAddUserIds.addAll(newEmployee);
                } else {
                    Map userId2StaffMap = employeeList.stream().collect(Collectors.toMap(AppletSpreadChannelStaff::getUserId, Functions.identity()));
                    Set<String> oldEmployee = userId2StaffMap.keySet();
                    needAddUserIds.addAll(CollectionUtils.removeAll(newEmployee, oldEmployee));
                    needDelUserIds = CollectionUtils.removeAll(oldEmployee, newEmployee);
                    if (CollectionUtils.isNotEmpty((Collection)needDelUserIds)) {
                        for (String userId : needDelUserIds) {
                            needDelIds.add(((AppletSpreadChannelStaff)userId2StaffMap.get(userId)).getId());
                        }
                    }
                }
                HashMap userId2NumMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty((Collection)needAddUserIds) && CollectionUtils.isNotEmpty((Collection)(users = this.userMapper.getUserInfoByNums((Collection)needAddUserIds)))) {
                    Map deptId2NumMap = this.organizationMapper.getNumByIds(userInfo.getBizId(), (Collection)users.stream().map(User::getNodeId).collect(Collectors.toSet()));
                    Iterator iterator = users.iterator();
                    while (iterator.hasNext()) {
                        User user = (User)iterator.next();
                        if (!Objects.nonNull(user.getNodeId()) || !deptId2NumMap.containsKey(user.getNodeId())) continue;
                        userId2NumMap.put(user.getNum(), deptId2NumMap.get(user.getNodeId()));
                    }
                }
                users = needAddUserIds.iterator();
                while (users.hasNext()) {
                    String userId = (String)users.next();
                    channelStaffNum = this.idGen.getNum();
                    staffQrcodeUrl = this.getQrcodeUrl(accessToken, userInfo.getCorpId(), SpreadCodeTypeEnum.STAFF_SPREAD_CODE.getValue(), channelStaffNum, req2.getMaterialId());
                    AppletSpreadChannelStaff channelStaff = this.buildSpreadChannelStaff(userInfo, materialId, spreadChannelId, userId, StaffTypeEnum.EMPLOYEE.getStatus(), (String)userId2NumMap.get(userId), staffQrcodeUrl, channelStaffNum, currDate);
                    needAddRecords.add(channelStaff);
                }
            }
            needAddUserIds = Sets.newHashSet();
            if (CollectionUtils.isEmpty(newPartTimeJobPerson)) {
                if (CollectionUtils.isNotEmpty(partTimeJobPersonList)) {
                    needDelIds.addAll(partTimeJobPersonList.stream().map(AppletSpreadChannelStaff::getId).collect(Collectors.toList()));
                }
            } else {
                if (CollectionUtils.isEmpty(partTimeJobPersonList)) {
                    needAddUserIds.addAll(newPartTimeJobPerson);
                } else {
                    Map userId2PartTimeStaffMap = partTimeJobPersonList.stream().collect(Collectors.toMap(AppletSpreadChannelStaff::getUserId, Functions.identity()));
                    Set<String> oldPartTimeJobPerson = userId2PartTimeStaffMap.keySet();
                    needAddUserIds.addAll(CollectionUtils.removeAll(newPartTimeJobPerson, oldPartTimeJobPerson));
                    needDelUserIds = CollectionUtils.removeAll(oldPartTimeJobPerson, newPartTimeJobPerson);
                    if (CollectionUtils.isNotEmpty((Collection)needDelUserIds)) {
                        for (String userId : needDelUserIds) {
                            needDelIds.add(((AppletSpreadChannelStaff)userId2PartTimeStaffMap.get(userId)).getId());
                        }
                    }
                }
                for (String userId : needAddUserIds) {
                    channelStaffNum = this.idGen.getNum();
                    staffQrcodeUrl = this.getQrcodeUrl(accessToken, userInfo.getCorpId(), SpreadCodeTypeEnum.STAFF_SPREAD_CODE.getValue(), channelStaffNum, req2.getMaterialId());
                    AppletSpreadChannelStaff channelStaff = this.buildSpreadChannelStaff(userInfo, materialId, spreadChannelId, userId, StaffTypeEnum.PART_TIME.getStatus(), req2.getDeptId(), staffQrcodeUrl, channelStaffNum, currDate);
                    needAddRecords.add(channelStaff);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)needAddRecords)) {
                this.channelStaffMapper.batchInsert((Collection)needAddRecords);
            }
            if (CollectionUtils.isNotEmpty((Collection)needDelIds)) {
                this.channelStaffMapper.logicDelByIds(userInfo.getId(), currDate, (Collection)needDelIds);
            }
            if (!isNeedReleaseCacheRule || !StringUtils.isNotBlank((CharSequence)oldAllocCacheId)) continue;
            cacheRuleIds.add(oldAllocCacheId);
            this.weworkAllocService.releaseByCacheNum(oldAllocCacheId);
        }
        if (CollectionUtils.isNotEmpty((Collection)cacheRuleIds)) {
            new Thread(() -> {
                for (String cacheRuleId : cacheRuleIds) {
                    try {
                        log.info("\u91ca\u653e\u540d\u7247\u7f13\u5b58cacheRuleId:{}", (Object)cacheRuleId);
                        this.weworkAllocService.releaseByCacheNum(cacheRuleId);
                    }
                    catch (Exception ex) {
                        log.error("\u91ca\u653e\u540d\u7247\u7f13\u5b58cacheRuleId:{}\u5931\u8d25\uff1a", (Object)cacheRuleId, (Object)ex);
                    }
                }
            }).start();
        }
    }

    @Override
    public List<StaffSpreadCodeResp> staffQrcodeList(SpreadCodeListReq req) {
        Set userNums;
        List users;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("add spread code reqs:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        AppletMarketingMaterial marketingMaterial = this.materialMapper.selectByNum(req.getMaterialId());
        if (marketingMaterial == null) {
            log.info("\u6839\u636ematerialNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getMaterialId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d44\u6599id\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        List spreadChannels = this.spreadChannelMapper.queryByBizIdMaterialIdAndChannelId(userInfo.getBizId(), marketingMaterial.getId(), req.getChannelId());
        if (CollectionUtils.isEmpty((Collection)spreadChannels)) {
            log.info("\u6839\u636ematerialId:{},channelNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)marketingMaterial.getId(), (Object)req.getChannelId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        Map channelNum2NameMap = this.channelMapper.selectNameByNums(userInfo.getBizId(), Collections.singletonList(req.getChannelId()));
        String channelName = MapUtils.isNotEmpty((Map)channelNum2NameMap) ? (String)channelNum2NameMap.get(req.getChannelId()) : "";
        SpreadChannelStaffQuery query = new SpreadChannelStaffQuery();
        query.setBizId(userInfo.getBizId());
        query.setMaterialId(marketingMaterial.getId());
        query.setSpreadChannelIds(spreadChannels.stream().map(AppletSpreadChannel::getId).collect(Collectors.toSet()));
        query.setOffset(Integer.valueOf(req.getPageDto().getOffset()));
        query.setPageSize(req.getPageDto().getPageSize());
        List channelStaffs = this.channelStaffMapper.selectListByQuery(query);
        if (CollectionUtils.isEmpty((Collection)channelStaffs)) {
            return Collections.emptyList();
        }
        int count = this.channelStaffMapper.selectCountByQuery(query);
        req.getPageDto().setCount(Integer.valueOf(count));
        List employees = channelStaffs.stream().filter(staff -> StaffTypeEnum.EMPLOYEE.getStatus() == staff.getStaffType().intValue()).collect(Collectors.toList());
        Map<String, String> userNum2NameMap = null;
        if (CollectionUtils.isNotEmpty(employees) && CollectionUtils.isNotEmpty((Collection)(users = this.userMapper.getUserInfoByNums(userNums = employees.stream().map(AppletSpreadChannelStaff::getUserId).collect(Collectors.toSet()))))) {
            userNum2NameMap = users.stream().collect(Collectors.toMap(User::getNum, User::getName, (k1, k2) -> k2));
        }
        ArrayList resps = Lists.newArrayList();
        for (AppletSpreadChannelStaff channelStaff : channelStaffs) {
            StaffSpreadCodeResp codeResp = new StaffSpreadCodeResp();
            resps.add(codeResp);
            codeResp.setId(channelStaff.getNum());
            codeResp.setMaterialId(req.getMaterialId());
            codeResp.setQrcodeUrl(channelStaff.getQrcodeUrl());
            codeResp.setStaffType(channelStaff.getStaffType());
            codeResp.setStaffTypeDesc(StaffTypeEnum.get(channelStaff.getStaffType()).getDesc());
            codeResp.setChannelName(channelName);
            if (StaffTypeEnum.EMPLOYEE.getStatus() == channelStaff.getStaffType().intValue()) {
                codeResp.setStaffName(userNum2NameMap != null ? userNum2NameMap.get(channelStaff.getUserId()) : "");
                continue;
            }
            codeResp.setStaffName(channelStaff.getUserId());
        }
        return resps;
    }

    @Override
    public String getLink(SpreadCodeLinkReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("getLink,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        String appId = this.getAppletId(userInfo.getBizId());
        StringBuilder sb = new StringBuilder("a=").append(req.getSpreadCodeType()).append("&b=").append(req.getSpreadCodeId()).append("&c=").append(req.getMaterialId());
        GenerateUrlLinkReq urlLinkReq = new GenerateUrlLinkReq();
        urlLinkReq.setPath(this.marketingIndexPage);
        urlLinkReq.setQuery(sb.toString());
        urlLinkReq.setIsExpire(Boolean.valueOf(true));
        urlLinkReq.setExpireType(NumberUtils.INTEGER_ONE);
        urlLinkReq.setEnvVersion(this.envVersion);
        try {
            String accessToken = this.appletAccessTokenService.getAccessToken(appId);
            GenerateUrlLinkResp urlLinkResp = this.appletQrcodeAPI.generateUrlLinkUrl(accessToken, urlLinkReq);
            return urlLinkResp.getUrlLink();
        }
        catch (Exception ex) {
            log.error("urlLinkReq:{},\u751f\u6210\u5c0f\u7a0b\u5e8furl link\u53d1\u751f\u5f02\u5e38:", (Object)urlLinkReq, (Object)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u5c0f\u7a0b\u5e8f\u94fe\u63a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public void addFriendConfig(AddFriendConfigReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("addFriendConfig,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        AppletMarketingMaterial marketingMaterial = this.materialMapper.selectByNum(req.getMaterialId());
        if (marketingMaterial == null) {
            log.warn("\u6839\u636ematerialNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getMaterialId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        AppletMarketingAddFriendConfig addFriendConfig = req.convert2AddFriendConfig(userInfo, marketingMaterial.getId());
        addFriendConfig.setNum(this.idGen.getNum());
        this.appletMarketingAddFriendConfigMapper.insertOrUpdate(addFriendConfig);
    }

    @Override
    public AddFriendConfigResp addFriendConfigDetail(AddFriendConfigReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("addFriendConfigDetail,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        AppletMarketingMaterial marketingMaterial = this.materialMapper.selectByNum(req.getMaterialId());
        if (marketingMaterial == null) {
            log.warn("\u6839\u636ematerialNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getMaterialId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        AddFriendConfigResp addFriendConfigResp = new AddFriendConfigResp();
        addFriendConfigResp.setMaterialId(req.getMaterialId());
        addFriendConfigResp.setChannelId(req.getChannelId());
        AppletMarketingAddFriendConfig addFriendConfig = this.appletMarketingAddFriendConfigMapper.selectByMaterialIdAndChannelId(userInfo.getBizId(), marketingMaterial.getId(), req.getChannelId());
        if (addFriendConfig == null) {
            log.warn("\u8d44\u6599:{}\u5bf9\u5e94\u7684\u6e20\u9053:{}\u8fd8\u672a\u914d\u7f6e\u52a0\u597d\u53cb\u76f8\u5173\u4fe1\u606f", (Object)req.getMaterialId(), (Object)req.getChannelId());
            return addFriendConfigResp;
        }
        addFriendConfigResp.setAddFriendRemark(addFriendConfig.getAddFriendRemark());
        if (StringUtils.isNotBlank((CharSequence)addFriendConfig.getTagIds())) {
            addFriendConfigResp.setTagIds(JSONArray.parseArray((String)addFriendConfig.getTagIds(), IdAndNameDto.class));
        }
        if (StringUtils.isNotBlank((CharSequence)addFriendConfig.getWelcomeContent())) {
            addFriendConfigResp.setAddFriendWelcome((FriendWelcomeDto)JSONObject.parseObject((String)addFriendConfig.getWelcomeContent(), FriendWelcomeDto.class));
        }
        return addFriendConfigResp;
    }

    private String getAllocCacheId(CurrentUserInfo userInfo, String allocRuleNum) {
        if (StringUtils.isBlank((CharSequence)allocRuleNum)) {
            return "";
        }
        CreateAllocCacheReq cacheReq = new CreateAllocCacheReq();
        cacheReq.setBizId(userInfo.getBizId());
        cacheReq.setAllocRuleNum(allocRuleNum);
        cacheReq.setBusinessType(AllocBusinessType.APPLET_MARKETING_MATERIAL.getType());
        cacheReq.setCreateBy(userInfo.getId());
        try {
            CreateAllocCacheResp cacheResp = this.weworkAllocService.createAllocCache(cacheReq);
            return cacheResp.getAllocCacheId();
        }
        catch (Exception ex) {
            log.info("getAllocCacheId,\u83b7\u53d6\u5206\u914d\u89c4\u5219\u7f13\u5b58id\u5f02\u5e38:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u5206\u914d\u89c4\u5219\u7f13\u5b58\u4fe1\u606f\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private String getQrcodeUrl(String accessToken, String corpId, Integer spreadCodeType, String uniqNum, String materialId) {
        QrcodeCreateReq qrcodeCreateReq = new QrcodeCreateReq();
        qrcodeCreateReq.setPage(this.marketingIndexPage);
        String scene = "a=" + spreadCodeType + "&b=" + uniqNum + "&c=" + materialId;
        qrcodeCreateReq.setScene(scene);
        qrcodeCreateReq.setEnvVersion(this.envVersion);
        File file = null;
        try {
            file = this.appletQrcodeAPI.getUnlimitedQrcodeFile(accessToken, qrcodeCreateReq);
            String string = this.aliyunOss.uploadFile(corpId, file, file.getName());
            return string;
        }
        catch (Exception ex) {
            log.info("getQrcodeUrl,qrcodeCreateReq:{}\u751f\u6210\u63a8\u5e7f\u7801\u5931\u8d25:", (Object)qrcodeCreateReq, (Object)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u63a8\u5e7f\u7801\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }

    private String getAppletId(Long bizId) {
        AppletInfo appletInfo = this.appletInfoMapper.getByBizIdAndBusinessType(bizId, AppletUseBusinessType.MARKETING_MATERIAL.getType());
        if (appletInfo == null) {
            log.info("getAppletId,\u6839\u636ebizId:{}\u672a\u67e5\u8be2\u5230\u7528\u4e8e\u8425\u9500\u8d44\u6599\u7684\u5c0f\u7a0b\u5e8f", (Object)bizId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u67e5\u8be2\u5230\u53ef\u7528\u4e8e\u8425\u9500\u8d44\u6599\u7684\u5c0f\u7a0b\u5e8f");
        }
        if (!NumberUtils.INTEGER_ZERO.equals(appletInfo.getVerifyType())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u7a0b\u5e8f\u8fd8\u672a\u8fdb\u884c\u5fae\u4fe1\u8ba4\u8bc1");
        }
        if (!NumberUtils.INTEGER_ONE.equals(appletInfo.getAuthStatus())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u7a0b\u5e8f\u8fd8\u672a\u6388\u6743");
        }
        return appletInfo.getAppId();
    }

    private AppletSpreadChannel buildSpreadChannel(Long materialId, String channelSpreadNum, String channelId, String allocRuleId, String allocCacheId, String qrcodeUrl, CurrentUserInfo userInfo, Date currDate) {
        AppletSpreadChannel spreadChannel = new AppletSpreadChannel();
        spreadChannel.setNum(channelSpreadNum);
        spreadChannel.setBizId(userInfo.getBizId());
        spreadChannel.setMaterialId(materialId);
        spreadChannel.setChannelId(channelId);
        spreadChannel.setAllocRuleId(allocRuleId);
        spreadChannel.setAllocRuleCacheId(allocCacheId);
        spreadChannel.setQrcodeUrl(qrcodeUrl);
        spreadChannel.setIsDeleted(NumberUtils.INTEGER_ZERO);
        spreadChannel.setCreateTime(currDate);
        spreadChannel.setCreateBy(userInfo.getId());
        spreadChannel.setUpdateTime(currDate);
        spreadChannel.setUpdateBy(userInfo.getId());
        return spreadChannel;
    }

    private AppletSpreadChannelStaff buildSpreadChannelStaff(CurrentUserInfo userInfo, Long materialId, Long spreadChannelId, String staffId, Integer staffType, String belongDeptId, String qrcodeUrl, String num, Date currDate) {
        AppletSpreadChannelStaff channelStaff = new AppletSpreadChannelStaff();
        channelStaff.setNum(num);
        channelStaff.setBizId(userInfo.getBizId());
        channelStaff.setMaterialId(materialId);
        channelStaff.setSpreadChannelId(spreadChannelId);
        channelStaff.setUserId(staffId);
        channelStaff.setStaffType(staffType);
        channelStaff.setBelongDeptId(StringUtils.isNotBlank((CharSequence)belongDeptId) ? belongDeptId : "");
        channelStaff.setQrcodeUrl(qrcodeUrl);
        channelStaff.setIsDeleted(NumberUtils.INTEGER_ZERO);
        channelStaff.setCreateTime(currDate);
        channelStaff.setCreateBy(userInfo.getId());
        channelStaff.setUpdateTime(currDate);
        channelStaff.setUpdateBy(userInfo.getId());
        return channelStaff;
    }
}

