/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.material.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.applet.AppletQrcodeAPI;
import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateUrlLinkReq;
import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateUrlLinkResp;
import cn.kinyun.wework.sdk.api.WwMaterialApi;
import cn.kinyun.wework.sdk.entity.material.UploadMaterialResult;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.resp.AppletBaseInfoResp;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.dto.UrlParams;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.applet.dto.AppletMaterialListQuery;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterial;
import com.kuaike.scrm.dal.applet.entity.AppletSpreadChannel;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialUserInfoMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletSpreadChannelMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletSpreadChannelStaffMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.enums.AppletUseBusinessType;
import com.kuaike.scrm.material.dto.req.AppletMaterialSidebarReq;
import com.kuaike.scrm.material.dto.req.AppletUrlLinkReq;
import com.kuaike.scrm.material.dto.req.MaterialBaseReq;
import com.kuaike.scrm.material.dto.resp.AppletMaterialBaseResp;
import com.kuaike.scrm.material.dto.resp.SidebarSpreadCodeResp;
import com.kuaike.scrm.material.dto.resp.SpreadDataStatisticResp;
import com.kuaike.scrm.material.service.AppletMaterialSidebarService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppletMaterialSidebarServiceImpl
implements AppletMaterialSidebarService {
    private static final Logger log = LoggerFactory.getLogger(AppletMaterialSidebarServiceImpl.class);
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private AppletMarketingMaterialMapper marketingMaterialMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private AppletSpreadChannelStaffMapper channelStaffMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private AppletMarketingMaterialUserInfoMapper marketingMaterialUserInfoMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private AppletSpreadChannelMapper spreadChannelMapper;
    @Resource
    private AppletQrcodeAPI appletQrcodeAPI;
    @Resource
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private CustomizedTokenService customizedTokenService;
    @Resource
    private WwMaterialApi wwMaterialApi;
    @Value(value="${applet.marketing.index.page}")
    private String marketingIndexPage;
    @Value(value="${scrm.applet.envVersion}")
    private String envVersion;
    @Value(value="${scrm.applet.sidebar.channelNum}")
    private String appletSidebarChannelNum;
    private static final String TEMP_FILE_DIR = "./applet/tmp/";

    @Override
    public AppletBaseInfoResp appletInfo() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("appletInfo,userId:{}", (Object)userInfo.getId());
        AppletInfo appletInfo = this.appletInfoMapper.getByCorpId(userInfo.getCorpId(), AppletUseBusinessType.MARKETING_MATERIAL.getType());
        if (appletInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u67e5\u8be2\u5230\u7528\u4e8e\u8425\u9500\u8d44\u6599\u7684\u5c0f\u7a0b\u5e8f");
        }
        if (!NumberUtils.INTEGER_ZERO.equals(appletInfo.getVerifyType())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u7a0b\u5e8f\u8fd8\u672a\u8fdb\u884c\u5fae\u4fe1\u8ba4\u8bc1");
        }
        if (!NumberUtils.INTEGER_ONE.equals(appletInfo.getAuthStatus())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u7a0b\u5e8f\u8fd8\u672a\u6388\u6743");
        }
        AppletBaseInfoResp resp = new AppletBaseInfoResp();
        resp.setAppId(appletInfo.getAppId());
        resp.setLogo(appletInfo.getLogo());
        resp.setName(appletInfo.getStoreName());
        return resp;
    }

    @Override
    public List<AppletMaterialBaseResp> materialList(AppletMaterialSidebarReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("materialList,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateListParams();
        String userNum = this.userMapper.getNumById(userInfo.getId());
        Set materialIds = this.channelStaffMapper.selectMaterialIdsByParams(userInfo.getBizId(), this.appletSidebarChannelNum, userNum);
        if (CollectionUtils.isEmpty((Collection)materialIds)) {
            return Collections.emptyList();
        }
        AppletMaterialListQuery listQuery = new AppletMaterialListQuery();
        listQuery.setBizId(userInfo.getBizId());
        listQuery.setIds(materialIds);
        listQuery.setTitle(req.getTitle());
        listQuery.setStatus(NumberUtils.INTEGER_ONE);
        listQuery.setOffset(req.getPageDto().getCount());
        listQuery.setPageSize(req.getPageDto().getPageSize());
        List marketingMaterials = this.marketingMaterialMapper.selectSidebarListByQuery(listQuery);
        if (CollectionUtils.isEmpty((Collection)marketingMaterials)) {
            return Collections.emptyList();
        }
        int count = this.marketingMaterialMapper.selectSidebarListCountByQuery(listQuery);
        req.getPageDto().setCount(Integer.valueOf(count));
        ArrayList resps = Lists.newArrayList();
        for (AppletMarketingMaterial marketingMaterial : marketingMaterials) {
            AppletMaterialBaseResp baseResp = new AppletMaterialBaseResp();
            resps.add(baseResp);
            baseResp.setId(marketingMaterial.getNum());
            baseResp.setTitle(marketingMaterial.getTitle());
            baseResp.setPicUrl(marketingMaterial.getPicUrl());
        }
        return resps;
    }

    @Override
    public String getAppletUrlLink(AppletUrlLinkReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("getAppletUrlLink,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        AppletMarketingMaterial marketingMaterial = this.marketingMaterialMapper.selectByNum(req.getMaterialId());
        if (marketingMaterial == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d44\u6599id\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        String userNum = this.userMapper.getNumById(userInfo.getId());
        String channelStaffNum = this.channelStaffMapper.selectOneNum(userNum, marketingMaterial.getId(), this.appletSidebarChannelNum);
        if (StringUtils.isBlank((CharSequence)channelStaffNum)) {
            log.info("\u6839\u636euserNum:{}, materialId:{}, appletSidebarChannelNum:{}\u672a\u67e5\u8be2\u5230\u5458\u5de5\u63a8\u5e7f\u7801", new Object[]{userNum, marketingMaterial.getId(), this.appletSidebarChannelNum});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d44\u6599\u4e0b\u672a\u8bbe\u7f6e\u8be5\u5458\u5de5\u7684\u4f01\u4e1a\u5fae\u4fe1\u6e20\u9053\u7684\u63a8\u5e7f\u7801");
        }
        GenerateUrlLinkReq urlLinkReq = new GenerateUrlLinkReq();
        urlLinkReq.setPath(this.marketingIndexPage);
        String query = "a=2&b=" + channelStaffNum + "&c=" + req.getMaterialId();
        urlLinkReq.setQuery(query);
        urlLinkReq.setIsExpire(Boolean.valueOf(true));
        urlLinkReq.setExpireType(NumberUtils.INTEGER_ONE);
        urlLinkReq.setExpireInterval(Integer.valueOf(180));
        urlLinkReq.setEnvVersion(this.envVersion);
        try {
            String accessToken = this.appletAccessTokenService.getAccessToken(req.getAppId());
            GenerateUrlLinkResp urlLinkResp = this.appletQrcodeAPI.generateUrlLinkUrl(accessToken, urlLinkReq);
            return urlLinkResp.getUrlLink();
        }
        catch (Exception ex) {
            log.error("urlLinkReq:{},\u751f\u6210\u5c0f\u7a0b\u5e8furl link\u53d1\u751f\u5f02\u5e38:", (Object)urlLinkReq, (Object)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u5c0f\u7a0b\u5e8f\u94fe\u63a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public List<SidebarSpreadCodeResp> qrcodeList(MaterialBaseReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("qrcodeList,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        String userNum = this.userMapper.getNumById(userInfo.getId());
        AppletMarketingMaterial marketingMaterial = this.marketingMaterialMapper.selectByNum(req.getMaterialId());
        if (marketingMaterial == null) {
            log.info("\u6839\u636ematerialNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getMaterialId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        Map channelId2QrcodeUrlMap = this.channelStaffMapper.selectByMaterialIdAndUserNum(marketingMaterial.getId(), userNum);
        if (MapUtils.isEmpty((Map)channelId2QrcodeUrlMap)) {
            return Collections.emptyList();
        }
        Map channelNum2NameMap = this.channelMapper.selectNameByNums(userInfo.getBizId(), channelId2QrcodeUrlMap.keySet());
        ArrayList resps = Lists.newArrayList();
        for (Map.Entry entry : channelId2QrcodeUrlMap.entrySet()) {
            SidebarSpreadCodeResp codeResp = new SidebarSpreadCodeResp();
            resps.add(codeResp);
            codeResp.setQrcodeUrl((String)entry.getValue());
            if (!MapUtils.isNotEmpty((Map)channelNum2NameMap)) continue;
            codeResp.setChannelName((String)channelNum2NameMap.get(entry.getKey()));
        }
        return resps;
    }

    @Override
    public List<SpreadDataStatisticResp> statistic(AppletMaterialSidebarReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("statistic,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateListParams();
        User user = this.userMapper.getUserInfoById(userInfo.getId());
        String userNum = user.getNum();
        AppletMaterialListQuery listQuery = new AppletMaterialListQuery();
        listQuery.setBizId(userInfo.getBizId());
        listQuery.setUserId(userNum);
        listQuery.setTitle(req.getTitle());
        listQuery.setStatus(NumberUtils.INTEGER_ONE);
        listQuery.setOffset(req.getPageDto().getCount());
        listQuery.setPageSize(req.getPageDto().getPageSize());
        List marketingMaterials = this.marketingMaterialMapper.sidebarList(listQuery);
        if (CollectionUtils.isEmpty((Collection)marketingMaterials)) {
            return Collections.emptyList();
        }
        int count = this.marketingMaterialMapper.sidebarListCount(listQuery);
        req.getPageDto().setCount(Integer.valueOf(count));
        Set materialNums = marketingMaterials.stream().map(AppletMarketingMaterial::getNum).collect(Collectors.toSet());
        Map materialNum2ScanCountMap = this.marketingMaterialUserInfoMapper.selectScanCountByMaterialNums(userInfo.getBizId(), userNum, materialNums);
        Map materialNum2AddVCountMap = this.marketingMaterialUserInfoMapper.selectAddVCountByMaterialNums(userInfo.getBizId(), userNum, materialNums);
        Map materialNum2BrowsePersonCount = this.marketingMaterialUserInfoMapper.selectBrowsePersonCountByMaterialNums(userInfo.getBizId(), userNum, materialNums);
        String deptName = this.organizationMapper.getNameByBizIdAndOrgId(userInfo.getBizId(), user.getNodeId());
        ArrayList resps = Lists.newArrayList();
        for (AppletMarketingMaterial marketingMaterial : marketingMaterials) {
            SpreadDataStatisticResp resp = new SpreadDataStatisticResp();
            resps.add(resp);
            resp.setUserName(userInfo.getName());
            resp.setDeptName(deptName);
            resp.setTitle(marketingMaterial.getTitle());
            String materialNum = marketingMaterial.getNum();
            if (MapUtils.isNotEmpty((Map)materialNum2ScanCountMap) && materialNum2ScanCountMap.containsKey(materialNum)) {
                resp.setScanCount((Integer)materialNum2ScanCountMap.get(materialNum));
            }
            if (MapUtils.isNotEmpty((Map)materialNum2AddVCountMap) && materialNum2AddVCountMap.containsKey(materialNum)) {
                resp.setAddVCount((Integer)materialNum2AddVCountMap.get(materialNum));
            }
            if (!MapUtils.isNotEmpty((Map)materialNum2BrowsePersonCount) || !materialNum2BrowsePersonCount.containsKey(materialNum)) continue;
            resp.setBrowsePersonCount((Integer)materialNum2BrowsePersonCount.get(materialNum));
        }
        return resps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMediaId(UrlParams req) {
        Map channelNum2NameMap;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("getMediaId:{},operatorId:{}", (Object)req, (Object)userInfo);
        if (StringUtils.isBlank((CharSequence)req.getUrl())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u63a8\u5e7f\u7801\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileUlr = req.getUrl();
        int index = fileUlr.lastIndexOf(47);
        String originFileName = fileUlr.substring(index + 1);
        int lastDot = originFileName.lastIndexOf(46);
        String params = originFileName.substring(0, lastDot);
        String[] paramArr = params.split("&");
        Integer qrCodeType = Integer.parseInt(paramArr[0].split("=")[1]);
        String spreadCodeNum = paramArr[1].split("=")[1];
        String materialNum = paramArr[2].split("=")[1];
        AppletMarketingMaterial marketingMaterial = this.marketingMaterialMapper.selectByNum(materialNum);
        if (marketingMaterial == null) {
            log.info("\u6839\u636ematerialNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)materialNum);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        String channelNum = "";
        String userName = "";
        if (qrCodeType == 1) {
            AppletSpreadChannel spreadChannel = this.spreadChannelMapper.queryByNum(spreadCodeNum);
            channelNum = spreadChannel.getNum();
        } else {
            channelNum = this.channelStaffMapper.queryChannelNumByNum(spreadCodeNum);
            userName = userInfo.getName();
        }
        String channelName = "";
        if (StringUtils.isNotBlank((CharSequence)channelNum) && MapUtils.isNotEmpty((Map)(channelNum2NameMap = this.channelMapper.selectNameByNums(userInfo.getBizId(), Collections.singletonList(channelNum))))) {
            channelName = (String)channelNum2NameMap.get(channelNum);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TEMP_FILE_DIR).append(marketingMaterial.getTitle()).append('_').append(channelName);
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            sb.append('_').append(userName);
        }
        sb.append(".jpeg");
        File tempFile = null;
        String mediaId = "";
        try {
            URL url = new URL(fileUlr);
            tempFile = new File(sb.toString());
            FileUtils.copyURLToFile((URL)url, (File)tempFile);
            String accessToken = this.customizedTokenService.getAgentAccessToken(userInfo.getCorpId());
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                log.warn("access_token is empty");
                String string = null;
                return string;
            }
            UploadMaterialResult uploadMaterialResult = this.wwMaterialApi.uploadMaterial(accessToken, "image", tempFile);
            mediaId = uploadMaterialResult.getMediaId();
        }
        catch (IOException e) {
            log.error("applet shop getMediaId error:", (Throwable)e);
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
        return mediaId;
    }
}

