/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.WxMediaAPI;
import cn.kinyun.scrm.weixin.sdk.api.applet.AppletAccountAPI;
import cn.kinyun.scrm.weixin.sdk.api.applet.AppletCategoryAPI;
import cn.kinyun.scrm.weixin.sdk.api.applet.AppletRegisterAPI;
import cn.kinyun.scrm.weixin.sdk.entity.media.MediaResult;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.AppletCategoryAuditEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.AppletNameAuditEvent;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.category.AddCategoriesDto;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.category.CerticateItem;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.FastCreateReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.CheckWxVerifyNicknameReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.ModifyHeadImageReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.ModifySignatureReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.SetNicknameReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.category.AddCategoryReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.account.CheckWxVerifyNicknameResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.account.SetNicknameResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.category.GetCategoryResp;
import cn.kinyun.scrm.weixin.sdk.enums.WxMediaType;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.scrm.applet.dto.dto.CategoryDto;
import com.kuaike.scrm.applet.dto.req.AppletModReq;
import com.kuaike.scrm.applet.dto.req.CheckNameReq;
import com.kuaike.scrm.applet.dto.req.FastRegisterReq;
import com.kuaike.scrm.applet.dto.resp.CheckNameResp;
import com.kuaike.scrm.applet.dto.resp.EditResp;
import com.kuaike.scrm.applet.dto.resp.FastRegisterInfoResp;
import com.kuaike.scrm.applet.dto.resp.FastRegisterResp;
import com.kuaike.scrm.applet.service.AppletCommonService;
import com.kuaike.scrm.applet.service.AppletRegisterService;
import com.kuaike.scrm.applet.service.AppletService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.applet.entity.FastRegisterDraft;
import com.kuaike.scrm.dal.applet.mapper.FastRegisterDraftMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppletRegisterServiceImpl
implements AppletRegisterService {
    private static final Logger log = LoggerFactory.getLogger(AppletRegisterServiceImpl.class);
    @Autowired
    private AppletInfoMapper appletInfoMapper;
    @Autowired
    private FastRegisterDraftMapper registerDraftMapper;
    @Autowired
    private ComponentTokenService componentTokenService;
    @Autowired
    private AppletRegisterAPI appletRegisterAPI;
    @Autowired
    private AppletAccountAPI appletAccountAPI;
    @Autowired
    private AppletCommonService appletCommonService;
    @Autowired
    private AppletCategoryAPI appletCategoryAPI;
    @Autowired
    private WxMediaAPI wxMediaAPI;
    @Autowired
    private AppletService appletService;
    @Value(value="${componentPhone:18610720740}")
    private String componentPhone;
    private Set<Integer> holdingStatus = Sets.newHashSet((Object[])new Integer[]{1, 2});

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FastRegisterResp fastRegister(FastRegisterReq req) {
        log.info("fastRegister with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        List registerDrafts = this.registerDraftMapper.queryByBizIdAndRegisterStatus(currentUserInfo.getBizId(), Integer.valueOf(1));
        Preconditions.checkArgument((boolean)CollectionUtils.isEmpty((Collection)registerDrafts), (Object)"\u5f53\u524d\u5546\u6237\u5df2\u7ecf\u6ce8\u518c\u4e86\u5c0f\u7a0b\u5e8f");
        List notRegisterDrafts = this.registerDraftMapper.queryByBizIdAndRegisterStatus(currentUserInfo.getBizId(), Integer.valueOf(0));
        Preconditions.checkArgument((CollectionUtils.isEmpty((Collection)notRegisterDrafts) || CollectionUtils.isNotEmpty((Collection)notRegisterDrafts) && notRegisterDrafts.size() == 1 ? 1 : 0) != 0, (Object)"\u5546\u6237\u4e0b\u5b58\u5728\u591a\u4e2a\u672a\u6ce8\u518c\u6210\u529f\u7684\u8bb0\u5f55");
        FastRegisterDraft draft = this.addOrModDraft(req, currentUserInfo, notRegisterDrafts);
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        FastCreateReq fastCreateReq = new FastCreateReq();
        BeanUtils.copyProperties((Object)req, (Object)fastCreateReq);
        fastCreateReq.setComponentPhone(this.componentPhone);
        FastRegisterResp resp = new FastRegisterResp();
        try {
            this.appletRegisterAPI.fastCreate(componentAccessToken, fastCreateReq);
            draft.setRegisterStatus(Integer.valueOf(1));
            resp.setRegisterStatus(1);
        }
        catch (Exception e) {
            log.error("fastCreate with error", (Throwable)e);
            String msg = StringUtils.abbreviate((String)e.getMessage(), (int)240);
            draft.setRegisterStatus(Integer.valueOf(3));
            draft.setRegisterReason(msg);
            resp.setRegisterReason(msg);
            resp.setRegisterStatus(3);
        }
        this.registerDraftMapper.updateByPrimaryKeySelective((Object)draft);
        return resp;
    }

    private FastRegisterDraft addOrModDraft(FastRegisterReq req, CurrentUserInfo currentUserInfo, List<FastRegisterDraft> notRegisterDrafts) {
        if (CollectionUtils.isEmpty(notRegisterDrafts)) {
            FastRegisterDraft draft = new FastRegisterDraft();
            draft.setBizId(currentUserInfo.getBizId());
            draft.setCorpId(currentUserInfo.getCorpId());
            draft.setCreateBy(currentUserInfo.getId());
            draft.setCreateTime(new Date());
            draft.setLegalPersonaName(req.getLegalPersonaName());
            draft.setLegalPersonaWechat(req.getLegalPersonaWechat());
            draft.setPrincipalCode(req.getCode());
            draft.setPrincipalName(req.getName());
            draft.setCodeType(req.getCodeType());
            draft.setRegisterStatus(Integer.valueOf(2));
            draft.setRegisterReason("");
            draft.setIsDeleted(Integer.valueOf(0));
            this.registerDraftMapper.insert((Object)draft);
            return draft;
        }
        FastRegisterDraft draft = notRegisterDrafts.get(0);
        draft.setLegalPersonaName(req.getLegalPersonaName());
        draft.setLegalPersonaWechat(req.getLegalPersonaWechat());
        draft.setPrincipalCode(req.getCode());
        draft.setPrincipalName(req.getName());
        draft.setCodeType(req.getCodeType());
        draft.setUpdateTime(new Date());
        draft.setUpdateBy(currentUserInfo.getId());
        draft.setIsDeleted(Integer.valueOf(0));
        this.registerDraftMapper.updateByPrimaryKeySelective((Object)draft);
        return draft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMediaId(String accessToken, String imgUrl) {
        File tempFile = null;
        try {
            URL url = new URL(imgUrl);
            String tempFilePath = FileUtils.getTempDirectoryPath() + UUID.randomUUID() + "." + FilenameUtils.getExtension((String)imgUrl);
            tempFile = new File(tempFilePath);
            FileUtils.copyURLToFile((URL)url, (File)new File(tempFilePath));
            MediaResult mediaResult = this.wxMediaAPI.upload(accessToken, WxMediaType.Image, tempFile);
            String string = mediaResult.getMediaId();
            return string;
        }
        catch (Exception e) {
            log.error("read file from url={} with error", (Object)imgUrl, (Object)e);
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                FileUtils.deleteQuietly((File)tempFile);
            }
        }
        return null;
    }

    @Override
    public EditResp edit(AppletModReq req) {
        log.info("edit with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        String appId = this.appletCommonService.getCurrentAppId();
        String accessToken = this.appletCommonService.getCurrentAccessToken();
        FastRegisterDraft oldFastRegisterDraft = this.registerDraftMapper.queryByAppId(appId);
        if (Objects.isNull(oldFastRegisterDraft)) {
            oldFastRegisterDraft = this.buildRegisterDraft(currentUserInfo, appId);
        }
        EditResp resp = new EditResp();
        FastRegisterInfoResp registerInfoResp = this.fastRegisterInfo();
        if (Objects.nonNull(registerInfoResp)) {
            BeanUtils.copyProperties((Object)registerInfoResp, (Object)resp);
        }
        this.setHeadImg(req, accessToken, oldFastRegisterDraft, resp);
        this.setDesc(req, accessToken, oldFastRegisterDraft, resp);
        this.setCategory(req, accessToken, oldFastRegisterDraft, resp);
        this.setName(req, accessToken, oldFastRegisterDraft, resp);
        return resp;
    }

    private void setCategory(AppletModReq req, String accessToken, FastRegisterDraft oldFastRegisterDraft, EditResp resp) {
        if (CollectionUtils.isNotEmpty(req.getCategories()) && !this.holdingStatus.contains(oldFastRegisterDraft.getCatStatus())) {
            GetCategoryResp categoryResp = this.appletCategoryAPI.getCategory(accessToken);
            if (categoryResp.getQuota() > 0) {
                List left;
                Set successAndOngoing = categoryResp.getCategories().stream().filter(a -> !Objects.equals(a.getAuditStatus(), 2)).map(a -> String.format("%d$$%d", a.getFirst(), a.getSecond())).collect(Collectors.toSet());
                Set newCats = req.getCategories().stream().map(a -> String.format("%d$$%d", a.getFirst(), a.getSecond())).collect(Collectors.toSet());
                newCats.removeAll(successAndOngoing);
                if (!this.holdingStatus.contains(oldFastRegisterDraft.getCatStatus()) && CollectionUtils.isNotEmpty(newCats) && CollectionUtils.isNotEmpty(left = req.getCategories().stream().filter(a -> newCats.contains(String.format("%d$$%d", a.getFirst(), a.getSecond()))).collect(Collectors.toList()))) {
                    boolean haveCerticate = false;
                    for (CategoryDto categoryDto : left) {
                        if (!CollectionUtils.isNotEmpty(categoryDto.getCerticates())) continue;
                        for (CerticateItem certicate : categoryDto.getCerticates()) {
                            certicate.setValue(this.getMediaId(accessToken, certicate.getValue()));
                            haveCerticate = true;
                        }
                    }
                    AddCategoryReq addCategoryReq = new AddCategoryReq();
                    List categoriesDtos = left.stream().map(a -> this.buildCategoriedDto((CategoryDto)a)).collect(Collectors.toList());
                    addCategoryReq.setCategories(categoriesDtos);
                    try {
                        this.appletCategoryAPI.addCategory(accessToken, addCategoryReq);
                        if (haveCerticate) {
                            oldFastRegisterDraft.setCatStatus(Integer.valueOf(1));
                            oldFastRegisterDraft.setCatReason("");
                            resp.setCatStatus(1);
                        } else {
                            oldFastRegisterDraft.setCatStatus(Integer.valueOf(2));
                            resp.setCatStatus(2);
                        }
                    }
                    catch (Exception e) {
                        log.error("add category with error", (Throwable)e);
                        String msg = StringUtils.abbreviate((String)e.getMessage(), (int)240);
                        oldFastRegisterDraft.setCatStatus(Integer.valueOf(3));
                        oldFastRegisterDraft.setCatReason(msg);
                        resp.setCatStatus(3);
                        resp.setCatReason(msg);
                    }
                    oldFastRegisterDraft.setCats(JSON.toJSONString(req.getCategories()));
                    this.registerDraftMapper.updateByPrimaryKeySelective((Object)oldFastRegisterDraft);
                }
            } else {
                resp.setCatStatus(3);
                resp.setCatReason("\u6ca1\u6709\u7c7b\u76ee\u4fee\u6539\u989d\u5ea6,\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
        }
    }

    private void setDesc(AppletModReq req, String accessToken, FastRegisterDraft oldFastRegisterDraft, EditResp resp) {
        if (!Objects.equals(oldFastRegisterDraft.getDescStatus(), 1) && StringUtils.isNotBlank((CharSequence)req.getAppletDesc())) {
            ModifySignatureReq modifySignatureReq = new ModifySignatureReq();
            modifySignatureReq.setSignature(req.getAppletDesc());
            try {
                this.appletAccountAPI.modifySignature(accessToken, modifySignatureReq);
                oldFastRegisterDraft.setDescStatus(Integer.valueOf(1));
                oldFastRegisterDraft.setDescReason("");
                resp.setDescStatus(1);
            }
            catch (Exception e) {
                log.error("modify signature with error", (Throwable)e);
                String msg = StringUtils.abbreviate((String)e.getMessage(), (int)240);
                oldFastRegisterDraft.setDescStatus(Integer.valueOf(2));
                oldFastRegisterDraft.setDescReason(msg);
                resp.setDescStatus(2);
                resp.setDescReason(msg);
            }
            oldFastRegisterDraft.setSignature(req.getAppletDesc());
            this.registerDraftMapper.updateByPrimaryKeySelective((Object)oldFastRegisterDraft);
        }
    }

    private void setHeadImg(AppletModReq req, String accessToken, FastRegisterDraft oldFastRegisterDraft, EditResp resp) {
        if (!Objects.equals(oldFastRegisterDraft.getHeadImgStatus(), 1) && StringUtils.isNotBlank((CharSequence)req.getAppletHeadImg())) {
            ModifyHeadImageReq modifyHeadImageReq = new ModifyHeadImageReq();
            modifyHeadImageReq.setHeadImgMediaId(this.getMediaId(accessToken, req.getAppletHeadImg()));
            modifyHeadImageReq.setX1("0");
            modifyHeadImageReq.setY1("0");
            modifyHeadImageReq.setX2("1");
            modifyHeadImageReq.setY2("1");
            try {
                this.appletAccountAPI.modifyHeadImage(accessToken, modifyHeadImageReq);
                oldFastRegisterDraft.setHeadImgStatus(Integer.valueOf(1));
                oldFastRegisterDraft.setHeadImgReason("");
                resp.setHeadImgStatus(1);
            }
            catch (Exception e) {
                log.error("modify modify HeadImage with error", (Throwable)e);
                String msg = StringUtils.abbreviate((String)e.getMessage(), (int)240);
                oldFastRegisterDraft.setHeadImgStatus(Integer.valueOf(2));
                oldFastRegisterDraft.setHeadImgReason(msg);
                resp.setHeadImgStatus(2);
                resp.setHeadImgReason(msg);
            }
            oldFastRegisterDraft.setLogo(req.getAppletHeadImg());
            this.registerDraftMapper.updateByPrimaryKeySelective((Object)oldFastRegisterDraft);
        }
    }

    private FastRegisterDraft buildRegisterDraft(CurrentUserInfo currentUserInfo, String appId) {
        AppletInfo appletInfo = this.appletInfoMapper.queryByAppId(appId);
        FastRegisterDraft draft = new FastRegisterDraft();
        draft.setPrincipalName(appletInfo.getPrincipalName());
        draft.setPrincipalCode(appletInfo.getPrincipalCode());
        draft.setCorpId(currentUserInfo.getCorpId());
        draft.setBizId(currentUserInfo.getBizId());
        draft.setAppId(appId);
        draft.setRegisterStatus(Integer.valueOf(2));
        draft.setCreateBy(Long.valueOf(-1L));
        draft.setCreateTime(new Date());
        this.registerDraftMapper.insertSelective((Object)draft);
        FastRegisterDraft oldFastRegisterDraft = draft;
        return oldFastRegisterDraft;
    }

    private void setName(AppletModReq req, String accessToken, FastRegisterDraft oldFastRegisterDraft, EditResp resp) {
        if (!this.holdingStatus.contains(oldFastRegisterDraft.getNameStatus()) && StringUtils.isNotBlank((CharSequence)req.getAppletName())) {
            SetNicknameReq setNicknameReq = new SetNicknameReq();
            setNicknameReq.setNickname(req.getAppletName());
            String licenseMediaId = this.getMediaId(accessToken, req.getLicense());
            setNicknameReq.setLicense(licenseMediaId);
            if (CollectionUtils.isNotEmpty(req.getOtherStuff())) {
                for (int i = 0; i < req.getOtherStuff().size(); ++i) {
                    String url = req.getOtherStuff().get(i);
                    if (i == 0) {
                        setNicknameReq.setNamingOtherStuff1(this.getMediaId(accessToken, url));
                        continue;
                    }
                    if (i == 1) {
                        setNicknameReq.setNamingOtherStuff2(this.getMediaId(accessToken, url));
                        continue;
                    }
                    if (i == 2) {
                        setNicknameReq.setNamingOtherStuff3(this.getMediaId(accessToken, url));
                        continue;
                    }
                    if (i == 3) {
                        setNicknameReq.setNamingOtherStuff4(this.getMediaId(accessToken, url));
                        continue;
                    }
                    if (i != 4) continue;
                    setNicknameReq.setNamingOtherStuff5(this.getMediaId(accessToken, url));
                }
            }
            SetNicknameResp nicknameResp = null;
            try {
                nicknameResp = this.appletAccountAPI.setNickname(setNicknameReq, accessToken);
                if (Objects.nonNull(nicknameResp.getAuditId())) {
                    oldFastRegisterDraft.setNameStatus(Integer.valueOf(1));
                    oldFastRegisterDraft.setNameReason("");
                    oldFastRegisterDraft.setNameAuditId(nicknameResp.getAuditId());
                    resp.setNameStatus(1);
                    resp.setWording(nicknameResp.getWording());
                } else {
                    oldFastRegisterDraft.setNameStatus(Integer.valueOf(2));
                    oldFastRegisterDraft.setNameReason("");
                    resp.setNameStatus(2);
                    resp.setWording(nicknameResp.getWording());
                    this.appletService.resetAppletInfo(oldFastRegisterDraft.getAppId());
                }
            }
            catch (Exception e) {
                log.error("set applet nickName with error", (Throwable)e);
                String msg = StringUtils.abbreviate((String)e.getMessage(), (int)240);
                oldFastRegisterDraft.setNameStatus(Integer.valueOf(3));
                oldFastRegisterDraft.setNameReason(msg);
                resp.setNameStatus(3);
                resp.setNameReason(msg);
            }
            oldFastRegisterDraft.setStoreName(req.getAppletName());
            oldFastRegisterDraft.setOtherStuff(JSON.toJSONString(req.getOtherStuff()));
            oldFastRegisterDraft.setLicense(req.getLicense());
            this.registerDraftMapper.updateByPrimaryKeySelective((Object)oldFastRegisterDraft);
        }
    }

    public AddCategoriesDto buildCategoriedDto(CategoryDto categoryDto) {
        AddCategoriesDto dto = new AddCategoriesDto();
        dto.setCerticates(categoryDto.getCerticates());
        dto.setFirst(Integer.valueOf(categoryDto.getFirst().intValue()));
        dto.setSecond(Integer.valueOf(categoryDto.getSecond().intValue()));
        return dto;
    }

    @Override
    public FastRegisterInfoResp fastRegisterInfo() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        List registerDrafts = this.registerDraftMapper.queryByBizIdAndRegisterStatus(currentUserInfo.getBizId(), null);
        if (CollectionUtils.isEmpty((Collection)registerDrafts)) {
            return null;
        }
        Preconditions.checkArgument((registerDrafts.size() == 1 ? 1 : 0) != 0, (Object)"\u5546\u6237\u5b58\u5728\u591a\u4e2a\u6ce8\u518c\u5c0f\u7a0b\u5e8f\u8bb0\u5f55");
        FastRegisterDraft draft = (FastRegisterDraft)registerDrafts.get(0);
        FastRegisterInfoResp resp = new FastRegisterInfoResp();
        resp.setAppletDesc(draft.getSignature());
        resp.setAppletHeadImg(draft.getLogo());
        resp.setAppletName(draft.getStoreName());
        resp.setCategories(JSONArray.parseArray((String)draft.getCats(), CategoryDto.class));
        resp.setRegisterStatus(draft.getRegisterStatus());
        resp.setRegisterReason(draft.getRegisterReason());
        resp.setCatReason(draft.getCatReason());
        resp.setCatStatus(draft.getCatStatus());
        resp.setCommitCodeReason(draft.getCommitCodeReason());
        resp.setCommitCodeStatus(draft.getCommitCodeStatus());
        resp.setDescReason(draft.getDescReason());
        resp.setDescStatus(draft.getDescStatus());
        resp.setDomainReason(draft.getDomainReason());
        resp.setDomainStatus(draft.getDomainStatus());
        resp.setHeadImgReason(draft.getHeadImgReason());
        resp.setHeadImgStatus(draft.getHeadImgStatus());
        resp.setLicense(draft.getLicense());
        resp.setNameReason(draft.getNameReason());
        resp.setNameStatus(draft.getNameStatus());
        resp.setOtherStuff(JSONArray.parseArray((String)draft.getOtherStuff(), String.class));
        resp.setSearchReason(draft.getSearchReason());
        resp.setSearchStatus(draft.getSearchStatus());
        resp.setName(draft.getPrincipalName());
        resp.setCode(draft.getPrincipalCode());
        resp.setCodeType(draft.getCodeType());
        resp.setLegalPersonaName(draft.getLegalPersonaName());
        resp.setLegalPersonaWechat(draft.getLegalPersonaWechat());
        return resp;
    }

    @Override
    public CheckNameResp checkNameAvailable(CheckNameReq req) {
        log.info("checkNameAvailable with req={}", (Object)req);
        req.validate();
        String accessToken = this.appletCommonService.getCurrentAccessToken();
        CheckWxVerifyNicknameReq verifyNicknameReq = new CheckWxVerifyNicknameReq();
        verifyNicknameReq.setNickname(req.getNickName());
        CheckWxVerifyNicknameResp resp = null;
        CheckNameResp nameResp = new CheckNameResp();
        try {
            resp = this.appletAccountAPI.checkWxVerifyNickname(accessToken, verifyNicknameReq);
            if (Objects.nonNull(resp)) {
                nameResp.setWording(resp.getWording());
                nameResp.setHitCondition(resp.getHitCondition());
            }
        }
        catch (WeixinException e) {
            nameResp.setErrorMsg(e.getErrorMsg());
        }
        return nameResp;
    }

    @Override
    public void dealNameAuditEvent(AppletNameAuditEvent appletNameAuditEvent) {
        log.info("dealNameAuditEvent with event={}", (Object)appletNameAuditEvent);
        FastRegisterDraft draft = this.registerDraftMapper.queryByNameAndNotSuccess(appletNameAuditEvent.getNickname());
        switch (appletNameAuditEvent.getRet()) {
            case 2: {
                draft.setNameStatus(Integer.valueOf(3));
                draft.setNameReason(StringUtils.abbreviate((String)appletNameAuditEvent.getReason(), (int)240));
                break;
            }
            case 3: {
                draft.setNameStatus(Integer.valueOf(2));
                this.appletService.resetAppletInfo(draft.getAppId());
                break;
            }
        }
        this.registerDraftMapper.updateByPrimaryKeySelective((Object)draft);
    }

    @Override
    public void dealCategoryAuditEvent(AppletCategoryAuditEvent appletCategoryAuditEvent) {
        log.info("dealCategoryAuditEvent with event={}", (Object)appletCategoryAuditEvent);
        String userName = appletCategoryAuditEvent.getToUserName();
        String appId = this.appletInfoMapper.queryAppIdByUserName(userName);
        if (StringUtils.isBlank((CharSequence)appId)) {
            log.info("appId is null,event={}", (Object)appletCategoryAuditEvent);
            return;
        }
        FastRegisterDraft draft = this.registerDraftMapper.queryByAppId(appId);
        if (Objects.isNull(draft)) {
            log.info("draft is null,event={}", (Object)appletCategoryAuditEvent);
            return;
        }
        switch (appletCategoryAuditEvent.getRet()) {
            case 2: {
                draft.setCatStatus(Integer.valueOf(2));
                break;
            }
            case 3: {
                draft.setCatStatus(Integer.valueOf(3));
                draft.setCatReason(appletCategoryAuditEvent.getReason());
                break;
            }
        }
        this.registerDraftMapper.updateByPrimaryKeySelective((Object)draft);
    }
}

