/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.dto.req;

import cn.kinyun.ad.common.dto.IdAndNameDto;
import com.google.common.base.Preconditions;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.dto.FriendWelcomeDto;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingAddFriendConfig;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AddFriendConfigReq {
    private String materialId;
    private String channelId;
    private String addFriendRemark;
    private FriendWelcomeDto addFriendWelcome;
    private List<IdAndNameDto> tags;

    public void validateParams() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.materialId), (Object)"\u8d44\u6599id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.channelId), (Object)"\u6e20\u9053id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public AppletMarketingAddFriendConfig convert2AddFriendConfig(CurrentUserInfo userInfo, Long materialId) {
        AppletMarketingAddFriendConfig addFriendConfig = new AppletMarketingAddFriendConfig();
        addFriendConfig.setBizId(userInfo.getBizId());
        addFriendConfig.setMaterialId(materialId);
        addFriendConfig.setChannelId(this.channelId);
        if (StringUtils.isBlank((CharSequence)this.addFriendRemark)) {
            addFriendConfig.setAddFriendRemark("");
        } else {
            addFriendConfig.setAddFriendRemark(this.addFriendRemark);
        }
        if (this.addFriendWelcome == null) {
            addFriendConfig.setWelcomeContent("");
        } else {
            addFriendConfig.setWelcomeContent(JacksonUtil.obj2Str((Object)this.addFriendWelcome));
        }
        if (CollectionUtils.isEmpty(this.tags)) {
            addFriendConfig.setTagIds("");
        } else {
            addFriendConfig.setTagIds(JacksonUtil.obj2Str(this.tags));
        }
        addFriendConfig.setCreateBy(userInfo.getId());
        addFriendConfig.setUpdateBy(userInfo.getId());
        Date curDate = new Date();
        addFriendConfig.setCreateTime(curDate);
        addFriendConfig.setUpdateTime(curDate);
        return addFriendConfig;
    }

    public String getMaterialId() {
        return this.materialId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getAddFriendRemark() {
        return this.addFriendRemark;
    }

    public FriendWelcomeDto getAddFriendWelcome() {
        return this.addFriendWelcome;
    }

    public List<IdAndNameDto> getTags() {
        return this.tags;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setAddFriendRemark(String addFriendRemark) {
        this.addFriendRemark = addFriendRemark;
    }

    public void setAddFriendWelcome(FriendWelcomeDto addFriendWelcome) {
        this.addFriendWelcome = addFriendWelcome;
    }

    public void setTags(List<IdAndNameDto> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddFriendConfigReq)) {
            return false;
        }
        AddFriendConfigReq other = (AddFriendConfigReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$materialId = this.getMaterialId();
        String other$materialId = other.getMaterialId();
        if (this$materialId == null ? other$materialId != null : !this$materialId.equals(other$materialId)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        String this$addFriendRemark = this.getAddFriendRemark();
        String other$addFriendRemark = other.getAddFriendRemark();
        if (this$addFriendRemark == null ? other$addFriendRemark != null : !this$addFriendRemark.equals(other$addFriendRemark)) {
            return false;
        }
        FriendWelcomeDto this$addFriendWelcome = this.getAddFriendWelcome();
        FriendWelcomeDto other$addFriendWelcome = other.getAddFriendWelcome();
        if (this$addFriendWelcome == null ? other$addFriendWelcome != null : !this$addFriendWelcome.equals(other$addFriendWelcome)) {
            return false;
        }
        List<IdAndNameDto> this$tags = this.getTags();
        List<IdAndNameDto> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddFriendConfigReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $materialId = this.getMaterialId();
        result = result * 59 + ($materialId == null ? 43 : $materialId.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        String $addFriendRemark = this.getAddFriendRemark();
        result = result * 59 + ($addFriendRemark == null ? 43 : $addFriendRemark.hashCode());
        FriendWelcomeDto $addFriendWelcome = this.getAddFriendWelcome();
        result = result * 59 + ($addFriendWelcome == null ? 43 : $addFriendWelcome.hashCode());
        List<IdAndNameDto> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "AddFriendConfigReq(materialId=" + this.getMaterialId() + ", channelId=" + this.getChannelId() + ", addFriendRemark=" + this.getAddFriendRemark() + ", addFriendWelcome=" + this.getAddFriendWelcome() + ", tags=" + this.getTags() + ")";
    }
}

