/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.app.center.service.impl;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.AppOpenBaseReqDto;
import com.kuaike.scrm.common.service.AppInstallService;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.wework.entity.TabUrlParamsConfig;
import com.kuaike.scrm.dal.wework.mapper.TabUrlParamsConfigMapper;
import com.kuaike.scrm.wework.tab.dto.TabUrlParamsConfigDto;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BjyNetSchoolInstallServiceImpl
implements AppInstallService {
    private static final Logger log = LoggerFactory.getLogger(BjyNetSchoolInstallServiceImpl.class);
    @Value(value="${app.bjyNetSchool.appCode}")
    private String appCode;
    @Autowired
    private AppBindingsMapper bindingsMapper;
    @Autowired
    private TabUrlParamsConfigMapper tabUrlParamsConfigMapper;

    public String getAppCode() {
        return this.appCode;
    }

    public void install(AppBindings bindings) {
        this.addOrModNetSchoolSetting(bindings);
    }

    public void update(AppBindings bindings) {
        this.addOrModNetSchoolSetting(bindings);
    }

    private void addOrModNetSchoolSetting(AppBindings bindings) {
        AppOpenBaseReqDto reqDto = null;
        if (StringUtils.isBlank((CharSequence)bindings.getConfigJson())) {
            log.info("getConfigJson is null");
            return;
        }
        try {
            log.info("BjyNetSchoolInstall getConfigJson: {}", (Object)bindings.getConfigJson());
            reqDto = (AppOpenBaseReqDto)JacksonUtil.str2Obj((String)bindings.getConfigJson(), AppOpenBaseReqDto.class);
        }
        catch (IOException e) {
            log.error("reqDto  str2Obj error", (Throwable)e);
        }
        if (ObjectUtils.isEmpty(reqDto)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "bjy\u4f1a\u8bae\u53c2\u6570\u914d\u7f6e\u4e3a\u7a7a");
        }
        bindings.setUpdateBy(Long.valueOf(-1L));
        bindings.setUpdateTime(new Date());
        bindings.setConfigJson(JacksonUtil.obj2Str((Object)reqDto));
        this.bindingsMapper.updateByPrimaryKey((Object)bindings);
        if (StringUtils.isEmpty((CharSequence)reqDto.getUrl()) || StringUtils.isEmpty((CharSequence)reqDto.getFkId()) || StringUtils.isEmpty((CharSequence)reqDto.getFkKey()) || StringUtils.isEmpty((CharSequence)reqDto.getFkSecret())) {
            log.warn("url || fkId || fkKey || fkSecret 4\u4e2a\u53c2\u6570\u4e2d\u6709\u4e3a\u7a7a\u7684");
            return;
        }
        TabUrlParamsConfigDto params = new TabUrlParamsConfigDto();
        params.setUrl(reqDto.getUrl());
        params.setWxId(reqDto.getFkId());
        params.setWxKey(reqDto.getFkKey());
        params.setWxSecretKey(reqDto.getFkSecret());
        log.info("addOrModNetSchoolSetting params: {}", (Object)params);
        TabUrlParamsConfig config = new TabUrlParamsConfig();
        config.setBizId(bindings.getBizId());
        config.setCorpId(bindings.getCorpId());
        config.setConfigType(Integer.valueOf(1));
        config = (TabUrlParamsConfig)this.tabUrlParamsConfigMapper.selectOne((Object)config);
        if (config == null) {
            config = new TabUrlParamsConfig();
            config.setBizId(bindings.getBizId());
            config.setCorpId(bindings.getCorpId());
            config.setConfigType(Integer.valueOf(1));
            config.setCreateBy(Long.valueOf(-1L));
            config.setCreateTime(new Date());
        }
        config.setUrl(params.getUrl());
        config.setConfigJson(JacksonUtil.obj2Str((Object)params));
        config.setUpdateBy(Long.valueOf(-1L));
        config.setUpdateTime(new Date());
        if (config.getId() == null) {
            this.tabUrlParamsConfigMapper.insertSelective((Object)config);
        } else {
            this.tabUrlParamsConfigMapper.updateByPrimaryKeySelective((Object)config);
        }
    }
}

