/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.app.center.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JsonUtil;
import com.kuaike.scrm.app.center.dto.req.AppAddReqDto;
import com.kuaike.scrm.app.center.dto.req.AppAddReviewReqDto;
import com.kuaike.scrm.app.center.dto.req.AppBindBaseDto;
import com.kuaike.scrm.app.center.dto.req.AppBindListReqDto;
import com.kuaike.scrm.app.center.dto.req.AppBindReqDto;
import com.kuaike.scrm.app.center.dto.req.AppCenterReqDto;
import com.kuaike.scrm.app.center.dto.req.AppListReqDto;
import com.kuaike.scrm.app.center.dto.req.AppReleaseReqDto;
import com.kuaike.scrm.app.center.dto.req.AppReviewBaseDto;
import com.kuaike.scrm.app.center.dto.req.AppReviewListReqDto;
import com.kuaike.scrm.app.center.dto.req.AppReviewReqDto;
import com.kuaike.scrm.app.center.dto.req.AppTypeBaseDto;
import com.kuaike.scrm.app.center.dto.resp.AppBindRespDto;
import com.kuaike.scrm.app.center.dto.resp.AppInfoRespDto;
import com.kuaike.scrm.app.center.dto.resp.AppListRespDto;
import com.kuaike.scrm.app.center.dto.resp.AppPkgRespDto;
import com.kuaike.scrm.app.center.dto.resp.AppReviewInfoRespDto;
import com.kuaike.scrm.app.center.dto.resp.AppReviewRespDto;
import com.kuaike.scrm.app.center.service.AppCenterService;
import com.kuaike.scrm.app.center.service.impl.ReviewEnum;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.dto.AppOpenBaseReqDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.AppInstallService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.app.entity.App;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.entity.AppReview;
import com.kuaike.scrm.dal.app.entity.AppType;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.app.mapper.AppMapper;
import com.kuaike.scrm.dal.app.mapper.AppReviewMapper;
import com.kuaike.scrm.dal.app.mapper.AppTypeMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.call.entity.CallMember;
import com.kuaike.scrm.dal.call.mapper.CallMemberMapper;
import com.kuaike.scrm.dal.system.entity.Package;
import com.kuaike.scrm.dal.system.mapper.PackageMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class AppCenterServiceImpl
implements AppCenterService,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AppCenterServiceImpl.class);
    @Value(value="${app.call.memberInfoUrl}")
    private String memberInfoUrl;
    @Value(value="${app.call.appCode}")
    private String appCode;
    @Autowired
    private IdGen idGen;
    @Autowired
    private AppMapper appMapper;
    @Autowired
    private AppBindingsMapper bindingsMapper;
    @Autowired
    private AppTypeMapper typeMapper;
    @Autowired
    private AppReviewMapper reviewMapper;
    @Autowired
    private BusinessCustomerMapper customerMapper;
    @Autowired
    private PackageMapper packageMapper;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private CallMemberMapper callMemberMapper;
    private Map<String, AppInstallService> installServiceMap = new HashMap<String, AppInstallService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map map = applicationContext.getBeansOfType(AppInstallService.class);
        map.forEach((k, v) -> this.installServiceMap.put(v.getAppCode(), (AppInstallService)v));
    }

    private AppInstallService getInstallService(String appCode) {
        return this.installServiceMap.get(appCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindApp(AppCenterReqDto reqDto) {
        Long bizId;
        Long appId = reqDto.getAppId();
        AppBindings binding = this.bindingsMapper.getExistsBinding(appId, bizId = reqDto.getBizId());
        if (!ObjectUtils.isEmpty((Object)binding) && binding.getIsDeleted() == 0) {
            return;
        }
        AppInstallService appInstallService = this.getInstallService(binding.getAppCode());
        if (appInstallService != null) {
            appInstallService.install(binding);
        }
    }

    @Override
    public String appTypeAdd(AppTypeBaseDto dto) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getName()), (Object)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List appTypes = this.typeMapper.queryAllTypes();
        if (!CollectionUtils.isEmpty((Collection)appTypes)) {
            List typeNames = appTypes.stream().map(AppType::getTypeName).collect(Collectors.toList());
            Preconditions.checkArgument((!typeNames.contains(dto.getName()) ? 1 : 0) != 0, (Object)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        AppType appType = new AppType();
        appType.setNum(this.idGen.getNum());
        appType.setCreateBy(Long.valueOf(-1L));
        appType.setCreateTime(new Date());
        appType.setUpdateBy(Long.valueOf(-1L));
        appType.setUpdateTime(new Date());
        appType.setIsDeleted(Integer.valueOf(0));
        appType.setTypeName(dto.getName());
        this.typeMapper.insert((Object)appType);
        return appType.getNum();
    }

    @Override
    public void appTypeDel(AppTypeBaseDto dto) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getId()), (Object)"\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a");
        AppType appType = this.typeMapper.queryTypeByNum(dto.getId());
        if (Objects.nonNull(appType)) {
            appType.setIsDeleted(Integer.valueOf(1));
            appType.setUpdateTime(new Date());
            this.typeMapper.updateByPrimaryKey((Object)appType);
        }
    }

    @Override
    public List<AppTypeBaseDto> appTypeList() {
        List appTypes = this.typeMapper.queryAllTypes();
        if (CollectionUtils.isEmpty((Collection)appTypes)) {
            return null;
        }
        ArrayList baseDtos = Lists.newArrayList();
        appTypes.forEach(a -> {
            AppTypeBaseDto dto = new AppTypeBaseDto();
            dto.setId(a.getNum());
            dto.setName(a.getTypeName());
            baseDtos.add(dto);
        });
        return baseDtos;
    }

    @Override
    public void appAddOrMod(AppAddReqDto reqDto) {
        reqDto.validate();
        log.info("appAddOrMod param: {}", (Object)reqDto);
        if (StringUtils.isBlank((CharSequence)reqDto.getId())) {
            this.insertApp(reqDto);
        } else {
            App app = this.appMapper.queryAppByNum(reqDto.getId());
            if (Objects.isNull(app)) {
                this.insertApp(reqDto);
            } else {
                app.setUpdateTime(new Date());
                app.setName(reqDto.getName());
                app.setCode(reqDto.getCode());
                app.setAppTypeId(reqDto.getTypeId());
                app.setMode(reqDto.getMode());
                app.setIcon(reqDto.getIcon());
                app.setDescription(reqDto.getDesc());
                app.setPkgId(reqDto.getPkgId());
                this.appMapper.updateByPrimaryKey((Object)app);
            }
        }
    }

    private void insertApp(AppAddReqDto reqDto) {
        App app = new App();
        app.setNum(this.idGen.getNum());
        app.setCreateBy(Long.valueOf(-1L));
        app.setCreateTime(new Date());
        app.setUpdateBy(Long.valueOf(-1L));
        app.setUpdateTime(new Date());
        app.setIsDeleted(Integer.valueOf(0));
        app.setName(reqDto.getName());
        app.setCode(reqDto.getCode());
        app.setAppTypeId(reqDto.getTypeId());
        app.setMode(reqDto.getMode());
        app.setIcon(reqDto.getIcon());
        app.setDescription(reqDto.getDesc());
        app.setIsRelease(Integer.valueOf(0));
        app.setPkgId(reqDto.getPkgId());
        this.appMapper.insert((Object)app);
    }

    @Override
    public void appRelease(AppReleaseReqDto reqDto) {
        reqDto.validate();
        App app = this.appMapper.queryAppByNum(reqDto.getId());
        Preconditions.checkArgument((boolean)Objects.nonNull(app), (Object)"\u64cd\u4f5c\u7684APP\u4e0d\u5b58\u5728");
        Preconditions.checkArgument((!reqDto.getRelease().equals(app.getIsRelease()) ? 1 : 0) != 0, (Object)"APP\u4e0d\u80fd\u91cd\u590d\u4e0a\u4e0b\u67b6");
        app.setIsRelease(reqDto.getRelease());
        app.setUpdateTime(new Date());
        this.appMapper.updateByPrimaryKey((Object)app);
    }

    @Override
    public List<AppInfoRespDto> appList(AppListReqDto reqDto) {
        List appList = this.appMapper.queryApp(reqDto.getName(), reqDto.getMode());
        if (CollectionUtils.isEmpty((Collection)appList)) {
            return null;
        }
        List appIds = appList.stream().map(App::getId).collect(Collectors.toList());
        Map appUseCount = this.bindingsMapper.queryAppUseCount(appIds);
        Map typeNameMap = this.typeMapper.queryAllTypeName();
        log.info("appList appUseCount: {}, typeNameMap: {}", (Object)appUseCount, (Object)typeNameMap);
        ArrayList respDtos = Lists.newArrayList();
        appList.forEach(a -> {
            AppInfoRespDto respDto = new AppInfoRespDto();
            respDtos.add(respDto);
            respDto.setId(a.getNum());
            respDto.setName(a.getName());
            respDto.setCode(a.getCode());
            respDto.setIcon(a.getIcon());
            respDto.setDesc(a.getDescription());
            respDto.setTypeId(a.getAppTypeId());
            if (Objects.nonNull(typeNameMap)) {
                String typeName = (String)typeNameMap.get(a.getAppTypeId());
                respDto.setTypeName(typeName);
            }
            respDto.setMode(a.getMode());
            if (Objects.nonNull(appUseCount)) {
                Integer count = (Integer)appUseCount.get(a.getId());
                if (count == null) {
                    count = 0;
                }
                respDto.setUseCount(count);
            }
            respDto.setIsRelease(a.getIsRelease());
            respDto.setPkgId(a.getPkgId());
        });
        return respDtos;
    }

    @Override
    public List<AppPkgRespDto> associatePkgList() {
        List pkgList = this.packageMapper.queryList(null);
        if (CollectionUtils.isEmpty((Collection)pkgList)) {
            return null;
        }
        ArrayList respDtos = Lists.newArrayList();
        for (Package pkg : pkgList) {
            if (pkg.getIsAppPkg() == null || pkg.getIsAppPkg() != 1) continue;
            AppPkgRespDto respDto = new AppPkgRespDto();
            respDto.setId(pkg.getId());
            respDto.setName(pkg.getName());
            respDto.setIsAppPkg(pkg.getIsAppPkg());
            App app = this.appMapper.queryAppByPkgId(pkg.getId());
            if (Objects.nonNull(app)) {
                respDto.setEnableSelect(0);
            } else {
                respDto.setEnableSelect(1);
            }
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void appBinding(AppBindReqDto reqDto, String staffName) {
        log.info("appBinding reqDto: {}", (Object)reqDto);
        reqDto.validate();
        BusinessCustomer customer = this.customerMapper.getByCorpId(reqDto.getCorpId());
        for (AppBindBaseDto baseDto : reqDto.getAppList()) {
            App app = this.appMapper.queryAppByNum(baseDto.getAppId());
            if (app == null) continue;
            List reviewList = this.reviewMapper.queryReviewByAppId(customer.getCorpId(), app.getId());
            if (!CollectionUtils.isEmpty((Collection)reviewList)) {
                AppReview review = (AppReview)reviewList.get(0);
                Integer status = baseDto.getIsOpen() == 1 ? 1 : 2;
                review.setStatus(status);
                review.setReviewTime(new Date());
                review.setReviewUserName(staffName);
                this.reviewMapper.updateByPrimaryKey((Object)review);
            }
            this.updateBinding(app, customer.getId(), customer.getCorpId(), baseDto.getIsOpen(), baseDto.getConfigJson(), staffName);
        }
    }

    @Override
    public void updateBinding(App app, Long bizId, String corpId, Integer isOpen, String configJson, String staffName) {
        AppBindings bindings = this.bindingsMapper.getExistsBinding(app.getId(), bizId);
        AppInstallService appInstallService = this.getInstallService(app.getCode());
        log.info("updateBinding bindings: {}, isOpen: {}", (Object)bindings, (Object)isOpen);
        if (bindings == null) {
            if (isOpen == 1) {
                bindings = new AppBindings();
                bindings.setNum(this.idGen.getNum());
                bindings.setBizId(bizId);
                bindings.setCorpId(corpId);
                bindings.setAppId(app.getId());
                bindings.setAppCode(app.getCode());
                bindings.setIsOpen(isOpen);
                bindings.setConfigJson(configJson);
                bindings.setConfigType(Integer.valueOf(1));
                bindings.setCreateBy(Long.valueOf(-1L));
                bindings.setUpdateBy(Long.valueOf(-1L));
                bindings.setCreateTime(new Date());
                bindings.setUpdateTime(new Date());
                bindings.setIsDeleted(Integer.valueOf(0));
                bindings.setBindingUserName(staffName);
                this.bindingsMapper.insert((Object)bindings);
                if (appInstallService != null) {
                    appInstallService.install(bindings);
                }
            } else {
                log.info("updateBinding binding \u4e3a\u7a7a\uff0c\u4e14\u72b6\u6001\u672a\u5f00\u901a\uff0c\u5c31\u4e0d\u9700\u8981\u5904\u7406");
            }
        } else {
            Integer oldOpenStatus = bindings.getIsOpen();
            log.info("oldOpenStatus:{}, isOpen:{}, appInstallService:{}", new Object[]{oldOpenStatus, isOpen, appInstallService});
            bindings.setAppCode(app.getCode());
            bindings.setConfigJson(configJson);
            bindings.setUpdateBy(Long.valueOf(-1L));
            bindings.setUpdateTime(new Date());
            bindings.setBindingUserName(staffName);
            bindings.setIsOpen(isOpen);
            this.bindingsMapper.updateByPrimaryKeySelective((Object)bindings);
            if (appInstallService != null) {
                if (oldOpenStatus.equals(isOpen)) {
                    appInstallService.update(bindings);
                } else if (oldOpenStatus < isOpen) {
                    appInstallService.install(bindings);
                } else {
                    appInstallService.uninstall(bindings);
                }
            }
        }
        this.updateCustomerPkgIds(corpId, app.getPkgId(), isOpen == 1);
    }

    private void updateCustomerPkgIds(String corpId, Long pkgId, boolean isOpen) {
        log.info("updateCustomerPkgIds corpId: {}, pkgId: {}, isOpen: {}", new Object[]{corpId, pkgId, isOpen});
        BusinessCustomer customer = this.customerMapper.getByCorpId(corpId);
        if (customer == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5546\u6237");
        }
        String pkgIds = customer.getPkgIds();
        ArrayList pkgIdList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)pkgIds)) {
            if (isOpen) {
                pkgIdList.add(pkgId);
            }
        } else {
            if (pkgIds.contains(",")) {
                for (String s : pkgIds.split(",")) {
                    Long parseLong = Long.parseLong(s);
                    pkgIdList.add(parseLong);
                }
            } else {
                pkgIdList.add(Long.parseLong(pkgIds));
            }
            log.info("updateCustomerPkgIds has pkgIdList: {}", (Object)pkgIdList);
            if (isOpen) {
                if (!pkgIdList.contains(pkgId)) {
                    pkgIdList.add(pkgId);
                }
            } else {
                pkgIdList.remove(pkgId);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)pkgIdList)) {
            String pkgIdStr = Joiner.on((String)",").join((Iterable)pkgIdList);
            log.info("updateCustomerPkgIds pkgIdStr: {}", (Object)pkgIdStr);
            this.customerMapper.updateBusinessPkgIds(corpId, pkgIdStr);
        }
    }

    @Override
    public List<AppBindRespDto> appBindingList(AppBindListReqDto reqDto) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getCorpId()), (Object)"\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        List apps = this.appMapper.queryAllApp();
        if (CollectionUtils.isEmpty((Collection)apps)) {
            return null;
        }
        List bindingsList = this.bindingsMapper.queryAppList(reqDto.getCorpId());
        Map<Long, AppBindings> bindingsMap = null;
        if (!CollectionUtils.isEmpty((Collection)bindingsList)) {
            bindingsMap = bindingsList.stream().collect(Collectors.toMap(AppBindings::getAppId, a -> a));
        }
        ArrayList respDtos = Lists.newArrayList();
        for (App app : apps) {
            AppBindings binding;
            AppBindRespDto respDto = new AppBindRespDto();
            respDtos.add(respDto);
            respDto.setAppId(app.getNum());
            respDto.setCode(app.getCode());
            respDto.setName(app.getName());
            respDto.setIsOpen(0);
            if (bindingsMap == null || (binding = bindingsMap.get(app.getId())) == null) continue;
            respDto.setIsOpen(binding.getIsOpen());
            respDto.setConfigJson(binding.getConfigJson());
        }
        return respDtos;
    }

    @Override
    public List<AppReviewRespDto> appReviewList(AppReviewListReqDto reqDto) {
        List reviewList;
        App app;
        log.info("appReviewList reqDto: {}", (Object)reqDto);
        Long appId = null;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getAppId()) && (app = this.appMapper.queryAppByNum(reqDto.getAppId())) != null) {
            appId = app.getId();
        }
        if (CollectionUtils.isEmpty((Collection)(reviewList = this.reviewMapper.queryReview(reqDto.getCorpName(), appId, reqDto.getStatus())))) {
            return null;
        }
        List appIds = reviewList.stream().map(AppReview::getAppId).collect(Collectors.toList());
        List appList = this.appMapper.queryAppByIds(appIds);
        Map<Long, App> appMap = appList.stream().collect(Collectors.toMap(App::getId, a -> a));
        log.info("appReviewList appMap: {}, appIds: {}", appMap, appIds);
        ArrayList respDtos = Lists.newArrayList();
        reviewList.forEach(it -> {
            AppReviewRespDto respDto = new AppReviewRespDto();
            respDtos.add(respDto);
            respDto.setId(it.getNum());
            respDto.setCorpName(it.getCorpName());
            respDto.setStatus(it.getStatus());
            ReviewEnum reviewEnum = ReviewEnum.get(it.getStatus());
            respDto.setStatusDesc(reviewEnum.getName());
            respDto.setUserName(it.getReviewUserName());
            respDto.setReviewTime(it.getReviewTime());
            respDto.setReviewDesc(it.getReviewDesc());
            respDto.setApplyTime(it.getCreateTime());
            App app = (App)appMap.get(it.getAppId());
            respDto.setCode(app.getCode());
            respDto.setAppName(app.getName());
            respDto.setCorpId(it.getCorpId());
            respDto.setBizId(it.getBizId());
        });
        return respDtos;
    }

    @Override
    public AppReviewInfoRespDto appReviewInfo(AppReviewBaseDto dto) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getId()), (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        AppReview review = this.reviewMapper.queryReivewByNum(dto.getId());
        if (review != null) {
            Long appId = review.getAppId();
            App app = (App)this.appMapper.selectByPrimaryKey((Object)appId);
            AppReviewInfoRespDto respDto = new AppReviewInfoRespDto();
            respDto.setId(review.getNum());
            respDto.setCorpName(review.getCorpName());
            respDto.setApplyTime(review.getCreateTime());
            respDto.setApplyInfo(review.getApplyInfo());
            respDto.setMobile(review.getReviewPhone());
            if (app != null) {
                respDto.setCode(app.getCode());
                respDto.setAppName(app.getName());
            }
            return respDto;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void appReview(AppReviewReqDto reqDto, String staffName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getId()), (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        reqDto.validate();
        AppReview review = this.reviewMapper.queryReivewByNum(reqDto.getId());
        if (review != null) {
            if (review.getStatus() != 0) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u7533\u8bf7\u5df2\u88ab\u5ba1\u6838\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u5ba1\u6838");
            }
            Integer status = reqDto.getIsOpen() == 1 ? ReviewEnum.REVIEW_PASS.getValue() : ReviewEnum.REVIEW_REJECT.getValue();
            review.setStatus(status);
            review.setReviewTime(new Date());
            review.setReviewUserName(staffName);
            review.setReviewDesc(reqDto.getReviewDesc());
            this.reviewMapper.updateByPrimaryKey((Object)review);
            App app = this.appMapper.queryAppById(review.getAppId());
            if (reqDto.getIsOpen() == 1) {
                this.updateBinding(app, review.getBizId(), review.getCorpId(), reqDto.getIsOpen(), reqDto.getConfigJson(), staffName);
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u627e\u5230\u7533\u8bf7\u7684\u5ba1\u6838\u4fe1\u606f");
        }
    }

    @Override
    public List<AppListRespDto> appUseList() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        Long userId = userInfo.getId();
        List apps = this.appMapper.queryAllApp();
        if (CollectionUtils.isEmpty((Collection)apps)) {
            return null;
        }
        Map typeNameMap = this.typeMapper.queryAllTypeName();
        ArrayList respDtos = Lists.newArrayList();
        ArrayList typeIds = Lists.newArrayList();
        for (App app : apps) {
            if (typeIds.contains(app.getAppTypeId())) continue;
            typeIds.add(app.getAppTypeId());
        }
        log.info("appUseList: {}", (Object)typeIds);
        List bindingsList = this.bindingsMapper.queryAppList(userInfo.getCorpId());
        Map<Long, AppBindings> bindingsMap = null;
        if (!CollectionUtils.isEmpty((Collection)bindingsList)) {
            bindingsMap = bindingsList.stream().collect(Collectors.toMap(AppBindings::getAppId, a -> a));
        }
        CallMember member = CallMember.builder().bizId(bizId).userId(userId).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).build();
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)member);
        for (String typeId : typeIds) {
            AppListRespDto respDto = new AppListRespDto();
            respDtos.add(respDto);
            respDto.setTypeId(typeId);
            if (typeNameMap != null) {
                String typeName = (String)typeNameMap.get(typeId);
                respDto.setTypeDesc(typeName);
            }
            ArrayList applist = Lists.newArrayList();
            for (App app : apps) {
                JSONObject jsonObject;
                List reviewList;
                AppBindings binding;
                if (!app.getAppTypeId().equals(typeId)) continue;
                AppInfoRespDto dto = new AppInfoRespDto();
                applist.add(dto);
                dto.setId(app.getNum());
                dto.setName(app.getName());
                dto.setCode(app.getCode());
                dto.setIcon(app.getIcon());
                dto.setDesc(app.getDescription());
                dto.setMode(app.getMode());
                dto.setIsOpen(0);
                if (bindingsMap != null && (binding = bindingsMap.get(app.getId())) != null) {
                    dto.setIsOpen(binding.getIsOpen());
                    dto.setConfigJson(binding.getConfigJson());
                }
                if (dto.getIsOpen() == 0 && !CollectionUtils.isEmpty((Collection)(reviewList = this.reviewMapper.queryReviewByAppId(userInfo.getCorpId(), app.getId())))) {
                    AppReview review = (AppReview)reviewList.get(0);
                    dto.setReviewStatus(review.getStatus());
                }
                if (!this.appCode.equals(dto.getCode()) || dto.getIsOpen() != 1) continue;
                if (StringUtils.isNotBlank((CharSequence)dto.getConfigJson())) {
                    String configJson = dto.getConfigJson();
                    jsonObject = JSONObject.parseObject((String)configJson);
                    if (!jsonObject.containsKey((Object)"supplierType") || jsonObject.getInteger("supplierType") == null) {
                        jsonObject.put("supplierType", (Object)0);
                    }
                    dto.setConfigJson(jsonObject.toJSONString());
                }
                if (ObjectUtils.isEmpty((Object)callMember)) continue;
                Map<String, String> params = this.getExtenInfoParams(userId);
                jsonObject = this.bjyPartnerService.bjyPost(bizId, this.memberInfoUrl, params);
                dto.setExten(jsonObject.getJSONObject("data").getJSONObject("exten"));
            }
            respDto.setApplist(applist);
        }
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void appBind(AppBindBaseDto baseDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)baseDto.getAppId()), (Object)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        App app = this.appMapper.queryAppByNum(baseDto.getAppId());
        if (app == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "APP\u4e0d\u5b58\u5728");
        }
        this.updateBinding(app, userInfo.getBizId(), userInfo.getCorpId(), 1, baseDto.getConfigJson(), null);
    }

    @Override
    public void addReview(AppAddReviewReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        App app = this.appMapper.queryAppByNum(reqDto.getAppId());
        if (app == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "APP\u4e0d\u5b58\u5728");
        }
        AppBindings bindings = this.bindingsMapper.getExistsBinding(app.getId(), userInfo.getBizId());
        if (bindings != null && bindings.getIsOpen() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "APP\u5df2\u5f00\u901a");
        }
        List reviewList = this.reviewMapper.queryReviewByAppId(userInfo.getCorpId(), app.getId());
        if (CollectionUtils.isEmpty((Collection)reviewList)) {
            this.addReview(userInfo, app, reqDto.getAppInfo(), reqDto.getMobile());
        } else {
            AppReview review = (AppReview)reviewList.get(0);
            switch (review.getStatus()) {
                case 0: {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u5728\u5f85\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u63d0\u4ea4");
                }
                case 1: {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u63d0\u4ea4");
                }
                case 2: {
                    this.addReview(userInfo, app, reqDto.getAppInfo(), reqDto.getMobile());
                    break;
                }
                default: {
                    log.warn("app review status: {}", (Object)review.getStatus());
                }
            }
        }
    }

    private void addReview(CurrentUserInfo userInfo, App app, String appInfo, String mobile) {
        AppReview r = new AppReview();
        r.setNum(this.idGen.getNum());
        r.setCreateBy(userInfo.getId());
        r.setCreateTime(new Date());
        r.setUpdateTime(new Date());
        r.setBizId(userInfo.getBizId());
        r.setCorpId(userInfo.getCorpId());
        r.setCorpName(userInfo.getBizName());
        r.setIsDeleted(Integer.valueOf(0));
        r.setAppId(app.getId());
        r.setStatus(Integer.valueOf(0));
        r.setApplyInfo(appInfo);
        r.setReviewPhone(mobile);
        this.reviewMapper.insert((Object)r);
    }

    @Override
    public void openBjyMeeting(AppOpenBaseReqDto reqDto) {
        reqDto.validate();
        AppBindBaseDto baseDto = new AppBindBaseDto();
        baseDto.setAppId(reqDto.getAppId());
        baseDto.setConfigJson(JsonUtil.toStr((Object)reqDto));
        this.appBind(baseDto);
    }

    @Override
    public void openBjyNetSchool(AppOpenBaseReqDto reqDto) {
        reqDto.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getFkSecret()), (Object)"Secret\u4e0d\u80fd\u4e3a\u7a7a");
        AppBindBaseDto baseDto = new AppBindBaseDto();
        baseDto.setAppId(reqDto.getAppId());
        baseDto.setConfigJson(JsonUtil.toStr((Object)reqDto));
        this.appBind(baseDto);
    }

    private Map<String, String> getExtenInfoParams(Long userId) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("user_number", String.valueOf(userId));
        return map;
    }
}

