/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.addFriend.service.impl;

import cn.kinyun.scrm.page.auth.service.WeworkOauthService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.addFriend.dto.AttachTagDto;
import com.kuaike.scrm.addFriend.dto.OriginItemDto;
import com.kuaike.scrm.addFriend.dto.RemarkDto;
import com.kuaike.scrm.addFriend.dto.SkipVerifyDto;
import com.kuaike.scrm.addFriend.dto.SyncQrcodeDto;
import com.kuaike.scrm.addFriend.dto.WelcomeDto;
import com.kuaike.scrm.addFriend.dto.req.AddFriendCfgListReq;
import com.kuaike.scrm.addFriend.dto.req.AddFriendCfgModifyReq;
import com.kuaike.scrm.addFriend.dto.req.AddFriendListReq;
import com.kuaike.scrm.addFriend.dto.req.EnableReq;
import com.kuaike.scrm.addFriend.dto.resp.AddFriendCfgListResp;
import com.kuaike.scrm.addFriend.dto.resp.AddFriendListResp;
import com.kuaike.scrm.addFriend.dto.resp.AttachTagRespDto;
import com.kuaike.scrm.addFriend.service.AddFriendCfgService;
import com.kuaike.scrm.addFriend.service.AddFriendCfgSyncService;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.enums.EnumDto;
import com.kuaike.scrm.common.enums.EnumService;
import com.kuaike.scrm.common.enums.OauthShortUrlTypeEnum;
import com.kuaike.scrm.common.enums.WeworkActiveStatusEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.utils.IdConvertUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.addFriend.dto.QueryAddFriendConfigDto;
import com.kuaike.scrm.dal.addFriend.dto.UserAddFriendConfig;
import com.kuaike.scrm.dal.addFriend.entity.AddFriendConfig;
import com.kuaike.scrm.dal.addFriend.entity.AddFriendConfigTag;
import com.kuaike.scrm.dal.addFriend.mapper.AddFriendConfigMapper;
import com.kuaike.scrm.dal.addFriend.mapper.AddFriendConfigTagMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.contactAnalyse.dto.NewFriendLogParams;
import com.kuaike.scrm.dal.contactAnalyse.dto.PlanChannelIdDto;
import com.kuaike.scrm.dal.contactAnalyse.entity.WeworkContactLog;
import com.kuaike.scrm.dal.contactAnalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkTagMapper;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AddFriendCfgServiceImpl
implements AddFriendCfgService {
    private static final Logger log = LoggerFactory.getLogger(AddFriendCfgServiceImpl.class);
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private WeworkContactLogMapper weworkContactLogMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private AddFriendConfigMapper addFriendConfigMapper;
    @Autowired
    private AddFriendConfigTagMapper addFriendConfigTagMapper;
    @Autowired
    private AddFriendCfgSyncService addFriendCfgSyncService;
    @Autowired
    private WeworkOauthService weworkOauthService;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${add-friend-cfg.url.format:/addFriendCfg?id={0}}")
    private String addFriendCfgUlr;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchModify(AddFriendCfgModifyReq params) {
        log.info("batch modify add friend config, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getWeworkUserIds()), (Object)"\u6210\u5458ID\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getSkipVerify() != null ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u901a\u8fc7\u9a8c\u8bc1\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getRemark() != null ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u5907\u6ce8\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getAttachTag() != null ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u6253\u6807\u7b7e\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getWelcome() != null ? 1 : 0) != 0, (Object)"\u6b22\u8fce\u8bed\u53c2\u6570\u4e3a\u7a7a");
        params.getSkipVerify().validate();
        params.getRemark().validate();
        params.getAttachTag().validate();
        params.getWelcome().validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long operatorId = LoginUtils.getCurrentUserId();
        List<String> weworkUserNums = params.getWeworkUserIds();
        Set<String> managerWeworkUserIds = this.queryCurManagerWeworkUser();
        List weworkUserList = this.weworkUserMapper.queryWeworkUsersByNums(corpId, weworkUserNums);
        Map<Object, Object> weworkUserMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)weworkUserList)) {
            weworkUserMap = weworkUserList.stream().collect(Collectors.toMap(it -> it.getNum(), it -> it));
        }
        for (String weworkUserNum : weworkUserNums) {
            WeworkUser u = (WeworkUser)weworkUserMap.get(weworkUserNum);
            Preconditions.checkArgument((u != null ? 1 : 0) != 0, (Object)("\u8be5\u6210\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664:" + weworkUserNum));
            String weworkUserId = u.getWeworkUserId();
            Preconditions.checkArgument((boolean)managerWeworkUserIds.contains(weworkUserId), (Object)("\u4f60\u65e0\u6743\u64cd\u4f5c\u8be5\u6210\u5458:" + weworkUserNum));
        }
        StopWatchDto timer = new StopWatchDto("batchModify", true, log);
        timer.start("queryAddFriendConfig");
        List configList = this.addFriendConfigMapper.queryByWeworkUserNums(corpId, weworkUserNums);
        Map<String, AddFriendConfig> configMap = configList.stream().collect(Collectors.toMap(it -> it.getWeworkUserNum(), it -> it));
        timer.stop();
        timer.start("queryAddFriendConfigTag");
        List configTagList = this.addFriendConfigTagMapper.queryByWeworkUserNums(corpId, weworkUserNums);
        Map<String, List<AddFriendConfigTag>> configTagMap = configTagList.stream().collect(Collectors.groupingBy(it -> it.getWeworkUserNum()));
        timer.stop();
        ArrayList addList = Lists.newArrayListWithCapacity((int)weworkUserNums.size());
        ArrayList addTagList = Lists.newArrayList();
        ArrayList delTagList = Lists.newArrayList();
        ArrayList taskList = Lists.newArrayList();
        for (String weworkUserNum : weworkUserNums) {
            AddFriendConfig exist = configMap.get(weworkUserNum);
            List<AddFriendConfigTag> existTags = configTagMap.get(weworkUserNum);
            if (exist == null) {
                exist = this.addFriendCfgSyncService.defaultConfig(bizId, corpId, weworkUserNum, operatorId);
            } else {
                exist.setUpdateBy(operatorId);
                exist.setUpdateTime(new Date());
            }
            this.setSkipVerify(exist, params.getSkipVerify());
            this.setRemark(exist, params.getRemark());
            this.setWelcome(exist, params.getWelcome());
            this.setAttachTag(exist, existTags, params.getAttachTag(), addTagList, delTagList);
            exist.setIsSync(Integer.valueOf(0));
            addList.add(exist);
            SyncQrcodeDto task = new SyncQrcodeDto();
            task.setBizId(bizId);
            task.setCorpId(corpId);
            task.setWeworkUserId(((WeworkUser)weworkUserMap.get(weworkUserNum)).getWeworkUserId());
            task.setWeworkUserNum(weworkUserNum);
            taskList.add(task);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            log.info("save add_friend_config, size:{}", (Object)addList.size());
            this.addFriendConfigMapper.batchInsert((Collection)addList);
        }
        if (CollectionUtils.isNotEmpty((Collection)addTagList)) {
            log.info("batch insert add_friend_config_tag, size:{}", (Object)addTagList.size());
            this.addFriendConfigTagMapper.batchInsert((Collection)addTagList);
        }
        if (CollectionUtils.isNotEmpty((Collection)delTagList)) {
            log.info("delete add_friend_config_tag, size:{}", (Object)delTagList.size());
            Set ids = delTagList.stream().map(it -> it.getId()).collect(Collectors.toSet());
            this.addFriendConfigTagMapper.logicDeleteByIds(ids, operatorId);
        }
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            this.startSyncTask(taskList);
        }
    }

    @Override
    public List<AddFriendCfgListResp> list(AddFriendCfgListReq params) {
        log.info("query add friend config list, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        Set<String> managerWeworkUserIds = this.queryCurManagerWeworkUser();
        StopWatchDto timer = new StopWatchDto("list", true, log);
        timer.start("queryWeworkUser");
        if (StringUtils.isNotBlank((CharSequence)params.getWeworkUserId())) {
            String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(params.getWeworkUserId());
            if (!managerWeworkUserIds.contains(weworkUserId)) {
                log.info("No permit to query weworkUserId:{}", (Object)weworkUserId);
                return Collections.emptyList();
            }
            managerWeworkUserIds = Collections.singleton(weworkUserId);
        }
        QueryAddFriendConfigDto queryParams = new QueryAddFriendConfigDto();
        queryParams.setCorpId(corpId);
        queryParams.setWeworkUserIds(managerWeworkUserIds);
        queryParams.setPageDto(params.getPageDto());
        if (params.getPageDto() != null) {
            int total = this.addFriendConfigMapper.countList(queryParams);
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        List list = this.addFriendConfigMapper.queryList(queryParams);
        timer.stop();
        List weworkUserNums = list.stream().map(it -> it.getNum()).collect(Collectors.toList());
        timer.start("queryAddFriendConfig");
        List configList = this.addFriendConfigMapper.queryByWeworkUserNums(corpId, weworkUserNums);
        Map<String, AddFriendConfig> configMap = configList.stream().collect(Collectors.toMap(it -> it.getWeworkUserNum(), it -> it));
        timer.stop();
        timer.start("queryAddFriendConfigTag");
        List configTagList = this.addFriendConfigTagMapper.queryByWeworkUserNums(corpId, weworkUserNums);
        Map<String, List<AddFriendConfigTag>> configTagMap = configTagList.stream().collect(Collectors.groupingBy(it -> it.getWeworkUserNum()));
        timer.stop();
        timer.start("queryUpdator");
        Set userIds = configList.stream().map(it -> it.getUpdateBy()).collect(Collectors.toSet());
        Map userNameMap = this.userMapper.selectUserIdAndNameByIds(bizId, corpId, userIds);
        timer.stop();
        timer.start("queryWeworkTag");
        Set tagIds = configTagList.stream().map(it -> it.getTagId()).collect(Collectors.toSet());
        Map tagMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(corpId, tagIds);
        timer.stop();
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        ArrayList addList = Lists.newArrayListWithCapacity((int)list.size());
        ArrayList taskList = Lists.newArrayList();
        for (UserAddFriendConfig u : list) {
            AddFriendCfgListResp dto = new AddFriendCfgListResp();
            result.add(dto);
            dto.setWeworkUserId(u.getNum());
            dto.setWeworkUserNickname(u.getName());
            dto.setAvatar(u.getAvatar());
            WeworkActiveStatusEnum status = WeworkActiveStatusEnum.get((Integer)u.getStatus());
            dto.setStatusDto(EnumDto.from((EnumService)status));
            AddFriendConfig cfg = configMap.get(u.getNum());
            if (cfg == null) {
                cfg = this.addFriendCfgSyncService.defaultConfig(bizId, corpId, u.getNum(), -1L);
                addList.add(cfg);
                SyncQrcodeDto task = new SyncQrcodeDto();
                task.setBizId(bizId);
                task.setCorpId(corpId);
                task.setWeworkUserId(u.getWeworkUserId());
                task.setWeworkUserNum(u.getNum());
                taskList.add(task);
            }
            if (cfg.getErrorCode() == 0) {
                String configKey = cfg.getWeworkUserNum();
                String originUrl = MessageFormat.format(this.addFriendCfgUlr, configKey);
                String shortUrl = this.weworkOauthService.wrapUrl(bizId, corpId, originUrl, null, Integer.valueOf(OauthShortUrlTypeEnum.ADD_FRIEND_URL.getValue()));
                dto.setQrcode(shortUrl);
            }
            dto.setCurrentSkipVerify(cfg.getSkipVerifyCurrentEnabled());
            dto.setErrorCode(cfg.getErrorCode());
            dto.setErrorMsg(cfg.getErrorMsg());
            dto.setSkipVerify(this.getSkipVerify(cfg));
            dto.setRemark(this.getRemark(cfg));
            dto.setAttachTag(this.getAttachTag(cfg, configTagMap.get(u.getNum()), tagMap));
            dto.setWelcome(this.getWelcome(cfg));
            if (cfg.getUpdateBy() <= 0L) {
                dto.setUpdatorName("\u7cfb\u7edf\u81ea\u52a8\u751f\u6210");
            } else {
                dto.setUpdatorName((String)userNameMap.get(cfg.getUpdateBy()));
            }
            dto.setUpdateTime(cfg.getUpdateTime());
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            timer.start("batchInsert");
            this.addFriendConfigMapper.batchInsert((Collection)addList);
            timer.stop();
        }
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            this.startSyncTask(taskList);
        }
        timer.print();
        return result;
    }

    private void startSyncTask(List<SyncQrcodeDto> list) {
        for (SyncQrcodeDto dto : list) {
            this.addFriendCfgSyncService.enqueue(dto);
        }
    }

    private SkipVerifyDto getSkipVerify(AddFriendConfig cfg) {
        SkipVerifyDto skipVerify = new SkipVerifyDto();
        skipVerify.setIsEnabled(cfg.getSkipVerifyIsEnabled());
        skipVerify.setType(cfg.getSkipVerifyType());
        skipVerify.setStartTime(cfg.getSkipVerifyStartTime());
        skipVerify.setEndTime(cfg.getSkipVerifyEndTime());
        skipVerify.setIsLimited(cfg.getSkipVerifyIsLimited());
        skipVerify.setLimit(cfg.getSkipVerifyLimit());
        return skipVerify;
    }

    private void setSkipVerify(AddFriendConfig cfg, SkipVerifyDto skipVerify) {
        cfg.setSkipVerifyIsEnabled(skipVerify.getIsEnabled());
        cfg.setSkipVerifyType(skipVerify.getType());
        cfg.setSkipVerifyStartTime(skipVerify.getStartTime());
        cfg.setSkipVerifyEndTime(skipVerify.getEndTime());
        cfg.setSkipVerifyIsLimited(skipVerify.getIsLimited());
        cfg.setSkipVerifyLimit(skipVerify.getLimit());
    }

    private RemarkDto getRemark(AddFriendConfig cfg) {
        RemarkDto remark = new RemarkDto();
        remark.setIsEnabled(cfg.getRemarkIsEnabled());
        remark.setIsSpecified(cfg.getRemarkIsSpecified() == null ? 1 : cfg.getRemarkIsSpecified());
        remark.setFormat(cfg.getRemarkFormat());
        remark.setUseOther(cfg.getRemarkUseOther() == null ? 0 : cfg.getRemarkUseOther());
        return remark;
    }

    private void setRemark(AddFriendConfig cfg, RemarkDto remark) {
        cfg.setRemarkIsEnabled(remark.getIsEnabled());
        cfg.setRemarkIsSpecified(Integer.valueOf(remark.getIsSpecified() == null ? 1 : remark.getIsSpecified()));
        cfg.setRemarkFormat(remark.getFormat());
        cfg.setRemarkUseOther(remark.getUseOther());
    }

    private AttachTagRespDto getAttachTag(AddFriendConfig cfg, List<AddFriendConfigTag> cfgTags, Map<String, String> tagMap) {
        AttachTagRespDto attachTag = new AttachTagRespDto();
        attachTag.setIsEnabled(cfg.getAttachTagIsEnabled());
        attachTag.setIsSpecified(cfg.getAttachTagIsSpecified() == null ? 1 : cfg.getAttachTagIsSpecified());
        attachTag.setUseOther(cfg.getAttachTagUseOther() == null ? 0 : cfg.getAttachTagUseOther());
        ArrayList weworkTags = Lists.newArrayList();
        attachTag.setWeworkTags(weworkTags);
        if (CollectionUtils.isNotEmpty(cfgTags)) {
            for (AddFriendConfigTag tag : cfgTags) {
                StrIdAndNameDto it = new StrIdAndNameDto();
                it.setId(tag.getTagId());
                it.setName(tagMap.get(tag.getTagId()));
                weworkTags.add(it);
            }
        }
        return attachTag;
    }

    private void setAttachTag(AddFriendConfig exist, List<AddFriendConfigTag> existTags, AttachTagDto attachTag, List<AddFriendConfigTag> addTagList, List<AddFriendConfigTag> delTagList) {
        List<String> weworkTagIds;
        exist.setAttachTagIsEnabled(attachTag.getIsEnabled());
        exist.setAttachTagIsSpecified(Integer.valueOf(attachTag.getIsSpecified() == null ? 1 : attachTag.getIsSpecified()));
        exist.setAttachTagUseOther(attachTag.getUseOther());
        Map<Object, Object> existTagMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty(existTags)) {
            existTagMap = existTags.stream().collect(Collectors.groupingBy(it -> it.getTagId(), Collectors.toList()));
        }
        if (CollectionUtils.isEmpty(weworkTagIds = attachTag.getWeworkTagIds())) {
            if (CollectionUtils.isNotEmpty(existTags)) {
                delTagList.addAll(existTags);
            }
            return;
        }
        HashSet cache = Sets.newHashSet();
        for (String tagId : weworkTagIds) {
            if (cache.contains(tagId)) continue;
            cache.add(tagId);
            if (existTagMap.remove(tagId) != null) continue;
            addTagList.add(this.newTag(exist.getBizId(), exist.getCorpId(), exist.getWeworkUserNum(), tagId));
        }
        if (!existTagMap.isEmpty()) {
            existTagMap.values().forEach(it -> delTagList.addAll((Collection<AddFriendConfigTag>)it));
        }
    }

    private AddFriendConfigTag newTag(Long bizId, String corpId, String weworkUserNum, String tagId) {
        Long operatorId = LoginUtils.getCurrentUserId();
        AddFriendConfigTag record = new AddFriendConfigTag();
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setWeworkUserNum(weworkUserNum);
        record.setTagId(tagId);
        record.setCreateBy(operatorId);
        record.setCreateTime(new Date());
        record.setUpdateBy(operatorId);
        record.setUpdateTime(new Date());
        return record;
    }

    private WelcomeDto getWelcome(AddFriendConfig cfg) {
        WelcomeDto welcome = null;
        if (StringUtils.isNotBlank((CharSequence)cfg.getWelcomeJson())) {
            try {
                welcome = (WelcomeDto)JacksonUtil.str2Obj((String)cfg.getWelcomeJson(), WelcomeDto.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (welcome == null) {
            welcome = new WelcomeDto();
        }
        welcome.setIsEnabled(cfg.getWelcomeIsEnabled());
        welcome.setIsSpecified(cfg.getWelcomeIsSpecified());
        welcome.setUseOther(cfg.getWelcomeUseOther() == null ? 0 : cfg.getWelcomeUseOther());
        return welcome;
    }

    private void setWelcome(AddFriendConfig cfg, WelcomeDto welcome) {
        cfg.setWelcomeIsEnabled(welcome.getIsEnabled());
        cfg.setWelcomeIsSpecified(welcome.getIsSpecified());
        cfg.setWelcomeUseOther(welcome.getUseOther());
        if (StringUtils.isNotBlank((CharSequence)welcome.getText()) || CollectionUtils.isNotEmpty(welcome.getAttachments())) {
            String json = JacksonUtil.obj2Str((Object)welcome);
            cfg.setWelcomeJson(json);
        } else {
            cfg.setWelcomeJson(null);
        }
    }

    private Set<String> queryCurManagerWeworkUser() {
        StopWatchDto timer = new StopWatchDto("queryCurManagerWeworkUser", true, log);
        timer.start("getManageNodeIds");
        Set nodeIds = this.userRoleCommonService.getManageNodeIds();
        timer.stop();
        timer.start("getDepartmentIds");
        Set departmentIds = this.orgService.getDepartmentIds(nodeIds);
        timer.stop();
        String currentCorpId = LoginUtils.getCurrentUser().getCorpId();
        timer.start("selectByCorpIdAndDepartmentIds");
        Set weworkUserIds = this.weworkDepartmentUserMapper.selectByCorpIdAndDepartmentIds(currentCorpId, (Collection)departmentIds, Boolean.valueOf(true));
        timer.stop();
        Long userId = LoginUtils.getCurrentUser().getId();
        timer.start("queryWeworkUserIdOfUser");
        String ownerWeworkUserId = this.userMapper.queryWeworkUserIdOfUser(userId);
        timer.stop();
        if (StringUtils.isNotBlank((CharSequence)ownerWeworkUserId)) {
            weworkUserIds.add(ownerWeworkUserId);
        }
        timer.print();
        return weworkUserIds;
    }

    @Override
    public List<AddFriendListResp> addFriendList(AddFriendListReq params) {
        log.info("query add friend list, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getWeworkUserId()), (Object)"weworkUserId is empty");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        String weworkUserNum = params.getWeworkUserId();
        StopWatchDto timer = new StopWatchDto("addList", true, log);
        AddFriendConfig cfg = this.addFriendConfigMapper.getByWeworkUser(corpId, weworkUserNum);
        if (cfg == null || StringUtils.isBlank((CharSequence)cfg.getQrcodeState())) {
            log.warn("\u6ca1\u6709\u627e\u5230\u6210\u5458\u7684\u4e13\u5c5e\u4e8c\u7ef4\u7801\u3002corpId={}, weworkUserNum:{}", (Object)corpId, (Object)weworkUserNum);
            return Collections.emptyList();
        }
        String qrcodeState = cfg.getQrcodeState();
        OriginItemDto originQuery = params.getOriginQuery();
        if (originQuery == null) {
            originQuery = new OriginItemDto();
        } else {
            originQuery.checkParams();
        }
        NewFriendLogParams queryParams = new NewFriendLogParams();
        queryParams.setCorpId(corpId);
        queryParams.setWeworkUserNum(weworkUserNum);
        queryParams.setType(originQuery.getType());
        queryParams.setState(qrcodeState);
        if (originQuery.getType() != null && originQuery.getType() == 2) {
            String planChannelId = originQuery.getPlanChannelId();
            this.setPlanChannelId(queryParams, planChannelId);
        }
        timer.start("queryContactLog");
        int total = this.weworkContactLogMapper.countByWeworkUser(queryParams);
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(total));
        }
        if (total == 0) {
            timer.stop();
            timer.print();
            return Collections.emptyList();
        }
        queryParams.setPageDto(pageDto);
        List list = this.weworkContactLogMapper.queryByWeworkUser(queryParams);
        timer.stop();
        List contactIds = list.stream().map(item -> item.getContactId()).collect(Collectors.toList());
        timer.start("queryContact");
        List contactList = this.weworkContactMapper.queryWeworkContactList(corpId, contactIds);
        Map<Object, Object> contactMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)contactList)) {
            contactMap = contactList.stream().collect(Collectors.toMap(it -> it.getContactId(), it -> it));
        }
        timer.stop();
        timer.start("queryContactTag");
        HashSet allTagIds = Sets.newHashSet();
        list.forEach(it -> {
            if (StringUtils.isBlank((CharSequence)it.getWeworkTagIds())) {
                return;
            }
            String[] args = StringUtils.split((String)it.getWeworkTagIds(), (char)';');
            if (args == null) {
                return;
            }
            for (String tagId : args) {
                allTagIds.add(tagId);
            }
        });
        Map tagNameMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(corpId, (Collection)allTagIds);
        timer.stop();
        Set planIds = list.stream().map(it -> it.getPlanId()).collect(Collectors.toSet());
        Set channelIds = list.stream().map(it -> it.getChannelId()).collect(Collectors.toSet());
        Map planNameMap = this.marketingPlanMapper.getPlanIdNameMap(planIds);
        Map channelNameMap = this.channelMapper.selectIdAndNameByIds(bizId, channelIds);
        channelNameMap.put(-1L, "\u9ed8\u8ba4\u6e20\u9053");
        timer.start("buildResult");
        ArrayList result = Lists.newArrayList();
        for (WeworkContactLog it2 : list) {
            String[] args;
            AddFriendListResp dto = new AddFriendListResp();
            String contactId = it2.getContactId();
            dto.setContactId(it2.getContactId());
            dto.setAddTime(it2.getAddTime());
            WeworkContact contact = (WeworkContact)contactMap.get(contactId);
            if (contact != null) {
                dto.setNickname(contact.getName());
                dto.setAvatar(contact.getAvatar());
                dto.setType(contact.getType());
                dto.setCorpName(contact.getCorpName());
            } else {
                dto.setNickname(it2.getName());
                dto.setAvatar(it2.getAvatar());
                dto.setType(it2.getType());
                dto.setCorpName(it2.getCorpName());
            }
            dto.setRemarkName(it2.getRemark());
            if (StringUtils.isNotBlank((CharSequence)it2.getWeworkTagIds()) && (args = StringUtils.split((String)it2.getWeworkTagIds(), (char)';')) != null) {
                ArrayList tags = Lists.newArrayList();
                for (String tagId : args) {
                    String name = (String)tagNameMap.get(tagId);
                    tags.add(name);
                }
                dto.setWeworkTags(tags);
            }
            Long planId = it2.getPlanId();
            Long channelId = it2.getChannelId();
            boolean isBusinessState = false;
            if (it2.getPlanId() == null && StringUtils.isNotEmpty((CharSequence)it2.getState())) {
                int count = this.weworkContactLogMapper.queryContactStateCount(corpId, it2.getState());
                boolean bl = isBusinessState = count > 0;
            }
            if (it2.getPlanId() == null && (StringUtils.isEmpty((CharSequence)it2.getState()) || !isBusinessState)) {
                dto.setOriginName("\u81ea\u7136\u6d41\u91cf");
            }
            if (it2.getPlanId() != null && it2.getChannelId() != null) {
                String name = "";
                if (planNameMap.containsKey(planId)) {
                    name = (String)planNameMap.get(planId);
                }
                if (channelNameMap.containsKey(channelId)) {
                    name = name + "-" + (String)channelNameMap.get(channelId);
                }
                dto.setOriginName(name);
            }
            if (StringUtils.isNotEmpty((CharSequence)it2.getState()) && it2.getState().startsWith("AFC_$_")) {
                dto.setOriginName("\u6210\u5458\u767e\u5bb6\u4e91\u4e8c\u7ef4\u7801");
            }
            result.add(dto);
        }
        timer.stop();
        timer.print();
        return result;
    }

    private String getAndValidateWeworkUserId(String corpId, String weworkUserNum) {
        WeworkUser u = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
        Preconditions.checkArgument((u != null ? 1 : 0) != 0, (Object)("\u8be5\u6210\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664:" + weworkUserNum));
        Preconditions.checkArgument((boolean)corpId.equals(u.getCorpId()), (Object)("\u4f60\u65e0\u6743\u64cd\u4f5c\u8be5\u6210\u5458:" + weworkUserNum));
        Set<String> manageWeworkUserIds = this.queryCurManagerWeworkUser();
        String weworkUserId = u.getWeworkUserId();
        Preconditions.checkArgument((boolean)manageWeworkUserIds.contains(weworkUserId), (Object)("\u4f60\u65e0\u6743\u64cd\u4f5c\u8be5\u6210\u5458:" + weworkUserNum));
        return weworkUserId;
    }

    @Override
    public void enableSkipVerify(EnableReq params) {
        log.info("enable skip verify, params:{}, operatorId:{}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        params.validate();
        String weworkUserNum = params.getWeworkUserId();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        String corpId = userInfo.getCorpId();
        Long operatorId = userInfo.getId();
        this.getAndValidateWeworkUserId(corpId, weworkUserNum);
        AddFriendConfig record = this.addFriendConfigMapper.getByWeworkUser(corpId, weworkUserNum);
        Preconditions.checkArgument((record != null ? 1 : 0) != 0, (Object)"\u65b0\u597d\u53cb\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        if (Objects.equals(params.getIsEnabled(), record.getSkipVerifyIsEnabled())) {
            log.info("no need to update skip_verify_is_enabled");
            return;
        }
        log.info("update skip_verify_is_enabled to {}", (Object)params.getIsEnabled());
        record.setSkipVerifyIsEnabled(params.getIsEnabled());
        record.setIsSync(Integer.valueOf(0));
        record.setUpdateBy(operatorId);
        record.setUpdateTime(new Date());
        this.addFriendConfigMapper.updateByPrimaryKey((Object)record);
    }

    @Override
    public void enableRemark(EnableReq params) {
        log.info("enable remark, params:{}, operatorId:{}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        params.validate();
        String weworkUserNum = params.getWeworkUserId();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        String corpId = userInfo.getCorpId();
        Long operatorId = userInfo.getId();
        this.getAndValidateWeworkUserId(corpId, weworkUserNum);
        AddFriendConfig record = this.addFriendConfigMapper.getByWeworkUser(corpId, weworkUserNum);
        Preconditions.checkArgument((record != null ? 1 : 0) != 0, (Object)"\u65b0\u597d\u53cb\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        if (Objects.equals(params.getIsEnabled(), record.getRemarkIsEnabled())) {
            log.info("no need to update remark_is_enabled");
            return;
        }
        log.info("update remark_is_enabled to {}", (Object)params.getIsEnabled());
        record.setRemarkIsEnabled(params.getIsEnabled());
        record.setUpdateBy(operatorId);
        record.setUpdateTime(new Date());
        this.addFriendConfigMapper.updateByPrimaryKey((Object)record);
    }

    @Override
    public void enableWelcome(EnableReq params) {
        log.info("enable welcome, params:{}, operatorId:{}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        params.validate();
        String weworkUserNum = params.getWeworkUserId();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        String corpId = userInfo.getCorpId();
        Long operatorId = userInfo.getId();
        this.getAndValidateWeworkUserId(corpId, weworkUserNum);
        AddFriendConfig record = this.addFriendConfigMapper.getByWeworkUser(corpId, weworkUserNum);
        Preconditions.checkArgument((record != null ? 1 : 0) != 0, (Object)"\u65b0\u597d\u53cb\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        if (Objects.equals(params.getIsEnabled(), record.getWelcomeIsEnabled())) {
            log.info("no need to update welcome_is_enabled");
            return;
        }
        log.info("update welcome_is_enabled to {}", (Object)params.getIsEnabled());
        record.setWelcomeIsEnabled(params.getIsEnabled());
        record.setUpdateBy(operatorId);
        record.setUpdateTime(new Date());
        this.addFriendConfigMapper.updateByPrimaryKey((Object)record);
    }

    @Override
    public void enableAttachTag(EnableReq params) {
        log.info("enable attach tag, params:{}, operatorId:{}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        params.validate();
        String weworkUserNum = params.getWeworkUserId();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        String corpId = userInfo.getCorpId();
        Long operatorId = userInfo.getId();
        this.getAndValidateWeworkUserId(corpId, weworkUserNum);
        AddFriendConfig record = this.addFriendConfigMapper.getByWeworkUser(corpId, weworkUserNum);
        Preconditions.checkArgument((record != null ? 1 : 0) != 0, (Object)"\u65b0\u597d\u53cb\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        if (Objects.equals(params.getIsEnabled(), record.getAttachTagIsEnabled())) {
            log.info("no need to update attach_tag_is_enabled");
            return;
        }
        log.info("update attach_tag_is_enabled to {}", (Object)params.getIsEnabled());
        record.setAttachTagIsEnabled(params.getIsEnabled());
        record.setUpdateBy(operatorId);
        record.setUpdateTime(new Date());
        this.addFriendConfigMapper.updateByPrimaryKey((Object)record);
    }

    @Override
    public List<OriginItemDto> getOriginList(AddFriendListReq params) {
        String weworkUserNum = params.getWeworkUserId();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)weworkUserNum), (Object)"weworkUserId\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        AddFriendConfig record = this.addFriendConfigMapper.getByWeworkUser(corpId, weworkUserNum);
        Preconditions.checkArgument((record != null ? 1 : 0) != 0, (Object)"\u65b0\u597d\u53cb\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        ArrayList result = Lists.newArrayList();
        OriginItemDto other = new OriginItemDto();
        other.setType(1);
        other.setName("\u81ea\u7136\u6d41\u91cf");
        result.add(other);
        OriginItemDto userDto = new OriginItemDto();
        userDto.setType(3);
        userDto.setName("\u6210\u5458\u767e\u5bb6\u4e91\u4e8c\u7ef4\u7801");
        result.add(userDto);
        List planChannelIdDtos = this.weworkContactLogMapper.queryWeworkUserPlanGroup(corpId, weworkUserNum);
        Set planIds = planChannelIdDtos.stream().map(it -> it.getPlanId()).collect(Collectors.toSet());
        Set channelIds = planChannelIdDtos.stream().map(it -> it.getChannelId()).collect(Collectors.toSet());
        Map planNameMap = this.marketingPlanMapper.getPlanIdNameMap(planIds);
        Map channelNameMap = this.channelMapper.selectIdAndNameByIds(bizId, channelIds);
        channelNameMap.put(-1L, "\u9ed8\u8ba4\u6e20\u9053");
        for (PlanChannelIdDto planChannelIdDto : planChannelIdDtos) {
            Long planId = planChannelIdDto.getPlanId();
            Long channelId = planChannelIdDto.getChannelId();
            OriginItemDto planOriginItem = new OriginItemDto();
            planOriginItem.setType(2);
            String name = "";
            if (planNameMap.containsKey(planId)) {
                name = (String)planNameMap.get(planId);
            }
            if (channelNameMap.containsKey(channelId)) {
                name = name + "-" + (String)channelNameMap.get(channelId);
            }
            planOriginItem.setName(name);
            String planChannelStr = IdConvertUtils.encodeId((String)planId.toString()) + "-" + IdConvertUtils.encodeId((String)channelId.toString());
            planOriginItem.setPlanChannelId(planChannelStr);
            result.add(planOriginItem);
        }
        return result;
    }

    @Override
    public String info(BaseDto params) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        AddFriendConfig record = this.addFriendConfigMapper.getByWeworkUserNum(params.getId());
        if (record != null) {
            return record.getQrcodeUrl();
        }
        return null;
    }

    private void setPlanChannelId(NewFriendLogParams queryParams, String planChannelId) {
        String[] strArr = planChannelId.split("-");
        try {
            Long planId = Long.parseLong(IdConvertUtils.decodeId((String)strArr[0]));
            Long channelId = -1L;
            if (strArr.length == 2) {
                channelId = Long.parseLong(IdConvertUtils.decodeId((String)strArr[1]));
            }
            queryParams.setPlanId(planId);
            queryParams.setChannelId(channelId);
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "planChannelId\u53c2\u6570\u9519\u8bef\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
    }
}

