/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.addFriend.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class QrcodeSyncThreadPoolConfig {
    private static final Logger log = LoggerFactory.getLogger(QrcodeSyncThreadPoolConfig.class);

    @Bean(value={"qrcodeSyncThreadPool"})
    public ExecutorService getQrcodeSyncThreadPool() {
        int nThread = Runtime.getRuntime().availableProcessors() * 4 + 1;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("qrcode-sync-thread-%d").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("qrcode sync error", e);
            }
        }).build();
        return Executors.newFixedThreadPool(nThread, threadFactory);
    }
}

