/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.addfriend.service.impl;

import cn.kinyun.wework.sdk.api.external.ContactWayClient;
import cn.kinyun.wework.sdk.entity.external.contactway.ConfigIdResp;
import cn.kinyun.wework.sdk.entity.external.contactway.ContactWay;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.addfriend.dto.SyncQrcodeDto;
import com.kuaike.scrm.addfriend.service.AddFriendCfgSyncService;
import com.kuaike.scrm.common.enums.WeworkActiveStatusEnum;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.addfriend.entity.AddFriendConfig;
import com.kuaike.scrm.dal.addfriend.mapper.AddFriendConfigMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class AddFriendCfgSyncServiceImpl
implements AddFriendCfgSyncService {
    private static final Logger log = LoggerFactory.getLogger(AddFriendCfgSyncServiceImpl.class);
    private SimpleDateFormat formater = new SimpleDateFormat("HH:mm");
    @Value(value="${kafka.topic.task_add_friend_qrcode}")
    private String topic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    @Qualifier(value="qrcodeSyncThreadPool")
    private ExecutorService executorService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ContactWayClient contactWayClient;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactLogMapper weworkContactLogMapper;
    @Autowired
    private AddFriendConfigMapper addFriendConfigMapper;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;

    @Override
    public AddFriendConfig defaultConfig(Long bizId, String corpId, String weworkUserNum, Long operatorId) {
        AddFriendConfig addFriendConfig = new AddFriendConfig();
        addFriendConfig.setBizId(bizId);
        addFriendConfig.setCorpId(corpId);
        addFriendConfig.setWeworkUserNum(weworkUserNum);
        addFriendConfig.setSkipVerifyCurrentEnabled(null);
        addFriendConfig.setSkipVerifyIsEnabled(Integer.valueOf(1));
        addFriendConfig.setSkipVerifyType(Integer.valueOf(1));
        addFriendConfig.setSkipVerifyStartTime(null);
        addFriendConfig.setSkipVerifyEndTime(null);
        addFriendConfig.setSkipVerifyIsLimited(Integer.valueOf(0));
        addFriendConfig.setSkipVerifyLimit(Integer.valueOf(0));
        addFriendConfig.setRemarkIsEnabled(Integer.valueOf(0));
        addFriendConfig.setRemarkIsSpecified(Integer.valueOf(1));
        addFriendConfig.setRemarkUseOther(Integer.valueOf(0));
        addFriendConfig.setRemarkFormat("");
        addFriendConfig.setAttachTagIsEnabled(Integer.valueOf(0));
        addFriendConfig.setAttachTagIsSpecified(Integer.valueOf(1));
        addFriendConfig.setAttachTagUseOther(Integer.valueOf(0));
        addFriendConfig.setWelcomeIsEnabled(Integer.valueOf(0));
        addFriendConfig.setWelcomeIsSpecified(Integer.valueOf(1));
        addFriendConfig.setWelcomeUseOther(Integer.valueOf(0));
        addFriendConfig.setWelcomeJson(null);
        addFriendConfig.setCreateBy(operatorId);
        addFriendConfig.setCreateTime(new Date());
        addFriendConfig.setUpdateBy(operatorId);
        addFriendConfig.setUpdateTime(new Date());
        addFriendConfig.setQrcodeState("AFC_$_" + this.idGen.getNum());
        addFriendConfig.setIsSync(Integer.valueOf(0));
        addFriendConfig.setErrorCode(Integer.valueOf(-999));
        addFriendConfig.setErrorMsg("\u51c6\u5907\u521d\u59cb\u5316\u4e8c\u7ef4\u7801..");
        return addFriendConfig;
    }

    @Override
    public void startAll() {
        log.info("\u542f\u52a8\u540c\u6b65\u4efb\u52a1");
        List corpList = this.weworkCorpMapper.selectAllAuthed();
        if (CollectionUtils.isEmpty((Collection)corpList)) {
            log.info("\u5f53\u524d\u6ca1\u6709\u6388\u6743\u8fc7\u7684\u4f01\u4e1a\u4fe1\u606f\uff0c\u4e0d\u542f\u52a8\u540c\u6b65\u4efb\u52a1\u3002");
            return;
        }
        for (WeworkCorp corp : corpList) {
            this.start(corp);
        }
    }

    private void start(WeworkCorp corp) {
        Long bizId = corp.getBizId();
        String corpId = corp.getCorpId();
        log.debug("\u542f\u52a8\u540c\u6b65\u4efb\u52a1, bizId:{}, corpId:{}", (Object)bizId, (Object)corpId);
        List list = this.weworkUserMapper.queryByCorpId(corpId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.warn("\u4f01\u4e1a\u5fae\u4fe1\u6210\u5458\u5217\u8868\u4e3a\u7a7a, corpId:{}", (Object)corpId);
            return;
        }
        for (WeworkUser u : list) {
            String weworkUserId = u.getWeworkUserId();
            String weworkUserNum = u.getNum();
            WeworkActiveStatusEnum status = WeworkActiveStatusEnum.get((Integer)u.getStatus());
            if (status != WeworkActiveStatusEnum.ALREADY_ACTIVE) {
                log.warn("\u6210\u5458\u672a\u6fc0\u6d3b, {} - {}, status:{}", new Object[]{corpId, weworkUserId, status});
                if (u.getEnableQrcode() != 1) continue;
                u.setEnableQrcode(Integer.valueOf(0));
                this.weworkUserMapper.updateByPrimaryKeySelective((Object)u);
                continue;
            }
            SyncQrcodeDto dto = new SyncQrcodeDto();
            dto.setBizId(bizId);
            dto.setCorpId(corpId);
            dto.setWeworkUserId(weworkUserId);
            dto.setWeworkUserNum(weworkUserNum);
            this.enqueue(dto);
        }
    }

    @Override
    public void enqueue(SyncQrcodeDto params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((params.getCorpId() != null ? 1 : 0) != 0, (Object)"corpId is null");
        Preconditions.checkArgument((params.getWeworkUserId() != null ? 1 : 0) != 0, (Object)"weworkUserNum is null");
        Preconditions.checkArgument((params.getWeworkUserNum() != null ? 1 : 0) != 0, (Object)"weworkUserId is null");
        log.debug("\u52a0\u5165\u961f\u5217. {} - {}", (Object)params.getCorpId(), (Object)params.getWeworkUserId());
        String key = params.getWeworkUserNum();
        String json = JacksonUtil.obj2Str((Object)params);
        try {
            this.kafkaTemplate.send(this.topic, (Object)key, (Object)json);
        }
        catch (Exception e) {
            log.error("send kafka failed: {}\n", (Object)json, (Object)e);
        }
    }

    @Override
    public void sync(SyncQrcodeDto params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((params.getCorpId() != null ? 1 : 0) != 0, (Object)"corpId is null");
        Preconditions.checkArgument((params.getWeworkUserId() != null ? 1 : 0) != 0, (Object)"weworkUserNum is null");
        Preconditions.checkArgument((params.getWeworkUserNum() != null ? 1 : 0) != 0, (Object)"weworkUserId is null");
        Long bizId = params.getBizId();
        String corpId = params.getCorpId();
        String weworkUserId = params.getWeworkUserId();
        String weworkUserNum = params.getWeworkUserNum();
        log.debug("\u540c\u6b65\u65b0\u597d\u53cb\u914d\u7f6e. {} - {}", (Object)corpId, (Object)weworkUserId);
        AddFriendConfig addFriendConfig = this.getOrCreate(bizId, corpId, weworkUserId, weworkUserNum);
        boolean skipVerify = this.isSkipVerify(addFriendConfig);
        if (StringUtils.isNotBlank((CharSequence)addFriendConfig.getQrConfigId()) && addFriendConfig.getSkipVerifyCurrentEnabled() != null) {
            boolean currentSkipVerify;
            boolean bl = currentSkipVerify = addFriendConfig.getSkipVerifyCurrentEnabled() != null && addFriendConfig.getSkipVerifyCurrentEnabled() != 0;
            if (skipVerify == currentSkipVerify) {
                log.debug("\u4e8c\u7ef4\u7801\u53c2\u6570\u65e0\u53d8\u52a8\uff0c\u4e0d\u9700\u8981\u4fee\u6539\u3002{} - {}", (Object)corpId, (Object)weworkUserId);
                addFriendConfig.setLastSyncTime(new Date());
                this.addFriendConfigMapper.updateByPrimaryKey((Object)addFriendConfig);
                return;
            }
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
        if (addFriendConfig.getErrorCode() != null && weworkUser.getEnableQrcode() != 1) {
            log.info("add friend qrcode config not update last time config error weworkUserNum: {}", (Object)weworkUserNum);
            return;
        }
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId:{}", (Object)corpId);
            addFriendConfig.setIsSync(Integer.valueOf(0));
            addFriendConfig.setErrorCode(Integer.valueOf(-1));
            addFriendConfig.setErrorMsg("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
            addFriendConfig.setLastSyncTime(new Date());
            this.addFriendConfigMapper.updateByPrimaryKey((Object)addFriendConfig);
            return;
        }
        this.executorService.submit(() -> this.refreshQrcode(corpId, weworkUserId, skipVerify, addFriendConfig));
    }

    @Override
    public void syncRetryContactWay(Long bizId) {
        List list = this.addFriendConfigMapper.queryFailList(bizId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (AddFriendConfig addFriendConfig : list) {
            if (addFriendConfig.getErrorCode() == -999) continue;
            boolean skipVerify = this.isSkipVerify(addFriendConfig);
            this.executorService.submit(() -> {
                String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(addFriendConfig.getWeworkUserNum());
                this.refreshQrcode(addFriendConfig.getCorpId(), weworkUserId, skipVerify, addFriendConfig);
            });
        }
    }

    private AddFriendConfig getOrCreate(Long bizId, String corpId, String weworkUserId, String weworkUserNum) {
        AddFriendConfig addFriendConfig = this.addFriendConfigMapper.getByWeworkUserUniqIndex(corpId, weworkUserNum);
        if (addFriendConfig == null) {
            log.info("\u65b0\u597d\u53cb\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u81ea\u52a8\u521b\u5efa. {} - {}", (Object)corpId, (Object)weworkUserId);
            addFriendConfig = this.defaultConfig(bizId, corpId, weworkUserNum, -1L);
            this.addFriendConfigMapper.insertSelective((Object)addFriendConfig);
        }
        return addFriendConfig;
    }

    private void refreshQrcode(String corpId, String weworkUserId, boolean skipVerify, AddFriendConfig addFriendConfig) {
        try {
            if (StringUtils.isBlank((CharSequence)addFriendConfig.getQrConfigId())) {
                log.info("\u521b\u5efa\u4e8c\u7ef4\u7801: {} - {}, skipVerify:{}", new Object[]{corpId, weworkUserId, skipVerify});
                this.saveQrcode(weworkUserId, skipVerify, addFriendConfig);
                log.info("\u4e8c\u7ef4\u7801\u521b\u5efa\u6210\u529f: {} - {}, configId:{}, qrcode:{}", (Object)addFriendConfig.getQrConfigId(), (Object)addFriendConfig.getQrcodeUrl());
            } else {
                log.info("\u66f4\u65b0\u4e8c\u7ef4\u7801: {} - {}, skipVerify:{}", new Object[]{corpId, weworkUserId, skipVerify});
                this.updateQrcode(weworkUserId, skipVerify, addFriendConfig);
                log.info("\u4e8c\u7ef4\u7801\u66f4\u65b0\u6210\u529f: {} - {}", (Object)corpId, (Object)weworkUserId);
            }
            addFriendConfig.setSkipVerifyCurrentEnabled(Integer.valueOf(skipVerify ? 1 : 0));
            addFriendConfig.setIsSync(Integer.valueOf(1));
            addFriendConfig.setErrorCode(Integer.valueOf(0));
            addFriendConfig.setErrorMsg(null);
        }
        catch (WeworkException e) {
            log.error("\u914d\u7f6e\u4e8c\u7ef4\u7801\u5931\u8d25, {}, {} - {}", new Object[]{e.getMessage(), corpId, weworkUserId});
            addFriendConfig.setIsSync(Integer.valueOf(0));
            addFriendConfig.setErrorCode(e.getErrorCode());
            addFriendConfig.setErrorMsg(e.getErrorMsg());
            this.weworkUserMapper.updateUserQrcode(addFriendConfig.getBizId(), weworkUserId, 0);
        }
        catch (Exception e) {
            log.error("\u914d\u7f6e\u4e8c\u7ef4\u7801\u5931\u8d25, {} - {}", new Object[]{corpId, weworkUserId, e});
            addFriendConfig.setIsSync(Integer.valueOf(0));
            addFriendConfig.setErrorCode(Integer.valueOf(999));
            addFriendConfig.setErrorMsg("\u914d\u7f6e\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u3002");
        }
        addFriendConfig.setLastSyncTime(new Date());
        this.addFriendConfigMapper.updateByPrimaryKey((Object)addFriendConfig);
    }

    public void saveQrcode(String weworkUserId, boolean skipVerify, AddFriendConfig addFriendConfig) {
        ContactWay params = new ContactWay();
        params.setType(Integer.valueOf(1));
        params.setScene(Integer.valueOf(2));
        params.setState(addFriendConfig.getQrcodeState());
        params.setUserIds(Collections.singletonList(weworkUserId));
        params.setSkipVerify(skipVerify);
        ConfigIdResp resp = this.contactWayClient.create(addFriendConfig.getCorpId(), params);
        addFriendConfig.setQrConfigId(resp.getConfigId());
        addFriendConfig.setQrcodeUrl(resp.getQrCode());
    }

    public void updateQrcode(String weworkUserId, boolean skipVerify, AddFriendConfig addFriendConfig) {
        ContactWay params = new ContactWay();
        params.setConfigId(addFriendConfig.getQrConfigId());
        params.setType(Integer.valueOf(1));
        params.setScene(Integer.valueOf(2));
        params.setState(addFriendConfig.getQrcodeState());
        params.setSkipVerify(skipVerify);
        this.contactWayClient.update(addFriendConfig.getCorpId(), params);
    }

    private boolean isSkipVerify(AddFriendConfig addFriendConfig) {
        if (addFriendConfig.getSkipVerifyIsEnabled() == 0) {
            return false;
        }
        if (this.isRestTime(addFriendConfig)) {
            return false;
        }
        return !this.isLimited(addFriendConfig);
    }

    private boolean isLimited(AddFriendConfig addFriendConfig) {
        Date endTime;
        Date startTime;
        String state;
        String weworkUserNum;
        if (addFriendConfig.getSkipVerifyIsLimited() == null || addFriendConfig.getSkipVerifyIsLimited() == 0) {
            return false;
        }
        if (addFriendConfig.getSkipVerifyLimit() == null || addFriendConfig.getSkipVerifyLimit() <= 0) {
            return false;
        }
        String corpId = addFriendConfig.getCorpId();
        int count = this.weworkContactLogMapper.getAddCountByWeworkUserState(corpId, weworkUserNum = addFriendConfig.getWeworkUserNum(), state = addFriendConfig.getQrcodeState(), startTime = DateUtil.getTodayStartTime(), endTime = DateUtil.getDate());
        return count >= addFriendConfig.getSkipVerifyLimit();
    }

    private boolean isRestTime(AddFriendConfig addFriendConfig) {
        if (addFriendConfig.getSkipVerifyType() == 1) {
            return false;
        }
        String begin = addFriendConfig.getSkipVerifyStartTime();
        String end = addFriendConfig.getSkipVerifyEndTime();
        String now = this.formater.format(new Date());
        return !this.between(now, begin, end);
    }

    private boolean between(String now, String begin, String end) {
        int cp = begin.compareTo(end);
        if (cp > 0) {
            return now.compareTo(begin) >= 0 || now.compareTo(end) <= 0;
        }
        return now.compareTo(begin) >= 0 && now.compareTo(end) <= 0;
    }
}

