/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.acquisition.service.impl;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.CustomerAcquisitionFkTypeEnum;
import com.kuaike.scrm.common.service.ScrmCustomerAcquisitionService;
import com.kuaike.scrm.common.service.dto.req.customeracquisition.CreateShareRecordReq;
import com.kuaike.scrm.common.service.dto.req.customeracquisition.SetSharePlanReq;
import com.kuaike.scrm.common.service.dto.req.customeracquisition.UpdateSharePlanReq;
import com.kuaike.scrm.common.service.dto.resp.customeracquisition.CreateShareRecordResp;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionLink;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionSharePlan;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionShareRecord;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionLinkMapper;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionSharePlanMapper;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionShareRecordMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScrmCustomerAcquisitionServiceImpl
implements ScrmCustomerAcquisitionService {
    private static final Logger log = LoggerFactory.getLogger(ScrmCustomerAcquisitionServiceImpl.class);
    @Resource
    private IdGen idGen;
    @Resource
    private WeworkCustomerAcquisitionLinkMapper weworkCustomerAcquisitionLinkMapper;
    @Resource
    private WeworkCustomerAcquisitionShareRecordMapper weworkCustomerAcquisitionShareRecordMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private WeworkCustomerAcquisitionSharePlanMapper weworkCustomerAcquisitionSharePlanMapper;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}")
    private String root;

    @Transactional(rollbackFor={Exception.class})
    public CreateShareRecordResp createShareRecord(CreateShareRecordReq req) {
        log.info("createShareRecord,req:{}", (Object)req);
        req.validate();
        CreateShareRecordResp resp = new CreateShareRecordResp();
        WeworkCustomerAcquisitionLink select = new WeworkCustomerAcquisitionLink();
        select.setNum(req.getCustomerAcquisitionLinkNum());
        select.setIsDeleted(Integer.valueOf(0));
        WeworkCustomerAcquisitionLink weworkCustomerAcquisitionLink = (WeworkCustomerAcquisitionLink)this.weworkCustomerAcquisitionLinkMapper.selectOne((Object)select);
        Preconditions.checkArgument((weworkCustomerAcquisitionLink != null ? 1 : 0) != 0, (Object)"\u83b7\u5ba2\u94fe\u63a5\u4e0d\u5b58\u5728");
        resp.setLinkId(weworkCustomerAcquisitionLink.getId());
        Long sharePlanId = this.selectSharePlanId(weworkCustomerAcquisitionLink.getBizId(), weworkCustomerAcquisitionLink.getId(), req);
        Date now = new Date();
        WeworkCustomerAcquisitionShareRecord insert = new WeworkCustomerAcquisitionShareRecord();
        insert.setNum(this.idGen.getNum());
        insert.setBizId(weworkCustomerAcquisitionLink.getBizId());
        insert.setCustomerAcquisitionLinkId(weworkCustomerAcquisitionLink.getId());
        insert.setFkId(req.getFkId());
        insert.setFkType(req.getFkType());
        insert.setFkDetailId(req.getFkDetailId());
        insert.setMobile(req.getMobile());
        insert.setWeworkUserId(req.getWeworkUserId());
        insert.setContactId(req.getContactId());
        insert.setCreateTime(now);
        insert.setUpdateTime(now);
        insert.setCustomerAcquisitionSharePlanId(sharePlanId);
        log.info("createShareRecord,insert share plan:{}", (Object)insert);
        this.weworkCustomerAcquisitionShareRecordMapper.insertSelective((Object)insert);
        resp.setShareRecordNum(insert.getNum());
        resp.setShareRecordId(insert.getId());
        resp.setUrl(this.root + "/ca/" + insert.getNum());
        return resp;
    }

    private Long selectSharePlanId(Long bizId, Long linkId, CreateShareRecordReq req) {
        WeworkCustomerAcquisitionSharePlan sharePlan;
        Long sharePlanId = -1L;
        Long channelId = null;
        if (StringUtils.isNotBlank((CharSequence)req.getChannelNum())) {
            Channel select = new Channel();
            select.setNum(req.getChannelNum());
            Channel channel = (Channel)this.channelMapper.selectOne((Object)select);
            if (channel != null) {
                channelId = channel.getId();
            }
        }
        if ((sharePlan = this.weworkCustomerAcquisitionSharePlanMapper.selectWhenCreateRecord(bizId, req.getFkType(), req.getFkId(), linkId, req.getFkDetailId(), channelId)) != null) {
            log.info("selectSharePlanId,sharePlan:{}", (Object)sharePlan.getId());
            sharePlanId = sharePlan.getId();
        }
        return sharePlanId;
    }

    public void updateSharePlan(UpdateSharePlanReq req) {
        log.info("updateSharePlanWelcomeConfig,req:{}", (Object)req);
        req.validate();
        if (CustomerAcquisitionFkTypeEnum.AD.getType() == req.getFkType().intValue()) {
            this.weworkCustomerAcquisitionSharePlanMapper.updateWelcomeConfigByAllocRuleNum(req.getWeworkAllocRuleNum(), req.getAddFriendRemark(), req.getWelcomeContent(), req.getTagIds(), req.getIsAddFriendConfigEnable());
        }
    }

    public void setSharePlan(List<SetSharePlanReq> reqList) {
        log.info("setSharePlanWelcomeConfig,reqList:{}", reqList);
        if (CollectionUtils.isEmpty(reqList)) {
            return;
        }
        HashSet<String> linkNums = new HashSet<String>();
        HashSet<String> channelNums = new HashSet<String>();
        for (SetSharePlanReq req : reqList) {
            req.validate();
            linkNums.add(req.getLinkNum());
            channelNums.add(req.getChannelNum());
        }
        List acquisitionLinks = this.weworkCustomerAcquisitionLinkMapper.selectByNums(linkNums);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)acquisitionLinks), (Object)"\u83b7\u5ba2\u94fe\u63a5\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Map<String, Long> linkNumMap = acquisitionLinks.stream().collect(Collectors.toMap(WeworkCustomerAcquisitionLink::getNum, WeworkCustomerAcquisitionLink::getId));
        Map<Object, Object> channelNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty(channelNums)) {
            List channels = this.channelMapper.selectByNums(channelNums);
            channelNumMap = channels.stream().collect(Collectors.toMap(Channel::getNum, Channel::getId));
        }
        Date now = new Date();
        Long bizId = ((WeworkCustomerAcquisitionLink)acquisitionLinks.get(0)).getBizId();
        ArrayList<WeworkCustomerAcquisitionSharePlan> insertList = new ArrayList<WeworkCustomerAcquisitionSharePlan>();
        for (SetSharePlanReq req : reqList) {
            Long channelId;
            Long linkId = linkNumMap.get(req.getLinkNum());
            if (linkId == null) continue;
            WeworkCustomerAcquisitionSharePlan insert = new WeworkCustomerAcquisitionSharePlan();
            insert.setBizId(bizId);
            insert.setNum(this.idGen.getNum());
            insert.setCustomerAcquisitionLinkId(linkId);
            insert.setFkType(req.getFkType());
            insert.setFkId(req.getFkId());
            insert.setAddFriendRemark(req.getAddFriendRemark());
            insert.setWelcomeContent(req.getWelcomeContent());
            insert.setTagIds(req.getTagIds());
            insert.setIsAddFriendConfigEnable(req.getIsAddFriendConfigEnable());
            insert.setWeworkAllocRuleNum(req.getWeworkAllocRuleNum());
            if (StringUtils.isNotBlank((CharSequence)req.getChannelNum()) && (channelId = (Long)channelNumMap.get(req.getChannelNum())) != null) {
                insert.setChannelId(channelId);
            }
            insert.setCreateTime(now);
            insert.setUpdateTime(now);
            insert.setIsDeleted(Integer.valueOf(0));
            log.info("setSharePlanWelcomeConfig,insert:{}", (Object)insert);
            insertList.add(insert);
        }
        if (CollectionUtils.isNotEmpty(insertList)) {
            this.weworkCustomerAcquisitionSharePlanMapper.batchInsert(insertList);
        }
    }
}

