/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.dal.call.mapper;

import com.kuaike.scrm.dal.call.dto.CallQueryById;
import com.kuaike.scrm.dal.call.dto.CallRecordQueryParams;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.dal.call.entity.CallRecordCriteria;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.common.Mapper;

public interface CallRecordMapper
extends Mapper<CallRecord> {
    public int deleteByFilter(CallRecordCriteria var1);

    public List<CallRecord> queryList(CallRecordQueryParams var1);

    public int queryCount(CallRecordQueryParams var1);

    public List<CallRecord> calledList(CallRecordQueryParams var1);

    public List<CallRecord> callCount(CallRecordQueryParams var1);

    public List<CallRecord> queryLatestRecord(CallRecordQueryParams var1);

    public List<CallRecord> batchQueryCallCount(CallRecordQueryParams var1);

    public CallRecord lastCall(CallRecordQueryParams var1);

    public List<CallRecord> selectDataByTaskDetailId(CallQueryById var1);

    @Select(value={"SELECT distinct a.user_id userId,a.node_id nodeId\n    FROM call_record a\n    where a.biz_id = #{bizId}\n    and a.create_time >= #{startDate}\n    and a.create_time <= #{endDate}"})
    public List<CallRecord> userList(CallRecordQueryParams var1);

    @Select(value={"SELECT distinct a.biz_id bizId,a.corp_id corpId\n    FROM call_record a\n    where a.create_time >= #{startDate}\n    and a.create_time <= #{endDate}"})
    public List<CallRecord> bizList(CallRecordQueryParams var1);

    @Select(value={"SELECT ifnull( sum( call_duration ), 0 ) \n    FROM call_record a\n    where a.biz_id = #{bizId}\n    and a.user_id = #{userId}\n    and a.type = #{type}\n    and a.user_type = #{userType}\n    and a.status = 1\n    and a.create_time >= #{startDate}\n    and a.create_time <= #{endDate}"})
    public int callDuration(CallRecordQueryParams var1);

    @Select(value={"SELECT ifnull( sum( call_duration ), 0 ) \n    FROM ( SELECT ceiling( call_duration / 60 ) call_duration FROM call_record a     where a.biz_id = #{bizId}\n    and a.user_id = #{userId}\n    and a.type = #{type}\n    and a.user_type = #{userType}\n    and a.status = 1\n    and a.create_time >= #{startDate}\n    and a.create_time <= #{endDate} ) tmp"})
    public int billCallDuration(CallRecordQueryParams var1);

    public List<CallRecord> queryCalledList(CallRecordQueryParams var1);

    public Integer getStatusByCallDetailId(@Param(value="bizId") Long var1, @Param(value="callDetailId") Long var2, @Param(value="mobile") String var3);
}

