/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ObjectIdUtil {
    private static final Logger log = LoggerFactory.getLogger(ObjectIdUtil.class);
    private static final String DATE_FORMAT = "yyyyMMdd";
    private long sequence;
    private static final int MAX_SEQUENCE = 99999;
    @Value(value="${IdGen.serviceId}")
    private Long serviceId;
    @Value(value="${IdGen.machineId}")
    private Long machineId;
    @Value(value="${spring.redis.key.prefix}")
    private String redisPrefix;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public ObjectIdUtil() {
    }

    public ObjectIdUtil(Long serviceId, Long machineId) {
        this.serviceId = serviceId;
        this.machineId = machineId;
    }

    private String getMachineCode() {
        StringBuilder str = new StringBuilder();
        str.append(this.serviceId).append(this.machineId);
        return StringUtils.right((String)str.toString(), (int)2);
    }

    public synchronized String generateId() {
        String timestampStr = new SimpleDateFormat(DATE_FORMAT).format(new Date());
        this.sequence = this.redisTemplate.opsForValue().increment((Object)this.getKey()) % 100000L;
        String sequenceStr = StringUtils.right((String)String.format("%05d", this.sequence), (int)5);
        String id = timestampStr + this.getMachineCode() + sequenceStr;
        return id;
    }

    private String getKey() {
        return this.redisPrefix + "today:sequence";
    }
}

