/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class MobileUtils {
    private static final int MOBILE_LENGTH = 11;
    private static final int QQ_LENGTH = 11;
    private static final int WECHAT_LENGTH = 11;

    private MobileUtils() {
    }

    public boolean isQQ(String qq) {
        if (StringUtils.isBlank((CharSequence)qq)) {
            return false;
        }
        return qq.matches("^[1-9][0-9]{4,10}$");
    }

    public boolean isWechat(String wechat) {
        if (StringUtils.isBlank((CharSequence)wechat)) {
            return false;
        }
        if (wechat.length() < 6 || wechat.length() > 20) {
            return false;
        }
        if (!wechat.matches("^[a-zA-Z0-9_-]+$")) {
            return false;
        }
        return !wechat.matches("^[0-9]+$");
    }

    public static boolean isPhone(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return false;
        }
        String regex = "^1[0-9]{10}$";
        if (phone.length() == 11) {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(phone);
            return m.matches();
        }
        return false;
    }

    public static List<String> encryptMobile(List<String> mobiles) {
        if (CollectionUtils.isEmpty(mobiles)) {
            return mobiles;
        }
        for (int i = 0; i < mobiles.size(); ++i) {
            String mobile = mobiles.get(i);
            if (mobile.length() < 4) continue;
            char[] chars = mobile.toCharArray();
            for (int j = 0; j < 4; ++j) {
                if (chars.length <= j + 3) continue;
                chars[j + 3] = 42;
            }
            mobile = new String(chars);
            mobiles.set(i, mobile);
        }
        return mobiles;
    }

    public static String encryptMobile(String mobile) {
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            return mobile;
        }
        if (mobile.length() < 4) {
            return mobile;
        }
        char[] chars = mobile.toCharArray();
        for (int j = 0; j < 4; ++j) {
            if (chars.length <= j + 3) continue;
            chars[j + 3] = 42;
        }
        mobile = new String(chars);
        return mobile;
    }
}

