/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import cn.kinyun.customer.center.dto.req.AttachAllTag;
import cn.kinyun.customer.center.service.CcCustomerTagService;
import cn.kinyun.wework.sdk.api.external.ExternalTagClient;
import cn.kinyun.wework.sdk.entity.external.croptag.AddCorpTagParams;
import cn.kinyun.wework.sdk.entity.external.croptag.AddCorpTagResp;
import cn.kinyun.wework.sdk.entity.external.croptag.CorpTag;
import cn.kinyun.wework.sdk.entity.external.croptag.CorpTagGroup;
import cn.kinyun.wework.sdk.entity.external.croptag.MarkTagParams;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.WeworkTagMsg;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.service.ScrmTagService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworktag.entity.WeworkTag;
import com.kuaike.scrm.dal.weworktag.entity.WeworkTagGroup;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagGroupMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScrmTagServiceImpl
implements ScrmTagService {
    private static final Logger log = LoggerFactory.getLogger(ScrmTagServiceImpl.class);
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private ExternalTagClient externalTagClient;
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkTagGroupMapper weworkTagGroupMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private SettingService settingService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private CcCustomerTagService ccCustomerTagService;
    private String SOURCE = "scrm";
    private final int size = Runtime.getRuntime().availableProcessors();
    private ExecutorService executeService = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(500), new NamedThreadFactory("contactTagSync"), new ThreadPoolExecutor.CallerRunsPolicy());

    public Map<String, String> getNameByIds(String corpId, Collection<String> ids) {
        log.info("get tag name by ids, operatorId:{}, ids:{}", (Object)LoginUtils.getCurrentUserId(), ids);
        if (CollectionUtils.isEmpty(ids)) {
            log.warn("ids is empty");
            return Collections.emptyMap();
        }
        return this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(corpId, ids);
    }

    @Transactional
    public String getTagIdByNames(Long bizId, String groupName, String tagName) {
        log.info("getTagIdByNames: bizId:{}, groupName:{}, tagName:{}", new Object[]{bizId, groupName, tagName});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u5546\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)groupName), (Object)"\u6807\u7b7e\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tagName), (Object)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String corpId = this.businessCustomerMapper.getCorpIdById(bizId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"\u6839\u636e\u5546\u6237Id\u65e0\u6cd5\u67e5\u8be2\u5230corpId");
        String tagId = this.weworkTagMapper.queryByGroupNameAndTagName(bizId, groupName, tagName);
        log.info("getTagIdByNames: bizId:{}, groupName:{}, tagName:{}, tagId:{}", new Object[]{bizId, groupName, tagName, tagId});
        if (StringUtils.isNotBlank((CharSequence)tagId)) {
            return tagId;
        }
        try {
            CorpTagGroup tagGroup = this.addTagToWework(corpId, groupName, tagName);
            log.info("getTagIdByNames: bizId:{}, tagGroup:{}", (Object)bizId, (Object)tagGroup);
            this.saveTagGroup(bizId, corpId, -1L, tagGroup);
            CorpTag corpTag = (CorpTag)tagGroup.getTagList().get(0);
            this.saveTag(bizId, corpId, -1L, tagGroup.getGroupId(), corpTag);
            return corpTag.getId();
        }
        catch (WeworkException e) {
            this.handleTagException(e);
            return "";
        }
    }

    private CorpTagGroup addTagToWework(String corpId, String groupName, String tagName) {
        AddCorpTagParams addCorpTagParams = new AddCorpTagParams();
        addCorpTagParams.setGroupName(groupName);
        ArrayList tagList = Lists.newArrayList();
        CorpTag corpTag = new CorpTag();
        corpTag.setName(tagName);
        tagList.add(corpTag);
        addCorpTagParams.setTagList((List)tagList);
        AddCorpTagResp add = this.externalTagClient.add(corpId, addCorpTagParams);
        return add.getTagGroup();
    }

    public void saveTagGroup(Long bizId, String corpId, Long userId, CorpTagGroup tagGroup) {
        Date curTime = new Date();
        WeworkTagGroup weworkTagGroup = new WeworkTagGroup();
        weworkTagGroup.setNum(this.idGen.getNum());
        weworkTagGroup.setBizId(bizId);
        weworkTagGroup.setCorpId(corpId);
        weworkTagGroup.setAddTime(new Date(tagGroup.getCreateTime() * 1000L));
        weworkTagGroup.setGroupId(tagGroup.getGroupId());
        weworkTagGroup.setGroupName(tagGroup.getGroupName());
        weworkTagGroup.setOrder(tagGroup.getOrder());
        weworkTagGroup.setCreateBy(userId);
        weworkTagGroup.setCreateTime(curTime);
        weworkTagGroup.setUpdateBy(userId);
        weworkTagGroup.setUpdateTime(curTime);
        weworkTagGroup.setIsDeleted(Integer.valueOf(0));
        this.weworkTagGroupMapper.batchInsert((Collection)Lists.newArrayList((Object[])new WeworkTagGroup[]{weworkTagGroup}));
    }

    public void saveTag(Long bizId, String corpId, Long userId, String tagGroupId, CorpTag corpTag) {
        Date curDate = new Date();
        WeworkTag weworkTag = new WeworkTag();
        String tagNum = this.idGen.getNum();
        weworkTag.setNum(tagNum);
        weworkTag.setBizId(bizId);
        weworkTag.setCorpId(corpId);
        weworkTag.setAddTime(new Date(corpTag.getCreateTime() * 1000L));
        weworkTag.setGroupId(tagGroupId);
        weworkTag.setTagId(corpTag.getId());
        weworkTag.setName(corpTag.getName());
        weworkTag.setOrder(corpTag.getOrder());
        weworkTag.setIsDeleted(Integer.valueOf(0));
        weworkTag.setCreateBy(userId);
        weworkTag.setUpdateBy(userId);
        weworkTag.setCreateTime(curDate);
        weworkTag.setUpdateTime(curDate);
        this.weworkTagMapper.batchInsert((Collection)Lists.newArrayList((Object[])new WeworkTag[]{weworkTag}));
    }

    private void handleTagException(WeworkException weworkException) {
        if (weworkException.getErrorCode() == 40071) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u76f8\u540c\u6807\u7b7e\u7ec4\u540d\u6216\u8005\u6807\u7b7e\u540d\uff0c \u8bf7\u540c\u6b65\u4f01\u5fae\u6807\u7b7e\u540e\u518d\u64cd\u4f5c");
        }
        if (weworkException.getErrorCode() == 81011) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6807\u7b7e\u4e0d\u662f\u5f53\u524d\u5e94\u7528\u521b\u5efa\u7684\uff0c\u65e0\u6743\u9650\u64cd\u4f5c\u6807\u7b7e");
        }
        if (weworkException.getErrorCode() == 40068) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9009\u62e9\u7684\u6807\u7b7e\u4e2d\u6709\u5df2\u7ecf\u88ab\u5220\u9664\u7684\uff0c\u8bf7\u540c\u6b65\u4f01\u5fae\u6807\u7b7e\u540e\u91cd\u65b0\u5c1d\u8bd5");
        }
        throw weworkException;
    }

    public void attachTagByContactId(Long bizId, String contactId, List<String> addTags, List<String> rmTags) {
        if (bizId == null || StringUtils.isBlank((CharSequence)contactId)) {
            return;
        }
        String corpId = this.businessCustomerMapper.getCorpIdById(bizId);
        List list = this.weworkContactRelationMapper.queryListByContactId(corpId, contactId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List weworkUserIds = list.stream().map(it -> it.getWeworkUserId()).collect(Collectors.toList());
        for (String weworkUserId : weworkUserIds) {
            MarkTagParams req = new MarkTagParams();
            req.setUserId(weworkUserId);
            req.setExternalUserId(contactId);
            req.setAddTagIds(addTags);
            req.setRemoveTagIds(rmTags);
            try {
                this.externalTagClient.markTag(corpId, req);
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u5ba2\u6237\u4f01\u4e1a\u6807\u7b7e\u5931\u8d25, {}, params:{}", (Object)e.getMessage(), (Object)req);
            }
        }
    }

    public Map<String, List<String>> getTagIdsByContact(Long bizId, List<String> contactIds) {
        log.info("getTagIdsByContact bizId: {}, contactIds: {}", (Object)bizId, contactIds);
        String corpId = this.businessCustomerMapper.getCorpIdById(bizId);
        List contactTags = this.weworkContactTagMapper.queryByCorpIdAndContactIds(corpId, contactIds);
        Map<String, List<String>> contactTagMaps = new HashMap<String, List<String>>();
        if (CollectionUtils.isNotEmpty((Collection)contactTags)) {
            contactTagMaps = contactTags.stream().collect(Collectors.groupingBy(WeworkContactTag::getContactId, Collectors.mapping(WeworkContactTag::getTagId, Collectors.toList())));
        }
        return contactTagMaps;
    }

    public void contactTagSync(WeworkTagMsg msg) {
        Long bizId = msg.getBizId();
        String contactId = msg.getContactId();
        Set tagIds = msg.getTagIds();
        log.info("contactTagSync bizId: {}, contactId: {}, tagIds: {}", new Object[]{bizId, contactId, tagIds});
        if (StringUtils.isEmpty((CharSequence)contactId)) {
            return;
        }
        String settingValue = this.settingService.getSettingDetail(bizId, SettingEnum.TAG_SYNC.getName());
        if (StringUtils.isEmpty((CharSequence)settingValue) || settingValue.equals("0")) {
            log.info("contactTagSync \u4f01\u4e1a\u4e3a\u5f00\u901a\u6807\u7b7e\u540c\u6b65\uff0c bizId: {}", (Object)bizId);
            return;
        }
        String corpId = msg.getCorpId();
        if (StringUtils.isEmpty((CharSequence)corpId)) {
            corpId = this.businessCustomerMapper.getCorpIdById(bizId);
        }
        List relationList = this.weworkContactRelationMapper.queryListByContactIdIncloudZoomFans(corpId, contactId);
        List weworkUserIds = relationList.stream().map(WeworkContactRelation::getWeworkUserId).collect(Collectors.toList());
        Map weworkUserNumMap = this.weworkUserMapper.queryUserNumIdMap(corpId, weworkUserIds);
        log.info("contactTagSync weworkUserIds: {}", weworkUserIds);
        List contactTags = this.weworkContactTagMapper.queryByCorpIdAndContactIdsFilterWeworkUserIds(corpId, (List)Lists.newArrayList((Object[])new String[]{contactId}));
        Map userContactMaps = contactTags.stream().collect(Collectors.groupingBy(WeworkContactTag::getWeworkUserId, Collectors.mapping(WeworkContactTag::getTagId, Collectors.toSet())));
        log.info("contactTagSync userContactMaps: {}", userContactMaps);
        WeworkContact contact = this.weworkContactMapper.queryContactByContactId(corpId, contactId);
        String customerNum = contact.getCustomerNum();
        log.info("contactTagSync get contact: {}, customerNum: {}", (Object)contactId, (Object)customerNum);
        Set<String> addTagIds = this.distinctTagIds(tagIds);
        for (WeworkContactRelation relation : relationList) {
            Set curTagIds = userContactMaps.get(relation.getWeworkUserId());
            Sets.SetView rmTagIds = new HashSet();
            if (curTagIds != null) {
                rmTagIds = Sets.difference(curTagIds, addTagIds);
            }
            log.info("contactTagSync contactId: {}, addTagIds: {}, rmTagIds: {}", new Object[]{contactId, addTagIds, rmTagIds});
            if (CollectionUtils.isEmpty(addTagIds) && CollectionUtils.isEmpty((Collection)rmTagIds)) continue;
            try {
                MarkTagParams markTagParams = new MarkTagParams();
                markTagParams.setUserId(relation.getWeworkUserId());
                markTagParams.setExternalUserId(contactId);
                markTagParams.setAddTagIds(new ArrayList<String>(addTagIds));
                markTagParams.setRemoveTagIds(new ArrayList(rmTagIds));
                this.executeService.submit(this.buildTask(markTagParams, corpId));
            }
            catch (Exception e) {
                log.info("contactTagSync to weworkSDK  error addTagIds: {}, rmTagIds: {}, contactId: {}", new Object[]{addTagIds, rmTagIds, contactId});
                log.error("contactTagSync to weworkSDK error ", (Throwable)e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)msg.getWeworkUserId())) {
            String weworkUserNum = (String)weworkUserNumMap.get(msg.getWeworkUserId());
            try {
                AttachAllTag tagReq = new AttachAllTag();
                tagReq.setBizId(bizId);
                tagReq.setWeworkUserNum(weworkUserNum);
                tagReq.setCustomerNum(customerNum);
                tagReq.setSource(this.SOURCE);
                tagReq.setAllTagIds(new ArrayList(msg.getTagIds()));
                this.ccCustomerTagService.updateAllTag(tagReq);
            }
            catch (Exception e) {
                log.error("contactTagSync to customerCenter error: ", (Throwable)e);
            }
        }
    }

    private Set<String> distinctTagIds(Collection<String> tagIds) {
        HashSet<String> set = new HashSet<String>();
        if (CollectionUtils.isEmpty(tagIds)) {
            return set;
        }
        for (String tagId : tagIds) {
            if (!StringUtils.isNotBlank((CharSequence)tagId)) continue;
            set.add(tagId.trim());
        }
        return set;
    }

    private Runnable buildTask(MarkTagParams markTagParams, String corpId) {
        return () -> {
            try {
                log.info("contactTagSync corpId: {}", (Object)corpId);
                this.externalTagClient.markTag(corpId, markTagParams);
            }
            catch (Exception e) {
                log.error("contactTagSync error", (Throwable)e);
            }
        };
    }

    public void syncCrmTagDataToScrm(WeworkTagMsg msg) {
        Long bizId = msg.getBizId();
        String corpId = msg.getCorpId();
        String contactId = msg.getContactId();
        Set allTagIds = msg.getTagIds();
        WeworkContact contact = this.weworkContactMapper.queryContactByContactId(corpId, contactId);
        String customerNum = contact.getCustomerNum();
        log.info("syncCrmTagDataToScrm get contact: {}, customerNum: {}", (Object)contactId, (Object)customerNum);
        List contactTags = this.weworkContactTagMapper.queryByCorpIdAndContactIdsFilterWeworkUserIds(corpId, (List)Lists.newArrayList((Object[])new String[]{contactId}));
        Map userContactMaps = contactTags.stream().collect(Collectors.groupingBy(WeworkContactTag::getWeworkUserId, Collectors.mapping(WeworkContactTag::getTagId, Collectors.toSet())));
        List relationList = this.weworkContactRelationMapper.queryListByContactIdIncloudZoomFans(corpId, contactId);
        List weworkUserIds = relationList.stream().map(WeworkContactRelation::getWeworkUserId).collect(Collectors.toList());
        log.info("syncCrmTagDataToScrm get WeworkContactRelation weworkUserIds: {}", weworkUserIds);
        ArrayList addTags = Lists.newArrayList();
        HashSet rmIds = Sets.newHashSet();
        for (String weworkUserId : weworkUserIds) {
            Set dbTagIds = userContactMaps.get(weworkUserId);
            if (CollectionUtils.isNotEmpty((Collection)allTagIds)) {
                for (String addTagId : allTagIds) {
                    if (dbTagIds != null && dbTagIds.contains(addTagId)) continue;
                    WeworkContactTag cTag = this.buildContactTag(bizId, corpId, contactId, weworkUserId, addTagId);
                    addTags.add(cTag);
                }
            }
            if (!CollectionUtils.isNotEmpty(dbTagIds)) continue;
            for (String rmTagId : dbTagIds) {
                List rmTags;
                if (allTagIds.contains(rmTagId) || !CollectionUtils.isNotEmpty(rmTags = contactTags.stream().filter(a -> a.getContactId().equals(contactId) && a.getWeworkUserId().equals(weworkUserId) && a.getTagId().equals(rmTagId)).collect(Collectors.toList()))) continue;
                List ids = rmTags.stream().map(WeworkContactTag::getId).collect(Collectors.toList());
                rmIds.addAll(ids);
            }
        }
        log.info("syncCrmTagDataToScrm addTagSie: {}, rmTagIds: {}", (Object)addTags.size(), (Object)rmIds);
        if (CollectionUtils.isNotEmpty((Collection)addTags)) {
            this.weworkContactTagMapper.batchInsert((List)addTags);
        }
        if (CollectionUtils.isNotEmpty((Collection)rmIds)) {
            this.weworkContactTagMapper.logicDeleteByIds((Collection)rmIds, Long.valueOf(-1L));
        }
        Map weworkUserNumMap = this.weworkUserMapper.queryUserNumIdMap(corpId, weworkUserIds);
        for (String weworkUserId : weworkUserIds) {
            try {
                AttachAllTag tagReq = new AttachAllTag();
                tagReq.setBizId(bizId);
                String weworkUserNum = (String)weworkUserNumMap.get(weworkUserId);
                tagReq.setWeworkUserNum(weworkUserNum);
                tagReq.setCustomerNum(customerNum);
                tagReq.setSource(this.SOURCE);
                tagReq.setAllTagIds(new ArrayList(allTagIds));
                this.ccCustomerTagService.updateAllTag(tagReq);
                log.info("syncCrmTagDataToScrm update customerCenter tagReq: {}", (Object)tagReq);
            }
            catch (Exception e) {
                log.error("syncCrmTagDataToScrm to customerCenter error: ", (Throwable)e);
            }
        }
    }

    private WeworkContactTag buildContactTag(Long bizId, String corpId, String contactId, String weworkUserID, String tagId) {
        WeworkContactTag cTag = new WeworkContactTag();
        cTag.setNum(this.idGen.getNum());
        cTag.setBizId(bizId);
        cTag.setCorpId(corpId);
        cTag.setContactId(contactId);
        cTag.setWeworkUserId(weworkUserID);
        cTag.setTagId(tagId);
        cTag.setType(Integer.valueOf(1));
        cTag.setCreateBy(Long.valueOf(-1L));
        cTag.setCreateTime(new Date());
        cTag.setUpdateBy(Long.valueOf(-1L));
        cTag.setUpdateTime(new Date());
        cTag.setIsDeleted(Integer.valueOf(0));
        return cTag;
    }

    public List<String> filterTagIds(Long bizId, List<String> tagIds) {
        log.info("filterTagIds bizId: {}, tagIds: {}", (Object)bizId, tagIds);
        if (CollectionUtils.isEmpty(tagIds)) {
            return Lists.newArrayList();
        }
        return this.weworkTagMapper.filterExistTagIds(bizId, tagIds);
    }
}

