/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.service.ScrmOrgService;
import com.kuaike.scrm.common.service.dto.resp.OrgRespDto;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScrmOrgServiceImpl
implements ScrmOrgService {
    private static final Logger log = LoggerFactory.getLogger(ScrmOrgServiceImpl.class);
    @Resource
    private OrganizationMapper organizationMapper;

    public List<OrgRespDto> getAllByBizId(Long bizId, Integer isDeleted) {
        log.info("getAllByBizId,bizId:{},isDeleted:{}", (Object)bizId, (Object)isDeleted);
        if (bizId == null || bizId <= 0L) {
            return Collections.emptyList();
        }
        List organizations = this.organizationMapper.selectByBizIdAndIsDeleted(bizId, isDeleted);
        if (CollectionUtils.isEmpty((Collection)organizations)) {
            return Collections.emptyList();
        }
        ArrayList orgRespDtos = Lists.newArrayList();
        for (Organization organization : organizations) {
            OrgRespDto orgRespDto = new OrgRespDto();
            orgRespDtos.add(orgRespDto);
            orgRespDto.setId(organization.getId());
            orgRespDto.setName(organization.getName());
            orgRespDto.setOrgType(organization.getOrgType());
            orgRespDto.setPayGroupKey(organization.getPayGroupKey());
            orgRespDto.setPid(organization.getPid());
        }
        return orgRespDtos;
    }
}

