/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.RestfulResult;
import com.kuaike.scrm.common.service.CommonBjyApiService;
import com.kuaike.scrm.common.utils.BaijiacloudServiceUtil;
import com.kuaike.scrm.common.utils.UrlUtils;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSettingMapper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CommonBjyApiServiceImpl
implements CommonBjyApiService {
    private static final Logger log = LoggerFactory.getLogger(CommonBjyApiServiceImpl.class);
    @Resource
    private MeetingSettingMapper meetingSettingMapper;

    @Override
    public <T extends Serializable> T postBjyApi(TypeReference<RestfulResult<T>> resultType, String apiAddress, Map<String, String> param, String corpId, String operation, String feature) {
        try {
            if (StringUtils.isBlank((CharSequence)apiAddress)) {
                log.warn("operation: {} feature:{} \u540c\u6b65\u767e\u5bb6\u4e91\u53c2\u6570 url:{}, param:{}  \u63a5\u53e3url\u4e3a\u7a7a", new Object[]{operation, feature, apiAddress, param});
                return null;
            }
            MeetingSetting meetingSetting = this.meetingSettingMapper.getSettingByCorpId(corpId);
            if (Objects.isNull(meetingSetting)) {
                throw new IllegalArgumentException("meeting setings is null");
            }
            String url = UrlUtils.assembleUrl(meetingSetting.getDominSite(), apiAddress);
            log.info("operation: {} feature:{} \u540c\u6b65\u767e\u5bb6\u4e91\u53c2\u6570 url:{} , param:{}", new Object[]{operation, feature, url, param});
            RestfulResult<T> restfulResult = BaijiacloudServiceUtil.postWithDefPara(url, param, null, resultType, meetingSetting.getBjyId(), meetingSetting.getBjyKey());
            log.info("operation: {} feature:{} \u540c\u6b65\u767e\u5bb6\u4e91\u8bf7\u6c42\u7ed3\u679c\uff1aresult:{}", new Object[]{operation, feature, JacksonUtil.obj2Str(restfulResult)});
            if (0 != restfulResult.getCode()) {
                log.error(" operation:{} feature:{} response a error code={}, msg={}", new Object[]{operation, feature, restfulResult.getCode(), restfulResult.getMsg()});
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, restfulResult.getMsg());
            }
            return (T)((Serializable)restfulResult.getData());
        }
        catch (Exception e) {
            log.error("operation: {} feature:{} \u540c\u6b65\u767e\u5bb6\u4e91  error,param:{}", new Object[]{operation, feature, param, e});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, feature + ":" + operation + "\u5931\u8d25\uff1amessage:" + e.getMessage());
        }
    }

    @Override
    public <T extends Serializable> List<T> postListBjyApi(TypeReference<RestfulResult<List<T>>> resultType, String apiAddress, Map<String, String> param, String corpId, String operation, String feature) {
        try {
            if (StringUtils.isBlank((CharSequence)apiAddress)) {
                log.warn("operation: {} feature:{} \u540c\u6b65\u767e\u5bb6\u4e91\u53c2\u6570 url:{},param:{}  \u63a5\u53e3url\u4e3a\u7a7a", new Object[]{operation, feature, apiAddress, param});
                return Lists.newArrayList();
            }
            MeetingSetting meetingSetting = this.meetingSettingMapper.getSettingByCorpId(corpId);
            if (Objects.isNull(meetingSetting)) {
                throw new IllegalArgumentException("meeting setings is null");
            }
            String url = UrlUtils.assembleUrl(meetingSetting.getDominSite(), apiAddress);
            log.info("operation: {} feature:{} \u540c\u6b65\u767e\u5bb6\u4e91\u53c2\u6570 url:{},param:{}", new Object[]{operation, feature, url, param});
            RestfulResult<List<T>> restfulResult = BaijiacloudServiceUtil.postWithDefPara(url, param, null, resultType, meetingSetting.getBjyId(), meetingSetting.getBjyKey());
            log.info("operation: {} feature: {} \u540c\u6b65\u767e\u5bb6\u4e91\u8bf7\u6c42\u7ed3\u679c\uff1aresult:{}", new Object[]{operation, feature, JacksonUtil.obj2Str(restfulResult)});
            if (0 != restfulResult.getCode()) {
                log.error(" operation:{} feature:{} response a error code={}, msg={}", new Object[]{operation, feature, restfulResult.getCode(), restfulResult.getMsg()});
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, restfulResult.getMsg());
            }
            return (List)restfulResult.getData();
        }
        catch (Exception e) {
            log.error("operation: {} feature:{}\u540c\u6b65\u767e\u5bb6\u4e91  error", new Object[]{operation, feature, e});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, feature + ":" + operation + "\u5931\u8d25\uff1amessage:" + e.getMessage());
        }
    }
}

