/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.enums.RedissonLockType;
import com.kuaike.scrm.common.utils.HashUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RedisDistributeLock
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributeLock.class);
    @Autowired
    RedissonClient redisson;
    @Value(value="${spring.redis.key.prefix}")
    private String redisPrefix;
    private static ThreadLocal<Map<String, RLock>> lockThreadLocal = new ThreadLocal();
    static final String CHECK_EXISTS_SCRIPT = "if (redis.call('exists', KEYS[1]) == 0) then return false; end; if (redis.call('hlen', KEYS[1]) > 0) then return true; end; return false;";

    public boolean lock(String key, RedissonLockType lockType, long timeoutMillSec, long leaseMillSec) throws InterruptedException {
        Preconditions.checkArgument((lockType != null ? 1 : 0) != 0, (Object)"lockType is null");
        long l = leaseMillSec = leaseMillSec < -1L ? -1L : leaseMillSec;
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        String redisKey = this.redisPrefix + key;
        RLock lock = null;
        String string = key.intern();
        synchronized (string) {
            ConcurrentMap key2Locks = lockThreadLocal.get();
            if (key2Locks == null) {
                key2Locks = Maps.newConcurrentMap();
                lockThreadLocal.set(key2Locks);
            }
            if ((lock = (RLock)key2Locks.get(key)) == null) {
                switch (lockType) {
                    case REENTRANT_LOCK: {
                        lock = this.redisson.getLock(redisKey);
                        break;
                    }
                    case FAIR_LOCK: {
                        lock = this.redisson.getFairLock(redisKey);
                        break;
                    }
                    default: {
                        lock = this.redisson.getLock(redisKey);
                    }
                }
            }
            if (lock != null) {
                boolean acquired;
                if (timeoutMillSec > 0L) {
                    try {
                        acquired = lock.tryLock(timeoutMillSec, leaseMillSec, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        log.error("lock was interrupted", (Throwable)e);
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                } else {
                    lock.lock();
                    acquired = true;
                }
                if (acquired) {
                    key2Locks.put(key, lock);
                } else {
                    log.error("\u5728\u7b49\u5f85\u65f6\u95f4\u5185\u672a\u83b7\u53d6\u5230\u9501,redisKey={},timeoutMillSec={}", (Object)redisKey, (Object)timeoutMillSec);
                }
                return acquired;
            }
            log.error("get lock is null,lock fail with key={}", (Object)key);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "get lock is null,lock fail");
        }
    }

    @Override
    public void lock(String key) throws InterruptedException {
        this.lock(key, RedissonLockType.REENTRANT_LOCK, 0L, -1L);
    }

    @Override
    public void lock(String key, long leaseTime, TimeUnit timeUnit) throws InterruptedException {
        long leaseTimeMillSec = TimeUnit.MILLISECONDS.convert(leaseTime, timeUnit);
        this.lock(key, RedissonLockType.REENTRANT_LOCK, 0L, leaseTimeMillSec);
    }

    @Override
    public void lock(String key, long leaseTime, long timeout, TimeUnit timeUnit) throws InterruptedException {
        long timeoutMillSec = TimeUnit.MILLISECONDS.convert(leaseTime, timeUnit);
        long leaseTimeMillSec = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        this.lock(key, RedissonLockType.REENTRANT_LOCK, timeoutMillSec, leaseTimeMillSec);
    }

    @Override
    public boolean tryLock(String key, long timeoutMillSec) throws InterruptedException {
        return this.lock(key, RedissonLockType.REENTRANT_LOCK, timeoutMillSec, -1L);
    }

    @Override
    public void unlock(String localKey) {
        if (StringUtils.isBlank((CharSequence)localKey)) {
            return;
        }
        Map<String, RLock> key2Locks = lockThreadLocal.get();
        if (MapUtils.isEmpty(key2Locks)) {
            return;
        }
        RLock lock = key2Locks.get(localKey);
        if (lock != null) {
            key2Locks.remove(localKey);
            lock.unlock();
            return;
        }
        log.warn("thread without lock, not need to unlock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void multiLock(Collection<String> keys) throws InterruptedException {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        keys.stream().forEach(a -> Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)a), (Object)"lock object can not be null or empty"));
        List<String> lockKeys = keys.stream().distinct().sorted().collect(Collectors.toList());
        String localKey = HashUtils.hash(lockKeys);
        RLock lock = null;
        String string = localKey.intern();
        synchronized (string) {
            ConcurrentMap lockMap = lockThreadLocal.get();
            if (lockMap == null) {
                lockMap = Maps.newConcurrentMap();
                lockThreadLocal.set(lockMap);
            }
            if ((lock = (RLock)lockMap.get(localKey)) == null) {
                lock = this.getRedissonMultiLock(lockKeys);
            }
            if (lock != null) {
                log.info("key={} ready to lock", (Object)localKey);
                lock.lock();
                boolean acquired = true;
                if (!acquired) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5728\u7b49\u5f85\u65f6\u95f4\u5185\u672a\u83b7\u53d6\u5230\u9501");
                }
                lockMap.put(localKey, lock);
            } else {
                log.error("get lock is null,lock fail with key={}", keys);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "get lock is null,lock fail");
            }
            log.info("key={} locked ", (Object)localKey);
        }
    }

    @Override
    public boolean tryMultiLock(Collection<String> keys, long timeoutMillSec) throws InterruptedException {
        if (CollectionUtils.isEmpty(keys)) {
            return false;
        }
        keys.stream().forEach(a -> Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)a), (Object)"lock object can not be null or empty"));
        List<String> lockKeys = keys.stream().distinct().sorted().collect(Collectors.toList());
        String localKey = HashUtils.hash(lockKeys);
        RLock lock = null;
        String string = localKey.intern();
        synchronized (string) {
            ConcurrentMap lockMap = lockThreadLocal.get();
            if (lockMap == null) {
                lockMap = Maps.newConcurrentMap();
                lockThreadLocal.set(lockMap);
            }
            if ((lock = (RLock)lockMap.get(localKey)) == null) {
                lock = this.getRedissonMultiLock(lockKeys);
            }
            if (lock != null) {
                boolean acquired;
                log.info("key={} ready to lock", (Object)localKey);
                if (timeoutMillSec > 0L) {
                    try {
                        acquired = lock.tryLock(timeoutMillSec, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        log.error("lock was interrupted", (Throwable)e);
                        throw e;
                    }
                } else {
                    lock.lock();
                    acquired = true;
                }
                if (acquired) {
                    lockMap.put(localKey, lock);
                } else {
                    log.error("\u5728\u7b49\u5f85\u65f6\u95f4\u5185\u672a\u83b7\u53d6\u5230\u9501,lockKeys={},timeoutMillSec={}", lockKeys, (Object)timeoutMillSec);
                }
                log.info("key={} locked ", (Object)localKey);
                return acquired;
            }
            log.error("get lock is null,lock fail with key={}", keys);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "get lock is null,lock fail");
        }
    }

    private RLock getRedissonMultiLock(List<String> lockKeys) {
        ArrayList subLocks = Lists.newArrayList();
        for (String lockKey : lockKeys) {
            lockKey = this.redisPrefix + lockKey;
            subLocks.add(this.redisson.getLock(lockKey));
        }
        return this.redisson.getMultiLock(subLocks.toArray(new RLock[0]));
    }

    @Override
    public void unlockMultiLock(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        keys.stream().forEach(a -> Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)a), (Object)"lock object can not be null or empty"));
        List<String> lockKeys = keys.stream().distinct().sorted().collect(Collectors.toList());
        String keyCode = HashUtils.hash(lockKeys);
        try {
            this.unlock(keyCode);
        }
        catch (Exception e) {
            log.error("unlock fail with error", (Throwable)e);
        }
    }

    @Override
    public boolean checkExistLock(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        String redisKey = this.redisPrefix + key;
        return (Boolean)this.redisson.getScript().eval(RScript.Mode.READ_ONLY, CHECK_EXISTS_SCRIPT, RScript.ReturnType.BOOLEAN, (List)Lists.newArrayList((Object[])new Object[]{redisKey}), new Object[0]);
    }
}

