/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.component;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.kuaike.scrm.common.utils.DateUtil;
import java.io.File;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public final class AliyunOss {
    private static final Logger log = LoggerFactory.getLogger(AliyunOss.class);
    @Value(value="${aliyun.oss.endpoint}")
    private String endpoint;
    @Value(value="${aliyun.oss.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${aliyun.oss.roleArn}")
    private String roleArn;
    @Value(value="${aliyun.oss.bucket}")
    private String bucket;
    @Value(value="${aliyun.oss.file.expireDays}")
    private long expireDays;

    public AssumeRoleResponse getSTS() throws ClientException {
        String roleSessionName = "session-name";
        String policy = "{\n    \"Version\": \"1\", \n    \"Statement\": [\n        {\n            \"Action\": [\n                \"oss:*\"\n            ], \n            \"Resource\": [\n                \"acs:oss:*:*:*\" \n            ], \n            \"Effect\": \"Allow\"\n        }\n    ]\n}";
        try {
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-shanghai", (String)this.accessKeyId, (String)this.accessKeySecret);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setMethod(MethodType.POST);
            request.setProtocol(ProtocolType.HTTPS);
            request.setRoleArn(this.roleArn);
            request.setRoleSessionName(roleSessionName);
            request.setPolicy(policy);
            return (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
        }
        catch (Exception e) {
            log.error("STS Request Failed", (Throwable)e);
            throw e;
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    private String fileKey(String corpId, File file, String originFileKey) {
        if (StringUtils.isBlank((CharSequence)corpId)) {
            throw new IllegalArgumentException("corpId can not be null or empty");
        }
        String dateStr = DateUtil.dateToDateString(new Date(), "yyyyMMdd");
        String fileDir = "scrm/" + corpId + File.separator + dateStr + File.separator;
        String fileKey = StringUtils.isNotBlank((CharSequence)originFileKey) ? fileDir + originFileKey : fileDir + UUID.randomUUID().toString().replace("-", "") + "-" + file.getName();
        return fileKey;
    }

    public String uploadFile(String corpId, File file, String originFileKey) {
        String fileKey = this.fileKey(corpId, file, originFileKey);
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        ossClient.putObject(this.bucket, fileKey, file);
        ossClient.shutdown();
        return "https://" + this.bucket + '.' + this.endpoint + '/' + fileKey;
    }

    public String uploadFileWithOriginFileName(String corpId, File file, String originFileKey, String originFileName) {
        String fileKey = this.fileKey(corpId, file, originFileKey);
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentDisposition("attachment;filename=\"" + originFileName + "\"");
        ossClient.putObject(this.bucket, fileKey, file, objectMetadata);
        ossClient.shutdown();
        return "https://" + this.bucket + '.' + this.endpoint + '/' + fileKey;
    }

    public void delUploadFile(String corpId, String originFileKey) {
        if (StringUtils.isBlank((CharSequence)corpId)) {
            throw new IllegalArgumentException("corpId can not be null or empty");
        }
        if (StringUtils.isBlank((CharSequence)originFileKey)) {
            throw new IllegalArgumentException("originFileKey can not be null or empty");
        }
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        ossClient.deleteObject(this.bucket, originFileKey);
        ossClient.shutdown();
    }
}

