/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.component;

import com.kuaike.scrm.common.component.BaseKafkaConsumerImpl;
import com.kuaike.scrm.common.component.KafkaMsgHandler;
import com.kuaike.scrm.common.utils.KafkaClientUtils;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;

public abstract class AbstractTopicConsumer
extends BaseKafkaConsumerImpl
implements CommandLineRunner,
KafkaMsgHandler<String, String> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTopicConsumer.class);
    @Value(value="${scrm.job.enable:true}")
    private boolean enable;

    @Override
    @Value(value="${scrm.consumer.poll.ms:1000}")
    public void setConsumerPollMs(Integer consumerPollMs) {
        this.consumerPollMs = consumerPollMs;
    }

    @Override
    @Autowired
    public void setKafkaClientUtils(KafkaClientUtils kafkaClientUtils) {
        this.kafkaClientUtils = kafkaClientUtils;
    }

    public void run(String ... args) throws Exception {
        log.info("scrm.job.enable:{}", (Object)this.enable);
        if (Objects.isNull(this.msgHandler)) {
            this.setMsgHandler(this);
        }
        if (this.enable) {
            this.doStart();
        }
    }

    @Override
    public abstract String getTopic();

    @Override
    public void onMessage(ConsumerRecord<String, String> records) throws Exception {
        this.handle(records);
    }

    public abstract void handle(ConsumerRecord<String, String> var1) throws Exception;
}

