/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.utils.exec;

import com.google.common.collect.Lists;
import com.kuaike.scrm.utils.exec.TaskJob;
import com.kuaike.scrm.utils.exec.TaskJobExecutor;
import com.kuaike.scrm.utils.exec.TaskJobRun;
import com.kuaike.scrm.utils.exec.TaskJobType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskJobTest {
    private static final Logger log = LoggerFactory.getLogger(TaskJobTest.class);

    public static void main(String[] arg) {
        List<Object> taskJobList = Lists.newArrayList();
        taskJobList = TaskJobTest.buildTask();
        for (TaskJob taskJob : taskJobList) {
            TaskJobExecutor.addTaskJob(taskJob);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            log.error("interrupt ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        taskJobList = TaskJobTest.buildTask();
        for (TaskJob taskJob : taskJobList) {
            TaskJobExecutor.addTaskJob(taskJob);
        }
        while (TaskJobExecutor.blockJobSize() != 0 || TaskJobExecutor.runningJobSize() != 0) {
            try {
                Thread.sleep(500L);
                log.info("blockJobSize={},runningJobSize={}", (Object)TaskJobExecutor.blockJobSize(), (Object)TaskJobExecutor.runningJobSize());
            }
            catch (InterruptedException e) {
                log.error("interrupt ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        System.out.println("finish");
    }

    private static List<TaskJob> buildTask() {
        ArrayList taskJobList = Lists.newArrayList();
        for (int i = 0; i < 40; ++i) {
            ArrayList list = Lists.newArrayList();
            int j = 0;
            while (j < 40) {
                int finalJ = j++;
                int finalI = i;
                TaskJobRun run = new TaskJobRun(() -> {
                    log.info("taskJobrun " + finalI + "," + finalJ + " start");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        log.error("interrupt ", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    log.info("taskJobrun " + finalI + "," + finalJ + " end");
                });
                list.add(run);
            }
            int n = i % 20;
            String wechatId = StringUtils.repeat((char)((char)(n + 48)), (int)5);
            TaskJob taskJob = new TaskJob(Long.valueOf(i), TaskJobType.GROUPSEND, wechatId, list);
            taskJobList.add(taskJob);
        }
        return taskJobList;
    }
}

