/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpHeadUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpHeadUtils.class);
    private static final Pattern PATTERN = Pattern.compile("mmecimage\\.cn|store\\.mp\\.video\\.tencent-cloud\\.com|mmbizurl\\.cn");
    private static final Set<String> HEAD_IMG_CONTENT_TYPES = Sets.newHashSet((Object[])new String[]{"image/png", "image/gif", "image/jpg", "image/jpeg", "image/bmp"});

    private HttpHeadUtils() {
    }

    public static Map<String, Object> getHeaderMap(String urlStr) {
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("HEAD");
            Map<String, List<String>> headerMap = conn.getHeaderFields();
            HashMap map = Maps.newHashMap();
            for (Map.Entry<String, List<String>> entry : headerMap.entrySet()) {
                String key = entry.getKey();
                List<String> values = entry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)key) || !Objects.nonNull(values)) continue;
                map.put(key, values.get(0));
            }
            return map;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6HEAD\u8bf7\u6c42\u5931\u8d25, url={}", (Object)urlStr, (Object)e);
            return Maps.newHashMap();
        }
    }

    public static boolean isWxResource(String url) {
        return PATTERN.matcher(url).find();
    }

    public static void checkImgAndSize(String imgUrl, String contentTypeMsg, int maxSize, String sizeMsg) {
        Map<String, Object> map = HttpHeadUtils.getHeaderMap(imgUrl);
        String contentType = (String)map.get("Content-Type");
        long contentLength = Long.parseLong((String)map.get("Content-Length"));
        Preconditions.checkArgument((boolean)HEAD_IMG_CONTENT_TYPES.contains(contentType), (Object)contentTypeMsg);
        Preconditions.checkArgument((contentLength <= 0x100000L * (long)maxSize ? 1 : 0) != 0, (Object)sizeMsg);
    }
}

