/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum XmlUtils {
    INSTANCE;

    private static final Logger log;
    private final XmlMapper xmlMapper = new XmlMapper();

    private XmlUtils() {
        this.xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public XmlMapper getXmlMapper() {
        return this.xmlMapper;
    }

    public static String obj2Xml(Object value) {
        try {
            return INSTANCE.getXmlMapper().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            log.error("Generate xml failed, obj={}", value, (Object)e);
            return null;
        }
    }

    public static <T> T xml2Obj(String content, Class<T> valueType) {
        try {
            return (T)INSTANCE.getXmlMapper().readValue(content, valueType);
        }
        catch (IOException e) {
            log.error("Parse xml failed, content={}", (Object)content, (Object)e);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(XmlUtils.class);
    }
}

