/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.collect.Maps;
import com.kuaike.scrm.common.service.ScrmStageService;
import com.kuaike.scrm.common.service.dto.resp.StageDto;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScrmStageServiceImpl
implements ScrmStageService {
    private static final Logger log = LoggerFactory.getLogger(ScrmStageServiceImpl.class);
    @Autowired
    private CustomerStageMapper customerStageMapper;

    public List<StageDto> getByIds(Long bizId, Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List list = this.customerStageMapper.getByIdsAndBizId(bizId, ids);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list.stream().map(this::newStageDto).collect(Collectors.toList());
    }

    public Map<Long, StageDto> getMapByIds(Long bizId, Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        List list = this.customerStageMapper.getByIdsAndBizId(bizId, ids);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return list.stream().map(this::newStageDto).collect(Collectors.toMap(StageDto::getId, Function.identity()));
    }

    public StageDto getById(Long bizId, Long id) {
        CustomerStage customerStage = this.customerStageMapper.getByIdAndBizId(bizId, id);
        return this.newStageDto(customerStage);
    }

    public StageDto getFirstStage(Long bizId) {
        CustomerStage customerStage = this.customerStageMapper.getFirstStageByBizId(bizId);
        return this.newStageDto(customerStage);
    }

    public StageDto getLastStage(Long bizId) {
        CustomerStage customerStage = this.customerStageMapper.getLastStageByBizId(bizId);
        return this.newStageDto(customerStage);
    }

    public List<StageDto> getAllStage(Long bizId) {
        List list = this.customerStageMapper.getAllStage(bizId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list.stream().map(this::newStageDto).collect(Collectors.toList());
    }

    public Map<Long, Integer> getStageIndex(Long bizId) {
        List list = this.customerStageMapper.getAllStage(bizId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        Map<Integer, List<CustomerStage>> stageMap = list.stream().collect(Collectors.groupingBy(CustomerStage::getType));
        List<CustomerStage> ending = stageMap.get(2);
        List<CustomerStage> follow = stageMap.get(1);
        ConcurrentMap indexMap = Maps.newConcurrentMap();
        int order = 0;
        for (CustomerStage it : ending) {
            indexMap.put(it.getId(), order++);
        }
        for (CustomerStage it : follow) {
            indexMap.put(it.getId(), order++);
        }
        return indexMap;
    }

    private StageDto newStageDto(CustomerStage customerStage) {
        if (customerStage == null) {
            return null;
        }
        StageDto dto = new StageDto();
        dto.setId(customerStage.getId());
        dto.setStageValue(customerStage.getStageValue());
        dto.setStageName(customerStage.getStageName());
        dto.setType(customerStage.getType());
        return dto;
    }
}

