/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.service.PersonQuickReplyCommonService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.quickreply.entity.PersonQuickReplyOrg;
import com.kuaike.scrm.dal.quickreply.mapper.PersonQuickReplyOrgMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonQuickReplyCommonServiceImpl
implements PersonQuickReplyCommonService {
    private static final Logger log = LoggerFactory.getLogger(PersonQuickReplyCommonServiceImpl.class);
    @Autowired
    private PersonQuickReplyOrgMapper personQuickReplyOrgMapper;
    @Autowired
    private IdGen idGen;

    @Override
    public void initDefaultPersonQuickReply(Long bizId, String corpId, Long userId) {
        log.info("initDefaultPersonQuickReply, bizId:{}, corpId:{}, userId:{}", new Object[]{bizId, corpId, userId});
        if (Objects.isNull(bizId) || StringUtils.isBlank((CharSequence)corpId) || Objects.isNull(userId)) {
            log.error("initDefaultPersonQuickReply: input is null, biz:{}, corpId:{}, user:{}", new Object[]{bizId, corpId, userId});
            return;
        }
        String defaultGroupName = "\u9ed8\u8ba4\u5206\u7ec4";
        PersonQuickReplyOrg olgOrg = this.personQuickReplyOrgMapper.queryByGroupName(corpId, userId, defaultGroupName);
        if (Objects.nonNull(olgOrg)) {
            return;
        }
        PersonQuickReplyOrg org = new PersonQuickReplyOrg();
        org.setNum(this.idGen.getNum());
        org.setBizId(bizId);
        org.setCorpId(corpId);
        org.setUserId(userId);
        org.setGroupName(defaultGroupName);
        org.setOrder(NumberUtils.INTEGER_ZERO);
        org.setCreateBy(userId);
        org.setUpdateBy(userId);
        org.setCreateTime(new Date());
        org.setUpdateTime(new Date());
        org.setIsDeleted(NumberUtils.INTEGER_ZERO);
        org.setIsDefault(NumberUtils.INTEGER_ONE);
        ArrayList list = Lists.newArrayList();
        list.add(org);
        this.personQuickReplyOrgMapper.batchInsert((List)list);
    }
}

