/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.collect.Maps;
import com.kuaike.scrm.common.enums.OperateLogTypeEnum;
import com.kuaike.scrm.common.service.OperateLogCommonService;
import com.kuaike.scrm.dal.operatelog.entity.OperateLog;
import com.kuaike.scrm.dal.operatelog.mapper.OperateLogMapper;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperateLogCommonServiceImpl
implements OperateLogCommonService {
    private static final Logger log = LoggerFactory.getLogger(OperateLogCommonServiceImpl.class);
    @Autowired
    private OperateLogMapper operateLogMapper;

    @Override
    public void saveOperateLog(Long operatorId, String module, String page, OperateLogTypeEnum operateType, String comment) {
        try {
            OperateLog operateLog = new OperateLog();
            operateLog.setModule(module);
            operateLog.setPage(page);
            operateLog.setType(Byte.valueOf((byte)operateType.getValue()));
            if (StringUtils.isNotBlank((CharSequence)comment) && comment.length() > 450) {
                comment = comment.substring(0, 400);
            }
            operateLog.setComment(comment);
            operateLog.setCreateBy(operatorId);
            operateLog.setCreateTime(new Date());
            operateLog.setUpdateBy(operatorId);
            operateLog.setUpdateTime(new Date());
            this.operateLogMapper.insertSelective((Object)operateLog);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
        }
    }

    @Override
    public Map<Long, Date> queryRecentLoginTimeByUserIds(Set<Long> userIds) {
        Map resultMap = Maps.newConcurrentMap();
        if (CollectionUtils.isEmpty(userIds)) {
            return resultMap;
        }
        resultMap = this.operateLogMapper.queryRecentLoginTimeByUserIds(userIds);
        return resultMap;
    }
}

