/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import cn.kinyun.wework.sdk.callback.corp.external.EditExternalContact;
import com.alibaba.fastjson.JSON;
import com.kuaike.common.utils.DateUtil;
import com.kuaike.scrm.common.component.KafkaAdminService;
import com.kuaike.scrm.common.dto.QyapiCallbackDto;
import com.kuaike.scrm.common.service.ExternalContactModService;
import com.kuaike.scrm.common.utils.XmlUtils;
import com.kuaike.scrm.dal.accesstoken.entity.CorpCustomizedToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpCustomizedTokenMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class ExternalContactModServiceImpl
implements ExternalContactModService {
    private static final Logger log = LoggerFactory.getLogger(ExternalContactModServiceImpl.class);
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private CorpCustomizedTokenMapper corpCustomizedTokenMapper;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Value(value="${kafka.topic.qyapi_callback}")
    private String topic;
    @Value(value="${qyapi.customized.id}")
    private String customizedId;
    @Autowired
    private KafkaAdminService kafkaAdminService;

    @Override
    public void syncSignalExternalContact(String corpId, String userId, String externalUserId) throws IOException {
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        log.info("syncSignalExternalContact corpId: {}, userId: {}, externalUserId: {}", new Object[]{corpId, userId, externalUserId});
        EditExternalContact contact = new EditExternalContact();
        contact.setToUserName(corpId);
        contact.setFromUserName("sys");
        contact.setCreateTime(Long.valueOf(DateUtil.currentUnixTimestamp()));
        contact.setMsgType("event");
        contact.setEvent("change_external_contact");
        contact.setChangeType("edit_external_contact");
        contact.setUserId(userId);
        contact.setExternalUserId(externalUserId);
        contact.setState("SCRM_FAKE_EVENT");
        String xmlText = XmlUtils.obj2Xml(contact);
        log.info("syncSignalExternalContact xmlText: {}", (Object)xmlText);
        CorpCustomizedToken corpCustomizedToken = this.corpCustomizedTokenMapper.getByCorpId(corpId, this.customizedId);
        if (corpCustomizedToken == null) {
            log.info("syncSignalExternalContact get corpCustomizedToken is null");
            return;
        }
        log.info("syncSignalExternalContact suiteId: {}, agentId: {}", (Object)this.customizedId, (Object)corpCustomizedToken.getAgentId());
        QyapiCallbackDto dto = new QyapiCallbackDto();
        dto.setQyapiType(QyapiCallbackDto.QyapiType.CUSTOMIZED_APP.name());
        dto.setCorpId(corpId);
        dto.setSuiteId(corpCustomizedToken.getSuiteId());
        dto.setAgentId(corpCustomizedToken.getAgentId());
        dto.setData(xmlText);
        dto.setMsgType(contact.getChangeType());
        if (StringUtils.isNotBlank((CharSequence)corpId)) {
            String dynamicTopic = this.kafkaAdminService.createAndSave(corpId, this.topic);
            log.info("dynamic topic:{}", (Object)dynamicTopic);
        }
        String json = JSON.toJSONString((Object)dto);
        try {
            this.kafkaTemplate.send(this.topic, (Object)corpId, (Object)json);
            log.info("send kafka: {}", (Object)json);
        }
        catch (Exception e) {
            log.error("send kafka failed: {}\n", (Object)json, (Object)e);
        }
    }
}

