/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.kuaike.scrm.common.service.DepartmentModService;
import com.kuaike.scrm.common.service.dto.DepartmentModMsg;
import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.common.utils.KafkaClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DepartmentModServiceImpl
implements DepartmentModService {
    private static final Logger log = LoggerFactory.getLogger(DepartmentModServiceImpl.class);
    @Autowired
    private KafkaClientUtils kafkaClient;
    @Value(value="${kafka.topic.department_mod}")
    private String departmentModTopic;

    @Override
    public void departmentModToKafka(DepartmentModMsg msg) {
        try {
            this.kafkaClient.sendMessage(this.departmentModTopic, JacksonUtils.getInstance().writeValueAsString(msg));
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5230\u90e8\u95e8\u53d8\u66f4\u8bb0\u5f55topic:{}, \u5931\u8d25,", (Object)this.departmentModTopic, (Object)e);
        }
    }
}

