/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.BizStatus;
import com.kuaike.scrm.common.service.BizStatusService;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizStatusServiceImpl
implements BizStatusService {
    private static final Logger log = LoggerFactory.getLogger(BizStatusServiceImpl.class);
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;

    @Override
    public void checkBusinessCustomerStatus(Long bizId) throws BusinessException {
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        if (businessCustomer == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5546\u6237\u4e0d\u5b58\u5728");
        }
        if (businessCustomer.getStatus().intValue() == BizStatus.FORBID.getValue()) {
            log.error("\u5546\u6237\u5df2\u88ab\u7981\u7528, {}", (Object)bizId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.TOKEN_EXPIRE, "\u5546\u6237\u5df2\u88ab\u7981\u7528");
        }
        if (businessCustomer.getStatus().intValue() == BizStatus.INVALID.getValue()) {
            log.error("\u5546\u6237\u5df2\u8fc7\u671f, {}", (Object)bizId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.TOKEN_EXPIRE, "\u5546\u6237\u5df2\u8fc7\u671f");
        }
        if (businessCustomer.getExpireDate().before(new Date())) {
            this.businessCustomerMapper.updateStatusById(Integer.valueOf(BizStatus.INVALID.getValue()), bizId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.TOKEN_EXPIRE, "\u5546\u6237\u5df2\u8fc7\u671f");
        }
    }
}

