/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.service.BatchCacheService;
import com.kuaike.scrm.common.service.dto.resp.BatchCacheDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.common.entity.BatchCache;
import com.kuaike.scrm.dal.common.mapper.BatchCacheMapper;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BatchCacheServiceImpl
implements BatchCacheService {
    private static final Logger log = LoggerFactory.getLogger(BatchCacheServiceImpl.class);
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private BatchCacheMapper batchCacheMapper;
    @Autowired
    private IdGen idGen;
    @Value(value="${scrm.cacheType:2}")
    private Integer cacheType;
    private static final int TOKEN_CACHE_EXPIRE = 1;
    private static final String BATCH_KEY = "SCRM_BATCH_CACHE_KEY_%s";

    public BatchCacheDto getBatchIdByData(List<String> list) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(list), (Object)"list is null or empty");
        String num = this.idGen.getNum();
        String key = this.redisKeyPrefix + String.format(BATCH_KEY, num);
        String value = JacksonUtil.obj2Str(list);
        this.save(key, value, this.cacheType);
        return new BatchCacheDto(num, CollectionUtils.size(list));
    }

    private void save(String key, String value, Integer type) {
        if (Objects.nonNull(type) && Objects.equals(type, 1)) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, 1L, TimeUnit.HOURS);
        } else {
            BatchCache batchCache = new BatchCache();
            batchCache.setBatchId(key);
            batchCache.setContent(value);
            batchCache.setCreateTime(new Date());
            this.batchCacheMapper.insert((Object)batchCache);
        }
    }

    public List<String> getCacheDataByBatchId(String batchId) {
        if (StringUtils.isBlank((CharSequence)batchId)) {
            return Lists.newArrayList();
        }
        String key = this.redisKeyPrefix + String.format(BATCH_KEY, batchId);
        try {
            return JacksonUtil.str2List((String)this.getValue(key, this.cacheType), String.class);
        }
        catch (IOException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u89e3\u6790\u7f13\u5b58\u5f02\u5e38");
        }
    }

    private String getValue(String key, Integer type) {
        if (Objects.nonNull(type) && Objects.equals(type, 1)) {
            Object data = this.redisTemplate.opsForValue().get((Object)key);
            if (ObjectUtils.isEmpty((Object)data)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f13\u5b58\u6570\u636e\u4e3a\u7a7a");
            }
            return data.toString();
        }
        return this.batchCacheMapper.queryByBatchId(key);
    }

    public void deleteBatchId(String batchId) {
        String key = this.redisKeyPrefix + String.format(BATCH_KEY, batchId);
        try {
            this.delete(key, this.cacheType);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7f13\u5b58\u4fe1\u606f\u5931\u8d25\uff1akey {}", (Object)key);
        }
    }

    private void delete(String key, Integer type) {
        if (Objects.nonNull(type) && Objects.equals(type, 1)) {
            this.redisTemplate.delete((Object)key);
        } else {
            this.batchCacheMapper.deleteByBatchId(key);
        }
    }
}

