/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service;

import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.SopTaskCallbackDto;
import com.kuaike.scrm.common.enums.sop.SopTaskType;
import com.kuaike.scrm.dal.marketing.mapper.SopTaskDetailMapper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class SopTaskStatusService {
    private static final Logger log = LoggerFactory.getLogger(SopTaskStatusService.class);
    @Value(value="${kafka.topic.sop_task_callback}")
    private String sopTaskTopic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private SopTaskDetailMapper sopTaskDetailMapper;

    public void sendSopTaskStatusMsg(Long taskId, Long subTaskId, SopTaskType taskType, String customerId, Integer status, String failReason, Date runTime) {
        try {
            List sopTaskDetails = this.sopTaskDetailMapper.querySopTask(taskId, Integer.valueOf(taskType.getValue()), customerId);
            log.info("sendSopTaskStatusMsg, taskId: {}, taskType:{}, customerId: {} ,sopTaskDetails: {}", new Object[]{taskId, taskType.getValue(), customerId, sopTaskDetails});
            if (CollectionUtils.isEmpty((Collection)sopTaskDetails)) {
                log.info("sendSopTaskStatusMsg not sop task taskId: {}, taskType: {}, customerId: {}", new Object[]{taskId, taskType, customerId});
                return;
            }
            SopTaskCallbackDto callbackDto = new SopTaskCallbackDto();
            callbackDto.setTaskId(taskId);
            callbackDto.setSubTaskId(subTaskId);
            callbackDto.setTaskType(taskType.getValue());
            callbackDto.setCustomerId(customerId);
            callbackDto.setStatus(status);
            callbackDto.setFailReason(failReason);
            callbackDto.setRunTime(runTime);
            log.info("sendSopTaskStatusMsg callbackDto: {}", (Object)callbackDto);
            this.kafkaTemplate.send(this.sopTaskTopic, (Object)String.valueOf(taskId), (Object)JacksonUtil.obj2Str((Object)callbackDto));
        }
        catch (Exception e) {
            log.error("callback sop task error: ", (Throwable)e);
        }
    }
}

