/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.dto.addfriend;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class TelAndRemarkDto {
    private String remark = "";
    private String tel;
    private String weworkUserNum;
    private String uniqKey;
    public static final String REGEX_MOBILE = "^(1)\\d{10}$";

    public TelAndRemarkDto(String remark, String tel, String weworkUserNum) {
        this.remark = remark;
        this.tel = tel;
        this.weworkUserNum = weworkUserNum;
    }

    public void validate() {
        this.remark = Optional.ofNullable(this.remark).orElse("");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.tel), (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)this.tel.matches(REGEX_MOBILE), (Object)"\u624b\u673a\u53f7\u975e\u6cd5");
        this.uniqKey = this.tel;
        if (StringUtils.isNotBlank((CharSequence)this.weworkUserNum)) {
            this.uniqKey = this.uniqKey + ":" + this.weworkUserNum;
        }
    }

    public static boolean isPhone(String tel) {
        if (StringUtils.isBlank((CharSequence)tel)) {
            return false;
        }
        return tel.matches(REGEX_MOBILE);
    }

    public String getRemark() {
        return this.remark;
    }

    public String getTel() {
        return this.tel;
    }

    public String getWeworkUserNum() {
        return this.weworkUserNum;
    }

    public String getUniqKey() {
        return this.uniqKey;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public void setWeworkUserNum(String weworkUserNum) {
        this.weworkUserNum = weworkUserNum;
    }

    public void setUniqKey(String uniqKey) {
        this.uniqKey = uniqKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TelAndRemarkDto)) {
            return false;
        }
        TelAndRemarkDto other = (TelAndRemarkDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$tel = this.getTel();
        String other$tel = other.getTel();
        if (this$tel == null ? other$tel != null : !this$tel.equals(other$tel)) {
            return false;
        }
        String this$weworkUserNum = this.getWeworkUserNum();
        String other$weworkUserNum = other.getWeworkUserNum();
        if (this$weworkUserNum == null ? other$weworkUserNum != null : !this$weworkUserNum.equals(other$weworkUserNum)) {
            return false;
        }
        String this$uniqKey = this.getUniqKey();
        String other$uniqKey = other.getUniqKey();
        return !(this$uniqKey == null ? other$uniqKey != null : !this$uniqKey.equals(other$uniqKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TelAndRemarkDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $tel = this.getTel();
        result = result * 59 + ($tel == null ? 43 : $tel.hashCode());
        String $weworkUserNum = this.getWeworkUserNum();
        result = result * 59 + ($weworkUserNum == null ? 43 : $weworkUserNum.hashCode());
        String $uniqKey = this.getUniqKey();
        result = result * 59 + ($uniqKey == null ? 43 : $uniqKey.hashCode());
        return result;
    }

    public String toString() {
        return "TelAndRemarkDto(remark=" + this.getRemark() + ", tel=" + this.getTel() + ", weworkUserNum=" + this.getWeworkUserNum() + ", uniqKey=" + this.getUniqKey() + ")";
    }

    public TelAndRemarkDto() {
    }
}

