/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.dto;

import com.kuaike.scrm.common.functions.PrintFunction;
import com.kuaike.scrm.common.functions.StartFunction;
import com.kuaike.scrm.common.functions.StopFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

public class StopWatchDto
implements StartFunction<String>,
StopFunction,
PrintFunction {
    private static final Logger log = LoggerFactory.getLogger(StopWatchDto.class);
    private final StartFunction<String> startFunction;
    private final StopFunction stopFunction;
    private final PrintFunction printFunction;
    private StopWatch stopWatch;

    public StopWatchDto(String id, boolean logTime, Logger log) {
        if (logTime) {
            this.stopWatch = new StopWatch(id);
        }
        this.startFunction = this.getStartConsumer(this.stopWatch, logTime);
        this.stopFunction = this.getStopFunction(this.stopWatch, logTime);
        this.printFunction = this.getPrintFunction(this.stopWatch, logTime, log);
    }

    @Override
    public void start(String name) {
        this.startFunction.start(name);
    }

    @Override
    public void stop() {
        this.stopFunction.stop();
    }

    @Override
    public void print() {
        this.printFunction.print();
    }

    private StartFunction<String> getStartConsumer(StopWatch watch, boolean logTime) {
        return a -> {
            if (watch == null || !logTime) {
                return;
            }
            if (StringUtils.isEmpty((Object)a)) {
                watch.start();
            } else {
                watch.start(a);
            }
        };
    }

    private StopFunction getStopFunction(StopWatch watch, boolean logTime) {
        return () -> {
            if (watch == null || !logTime) {
                return;
            }
            watch.stop();
        };
    }

    private PrintFunction getPrintFunction(StopWatch watch, boolean logTime, Logger log) {
        return () -> {
            if (watch == null || !logTime) {
                return;
            }
            if (log != null) {
                log.info(watch.prettyPrint());
            }
        };
    }
}

