/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.config;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DingTalkConfig {
    private static final Logger log = LoggerFactory.getLogger(DingTalkConfig.class);
    @Value(value="${ding.talk.callback:}")
    private String callBack;
    @Value(value="${ding.talk.token:}")
    private String token;
    @Value(value="${ding.talk.originalSign:}")
    private String originalSign;

    @Bean
    public DingTalkClient dingTalkClient() {
        long timestamp = System.currentTimeMillis();
        String sign = DingTalkConfig.sign(this.originalSign, timestamp);
        String url = this.callBack + "?access_token=" + this.token + "&timestamp=" + timestamp + "&sign=" + sign;
        return new DefaultDingTalkClient(url);
    }

    public static String sign(String secret, Long timestamp) {
        String stringToSign = timestamp + "\n" + secret;
        String sign = null;
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData), StandardCharsets.UTF_8), "UTF-8");
        }
        catch (Exception e) {
            log.error("\u52a0\u7b7e\u5931\u8d25", (Throwable)e);
        }
        return sign;
    }
}

