/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.utils.exec;

import com.kuaike.scrm.utils.exec.ITaskRunnable;
import com.kuaike.scrm.utils.exec.TaskJob;
import com.kuaike.scrm.utils.exec.TaskJobExecutor;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskJobRun
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TaskJobRun.class);
    private AtomicInteger totalSubJob;
    private TaskJob parentJob;
    private ITaskRunnable runnable;

    public TaskJobRun(ITaskRunnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public void run() {
        if (this.parentJob == null) {
            log.error("parentJob is null");
            return;
        }
        if (Objects.isNull(this.totalSubJob)) {
            log.error("total error, total is null");
            return;
        }
        if (this.totalSubJob.get() == 0) {
            log.error("total error, total={}", (Object)this.totalSubJob.get());
            return;
        }
        try {
            this.runnable.run();
        }
        catch (Exception e) {
            log.error("run with error", (Throwable)e);
        }
        finally {
            int left = this.totalSubJob.decrementAndGet();
            if (left <= 0) {
                TaskJobExecutor.addFinishedJob(this.parentJob);
                log.info("finish task id={}", (Object)this.parentJob.getId());
            }
        }
    }

    public void setParentJob(TaskJob taskJob) {
        this.parentJob = taskJob;
    }

    public void setTotalSubJob(AtomicInteger totalSubJob) {
        this.totalSubJob = totalSubJob;
    }

    public AtomicInteger getTotalSubJob() {
        return this.totalSubJob;
    }

    public TaskJob getParentJob() {
        return this.parentJob;
    }

    public ITaskRunnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(ITaskRunnable runnable) {
        this.runnable = runnable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskJobRun)) {
            return false;
        }
        TaskJobRun other = (TaskJobRun)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AtomicInteger this$totalSubJob = this.getTotalSubJob();
        AtomicInteger other$totalSubJob = other.getTotalSubJob();
        if (this$totalSubJob == null ? other$totalSubJob != null : !this$totalSubJob.equals(other$totalSubJob)) {
            return false;
        }
        TaskJob this$parentJob = this.getParentJob();
        TaskJob other$parentJob = other.getParentJob();
        if (this$parentJob == null ? other$parentJob != null : !((Object)this$parentJob).equals(other$parentJob)) {
            return false;
        }
        ITaskRunnable this$runnable = this.getRunnable();
        ITaskRunnable other$runnable = other.getRunnable();
        return !(this$runnable == null ? other$runnable != null : !this$runnable.equals(other$runnable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskJobRun;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicInteger $totalSubJob = this.getTotalSubJob();
        result = result * 59 + ($totalSubJob == null ? 43 : $totalSubJob.hashCode());
        TaskJob $parentJob = this.getParentJob();
        result = result * 59 + ($parentJob == null ? 43 : ((Object)$parentJob).hashCode());
        ITaskRunnable $runnable = this.getRunnable();
        result = result * 59 + ($runnable == null ? 43 : $runnable.hashCode());
        return result;
    }

    public String toString() {
        return "TaskJobRun(totalSubJob=" + this.getTotalSubJob() + ", parentJob=" + this.getParentJob() + ", runnable=" + this.getRunnable() + ")";
    }
}

