/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class IdConvertUtils {
    static final char[] DIGITS = new char[]{'u', 'v', 'w', 'J', 'K', 'L', '6', '7', 'N', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'o', 'p', 'q', 'M', '8', 'O', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'x', 'y', 'z', '0', 'U', '2', 'S', 'T', '1', 'r', 's', 't', 'P', 'Q', 'R', 'i', 'j', 'k', 'l', 'm', 'n', '3', 'W', '5', 'V', 'X', '4', 'Y', 'Z'};
    static final Map<Character, String> DIGITS_2_INDEX;
    static BigInteger b;

    private IdConvertUtils() {
    }

    public static String b62tob10(String int62) {
        BigInteger decimal = BigInteger.valueOf(0L);
        BigInteger base = BigInteger.valueOf(62L);
        int cnt = 0;
        char[] ident = int62.toCharArray();
        for (int i = ident.length - 1; i >= 0; --i) {
            String index = DIGITS_2_INDEX.get(Character.valueOf(ident[i]));
            BigInteger keisu = base.pow(cnt);
            decimal = decimal.add(keisu.multiply(new BigInteger(index)));
            ++cnt;
        }
        return String.format("%08d", decimal);
    }

    public static String b10tob62(String number, int length) {
        if (!StringUtils.isNumeric((CharSequence)number)) {
            return "";
        }
        BigInteger rest = new BigInteger(number);
        LinkedList<Character> stack = new LinkedList<Character>();
        StringBuilder result = new StringBuilder(0);
        BigInteger b62 = BigInteger.valueOf(62L);
        while (!rest.equals(BigInteger.ZERO)) {
            int index = rest.subtract(rest.divide(b62).multiply(b62)).intValue();
            stack.add(Character.valueOf(DIGITS[index]));
            rest = rest.divide(b62);
        }
        while (!stack.isEmpty()) {
            result.append(stack.pop());
        }
        int resultLength = result.length();
        StringBuilder temp0 = new StringBuilder();
        for (int i = 0; i < length - resultLength; ++i) {
            temp0.append('0');
        }
        return temp0.toString() + result.toString();
    }

    public static String encodeId(String id) {
        int i;
        BigInteger id2 = new BigInteger(id).xor(b);
        String tem = IdConvertUtils.b10tob62(id2.toString(), 16);
        for (i = 0; i < tem.length() && tem.charAt(i) == '0'; ++i) {
        }
        String a = tem.substring(i);
        return StringUtils.reverse((String)a);
    }

    public static String decodeId(String code) {
        String code2 = IdConvertUtils.b62tob10(StringUtils.reverse((String)code));
        BigInteger o = new BigInteger(code2);
        BigInteger t = o.xor(b);
        if (StringUtils.isNumeric((CharSequence)t.toString())) {
            return t.toString();
        }
        return "-1";
    }

    static {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < DIGITS.length; ++i) {
            map.put(Character.valueOf(DIGITS[i]), Integer.toString(i));
        }
        DIGITS_2_INDEX = ImmutableMap.copyOf((Map)map);
        b = BigInteger.valueOf(1000000000000000003L);
    }
}

