/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class HashUtils {
    private HashUtils() {
    }

    public static String hash(Collection<String> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return "";
        }
        collection.stream().forEach(a -> Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)a), (Object)"item can not be null or empty"));
        collection = collection.stream().sorted().collect(Collectors.toList());
        HashFunction hashFunction = Hashing.murmur3_128();
        Hasher hasher = hashFunction.newHasher();
        for (String s : collection) {
            hasher.putString((CharSequence)s, StandardCharsets.UTF_8);
        }
        return hasher.hash().toString();
    }
}

