/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.wework.sdk.api.external.ExternalContactClient;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalPendingIdDto;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalPendingIdResp;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalUserIdResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.service.UnionIdConvertService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.dal.wework.entity.UnionidPendingidRel;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.UnionidPendingidRelMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnionIdConvertServiceImpl
implements UnionIdConvertService {
    private static final Logger log = LoggerFactory.getLogger(UnionIdConvertServiceImpl.class);
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private UnionidPendingidRelMapper unionidPendingidRelMapper;
    @Autowired
    private ExternalContactClient externalContactClient;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;

    @Override
    public void unionIdToContactId(Long bizId, String corpId, String unionId, String openId) {
        log.info("unionIdToContactId, corpId:{}, unionId:{}, openId:{}", new Object[]{corpId, unionId, openId});
        if (StringUtils.isBlank((CharSequence)corpId)) {
            log.warn("corpId is null");
            return;
        }
        if (StringUtils.isBlank((CharSequence)unionId)) {
            log.warn("unionId is null");
            return;
        }
        if (StringUtils.isBlank((CharSequence)openId)) {
            log.warn("openId is null");
            return;
        }
        WeworkContact exist = this.weworkContactMapper.selectByCorpIdAndUnionId(corpId, unionId);
        if (exist != null) {
            log.info("found exist wework contact, corpId:{}, contactId:{}, unionId:{}", new Object[]{corpId, exist.getContactId(), unionId});
            return;
        }
        UnionidPendingidRel rel = this.unionidPendingidRelMapper.queryByUnionId(bizId, unionId, openId);
        if (rel != null && rel.getExpireTime().after(new Date())) {
            log.info("unionid pendingid rel exists corpId: {}, unionid: {}, pendingid: {}", new Object[]{corpId, rel.getUnionId(), rel.getPendingId()});
            return;
        }
        String externalUserId = null;
        String pendingId = null;
        try {
            ExternalUserIdResp resp = this.externalContactClient.unionIdConvert(corpId, unionId, openId);
            externalUserId = resp.getExternalUserId();
            pendingId = resp.getPendingId();
        }
        catch (WeworkException e) {
            log.error("Failed getting external_userid with, unionId:{}, openId:{}", new Object[]{unionId, openId, e});
            return;
        }
        catch (Exception e) {
            log.error("Failed getting external_userid with, unionId:{}, openId:{}", new Object[]{unionId, openId, e});
            return;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)externalUserId)) {
                exist = this.weworkContactMapper.selectByCorpIdAndContactId(corpId, externalUserId);
                if (exist == null) {
                    log.warn("weworkContact not found, corpId:{}, externalUserId:{}", (Object)corpId, (Object)externalUserId);
                    return;
                }
                this.weworkContactMapper.updateUnionId(corpId, externalUserId, unionId);
                this.ccCustomerNumService.getCustomerNumByWeworkContactId(exist.getBizId(), externalUserId, unionId);
            } else if (StringUtils.isNotBlank((CharSequence)pendingId)) {
                if (rel == null) {
                    rel = this.buildUnionIdPendingRel(bizId, corpId, unionId, openId, pendingId);
                    this.unionidPendingidRelMapper.insertSelective((Object)rel);
                } else {
                    rel.setUpdateTime(new Date());
                    rel.setPendingId(pendingId);
                    rel.setExpireTime(DateUtil.getDateAddDay(new Date(), 89));
                    this.unionidPendingidRelMapper.updateByPrimaryKeySelective((Object)rel);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5ba2\u6237unionId\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void assignPendingId(Long bizId, String corpId, String contactId) {
        WeworkContact exist = this.weworkContactMapper.selectByCorpIdAndContactId(corpId, contactId);
        if (exist == null) {
            log.warn("assignPendingId not find weworkContact corpId: {}, contactId: {}", (Object)corpId, (Object)contactId);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)exist.getUnionid())) {
            log.info("weworkContact unionid is not null");
            return;
        }
        try {
            ExternalPendingIdResp resp = this.externalContactClient.userIdGetPendingId(corpId, (List)Lists.newArrayList((Object[])new String[]{contactId}));
            List result = resp.getResult();
            if (CollectionUtils.isNotEmpty((Collection)result)) {
                ExternalPendingIdDto dto = (ExternalPendingIdDto)result.get(0);
                String pendingId = dto.getPendingId();
                UnionidPendingidRel rel = this.unionidPendingidRelMapper.queryByPendingId(bizId, pendingId);
                if (rel == null) {
                    log.info("UnionidPendingidRel is null");
                } else {
                    String unionId = rel.getUnionId();
                    this.weworkContactMapper.updateUnionId(corpId, contactId, unionId);
                }
            }
        }
        catch (Exception e) {
            log.error("external_userid get pendingid error: ", (Throwable)e);
        }
    }

    private UnionidPendingidRel buildUnionIdPendingRel(Long bizId, String corpId, String unionId, String openId, String pendingId) {
        Date cur = new Date();
        UnionidPendingidRel rel = new UnionidPendingidRel();
        rel.setBizId(bizId);
        rel.setCorpId(corpId);
        rel.setUnionId(unionId);
        rel.setOpenId(openId);
        rel.setPendingId(pendingId);
        rel.setExpireTime(DateUtil.getDateAddDay(cur, 89));
        rel.setCreateTime(cur);
        rel.setUpdateTime(cur);
        return rel;
    }
}

