/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.service.ScrmRoleService;
import com.kuaike.scrm.common.service.dto.req.RoleAddReqDto;
import com.kuaike.scrm.common.service.dto.resp.ScrmRoleResp;
import com.kuaike.scrm.dal.permission.entity.Role;
import com.kuaike.scrm.dal.permission.mapper.RoleMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScrmRoleServiceImpl
implements ScrmRoleService {
    private static final Logger log = LoggerFactory.getLogger(ScrmRoleServiceImpl.class);
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private UserMapper userMapper;

    public void initSystemRoles(List<RoleAddReqDto> roleAddReqDtos) {
        log.info("initSystemRoles, params:{}", roleAddReqDtos);
        ArrayList roles = Lists.newArrayList();
        Date date = new Date();
        for (RoleAddReqDto roleAddReqDto : roleAddReqDtos) {
            Role role = new Role();
            roles.add(role);
            role.setBizId(roleAddReqDto.getBizId());
            role.setName(roleAddReqDto.getName());
            role.setRemark("");
            role.setIsSystem(roleAddReqDto.getIsSystem());
            role.setCreateTime(date);
            role.setUpdateTime(date);
            role.setCorpId(roleAddReqDto.getCorpId());
            role.setType(roleAddReqDto.getType());
            role.setOrgType(roleAddReqDto.getOrgType());
        }
        this.roleMapper.batchInsert((Collection)roles);
    }

    public Set<String> getWeworkUserIdsByRoleName(String corpId, String roleName) {
        log.info("getWeworkUserIdsByRoleName, corpId:{}, roleName:{}", (Object)corpId, (Object)roleName);
        Long roleId = this.roleMapper.getSystemRoleIdByCorpIdAndRoleName(corpId, roleName);
        if (Objects.isNull(roleId)) {
            log.warn("\u6839\u636ecorpId:{}, roleName:{}\u672a\u67e5\u8be2\u5230\u89d2\u8272", (Object)corpId, (Object)roleName);
            return Sets.newHashSet();
        }
        Set userIds = this.userRoleMapper.selectUserIdsByCorpIdAndRoleId(corpId, roleId);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            log.warn("\u6839\u636ecorpId:{},roleId:{}\u672a\u67e5\u8be2\u5230\u7528\u6237id", (Object)corpId, (Object)roleId);
            return Sets.newHashSet();
        }
        return this.userMapper.queryWeworkUserIdByCorpIdAndUserIds(corpId, (Collection)userIds);
    }

    public Map<String, Long> getRoleIdByRoleNames(String corpId, Set<String> roleNames) {
        if (StringUtils.isEmpty((CharSequence)corpId)) {
            return Maps.newHashMap();
        }
        if (CollectionUtils.isEmpty(roleNames)) {
            return Maps.newHashMap();
        }
        return this.roleMapper.getSystemRoleIdByRoleNames(corpId, roleNames);
    }

    public Integer getRoleOrgTypeByRoleName(String corpId, String roleName) {
        return this.roleMapper.getOrgTypeByCorpIdAndRoleName(corpId, roleName);
    }

    public ScrmRoleResp getRoleInfoByRoleId(Long bizId, Long roleId) {
        Preconditions.checkArgument((boolean)Objects.nonNull(bizId), (Object)"bizId is null");
        Preconditions.checkArgument((boolean)Objects.nonNull(roleId), (Object)"roleId is null");
        Role role = this.roleMapper.selectRoleById(roleId, bizId);
        ScrmRoleResp resp = new ScrmRoleResp();
        if (Objects.nonNull(role)) {
            resp.setBizId(role.getBizId());
            resp.setName(role.getName());
            resp.setIsSystem(role.getIsSystem());
            resp.setCorpId(role.getCorpId());
            resp.setType(role.getType());
            resp.setOrgType(role.getOrgType());
            resp.setId(role.getId());
        }
        return resp;
    }
}

