/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.enums.GroupTypeEnum;
import com.kuaike.scrm.common.service.ScrmChannelService;
import com.kuaike.scrm.common.service.dto.resp.ChannelDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.group.entity.CommonGroup;
import com.kuaike.scrm.dal.group.mapper.CommonGroupMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScrmChannelServiceImpl
implements ScrmChannelService {
    private static final Logger log = LoggerFactory.getLogger(ScrmChannelServiceImpl.class);
    private static final Long TEMPLATE_BIZ_ID = 0L;
    @Autowired
    private ChannelMapper channelMapper;
    @Resource
    private CommonGroupMapper commonGroupMapper;

    public ChannelDto getById(Long bizId, Long id) {
        Channel channel = (Channel)this.channelMapper.selectByPrimaryKey((Object)id);
        if (channel == null) {
            return null;
        }
        return new ChannelDto(channel.getId(), channel.getNum(), channel.getName(), channel.getDescription(), channel.getIsEnabled(), channel.getLevel(), channel.getPayGroupKey());
    }

    public ChannelDto getByNum(Long bizId, String num) {
        Long id = this.channelMapper.getIdByNum(bizId, num);
        if (id == null) {
            return null;
        }
        Channel channel = (Channel)this.channelMapper.selectByPrimaryKey((Object)id);
        if (channel == null) {
            return null;
        }
        return new ChannelDto(channel.getId(), channel.getNum(), channel.getName(), channel.getDescription(), channel.getIsEnabled(), channel.getLevel(), channel.getPayGroupKey());
    }

    public List<ChannelDto> getByIds(Long bizId, Collection<Long> ids) {
        log.info("get channel by ids, operatorId:{}, ids:{}", (Object)LoginUtils.getCurrentUserId(), ids);
        if (CollectionUtils.isEmpty(ids)) {
            log.warn("ids is empty");
            return Collections.emptyList();
        }
        List list = this.channelMapper.queryChannels(bizId, ids);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list.stream().map(it -> new ChannelDto(it.getId(), it.getNum(), it.getName(), it.getDescription(), it.getIsEnabled(), it.getLevel(), it.getPayGroupKey())).collect(Collectors.toList());
    }

    public Map<Long, String> getNameByIds(Long bizId, Collection<Long> ids) {
        log.info("get channel name by ids, operatorId:{}, ids:{}", (Object)LoginUtils.getCurrentUserId(), ids);
        if (CollectionUtils.isEmpty(ids)) {
            log.warn("ids is empty");
            return Collections.emptyMap();
        }
        return this.channelMapper.selectIdAndNameByIds(bizId, ids);
    }

    public Map<String, Long> getIdByNums(Long bizId, Collection<String> nums) {
        log.info("get channel id by nums, operatorId:{}, nums:{}", (Object)LoginUtils.getCurrentUserId(), nums);
        if (CollectionUtils.isEmpty(nums)) {
            log.warn("nums is empty");
            return Collections.emptyMap();
        }
        return this.channelMapper.getIdByNums(bizId, nums);
    }

    public Map<Long, String> getNumByIds(Long bizId, Collection<Long> ids) {
        log.info("get channel num by ids, operatorId:{}, ids:{}", (Object)LoginUtils.getCurrentUserId(), ids);
        if (CollectionUtils.isEmpty(ids)) {
            log.warn("ids is empty");
            return Collections.emptyMap();
        }
        return this.channelMapper.getNumByIds(bizId, ids);
    }

    public ChannelDto getByName(Long bizId, String name) {
        if (bizId == null || bizId <= 0L) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        Channel channel = this.channelMapper.getByName(bizId, name);
        if (channel == null) {
            return null;
        }
        return new ChannelDto(channel.getId(), channel.getNum(), channel.getName(), channel.getDescription(), channel.getIsEnabled(), channel.getLevel(), channel.getPayGroupKey());
    }

    public List<ChannelDto> queryInnerChannels() {
        List channels = this.channelMapper.queryList(TEMPLATE_BIZ_ID, null, null);
        return channels.stream().map(channel -> new ChannelDto(channel.getId(), channel.getNum(), channel.getName(), channel.getDescription(), channel.getIsEnabled(), channel.getLevel(), channel.getPayGroupKey())).collect(Collectors.toList());
    }

    public List<ChannelDto> queryHighSchoolChannels(Long bizId) {
        log.info("queryHighSchoolChannels,bizId:{}", (Object)bizId);
        CommonGroup commonGroup = this.commonGroupMapper.selectByTypeAndName(bizId, GroupTypeEnum.CAHNNEL_MANAGER.getCode(), "\u9ad8\u6821");
        if (Objects.isNull(commonGroup)) {
            log.info("\u6839\u636e\u7ec4\u540d\u3010\u9ad8\u6821\u3011\u672a\u67e5\u8be2\u5230\u6e20\u9053\u7ec4");
            return Collections.emptyList();
        }
        List channels = this.channelMapper.selectByGroupNum(bizId, commonGroup.getNum());
        if (CollectionUtils.isEmpty((Collection)channels)) {
            log.info("\u6e20\u9053\u7ec4:{}\u4e0b\u672a\u8bbe\u7f6e\u6e20\u9053", (Object)commonGroup.getNum());
            return Collections.emptyList();
        }
        ArrayList channelsDtos = Lists.newArrayList();
        for (Channel channel : channels) {
            ChannelDto channelDto = new ChannelDto();
            channelsDtos.add(channelDto);
            channelDto.setNum(channel.getNum());
            channelDto.setName(channel.getName());
        }
        return channelsDtos;
    }

    public Map<String, String> getNameByNums(Long bizId, Collection<String> nums) {
        return this.channelMapper.selectNameByNums(bizId, nums);
    }
}

