/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.service.CachePhoneService;
import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.common.service.dto.resp.BatchPhoneDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.MobileUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CachePhoneServiceImpl
implements CachePhoneService {
    private static final Logger log = LoggerFactory.getLogger(CachePhoneServiceImpl.class);
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IdGen idGen;
    private static final int TOKEN_CACHE_EXPIRE = 1;
    private static final String BATCH_KEY = "SCRM_BJY_BATCH_KEY_%s";

    public BatchPhoneDto batchIdByCustomer(List<CustomerDto> customers) {
        return this.setCustomers(customers);
    }

    public BatchPhoneDto batchIdByCustomer(CustomerDto customer) {
        return this.setCustomers(Lists.newArrayList((Object[])new CustomerDto[]{customer}));
    }

    public List<CustomerDto> getCustomer(String num) {
        String key = this.redisKeyPrefix + String.format(BATCH_KEY, num);
        Object customer = this.redisTemplate.opsForValue().get((Object)key);
        if (ObjectUtils.isEmpty((Object)customer)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5ba2\u6237\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            return JacksonUtil.str2List((String)customer.toString(), CustomerDto.class);
        }
        catch (IOException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u5ba2\u6237\u5f02\u5e38");
        }
    }

    public void deleteCustomerCache(String num) {
        String key = this.redisKeyPrefix + String.format(BATCH_KEY, num);
        try {
            this.redisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7528\u6237\u7f13\u5b58\u4fe1\u606f\u5931\u8d25\uff1akey {}", (Object)key);
        }
    }

    public BatchPhoneDto batchIdByPhone(String phone) {
        return this.setPhone(Lists.newArrayList((Object[])new String[]{phone}));
    }

    public BatchPhoneDto batchIdByPhone(List<String> phones) {
        return this.setPhone(phones);
    }

    private BatchPhoneDto setPhone(List<String> phones) {
        ArrayList customers = Lists.newArrayListWithExpectedSize((int)phones.size());
        for (String phone : phones) {
            CustomerDto reqDto = new CustomerDto();
            reqDto.setPhone(phone);
            customers.add(reqDto);
        }
        return this.setCustomers(customers);
    }

    private BatchPhoneDto setCustomers(List<CustomerDto> customers) {
        ArrayList reqDtos = Lists.newArrayList();
        HashSet phones = Sets.newHashSet();
        for (CustomerDto customer : customers) {
            if (StringUtils.isBlank((CharSequence)customer.getPhone()) || !phones.add(customer.getPhone())) continue;
            Preconditions.checkArgument((boolean)MobileUtils.isPhone(customer.getPhone()), (Object)"\u624b\u673a\u53f7\u4e0d\u89c4\u8303");
            CustomerDto reqDto = new CustomerDto();
            reqDto.setPhone(customer.getPhone());
            reqDto.setName(customer.getName());
            reqDtos.add(reqDto);
        }
        if (CollectionUtils.isEmpty((Collection)reqDtos)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5ba2\u6237\u6570\u636e\u4e3a\u7a7a");
        }
        String num = this.idGen.getNum();
        String key = this.redisKeyPrefix + String.format(BATCH_KEY, num);
        this.redisTemplate.opsForValue().set((Object)key, (Object)JacksonUtil.obj2Str((Object)reqDtos), 1L, TimeUnit.HOURS);
        return new BatchPhoneDto(num, reqDtos.size());
    }
}

