/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.service.ArrangeService;
import com.kuaike.scrm.common.service.dto.Contact2WeworkUser;
import com.kuaike.scrm.common.service.dto.SelectedContact2WeworkUserDto;
import com.kuaike.scrm.common.service.dto.WeworkUser2Contact;
import com.kuaike.scrm.common.service.dto.WeworkUserDto;
import com.kuaike.scrm.dal.wework.dto.ContactWeworkPair;
import com.kuaike.scrm.dal.wework.dto.UserContactInfo;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArrangeServiceImpl
implements ArrangeService {
    private static final Logger log = LoggerFactory.getLogger(ArrangeServiceImpl.class);
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;

    private Map<String, WeworkUser> queryUserByUserIds(String corpId, Collection<String> weworkUserIds) {
        if (StringUtils.isBlank((CharSequence)corpId) || CollectionUtils.isEmpty(weworkUserIds)) {
            return Maps.newHashMap();
        }
        List users = this.weworkUserMapper.queryWeworkUserInfoList(corpId, weworkUserIds);
        return users.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, Function.identity()));
    }

    @Override
    public List<SelectedContact2WeworkUserDto> arrangeAvailableWeworkUserId(String corpId, Map<String, List<String>> contactId2UserIds) {
        ArrayList result = Lists.newArrayList();
        HashMap weworkUser2Item = Maps.newHashMap();
        ArrayList contact2WeworkUserList = Lists.newArrayList();
        ArrayList contactWeworkIdPairs = Lists.newArrayList();
        for (Map.Entry<String, List<String>> entry : contactId2UserIds.entrySet()) {
            String contactId = entry.getKey();
            List<String> temWeworkUserIds = contactId2UserIds.get(contactId);
            Contact2WeworkUser contactItem = new Contact2WeworkUser();
            contactItem.setContactId(contactId);
            contactItem.setWeworkUserIds(Lists.newArrayList());
            contact2WeworkUserList.add(contactItem);
            for (String temWeworkUserId : temWeworkUserIds) {
                ContactWeworkPair contactWeworkPair = new ContactWeworkPair(temWeworkUserId, contactId);
                contactWeworkIdPairs.add(contactWeworkPair);
                WeworkUser2Contact weworkUserItem = (WeworkUser2Contact)weworkUser2Item.get(temWeworkUserId);
                if (weworkUserItem == null) {
                    weworkUserItem = new WeworkUser2Contact();
                    weworkUserItem.setWeworkUserId(temWeworkUserId);
                    weworkUserItem.setContactIds(Lists.newArrayList());
                    weworkUserItem.setCount(0);
                    weworkUser2Item.put(temWeworkUserId, weworkUserItem);
                }
                contactItem.getWeworkUserIds().add(weworkUserItem);
            }
            contactItem.setCount(contactItem.getWeworkUserIds().size());
        }
        HashMap contactId2SelectedWeworkUserId = Maps.newHashMap();
        List contactList = contact2WeworkUserList.stream().sorted(Comparator.comparing(Contact2WeworkUser::getCount)).collect(Collectors.toList());
        for (Contact2WeworkUser item : contactList) {
            List<WeworkUser2Contact> weworkUserIds1 = item.getWeworkUserIds();
            List newWeworkUser = weworkUserIds1.stream().sorted(Comparator.comparing(WeworkUser2Contact::getCount)).collect(Collectors.toList());
            WeworkUser2Contact selectUser = (WeworkUser2Contact)newWeworkUser.get(0);
            selectUser.getContactIds().add(item.getContactId());
            selectUser.setCount(selectUser.getContactIds().size());
            contactId2SelectedWeworkUserId.put(item.getContactId(), selectUser.getWeworkUserId());
        }
        ArrayList<String> weworkUserIds = new ArrayList<String>(weworkUser2Item.keySet());
        Map<String, WeworkUser> weworkUserMap = this.queryUserByUserIds(corpId, weworkUserIds);
        ArrayList<String> newContactIds = new ArrayList<String>(contactId2UserIds.keySet());
        List userContactInfoList = this.weworkContactRelationMapper.queryContactInfoByWeworkUserIdAndNameQuery(corpId, "", (Collection)contactWeworkIdPairs);
        Map contactId2Entity = userContactInfoList.stream().collect(Collectors.toMap(a -> a.getWeworkUserId() + "$$" + a.getContactId(), Function.identity()));
        for (String contactId : newContactIds) {
            String weworkUserId = (String)contactId2SelectedWeworkUserId.get(contactId);
            WeworkUser weworkUser = weworkUserMap.get(weworkUserId);
            String key = weworkUserId + "$$" + contactId;
            UserContactInfo weworkContact = (UserContactInfo)contactId2Entity.get(key);
            SelectedContact2WeworkUserDto item = new SelectedContact2WeworkUserDto();
            item.setContactId(contactId);
            item.setContactDigitId(weworkContact.getContactDigitId());
            item.setContactAvatar(weworkContact.getAvatar());
            item.setContactCorpName(weworkContact.getCorpName());
            item.setContactName(StringUtils.isNotBlank((CharSequence)weworkContact.getRemark()) ? weworkContact.getRemark() : weworkContact.getOriginName());
            item.setWeworkNum(weworkUser.getNum());
            item.setWeworkUserDigitId(weworkUser.getWeworkDigitId());
            item.setWeworkAlias(weworkUser.getAlias());
            item.setWeworkName(weworkUser.getName());
            item.setWeworkAvatar(weworkUser.getAvatar());
            item.setAvailableSenders(Lists.newArrayList());
            List<String> available = contactId2UserIds.get(contactId);
            for (String userId : available) {
                WeworkUserDto weworkUserDto = new WeworkUserDto();
                WeworkUser weworkUserItem = weworkUserMap.get(userId);
                weworkUserDto.setWeworkNum(weworkUserItem.getNum());
                weworkUserDto.setWeworkAlias(weworkUserItem.getAlias());
                weworkUserDto.setWeworkName(weworkUserItem.getName());
                weworkUserDto.setWeworkAvatar(weworkUserItem.getAvatar());
                item.getAvailableSenders().add(weworkUserDto);
            }
            result.add(item);
        }
        return result;
    }
}

